/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.util.Iterator;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.commons.configuration.ConfigurationUtils;
import org.apache.commons.configuration.FileConfiguration;
import org.apache.commons.configuration.reloading.InvariantReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;

public abstract class AbstractFileConfiguration
extends BaseConfiguration
implements FileConfiguration {
    protected String fileName;
    protected String basePath;
    protected boolean autoSave;
    protected ReloadingStrategy strategy;
    private Object reloadLock = new Object();
    private String encoding;

    public AbstractFileConfiguration() {
        this.setReloadingStrategy(new InvariantReloadingStrategy());
    }

    public AbstractFileConfiguration(String fileName) throws ConfigurationException {
        this();
        this.setPath(fileName);
        this.load();
    }

    public AbstractFileConfiguration(File file) throws ConfigurationException {
        this();
        this.setFile(file);
        if (file.exists()) {
            this.load();
        }
    }

    public AbstractFileConfiguration(URL url) throws ConfigurationException {
        this();
        this.setURL(url);
        this.load();
    }

    public void load() throws ConfigurationException {
        this.load(this.getFileName());
    }

    public void load(String fileName) throws ConfigurationException {
        try {
            URL url = ConfigurationUtils.locate(this.basePath, fileName);
            if (url == null) {
                throw new ConfigurationException("Cannot locate configuration source " + fileName);
            }
            this.load(url);
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
    }

    public void load(File file) throws ConfigurationException {
        try {
            this.load(file.toURL());
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
    }

    /*
     * Loose catch block
     */
    public void load(URL url) throws ConfigurationException {
        block10: {
            InputStream in = null;
            in = url.openStream();
            this.load(in);
            Object var5_3 = null;
            try {
                if (in != null) {
                    in.close();
                }
                break block10;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            break block10;
            {
                catch (ConfigurationException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new ConfigurationException(e.getMessage(), e);
                }
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    public void load(InputStream in) throws ConfigurationException {
        this.load(in, this.getEncoding());
    }

    public void load(InputStream in, String encoding) throws ConfigurationException {
        InputStreamReader reader = null;
        if (encoding != null) {
            try {
                reader = new InputStreamReader(in, encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new ConfigurationException("The requested encoding is not supported, try the default encoding.", e);
            }
        }
        if (reader == null) {
            reader = new InputStreamReader(in);
        }
        this.load(reader);
    }

    public void save() throws ConfigurationException {
        this.save(this.fileName);
        this.strategy.init();
    }

    public void save(String fileName) throws ConfigurationException {
        try {
            File file = ConfigurationUtils.getFile(this.basePath, fileName);
            if (file == null) {
                throw new ConfigurationException("Invalid file name for save: " + fileName);
            }
            this.save(file);
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
    }

    public void save(URL url) throws ConfigurationException {
        File file = ConfigurationUtils.fileFromURL(url);
        if (file == null) {
            throw new ConfigurationException("Could not save to URL " + url);
        }
        this.save(file);
    }

    /*
     * Loose catch block
     */
    public void save(File file) throws ConfigurationException {
        block9: {
            FileOutputStream out = null;
            this.createPath(file);
            out = new FileOutputStream(file);
            this.save(out);
            Object var5_3 = null;
            try {
                if (out != null) {
                    ((OutputStream)out).close();
                }
                break block9;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            break block9;
            {
                catch (IOException e) {
                    throw new ConfigurationException(e.getMessage(), e);
                }
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                try {
                    if (out != null) {
                        ((OutputStream)out).close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    public void save(OutputStream out) throws ConfigurationException {
        this.save(out, this.getEncoding());
    }

    public void save(OutputStream out, String encoding) throws ConfigurationException {
        OutputStreamWriter writer = null;
        if (encoding != null) {
            try {
                writer = new OutputStreamWriter(out, encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new ConfigurationException("The requested encoding is not supported, try the default encoding.", e);
            }
        }
        if (writer == null) {
            writer = new OutputStreamWriter(out);
        }
        this.save(writer);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public File getFile() {
        return ConfigurationUtils.getFile(this.getBasePath(), this.getFileName());
    }

    public void setFile(File file) {
        this.setFileName(file.getName());
        this.setBasePath(file.getParentFile() != null ? file.getParentFile().getAbsolutePath() : null);
    }

    public String getPath() {
        return this.getFile().getAbsolutePath();
    }

    public void setPath(String path) {
        this.setFile(new File(path));
    }

    public URL getURL() {
        return ConfigurationUtils.locate(this.getBasePath(), this.getFileName());
    }

    public void setURL(URL url) {
        this.setBasePath(ConfigurationUtils.getBasePath(url));
        this.setFileName(ConfigurationUtils.getFileName(url));
    }

    public void setAutoSave(boolean autoSave) {
        this.autoSave = autoSave;
    }

    public boolean isAutoSave() {
        return this.autoSave;
    }

    protected void possiblySave() {
        if (this.autoSave && this.fileName != null) {
            try {
                this.save();
            }
            catch (ConfigurationException e) {
                throw new ConfigurationRuntimeException("Failed to auto-save", (Throwable)((Object)e));
            }
        }
    }

    protected void addPropertyDirect(String key, Object obj) {
        super.addPropertyDirect(key, obj);
        this.possiblySave();
    }

    public void clearProperty(String key) {
        super.clearProperty(key);
        this.possiblySave();
    }

    public ReloadingStrategy getReloadingStrategy() {
        return this.strategy;
    }

    public void setReloadingStrategy(ReloadingStrategy strategy) {
        this.strategy = strategy;
        strategy.setConfiguration(this);
        strategy.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        Object object = this.reloadLock;
        synchronized (object) {
            if (this.strategy.reloadingRequired()) {
                try {
                    this.clear();
                    this.load();
                    this.strategy.reloadingPerformed();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public Object getProperty(String key) {
        this.reload();
        return super.getProperty(key);
    }

    public boolean isEmpty() {
        this.reload();
        return super.isEmpty();
    }

    public boolean containsKey(String key) {
        this.reload();
        return super.containsKey(key);
    }

    public Iterator getKeys() {
        this.reload();
        return super.getKeys();
    }

    private void createPath(File file) {
        File parent;
        if (file != null && !file.exists() && (parent = file.getParentFile()) != null && !parent.exists()) {
            parent.mkdirs();
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public abstract /* synthetic */ void save(Writer var1) throws ConfigurationException;

    public abstract /* synthetic */ void load(Reader var1) throws ConfigurationException;
}

