/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.app.domain.contact;

import com.jgoodies.app.domain.contact.ContactData;
import com.jgoodies.app.persistency.Entity;
import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.base.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class ContactPerson
extends Entity {
    public static final String PROPERTY_LABEL = "label";
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_CONTACT_DATA = "contactData";
    private String label = "";
    private String name = "";
    private final List<ContactData> contactData = new ArrayList<ContactData>();

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String newValue) {
        this.label = newValue;
        this.firePropertyChange(PROPERTY_LABEL, this.label, this.label);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newValue) {
        this.name = newValue;
        this.firePropertyChange(PROPERTY_NAME, this.name, this.name);
    }

    public List<ContactData> getContactData() {
        return Collections.unmodifiableList(this.contactData);
    }

    public void setContactData(List<ContactData> newData) {
        Preconditions.checkNotNull(newData, "The %s must not be null.", "contact data list");
        this.contactData.clear();
        this.contactData.addAll(newData);
    }

    public void addContactData(ContactData contact) {
        Preconditions.checkNotNull(contact, "The %s must not be null.", "contact data to add");
        this.contactData.add(contact);
    }

    public Optional<ContactData> firstPhone() {
        return this.first(ContactData.ContactType.PHONE);
    }

    public Optional<ContactData> firstEmail() {
        return this.first(ContactData.ContactType.EMAIL);
    }

    public List<ContactData> allPhone() {
        return this.all(ContactData.ContactType.PHONE);
    }

    public List<ContactData> allEmail() {
        return this.all(ContactData.ContactType.EMAIL);
    }

    public boolean isEmpty() {
        return Strings.isBlank(this.getLabel()) && Strings.isBlank(this.getName()) && (this.contactData.isEmpty() || this.contactData.stream().allMatch(ContactData::isEmpty));
    }

    private List<ContactData> all(ContactData.ContactType type) {
        return this.contactData.stream().filter(data -> data.getType() == type).collect(Collectors.toList());
    }

    private Optional<ContactData> first(ContactData.ContactType type) {
        Preconditions.checkNotNull(type, "The %s must not be null.", "contact type");
        return this.contactData.stream().filter(data -> data.getType() == type).findFirst();
    }

    public int hashCode() {
        return Objects.hash(this.contactData, this.label, this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContactPerson other = (ContactPerson)obj;
        return Objects.equals(this.contactData, other.contactData) && Objects.equals(this.label, other.label) && Objects.equals(this.name, other.name);
    }

    public static final class Builder {
        private final ContactPerson target = new ContactPerson();

        public Builder label(String value) {
            this.target.setLabel(value);
            return this;
        }

        public Builder name(String value) {
            this.target.setName(value);
            return this;
        }

        public Builder addContactData(ContactData contact) {
            this.target.addContactData(contact);
            return this;
        }

        public ContactPerson build() {
            return this.target;
        }

        public Builder gf() {
            return this.label("Gesch\u00e4ftsf\u00fchrer");
        }

        public Builder workPhone(String value) {
            return this.addContactData(new ContactData.Builder().workPhone(value).build());
        }

        public Builder fax(String value) {
            return this.addContactData(new ContactData.Builder().fax(value).build());
        }

        public Builder privatePhone(String value) {
            return this.addContactData(new ContactData.Builder().privatePhone(value).build());
        }

        public Builder mobile(String value) {
            return this.addContactData(new ContactData.Builder().mobile(value).build());
        }

        public Builder workEmail(String value) {
            return this.addContactData(new ContactData.Builder().workEmail(value).build());
        }
    }
}

