/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.adapter;

import com.jgoodies.binding.adapter.SpinnerToValueModelConnector;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.common.base.Preconditions;
import java.util.Date;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;

public final class SpinnerAdapterFactory {
    private SpinnerAdapterFactory() {
    }

    public static SpinnerDateModel createDateAdapter(ValueModel valueModel, Date defaultDate) {
        return SpinnerAdapterFactory.createDateAdapter(valueModel, defaultDate, null, null, 5);
    }

    public static SpinnerDateModel createDateAdapter(ValueModel valueModel, Date defaultDate, Comparable<Date> start, Comparable<Date> end, int calendarField) {
        Preconditions.checkNotNull(valueModel, "The %s must not be null.", "valueModel");
        Preconditions.checkNotNull(defaultDate, "The %s must not be null.", "default date");
        Date valueModelDate = (Date)valueModel.getValue();
        Date initialDate = valueModelDate != null ? valueModelDate : defaultDate;
        SpinnerDateModel spinnerModel = new SpinnerDateModel(initialDate, start, end, calendarField);
        SpinnerAdapterFactory.connect(spinnerModel, valueModel, defaultDate);
        return spinnerModel;
    }

    public static SpinnerNumberModel createNumberAdapter(ValueModel valueModel, int defaultValue, int minValue, int maxValue, int stepSize) {
        return SpinnerAdapterFactory.createNumberAdapter(valueModel, (Number)defaultValue, (Comparable<? extends Number>)minValue, (Comparable<? extends Number>)maxValue, (Number)stepSize);
    }

    public static SpinnerNumberModel createNumberAdapter(ValueModel valueModel, Number defaultValue, Comparable<? extends Number> minValue, Comparable<? extends Number> maxValue, Number stepSize) {
        Number valueModelNumber = (Number)valueModel.getValue();
        Number initialValue = valueModelNumber != null ? (Number)valueModelNumber : (Number)defaultValue;
        SpinnerNumberModel spinnerModel = new SpinnerNumberModel(initialValue, minValue, maxValue, stepSize);
        SpinnerAdapterFactory.connect(spinnerModel, valueModel, defaultValue);
        return spinnerModel;
    }

    public static void connect(SpinnerModel spinnerModel, ValueModel valueModel, Object defaultValue) {
        SpinnerToValueModelConnector.connect(spinnerModel, valueModel, defaultValue);
    }
}

