/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.chart;

import com.jgoodies.chart.ChartModel;
import com.jgoodies.common.swing.internal.RenderingUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.text.Format;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.UIResource;

public abstract class AbstractChart<T>
extends JComponent {
    public static final String PROPERTY_MODEL = "model";
    public static final String PROPERTY_FORMAT = "format";
    public static final String PROPERTY_SHOW_SIZE = "showSize";
    protected static final Color OUTER_SHADOW_COLOR = new Color(0, 0, 0, 25);
    protected static final Color INNER_SHADOW_COLOR = new Color(0, 0, 0, 42);
    private final ChangeListener modelChangeHandler;
    protected ChartModel<T> model;
    private Format format;
    private boolean cacheIsValid = false;
    private boolean showSize = true;
    protected boolean printingDevice = false;

    protected AbstractChart() {
        this(null);
    }

    protected AbstractChart(Format format) {
        this.format = format;
        this.modelChangeHandler = new ChartModelChangeHandler();
        this.setFocusable(false);
        this.setUI(null);
    }

    public final ChartModel<T> getModel() {
        return this.model;
    }

    public final void setModel(ChartModel<T> newModel) {
        ChartModel<T> oldModel = this.getModel();
        if (oldModel != null) {
            oldModel.removeChangeListener(this.modelChangeHandler);
        }
        this.model = newModel;
        if (newModel != null) {
            newModel.addChangeListener(this.modelChangeHandler);
        }
        if (oldModel == newModel) {
            return;
        }
        this.firePropertyChange(PROPERTY_MODEL, oldModel, newModel);
        this.invalidateCache();
        this.repaint();
    }

    public final Format getFormat() {
        return this.format;
    }

    public final void setFormat(Format newFormat) {
        Format oldFormat = this.getFormat();
        this.format = newFormat;
        this.firePropertyChange(PROPERTY_FORMAT, oldFormat, newFormat);
        this.invalidateCache();
        this.repaint();
    }

    public final boolean getShowSize() {
        return this.showSize;
    }

    public final void setShowSize(boolean newValue) {
        boolean oldValue = this.getShowSize();
        this.showSize = newValue;
        this.firePropertyChange(PROPERTY_SHOW_SIZE, oldValue, newValue);
        this.invalidateCache();
        this.repaint();
    }

    public final T getDataAt(Point position) {
        int index = this.getIndexAt(position);
        return -1 == index ? null : (T)this.model.getData(index);
    }

    protected abstract int getIndexAt(Point var1);

    protected abstract void render(Graphics2D var1);

    protected abstract void validateCache();

    protected final String formatSize(long value) {
        return this.format != null ? this.format.format(value) : String.valueOf(value);
    }

    protected final boolean hasEmptyModel() {
        return this.model == null || this.model.getItemCount() == 0;
    }

    protected final void invalidateCache() {
        this.cacheIsValid = false;
    }

    protected final boolean cacheIsValid() {
        return this.cacheIsValid;
    }

    protected final void ensureValidCache() {
        if (!this.cacheIsValid()) {
            this.validateCache();
            this.cacheIsValid = true;
        }
    }

    @Override
    public void paint(Graphics g) {
        g.setFont(this.getFont());
        this.paint0(g);
    }

    private void paint0(Graphics g) {
        if (this.hasEmptyModel()) {
            this.renderNoData((Graphics2D)g);
            return;
        }
        this.ensureValidCache();
        this.render((Graphics2D)g);
    }

    @Override
    public void print(Graphics g) {
        this.printingDevice = true;
        Font storedFont = g.getFont();
        g.setFont(new Font("dialog", 0, storedFont.getSize()));
        this.paint0(g);
        g.setFont(storedFont);
        this.printingDevice = false;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        Font font = this.getFont();
        if (font instanceof UIResource) {
            this.setFont(UIManager.getFont("Table.font"));
        }
    }

    private void renderNoData(Graphics2D g2) {
        FontMetrics fm = g2.getFontMetrics();
        String str = "No Data";
        int x = (this.getSize().width - fm.stringWidth(str)) / 2;
        int y = (this.getSize().height + fm.getAscent()) / 2;
        g2.setColor(Color.BLACK);
        RenderingUtils.drawString(this, g2, str, x, y);
    }

    private final class ChartModelChangeHandler
    implements ChangeListener {
        private ChartModelChangeHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            AbstractChart.this.invalidateCache();
            AbstractChart.this.repaint();
        }
    }
}

