/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.dialogs.basics.accessibility;

import com.jgoodies.application.Application;
import com.jgoodies.application.ResourceMap;
import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.base.Strings;
import com.jgoodies.common.jsdl.action.I18nActionBuilder;
import com.jgoodies.components.JGHyperlink;
import com.jgoodies.components.JGSearchField;
import com.jgoodies.dialogs.basics.BasicDialogResources;
import com.jgoodies.dialogs.basics.accessibility.AccessibilityUtils;
import com.jgoodies.dialogs.basics.accessibility.ControlListModel;
import com.jgoodies.dialogs.basics.accessibility.ControlListView;
import com.jgoodies.dialogs.core.util.JSDLUtils;
import java.awt.AWTEvent;
import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.EventObject;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.text.JTextComponent;

public final class ControlList {
    private static final String ACTION_SHOW = "ControlList.Show";
    private static final String KEY_ELEMENT_LIST_EXCLUDE = "ControlList.exclude";
    private static final String KEY_ELEMENT_LIST_COMPONENT_TYPE = "ControlList.componentType";
    private static ControlList instance;
    private final Predicate<Component> componentVisitorFilter;
    private final ControlListRenderer renderer;
    private final Action showAction;
    private AWTEventListener showDialogHandler;
    private boolean temporarilyDisabled = false;

    public ControlList(Predicate<Component> componentVisitorFilter, ControlListRenderer renderer) {
        this.componentVisitorFilter = componentVisitorFilter;
        this.renderer = renderer;
        this.showAction = new I18nActionBuilder().handler(this::onShowPerformed).resources(BasicDialogResources.getResourceMap()).id(ACTION_SHOW).build();
    }

    public static ControlList getInstance() {
        return instance;
    }

    public static void install() {
        ResourceMap resources = Application.getResourceMap(BasicDialogResources.class);
        KeyStroke keyStroke = resources.getKeyStroke("ControlList.Show.Action.accelerator");
        ControlList.install(keyStroke);
    }

    public static synchronized void install(KeyStroke showDialogKey) {
        ResourceMap resources = Application.getResourceMap(BasicDialogResources.class);
        Predicate<Component> filter = new AccessibilityUtils.DefaultInputElementFilter().and(new DefaultControlListFilter());
        ControlList.install(showDialogKey, new ControlList(filter, new DefaultControlListRenderer(resources)));
    }

    public static synchronized void install(KeyStroke showDialogKey, ControlList controlList) {
        instance = controlList;
        ControlList.instance.showDialogHandler = new ShowDialogHandler(showDialogKey);
        Toolkit.getDefaultToolkit().addAWTEventListener(ControlList.instance.showDialogHandler, 8L);
        ControlList.getShowAction().putValue("AcceleratorKey", showDialogKey);
    }

    public static synchronized void uninstall() {
        if (instance != null) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(ControlList.instance.showDialogHandler);
        }
        instance = null;
    }

    public static void exclude(JComponent c) {
        c.putClientProperty(KEY_ELEMENT_LIST_EXCLUDE, Boolean.TRUE);
    }

    public static boolean isExcluded(Component c) {
        if (!(c instanceof JComponent)) {
            return false;
        }
        JComponent jc = (JComponent)c;
        return jc.getClientProperty(KEY_ELEMENT_LIST_EXCLUDE) != null;
    }

    public static void setTypeString(JComponent c, String type) {
        c.putClientProperty(KEY_ELEMENT_LIST_COMPONENT_TYPE, type);
    }

    public static String getTypeString(Component c) {
        if (!(c instanceof JComponent)) {
            return null;
        }
        JComponent jc = (JComponent)c;
        Object value = jc.getClientProperty(KEY_ELEMENT_LIST_COMPONENT_TYPE);
        return value instanceof String ? (String)value : null;
    }

    public static Action getShowAction() {
        return ControlList.getInstance() != null ? ControlList.getInstance().showAction : null;
    }

    private void onKeyTyped(KeyEvent evt) {
        this.showDialogAndActivateSelectedComponent(evt);
    }

    private void onShowPerformed(ActionEvent evt) {
        this.showDialogAndActivateSelectedComponent(evt);
    }

    private void showDialogAndActivateSelectedComponent(EventObject evt) {
        if (this.temporarilyDisabled) {
            return;
        }
        this.temporarilyDisabled = true;
        Window window = ControlList.getWindow(evt);
        if (window == null || ControlList.isControlListDialog(window)) {
            return;
        }
        List<Component> elements = AccessibilityUtils.visitAndCollectComponents(window, this.componentVisitorFilter);
        ControlListModel model = new ControlListModel(this.renderer, elements);
        boolean proceed = new ControlListView(model).showDialog(evt);
        EventQueue.invokeLater(() -> {
            this.temporarilyDisabled = false;
        });
        if (proceed) {
            ControlList.activate(model.getSelectedElement());
        }
    }

    private static void activate(Component c) {
        if (c == null) {
            return;
        }
        c.requestFocusInWindow();
        if (c instanceof AbstractButton) {
            ((AbstractButton)c).doClick();
        }
    }

    private static Window getWindow(EventObject e) {
        Object source = e.getSource();
        Component c = source instanceof Component ? (Component)source : null;
        return JSDLUtils.getWindowFor(c);
    }

    private static boolean isControlListDialog(Window w) {
        if (!(w instanceof JDialog)) {
            return false;
        }
        JRootPane rootPane = ((JDialog)w).getRootPane();
        return rootPane != null && Boolean.TRUE.equals(rootPane.getClientProperty("ControlListView"));
    }

    public static interface ControlListRenderer {
        public String displayString(Component var1);
    }

    public static final class DefaultControlListFilter
    implements Predicate<Component> {
        @Override
        public boolean test(Component c) {
            return AccessibilityUtils.hasAccessibleInfo(c) && c.isEnabled() && c.isFocusable() && !ControlList.isExcluded(c);
        }
    }

    public static class DefaultControlListRenderer
    implements ControlListRenderer {
        private final ResourceMap resources;
        private final JList<?> comboRendererList = new JList();

        public DefaultControlListRenderer(ResourceMap resources) {
            this.resources = Preconditions.checkNotNull(resources, "The %s must not be null.", "resources");
        }

        @Override
        public String displayString(Component c) {
            Object state;
            StringBuilder builder = new StringBuilder();
            builder.append(AccessibilityUtils.getAccessibleInfo(c));
            String type = this.typeString(c);
            if (type != null) {
                builder.append(" ");
                builder.append(type);
            }
            if ((state = this.getState(c)) != null) {
                builder.append(" ");
                builder.append(state.toString());
            }
            return builder.toString();
        }

        protected String typeString(Component c) {
            String componentType = ControlList.getTypeString(c);
            if (componentType != null) {
                return componentType;
            }
            String key = this.typeStringResourceKey(c);
            if (key == null) {
                return null;
            }
            return this.resources.getString("ControlListRenderer.type." + key, new Object[0]);
        }

        protected String typeStringResourceKey(Component c) {
            if (c instanceof JGSearchField) {
                return "JGSearchField";
            }
            if (c instanceof JTextField) {
                JTextField tf = (JTextField)c;
                return "JTextField." + (tf.isEditable() ? "editable" : "nonEditable");
            }
            if (c instanceof JTextArea) {
                JTextArea txa = (JTextArea)c;
                return "JTextArea." + (txa.isEditable() ? "editable" : "nonEditable");
            }
            if (c instanceof JTextComponent) {
                return "JTextComponent";
            }
            if (c instanceof JCheckBox) {
                return "JCheckBox";
            }
            if (c instanceof JRadioButton) {
                return "JRadioButton";
            }
            if (c instanceof JButton) {
                return "JButton";
            }
            if (c instanceof JMenu) {
                return "JMenu";
            }
            if (c instanceof JGHyperlink) {
                return "HyperLink";
            }
            if (c instanceof AbstractButton) {
                return "AbstractButton";
            }
            if (c instanceof JComboBox) {
                JComboBox combo = (JComboBox)c;
                return "JComboBox." + (combo.isEditable() ? "editable" : "nonEditable");
            }
            if (c instanceof JSpinner) {
                return "JSpinner";
            }
            if (c instanceof JList) {
                return "JList";
            }
            if (c instanceof JTable) {
                return "JTable";
            }
            if (c instanceof JTree) {
                return "JTree";
            }
            return null;
        }

        protected Object getState(Component c) {
            if (c instanceof AbstractButton && !(c instanceof JButton)) {
                AbstractButton b = (AbstractButton)c;
                if (b.isSelected()) {
                    return this.resources.getString("ControlListRenderer.state.selected", new Object[0]);
                }
            } else {
                if (c instanceof JTextComponent) {
                    JTextComponent tc = (JTextComponent)c;
                    return this.toSingleLine(tc.getText());
                }
                if (c instanceof JComboBox) {
                    JComboBox cb = (JComboBox)c;
                    ListCellRenderer<Object> renderer = cb.getRenderer();
                    Component rc = renderer.getListCellRendererComponent(this.comboRendererList, cb.getSelectedItem(), cb.getSelectedIndex(), true, false);
                    String rendererAccessibleName = rc.getAccessibleContext().getAccessibleName();
                    return Strings.isNotBlank(rendererAccessibleName) ? rendererAccessibleName : cb.getSelectedItem();
                }
                if (c instanceof JSlider) {
                    JSlider sl = (JSlider)c;
                    return sl.getValue();
                }
                if (c instanceof JSpinner) {
                    JSpinner sp = (JSpinner)c;
                    return sp.getValue();
                }
            }
            return null;
        }

        protected String toSingleLine(String multiLineText) {
            return multiLineText.replace('\n', ' ');
        }
    }

    private static final class ShowDialogHandler
    implements AWTEventListener {
        private final KeyStroke openKeyStroke;

        ShowDialogHandler(KeyStroke openKeyStroke) {
            this.openKeyStroke = openKeyStroke;
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            if (event instanceof KeyEvent && this.openKeyStroke.equals(AWTKeyStroke.getAWTKeyStrokeForEvent((KeyEvent)event))) {
                ControlList.getInstance().onKeyTyped((KeyEvent)event);
            }
        }
    }
}

