/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.dialogs.basics.accessibility;

import com.jgoodies.binding.binder.BeanBinder;
import com.jgoodies.binding.binder.Binders;
import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.jsdl.i18n.Resources;
import com.jgoodies.common.swing.Listeners;
import com.jgoodies.components.JGComponentFactory;
import com.jgoodies.dialogs.basics.accessibility.ControlListModel;
import com.jgoodies.dialogs.basics.accessibility.ControlListResources;
import com.jgoodies.dialogs.core.AspectRatio;
import com.jgoodies.dialogs.core.CommandValue;
import com.jgoodies.dialogs.core.PreferredWidth;
import com.jgoodies.dialogs.core.pane.task.TaskPane;
import com.jgoodies.dialogs.core.pane.task.TaskPaneBuilder;
import com.jgoodies.layout.builder.FormBuilder;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JRadioButton;

final class ControlListView {
    static final String DIALOG_MARKER = "ControlListView";
    private final ControlListModel model;
    private final ControlListResources resources = Resources.get(ControlListResources.class);
    private JList<String> elementNameList;
    private JRadioButton sortByFocusOrderRadio;
    private JRadioButton sortByNameRadio;

    ControlListView(ControlListModel model) {
        this.model = Preconditions.checkNotNull(model, "The %s must not be null.", "model");
        this.initComponents();
        this.initBindings();
        this.initEventHandling();
    }

    private void initComponents() {
        JGComponentFactory factory = JGComponentFactory.getCurrent();
        this.elementNameList = factory.createList(new String[0]);
        this.elementNameList.getAccessibleContext().setAccessibleName(this.resources.list_accessibleName);
        this.sortByFocusOrderRadio = factory.createRadioButton(this.resources.sortByFocusOrder_text, this.resources.sortByFocusOrder_accessibleName);
        this.sortByNameRadio = factory.createRadioButton(this.resources.sortByName_text, this.resources.sortByName_accessibleName);
    }

    private void initBindings() {
        BeanBinder binder = Binders.binderFor(this.model);
        binder.bind(this.model.getElementNamesModel(), this.model.getElementNamesSelectionModel()).to(this.elementNameList);
        binder.bindProperty("sortMode").to(this.sortByFocusOrderRadio, (Object)ControlListModel.SortMode.FOCUS_TRAVERSAL_ORDER);
        binder.bindProperty("sortMode").to(this.sortByNameRadio, (Object)ControlListModel.SortMode.ALPHABETICAL);
    }

    private void initEventHandling() {
        this.elementNameList.addMouseListener(Listeners.mouseDoubleClicked(this.model::onMouseDoubleClicked));
    }

    boolean showDialog(EventObject evt) {
        TaskPaneBuilder builder = ((TaskPaneBuilder)((TaskPaneBuilder)((TaskPaneBuilder)((TaskPaneBuilder)new TaskPaneBuilder().owner(evt)).title(this.resources.title, new Object[0])).mainInstructionText(this.resources.mainInstruction, new Object[0]).mainInstructionLabelsContent(true).content(this.buildContent()).commitCommands(CommandValue.OK, CommandValue.CLOSE).preferredWidth(PreferredWidth.LARGE)).aspectRatio(AspectRatio.NARROW)).marginContentTop(0);
        TaskPane pane = builder.build();
        JDialog dialog = builder.createDialog();
        dialog.getRootPane().putClientProperty(DIALOG_MARKER, Boolean.TRUE);
        dialog.setVisible(true);
        dialog.dispose();
        return !pane.isCancelled();
    }

    private JComponent buildContent() {
        return ((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)new FormBuilder().columns("p, $lcgap, fill:pref:grow", new Object[0])).rows("f:d:g, $rg, p", new Object[0])).add(this.elementNameList).xyw(1, 1, 3)).add(this.resources.sortBy, new Object[0]).xy(1, 3)).addBar(this.sortByFocusOrderRadio, this.sortByNameRadio).xy(3, 3)).build();
    }
}

