/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.dialogs.basics.choice.list_builder;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.layout.builder.FormBuilder;
import com.jgoodies.layout.util.FocusTraversalType;
import javax.swing.JButton;
import javax.swing.JComponent;

public final class ListBuilderPanelBuilder {
    private static final String FILTER_GAP_ROW = "1dlu";
    private static final String SUMMARY_GAP_ROW = "$rg";
    private static final String LIST_VIEW_COLUMN = "fill:[100dlu, default]:grow";
    private static final String LIST_VIEW_ROW = "fill:[120dlu, default]:grow";
    private JComponent optionsLabel;
    private JComponent optionsFilterView;
    private JComponent optionsView;
    private JComponent optionsSummaryView;
    private JButton[] buttons;
    private JComponent builtListLabel;
    private JComponent builtListFilterView;
    private JComponent builtListView;
    private JComponent builtListSummaryView;
    private String listViewColumn = "fill:[100dlu, default]:grow";
    private String listViewRow = "fill:[120dlu, default]:grow";

    public ListBuilderPanelBuilder optionsLabel(JComponent optionsLabel) {
        this.optionsLabel = Preconditions.checkNotNull(optionsLabel, "The %s must not be null.", "options label");
        return this;
    }

    public ListBuilderPanelBuilder optionsFilterView(JComponent optionsFilterView) {
        this.optionsFilterView = Preconditions.checkNotNull(optionsFilterView, "The %s must not be null.", "options filter view");
        return this;
    }

    public ListBuilderPanelBuilder optionsView(JComponent optionsView) {
        this.optionsView = Preconditions.checkNotNull(optionsView, "The %s must not be null.", "options view");
        return this;
    }

    public ListBuilderPanelBuilder optionsSummaryView(JComponent optionsDetailsView) {
        this.optionsSummaryView = Preconditions.checkNotNull(optionsDetailsView, "The %s must not be null.", "options details view");
        return this;
    }

    public ListBuilderPanelBuilder builtListLabel(JComponent builtListLabel) {
        this.builtListLabel = Preconditions.checkNotNull(builtListLabel, "The %s must not be null.", "built list label");
        return this;
    }

    public ListBuilderPanelBuilder builtListFilterView(JComponent builtListFilterView) {
        this.builtListFilterView = Preconditions.checkNotNull(builtListFilterView, "The %s must not be null.", "built list filter view");
        return this;
    }

    public ListBuilderPanelBuilder builtListView(JComponent builtListView) {
        this.builtListView = Preconditions.checkNotNull(builtListView, "The %s must not be null.", "built list view");
        return this;
    }

    public ListBuilderPanelBuilder builtListSummaryView(JComponent builtListDetailsView) {
        this.builtListSummaryView = Preconditions.checkNotNull(builtListDetailsView, "The %s must not be null.", "built list details view");
        return this;
    }

    public ListBuilderPanelBuilder listViewColumn(String columnSpecification) {
        this.listViewColumn = Preconditions.checkNotBlank(columnSpecification, "The %s must not be null, empty, or whitespace.", "list view column specification.");
        return this;
    }

    public ListBuilderPanelBuilder listViewRow(String rowSpecification) {
        this.listViewRow = Preconditions.checkNotBlank(rowSpecification, "The %s must not be null, empty, or whitespace.", "list view row specification.");
        return this;
    }

    public ListBuilderPanelBuilder buttons(JButton ... buttons) {
        this.buttons = Preconditions.checkNotNull(buttons, "The %s must not be null.", "buttons");
        return this;
    }

    public JComponent build() {
        boolean hasOptionsSummary = this.optionsSummaryView != null;
        boolean hasBuiltListSummary = this.builtListSummaryView != null;
        String summaryGapRow = hasOptionsSummary || hasBuiltListSummary ? SUMMARY_GAP_ROW : "0";
        return ((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)new FormBuilder().columns("%1$s, $rgap, $button, $rgap, %1$s", this.listViewColumn)).rows("p, $lcg, %1$s, %2$s, p", this.listViewRow, summaryGapRow)).honorsVisibility(true)).columnGroup(1, 5)).focusTraversalType(FocusTraversalType.CONTAINER_ORDER)).add(this.optionsLabel).xy(1, 1)).add(this.buildOptionsContent()).xy(1, 3)).add(hasOptionsSummary, this.optionsSummaryView).xy(1, 5)).addStack(this.buttons).xy(3, 3, "center, center")).add(this.builtListLabel).xy(5, 1)).add(this.buildBuiltListContent()).xy(5, 3)).add(hasBuiltListSummary, this.builtListSummaryView).xy(5, 5)).build();
    }

    private JComponent buildOptionsContent() {
        return ListBuilderPanelBuilder.buildFilterWithListView(this.optionsFilterView, this.optionsView);
    }

    private JComponent buildBuiltListContent() {
        return ListBuilderPanelBuilder.buildFilterWithListView(this.builtListFilterView, this.builtListView);
    }

    private static JComponent buildFilterWithListView(JComponent filterView, JComponent listView) {
        boolean hasFilter = filterView != null;
        String filterGapRow = hasFilter ? FILTER_GAP_ROW : "0";
        return ((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)new FormBuilder().columns("fill:0:grow", new Object[0])).rows("p, %s, f:0:g", filterGapRow)).add(hasFilter, filterView).xy(1, 1)).add(listView).xy(1, 3)).build();
    }
}

