/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.dialogs.core.plaf.basic;

import com.jgoodies.common.jsdl.internal.AudioUtils;
import com.jgoodies.dialogs.core.MessageType;
import com.jgoodies.dialogs.core.pane.AbstractStyledPane;
import com.jgoodies.dialogs.core.pane.AbstractStyledPaneVisualConfiguration;
import com.jgoodies.dialogs.core.plaf.basic.StyledPaneUI;
import com.jgoodies.layout.builder.FormBuilder;
import com.jgoodies.layout.layout.CellConstraints;
import com.jgoodies.layout.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;

public class BasicAbstractStyledPaneUI
extends StyledPaneUI {
    protected AbstractStyledPane<?> abstractStyledPane;
    protected PropertyChangeListener propertyChangeListener;

    public static ComponentUI createUI(JComponent x) {
        return new BasicAbstractStyledPaneUI();
    }

    @Override
    public void installUI(JComponent component) {
        this.abstractStyledPane = (AbstractStyledPane)component;
        this.installDefaults();
        this.abstractStyledPane.setLayout(this.createLayoutManager());
        this.installComponents();
        this.installListeners();
        this.installKeyboardActions();
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallComponents();
        this.abstractStyledPane.setLayout(null);
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.abstractStyledPane = null;
    }

    protected void installDefaults() {
        boolean headerEnabled;
        Object visualConfiguration = this.abstractStyledPane.getVisualConfiguration();
        if (((AbstractStyledPaneVisualConfiguration)visualConfiguration).getHeaderFont() == null || ((AbstractStyledPaneVisualConfiguration)visualConfiguration).getHeaderFont() instanceof UIResource) {
            ((AbstractStyledPaneVisualConfiguration)visualConfiguration).setHeaderFont(UIManager.getFont("AbstractStyledPane.header.font"));
        }
        if (((AbstractStyledPaneVisualConfiguration)visualConfiguration).getHeaderForeground() == null || ((AbstractStyledPaneVisualConfiguration)visualConfiguration).getHeaderForeground() instanceof UIResource) {
            ((AbstractStyledPaneVisualConfiguration)visualConfiguration).setHeaderForeground(UIManager.getColor("AbstractStyledPane.header.foreground"));
        }
        if (this.abstractStyledPane.getBackground() == null || this.abstractStyledPane.getBackground() instanceof UIResource) {
            this.abstractStyledPane.setBackground(UIManager.getColor("StyledPane.background"));
        }
        if (headerEnabled = UIManager.getBoolean("StyledPane.HeaderArea.enabled")) {
            ((AbstractStyledPaneVisualConfiguration)visualConfiguration).setHeaderArea(this.buildDefaultHeaderArea());
        }
        ((AbstractStyledPaneVisualConfiguration)visualConfiguration).setContentArea(this.buildDefaultContentArea());
        boolean commandAreaEnabled = UIManager.getBoolean("StyledPane.CommandArea.enabled");
        if (commandAreaEnabled) {
            ((AbstractStyledPaneVisualConfiguration)visualConfiguration).setCommandArea(this.buildDefaultCommandArea());
        }
    }

    protected void uninstallDefaults() {
    }

    protected void installComponents() {
        Object visualConfiguration = this.abstractStyledPane.getVisualConfiguration();
        FormBuilder builder = (FormBuilder)((FormBuilder)new FormBuilder().columns(this.getHorizontalLayoutSpec(), new Object[0])).rows(this.getVerticalLayoutSpec(), new Object[0]);
        Color dialogBackground = this.abstractStyledPane.getBackground();
        if (dialogBackground != null) {
            builder.background(dialogBackground);
        }
        builder.add(((AbstractStyledPaneVisualConfiguration)visualConfiguration).getHeaderArea()).xywh(1, 1, 4, 3, "fill, fill");
        int contentXStart = this.getContentXStart();
        int contentWidth = this.getContentXEnd() - contentXStart;
        builder.add(this.abstractStyledPane.getContent()).xyw(contentXStart, 5, contentWidth);
        builder.add(((AbstractStyledPaneVisualConfiguration)visualConfiguration).getContentArea()).xywh(1, 4, 4, 3);
        if (((AbstractStyledPaneVisualConfiguration)visualConfiguration).isCommandContentVisible()) {
            JComponent commandContent = this.buildCommandContent();
            builder.add(commandContent).xyw(2, 7, 2, CellConstraints.FILL, CellConstraints.CENTER);
            builder.add(((AbstractStyledPaneVisualConfiguration)visualConfiguration).getCommandArea()).xyw(1, 7, 4);
        }
        this.abstractStyledPane.add((Component)builder.build(), new CellConstraints(1, 1));
    }

    protected void uninstallComponents() {
        Component child;
        if (this.abstractStyledPane.getComponentCount() == 1 && (child = this.abstractStyledPane.getComponent(0)) instanceof Container) {
            ((Container)child).removeAll();
        }
        this.abstractStyledPane.removeAll();
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        if (this.propertyChangeListener != null) {
            this.abstractStyledPane.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    protected void uninstallListeners() {
        if (this.propertyChangeListener != null) {
            this.abstractStyledPane.removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
    }

    protected void installKeyboardActions() {
        AudioUtils.installSharedActionMap(this.abstractStyledPane, "StyledPane.actionMap");
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.abstractStyledPane, null);
    }

    protected LayoutManager createLayoutManager() {
        int minWidth = Math.max(this.abstractStyledPane.getPreferredWidth(), 100) - 10;
        return new FormLayout("fill:[" + minWidth + "dlu,default]:grow", "fill:default:grow");
    }

    protected final int getContentXStart() {
        AbstractStyledPaneVisualConfiguration.ContentAlignmentLeft alignLeft = ((AbstractStyledPaneVisualConfiguration)this.abstractStyledPane.getVisualConfiguration()).getContentAlignmentLeft();
        switch (alignLeft) {
            case BORDER: {
                return 1;
            }
            case MAIN_ICON: {
                return 2;
            }
            case MAIN_INSTRUCTION: {
                return 3;
            }
        }
        throw new IllegalStateException("Unknown content alignment left: " + (Object)((Object)alignLeft));
    }

    protected final int getContentXEnd() {
        AbstractStyledPaneVisualConfiguration.ContentAlignmentRight alignRight = ((AbstractStyledPaneVisualConfiguration)this.abstractStyledPane.getVisualConfiguration()).getContentAlignmentRight();
        switch (alignRight) {
            case BORDER: {
                return 5;
            }
            case MAIN_INSTRUCTION: {
                return 4;
            }
        }
        throw new IllegalStateException("Unknown content alignment right: " + (Object)((Object)alignRight));
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new BasicPropertyChangeHandler();
    }

    protected JComponent buildDefaultHeaderArea() {
        Color backgroundColor;
        JPanel area = new JPanel(new BorderLayout());
        Color separatorColor = UIManager.getColor("StyledPane.HeaderArea.separator");
        if (separatorColor != null) {
            JPanel separator = new JPanel(null);
            separator.setBackground(separatorColor);
            area.add((Component)separator, "South");
        }
        if ((backgroundColor = UIManager.getColor("StyledPane.HeaderArea.background")) != null) {
            JPanel filler = new JPanel(null);
            filler.setBackground(backgroundColor);
            area.add((Component)filler, "Center");
        }
        return area;
    }

    protected JComponent buildDefaultContentArea() {
        return null;
    }

    protected JComponent buildDefaultCommandArea() {
        Color backgroundColor;
        JPanel area = new JPanel(new BorderLayout());
        Color separatorColor = UIManager.getColor("StyledPane.CommandArea.separator");
        if (separatorColor != null) {
            JPanel separator = new JPanel(null);
            separator.setBackground(separatorColor);
            area.add((Component)separator, "North");
        }
        if ((backgroundColor = UIManager.getColor("StyledPane.CommandArea.background")) != null) {
            JPanel filler = new JPanel(null);
            filler.setBackground(backgroundColor);
            area.add((Component)filler, "Center");
        }
        return area;
    }

    protected JComponent buildCommandContent() {
        JComponent commitBar = this.abstractStyledPane.getCommandBar();
        return ((FormBuilder)((FormBuilder)((FormBuilder)new FormBuilder().columns("pref:grow", new Object[0])).rows("pref", new Object[0])).add(commitBar != null, commitBar).xy(1, 1)).build();
    }

    protected boolean hasPreferredWidth() {
        return this.abstractStyledPane.getPreferredWidth() > 0;
    }

    protected String getHorizontalLayoutSpec() {
        return String.format("%1$sdlu, pref, fill:%2$s:grow, %3$sdlu", ((AbstractStyledPaneVisualConfiguration)this.abstractStyledPane.getVisualConfiguration()).getMarginDialogLeft(), this.hasPreferredWidth() ? "0" : "default", ((AbstractStyledPaneVisualConfiguration)this.abstractStyledPane.getVisualConfiguration()).getMarginDialogRight());
    }

    protected String getVerticalLayoutSpec() {
        Object visualConfiguration = this.abstractStyledPane.getVisualConfiguration();
        return String.format("%1$sdlu, p, %2$sdlu, %3$sdlu, f:d:g, %4$sdlu, f:[%5$sdlu,p]", ((AbstractStyledPaneVisualConfiguration)visualConfiguration).getMarginHeaderTop(), ((AbstractStyledPaneVisualConfiguration)visualConfiguration).getMarginHeaderBottom(), ((AbstractStyledPaneVisualConfiguration)visualConfiguration).getMarginContentTop(), ((AbstractStyledPaneVisualConfiguration)visualConfiguration).getMarginContentBottom(), ((AbstractStyledPaneVisualConfiguration)visualConfiguration).getMinHeightCommandArea());
    }

    protected boolean propertyRequiresNoUIHandling(String name) {
        return "aspectRatio".equals(name) || "commitValue".equals(name) || "preferredSize".equals(name) || "UI".equals(name);
    }

    protected boolean propertyRequiresRevalidation(String name) {
        return false;
    }

    protected class BasicPropertyChangeHandler
    implements PropertyChangeListener {
        protected BasicPropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() != BasicAbstractStyledPaneUI.this.abstractStyledPane) {
                return;
            }
            AbstractStyledPane sp = (AbstractStyledPane)evt.getSource();
            String propertyName = evt.getPropertyName();
            if ("ancestor".equals(propertyName)) {
                boolean comingUp;
                boolean bl = comingUp = evt.getOldValue() == null;
                if (comingUp) {
                    this.playSound(sp, sp.getMessageType());
                }
            } else if ("componentOrientation".equals(propertyName)) {
                ComponentOrientation o = (ComponentOrientation)evt.getNewValue();
                if (o != (ComponentOrientation)evt.getOldValue()) {
                    sp.applyComponentOrientation(o);
                }
            } else if (!BasicAbstractStyledPaneUI.this.propertyRequiresNoUIHandling(propertyName)) {
                if (BasicAbstractStyledPaneUI.this.propertyRequiresRevalidation(propertyName)) {
                    this.revalidate();
                } else {
                    this.reinstall();
                }
            }
        }

        protected void revalidate() {
            BasicAbstractStyledPaneUI.this.abstractStyledPane.validate();
            BasicAbstractStyledPaneUI.this.abstractStyledPane.repaint();
        }

        protected void reinstall() {
            Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            JRootPane rootPane = BasicAbstractStyledPaneUI.this.abstractStyledPane.getRootPane();
            JButton defaultButton = rootPane != null ? rootPane.getDefaultButton() : null;
            BasicAbstractStyledPaneUI.this.uninstallComponents();
            BasicAbstractStyledPaneUI.this.installComponents();
            if (focusOwner != null) {
                focusOwner.requestFocusInWindow();
            }
            if (defaultButton != null && rootPane.isAncestorOf(defaultButton)) {
                rootPane.setDefaultButton(defaultButton);
            }
            BasicAbstractStyledPaneUI.this.abstractStyledPane.validate();
        }

        protected void playSound(AbstractStyledPane<?> sp, MessageType mt) {
            switch (mt) {
                case PLAIN: {
                    break;
                }
                case QUESTION: {
                    break;
                }
                case INFORMATION: {
                    break;
                }
                case WARNING: 
                case QUESTION_CRITICAL: {
                    this.playSound(sp, "OptionPane.warningSound");
                    break;
                }
                case ERROR: {
                    this.playSound(sp, "OptionPane.errorSound");
                    break;
                }
                case HELP: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown MessageType: " + (Object)((Object)mt));
                }
            }
        }

        private void playSound(JComponent c, String key) {
            AudioUtils.playSound(c, key);
        }
    }
}

