/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.fluent.tiles;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.base.Strings;
import com.jgoodies.common.bean.Bean;
import com.jgoodies.common.jsdl.icon.DynamicIconValue;
import com.jgoodies.fluent.Badge;
import com.jgoodies.fluent.internal.FluentResources;
import com.jgoodies.fluent.internal.IFluentResources;
import com.jgoodies.fluent.tiles.Tile;
import java.awt.Color;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.function.Consumer;

public abstract class AbstractTile
extends Bean
implements Tile {
    public static final String PROPERTY_BACKGROUND = "background";
    public static final String PROPERTY_FOREGROUND = "foreground";
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_LOGO = "logo";
    public static final String PROPERTY_LOGO_INSETS = "iconInsets";
    public static final String PROPERTY_BRANDING = "branding";
    public static final String PROPERTY_BADGE = "badge";
    protected final IFluentResources resources;
    private Tile.Size size;
    private Point origin;
    private Color background;
    private Color foreground;
    private String name;
    private DynamicIconValue logo;
    private Insets logoInsets = new Insets(0, 0, 0, 0);
    private Branding branding = Branding.NAME_AND_LOGO;
    private Badge badge = Badge.NONE;
    private Consumer<ActionEvent> onAction;
    private Consumer<MouseEvent> onContextMenu;

    protected AbstractTile() {
        this.resources = FluentResources.getInstance();
    }

    @Override
    public Tile.Size getSize() {
        return this.size;
    }

    public void setSize(Tile.Size newValue) {
        this.size = newValue;
        this.firePropertyChange("size", (Object)this.size, (Object)this.size);
    }

    @Override
    public Point getOrigin() {
        return this.origin;
    }

    public void setOrigin(Point newValue) {
        this.origin = newValue;
        this.firePropertyChange("origin", this.origin, this.origin);
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color newValue) {
        this.background = newValue;
        this.firePropertyChange(PROPERTY_BACKGROUND, this.background, this.background);
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setForeground(Color newValue) {
        this.foreground = newValue;
        this.firePropertyChange(PROPERTY_FOREGROUND, this.foreground, this.foreground);
    }

    public void setState(TileState state) {
        this.setBackground(this.resources.toBackground(state));
        this.setForeground(this.resources.toForeground(state));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newValue) {
        this.name = newValue;
        this.firePropertyChange(PROPERTY_NAME, this.name, this.name);
    }

    public DynamicIconValue getLogo() {
        return this.logo;
    }

    public void setLogo(DynamicIconValue newValue) {
        this.logo = newValue;
        this.firePropertyChange(PROPERTY_LOGO, this.logo, this.logo);
    }

    public Insets getLogoInsets() {
        return this.logoInsets;
    }

    public void setLogoInsets(Insets newValue) {
        this.logoInsets = newValue;
        this.firePropertyChange(PROPERTY_LOGO_INSETS, this.logoInsets, this.logoInsets);
    }

    public Branding getBranding() {
        return this.branding;
    }

    public void setBranding(Branding newValue) {
        Preconditions.checkNotNull(newValue, "The %s must not be null.", PROPERTY_BRANDING);
        this.branding = newValue;
        this.firePropertyChange(PROPERTY_BRANDING, (Object)this.branding, (Object)this.branding);
    }

    public Badge getBadge() {
        return this.badge;
    }

    public void setBadge(Badge newValue) {
        Preconditions.checkNotNull(newValue, "The %s must not be null.", PROPERTY_BADGE);
        this.badge = newValue;
        this.firePropertyChange(PROPERTY_BADGE, this.badge, this.badge);
    }

    public Consumer<ActionEvent> getOnAction() {
        return this.onAction;
    }

    public void setOnAction(Consumer<ActionEvent> handler) {
        this.onAction = handler;
    }

    public Consumer<MouseEvent> getOnContextMenu() {
        return this.onContextMenu;
    }

    public void setOnContextMenu(Consumer<MouseEvent> handler) {
        this.onContextMenu = handler;
    }

    public static abstract class AbstractBuilder<T extends AbstractTile, B extends AbstractBuilder<T, ?>> {
        protected final T target = this.createTarget();

        protected AbstractBuilder() {
        }

        protected abstract T createTarget();

        public final B foreground(Color value) {
            ((AbstractTile)this.target).setForeground(value);
            return (B)this;
        }

        public final B background(Color value) {
            ((AbstractTile)this.target).setBackground(value);
            return (B)this;
        }

        public final B state(TileState type) {
            ((AbstractTile)this.target).setState(type);
            return (B)this;
        }

        public final B error() {
            return this.state(TileState.ERROR);
        }

        public final B warning() {
            return this.state(TileState.WARNING);
        }

        public final B success() {
            return this.state(TileState.SUCCESS);
        }

        public final B info() {
            return this.state(TileState.INFO);
        }

        public final B name(String str, Object ... args) {
            ((AbstractTile)this.target).setName(Strings.get(str, args));
            return (B)this;
        }

        public final B logo(DynamicIconValue value) {
            ((AbstractTile)this.target).setLogo(value);
            return (B)this;
        }

        public final B logo(DynamicIconValue value, Insets insets) {
            ((AbstractTile)this.target).setLogo(value);
            ((AbstractTile)this.target).setLogoInsets(insets);
            return (B)this;
        }

        public final B logoInsets(Insets value) {
            ((AbstractTile)this.target).setLogoInsets(value);
            return (B)this;
        }

        public final B size(Tile.Size value) {
            ((AbstractTile)this.target).setSize(value);
            return (B)this;
        }

        public final B small() {
            return this.size(Tile.Size.SMALL);
        }

        public final B medium() {
            return this.size(Tile.Size.MEDIUM);
        }

        public final B wide() {
            return this.size(Tile.Size.WIDE);
        }

        public final B large() {
            return this.size(Tile.Size.LARGE);
        }

        public final B origin(int x, int y) {
            ((AbstractTile)this.target).setOrigin(new Point(x, y));
            return (B)this;
        }

        public final B onAction(Consumer<ActionEvent> value) {
            ((AbstractTile)this.target).setOnAction(value);
            return (B)this;
        }

        public final B onContextMenu(Consumer<MouseEvent> value) {
            ((AbstractTile)this.target).setOnContextMenu(value);
            return (B)this;
        }

        public final B branding(Branding value) {
            ((AbstractTile)this.target).setBranding(value);
            return (B)this;
        }

        public final B badge(int value) {
            return this.badge(new Badge(value));
        }

        public final B badge(Badge badge) {
            ((AbstractTile)this.target).setBadge(badge);
            return (B)this;
        }

        protected T build() {
            return this.target;
        }
    }

    public static enum Branding {
        NONE,
        LOGO,
        NAME,
        NAME_AND_LOGO;

    }

    public static enum TileState {
        ERROR,
        WARNING,
        SUCCESS,
        NEUTRAL,
        INFO,
        DEFAULT;

    }
}

