/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.framework.util;

import java.awt.EventQueue;
import java.awt.SecondaryLoop;
import java.awt.Toolkit;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public final class Background {
    private Background() {
    }

    public static <T> void accept(Consumer<T> consumer, T argument) {
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        SecondaryLoop secondaryLoop = eventQueue.createSecondaryLoop();
        BackgroundConsumer background = new BackgroundConsumer(secondaryLoop, consumer, argument);
        Thread thread = new Thread(background, "BackgroundConsumer -" + consumer.getClass().getSimpleName());
        thread.start();
        secondaryLoop.enter();
        if (background.exception != null) {
            throw background.exception;
        }
    }

    public static <T, R> R apply(Function<T, R> function, T argument) {
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        SecondaryLoop secondaryLoop = eventQueue.createSecondaryLoop();
        BackgroundFunction background = new BackgroundFunction(secondaryLoop, function, argument);
        Thread thread = new Thread(background, "BackgroundFunction -" + function.getClass().getSimpleName());
        thread.start();
        secondaryLoop.enter();
        if (background.exception != null) {
            throw background.exception;
        }
        return (R)background.result;
    }

    public static <R> R call(Callable<R> callable) throws Exception {
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        SecondaryLoop secondaryLoop = eventQueue.createSecondaryLoop();
        BackgroundCallable background = new BackgroundCallable(secondaryLoop, callable);
        Thread thread = new Thread(background, "BackgroundCallable: " + callable.getClass().getSimpleName());
        thread.start();
        secondaryLoop.enter();
        if (background.exception != null) {
            throw background.exception;
        }
        return (R)background.result;
    }

    public static <T> boolean test(Predicate<T> predicate, T argument) {
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        SecondaryLoop secondaryLoop = eventQueue.createSecondaryLoop();
        BackgroundPredicate background = new BackgroundPredicate(secondaryLoop, predicate, argument);
        Thread thread = new Thread(background, "BackgroundPredicate -" + predicate.getClass().getSimpleName());
        thread.start();
        secondaryLoop.enter();
        if (background.exception != null) {
            throw background.exception;
        }
        return background.result;
    }

    public static <R> R get(Supplier<R> supplier) {
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        SecondaryLoop secondaryLoop = eventQueue.createSecondaryLoop();
        BackgroundSupplier background = new BackgroundSupplier(secondaryLoop, supplier);
        Thread thread = new Thread(background, "BackgroundSupplier -" + supplier.getClass().getSimpleName());
        thread.start();
        secondaryLoop.enter();
        if (background.exception != null) {
            throw background.exception;
        }
        return (R)background.result;
    }

    public static <T> Consumer<T> toBackground(Consumer<T> consumer) {
        return t -> Background.accept(consumer, t);
    }

    public static <T, R> Function<T, R> toBackground(Function<T, R> function) {
        return t -> Background.apply(function, t);
    }

    public static <R> Callable<R> toBackground(Callable<R> callable) {
        return () -> Background.call(callable);
    }

    public static <T> Predicate<T> toBackground(Predicate<T> predicate) {
        return t -> Background.test(predicate, t);
    }

    public static <R> Supplier<R> toBackground(Supplier<R> supplier) {
        return () -> Background.get(supplier);
    }

    private static final class BackgroundCallable<R>
    implements Runnable {
        private final SecondaryLoop loop;
        private final Callable<R> delegate;
        private R result;
        private Exception exception;

        private BackgroundCallable(SecondaryLoop loop, Callable<R> delegate) {
            this.loop = loop;
            this.delegate = delegate;
        }

        @Override
        public void run() {
            try {
                this.result = this.delegate.call();
            }
            catch (Exception ex) {
                this.exception = ex;
                this.result = null;
            }
            finally {
                this.loop.exit();
            }
        }
    }

    private static final class BackgroundConsumer<T>
    implements Runnable {
        private final SecondaryLoop loop;
        private final Consumer<T> delegate;
        private final T argument;
        private RuntimeException exception;

        private BackgroundConsumer(SecondaryLoop loop, Consumer<T> delegate, T argument) {
            this.loop = loop;
            this.delegate = delegate;
            this.argument = argument;
        }

        @Override
        public void run() {
            try {
                this.delegate.accept(this.argument);
            }
            catch (RuntimeException ex) {
                this.exception = ex;
            }
            finally {
                this.loop.exit();
            }
        }
    }

    private static final class BackgroundFunction<T, R>
    implements Runnable {
        private final SecondaryLoop loop;
        private final Function<T, R> delegate;
        private final T argument;
        private R result;
        private RuntimeException exception;

        private BackgroundFunction(SecondaryLoop loop, Function<T, R> delegate, T argument) {
            this.loop = loop;
            this.delegate = delegate;
            this.argument = argument;
        }

        @Override
        public void run() {
            try {
                this.result = this.delegate.apply(this.argument);
            }
            catch (RuntimeException ex) {
                this.exception = ex;
                this.result = null;
            }
            finally {
                this.loop.exit();
            }
        }
    }

    private static final class BackgroundPredicate<T>
    implements Runnable {
        private final SecondaryLoop loop;
        private final Predicate<T> delegate;
        private final T argument;
        private boolean result;
        private RuntimeException exception;

        private BackgroundPredicate(SecondaryLoop loop, Predicate<T> delegate, T argument) {
            this.loop = loop;
            this.delegate = delegate;
            this.argument = argument;
        }

        @Override
        public void run() {
            try {
                this.result = this.delegate.test(this.argument);
            }
            catch (RuntimeException ex) {
                this.exception = ex;
            }
            finally {
                this.loop.exit();
            }
        }
    }

    private static final class BackgroundSupplier<R>
    implements Runnable {
        private final SecondaryLoop loop;
        private final Supplier<R> delegate;
        private R result;
        private RuntimeException exception;

        private BackgroundSupplier(SecondaryLoop loop, Supplier<R> delegate) {
            this.loop = loop;
            this.delegate = delegate;
        }

        @Override
        public void run() {
            try {
                this.result = this.delegate.get();
            }
            catch (RuntimeException ex) {
                this.exception = ex;
                this.result = null;
            }
            finally {
                this.loop.exit();
            }
        }
    }
}

