/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.jdiskreport.gui.application;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.base.Strings;
import com.jgoodies.common.bean.Bean;
import com.jgoodies.framework.builder.PopupMenuBuilder;
import com.jgoodies.framework.search.FieldSearchProcessor;
import com.jgoodies.jdiskreport.gui.application.JDResultModel;
import com.jgoodies.jdiskreport.gui.node.DirectoryNode;
import com.jgoodies.jdiskreport.gui.node.RootNode;
import com.jgoodies.jdiskreport.gui.settings.GUISettings;
import com.jgoodies.search.Completion;
import com.jgoodies.search.CompletionProcessor;
import com.jgoodies.search.CompletionPublisher;
import com.jgoodies.search.CompletionState;
import com.jgoodies.search.ValueCompletion;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public final class JDNavigationModel
extends Bean {
    public static final String PROPERTY_SELECTION = "selection";
    private final JDResultModel resultModel;
    private DirectoryNode selection;
    private final DirectoryNode.FileTreeModel dataModel;
    private final TreeSelectionModel selectionModel;

    JDNavigationModel(JDResultModel resultModel) {
        this.resultModel = resultModel;
        GUISettings.SortMode sortMode = resultModel.getGuiSettings().getSortMode();
        RootNode rootNode = resultModel.getRootNode();
        this.dataModel = rootNode.getTreeModel(sortMode);
        this.selectionModel = new DefaultTreeSelectionModel();
        this.selectionModel.setSelectionMode(1);
        this.setSelectionPathTo(rootNode);
        this.initEventHandling();
    }

    private void initEventHandling() {
        this.selectionModel.addTreeSelectionListener(this::onTreeSelectionChanged);
        this.resultModel.getHistory().addPropertyChangeListener(PROPERTY_SELECTION, this::onSelectionChanged);
        this.resultModel.getGuiSettings().addPropertyChangeListener("sortMode", this::onSortModeChanged);
    }

    DirectoryNode.FileTreeModel getDataModel() {
        return this.dataModel;
    }

    TreeSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    CompletionProcessor getSearchProcessor() {
        return new SearchProcessor(this);
    }

    DirectoryNode getSelection() {
        return this.selection;
    }

    private void setSelection(DirectoryNode newSelection) {
        DirectoryNode oldSelection = this.getSelection();
        this.selection = newSelection;
        this.firePropertyChange(PROPERTY_SELECTION, oldSelection, newSelection);
        this.resultModel.getHistory().setSelection(newSelection);
    }

    void setSelectionPathTo(DirectoryNode node) {
        this.selectionModel.setSelectionPath(node.getPathToRoot());
    }

    void goUp() {
        Preconditions.checkState(this.isUpPossible(), "Can't go up, because the node has no parent, i.e. the selected node is the root.");
        this.setSelection(this.getSelection().getParent());
    }

    boolean isUpPossible() {
        return this.selection.getParent() != null;
    }

    void updateRoot(RootNode root) {
        this.dataModel.setRoot(root);
        this.setSelectionPathTo(root);
    }

    private void onTreeSelectionChanged(TreeSelectionEvent evt) {
        DirectoryNode newSelection;
        TreePath path = this.selectionModel.getSelectionPath();
        DirectoryNode directoryNode = newSelection = path == null ? null : (DirectoryNode)path.getLastPathComponent();
        if (newSelection == null) {
            return;
        }
        this.setSelection(newSelection);
    }

    private void onSelectionChanged(PropertyChangeEvent evt) {
        DirectoryNode selection = (DirectoryNode)evt.getNewValue();
        this.setSelectionPathTo(selection);
    }

    private void onSortModeChanged(PropertyChangeEvent evt) {
        GUISettings.SortMode sortMode = this.resultModel.getGuiSettings().getSortMode();
        this.dataModel.setSortMode(sortMode);
    }

    void onContextMenuRequested(MouseEvent evt) {
        new PopupMenuBuilder().actionProvider(this.resultModel).action("OpenFolderInFileView").separator().action("DeleteSelectedFolder").show(evt);
    }

    private static final class SearchProcessor
    implements FieldSearchProcessor<DirectoryNode> {
        private final JDNavigationModel model;

        SearchProcessor(JDNavigationModel model) {
            this.model = model;
        }

        @Override
        public boolean isAutoActivatable(String content, int caretPosition) {
            if (content.length() == 0) {
                return false;
            }
            List<DirectoryNode> matches = this.matches(content);
            int count = matches.size();
            return count > 0;
        }

        @Override
        public boolean search(String content, int caretPosition, CompletionPublisher publisher, CompletionState state) {
            List<DirectoryNode> matches = this.matches(content);
            for (DirectoryNode node : matches) {
                String pathName = node.getPathName();
                ((ValueCompletion.Builder)((ValueCompletion.Builder)new ValueCompletion.Builder().displayString(pathName, new Object[0])).replacementText(pathName, new Object[0])).value(node).publish(publisher);
            }
            return true;
        }

        @Override
        public String getDisplayString(DirectoryNode value) {
            return value.getPathName();
        }

        @Override
        public DirectoryNode valueFor(Completion completion) {
            return (DirectoryNode)((ValueCompletion)completion).getValue();
        }

        @Override
        public boolean represents(String text, DirectoryNode value) {
            return text.trim().equals(value.getPathName());
        }

        @Override
        public DirectoryNode searchValue(String text) {
            return null;
        }

        private List<DirectoryNode> matches(String text) {
            ArrayList<DirectoryNode> result = new ArrayList<DirectoryNode>();
            DirectoryNode root = (DirectoryNode)this.model.getDataModel().getRoot();
            this.addMatches(text, root, result);
            return result;
        }

        private void addMatches(String text, DirectoryNode parent, List<DirectoryNode> toAppendTo) {
            for (DirectoryNode child : parent.getChildDirectories()) {
                if (Strings.startsWithIgnoreCase(child.getName(), text)) {
                    toAppendTo.add(child);
                }
                this.addMatches(text, child, toAppendTo);
            }
        }
    }
}

