/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.jdiskreport.gui.node;

import com.jgoodies.jdiskreport.domain.FileSnapshot;
import com.jgoodies.jdiskreport.gui.node.AbstractNode;
import com.jgoodies.jdiskreport.gui.shared.util.ExtFileSystemView;
import java.io.File;
import javax.swing.Icon;

public final class FileNode
extends AbstractNode {
    private final FileSnapshot snapshot;

    public FileNode(FileSnapshot snapshot) {
        this.snapshot = snapshot;
    }

    @Override
    public String getName() {
        return this.snapshot.getName();
    }

    public File getPath() {
        return this.getFile();
    }

    @Override
    public boolean isFileLeaf() {
        return true;
    }

    @Override
    public long getSize() {
        return this.snapshot.getSize();
    }

    @Override
    public long getFileCount() {
        return 1L;
    }

    public long getLastModifiedMillis() {
        return this.snapshot.getLastModifiedMillis();
    }

    public long getLastAccessMillis() {
        return this.snapshot.getLastAccessMillis();
    }

    public long getLastUsedMillis() {
        return this.snapshot.getLastUsedMillis();
    }

    @Override
    public Icon getIcon(boolean selected) {
        return ExtFileSystemView.getInstance().getLeafIcon(this.getFile());
    }

    public String getSuffix() {
        String name = this.getName();
        int index = name.lastIndexOf(46);
        return index == -1 ? null : name.substring(index + 1).toLowerCase();
    }
}

