/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.jdiskreport.gui.statistic;

import com.jgoodies.jdiskreport.gui.node.FileNode;
import com.jgoodies.jdiskreport.gui.statistic.AbstractDistribution;
import com.jgoodies.jdiskreport.gui.statistic.LastAccessDistribution;
import com.jgoodies.jdiskreport.gui.statistic.LastModifiedDistribution;
import com.jgoodies.jdiskreport.gui.statistic.LimitedTreeSet;
import com.jgoodies.jdiskreport.gui.statistic.SizeDistribution;
import com.jgoodies.jdiskreport.gui.statistic.TopList;
import com.jgoodies.jdiskreport.gui.statistic.TypeDistribution;
import java.util.List;

public final class Statistics {
    private final TopList largestFiles;
    private final TopList leastRecentlyModifiedFiles;
    private final TopList mostRecentlyModifiedFiles;
    private final TopList leastRecentlyAccessedFiles;
    private final TopList mostRecentlyAccessedFiles;
    private final TopList leastRecentlyUsedFiles;
    private final TopList mostRecentlyUsedFiles;
    private final AbstractDistribution sizeDistribution;
    private final AbstractDistribution modifiedDistribution;
    private final AbstractDistribution accessedDistribution;
    private final TypeDistribution typeDistribution;

    private Statistics(TopList largestFiles, TopList leastRecentlyModifiedFiles, TopList mostRecentlyModifiedFiles, TopList leastRecentlyAccessedFiles, TopList mostRecentlyAccessedFiles, TopList leastRecentlyUsedFiles, TopList mostRecentlyUsedFiles, AbstractDistribution sizeDistribution, AbstractDistribution modifiedDistribution, AbstractDistribution accessedDistribution, TypeDistribution typeDistribution) {
        this.largestFiles = largestFiles;
        this.leastRecentlyModifiedFiles = leastRecentlyModifiedFiles;
        this.mostRecentlyModifiedFiles = mostRecentlyModifiedFiles;
        this.leastRecentlyAccessedFiles = leastRecentlyAccessedFiles;
        this.mostRecentlyAccessedFiles = mostRecentlyAccessedFiles;
        this.leastRecentlyUsedFiles = leastRecentlyUsedFiles;
        this.mostRecentlyUsedFiles = mostRecentlyUsedFiles;
        this.sizeDistribution = sizeDistribution;
        this.modifiedDistribution = modifiedDistribution;
        this.accessedDistribution = accessedDistribution;
        this.typeDistribution = typeDistribution;
    }

    public static Statistics createFrom(FileNode[] allFiles) {
        LimitedTreeSet<FileNode> top50LargestSet = new LimitedTreeSet<FileNode>(50, TopList.LARGEST_COMPARATOR);
        LimitedTreeSet<FileNode> top50LeastRecentlyModifiedSet = new LimitedTreeSet<FileNode>(50, TopList.LEAST_RECENTLY_MODIFIED_COMPARATOR);
        LimitedTreeSet<FileNode> top50MostRecentlyModifiedSet = new LimitedTreeSet<FileNode>(50, TopList.MOST_RECENTLY_MODIFIED_COMPARATOR);
        LimitedTreeSet<FileNode> top50LeastRecentlyAccessedSet = new LimitedTreeSet<FileNode>(50, TopList.LEAST_RECENTLY_ACCESSED_COMPARATOR);
        LimitedTreeSet<FileNode> top50MostRecentlyAccessedSet = new LimitedTreeSet<FileNode>(50, TopList.MOST_RECENTLY_ACCESSED_COMPARATOR);
        LimitedTreeSet<FileNode> top50LeastRecentlyUsedSet = new LimitedTreeSet<FileNode>(50, TopList.LEAST_RECENTLY_USED_COMPARATOR);
        LimitedTreeSet<FileNode> top50MostRecentlyUsedSet = new LimitedTreeSet<FileNode>(50, TopList.MOST_RECENTLY_USED_COMPARATOR);
        SizeDistribution sizeDistribution = new SizeDistribution();
        LastModifiedDistribution modifiedDistribution = new LastModifiedDistribution();
        LastAccessDistribution accessedDistribution = new LastAccessDistribution();
        TypeDistribution typeDistribution = new TypeDistribution();
        for (FileNode fileNode : allFiles) {
            top50LargestSet.add(fileNode);
            top50LeastRecentlyModifiedSet.add(fileNode);
            top50MostRecentlyModifiedSet.add(fileNode);
            top50LeastRecentlyAccessedSet.add(fileNode);
            top50MostRecentlyAccessedSet.add(fileNode);
            top50LeastRecentlyUsedSet.add(fileNode);
            top50MostRecentlyUsedSet.add(fileNode);
            ((AbstractDistribution)sizeDistribution).add(fileNode);
            ((AbstractDistribution)modifiedDistribution).add(fileNode);
            ((AbstractDistribution)accessedDistribution).add(fileNode);
            typeDistribution.add(fileNode);
        }
        return new Statistics(new TopList(top50LargestSet), new TopList(top50LeastRecentlyModifiedSet), new TopList(top50MostRecentlyModifiedSet), new TopList(top50LeastRecentlyAccessedSet), new TopList(top50MostRecentlyAccessedSet), new TopList(top50LeastRecentlyUsedSet), new TopList(top50MostRecentlyUsedSet), sizeDistribution, modifiedDistribution, accessedDistribution, typeDistribution);
    }

    public static Statistics createFrom(List<Statistics> allStatistics) {
        LimitedTreeSet<FileNode> top50LargestSet = new LimitedTreeSet<FileNode>(50, TopList.LARGEST_COMPARATOR);
        LimitedTreeSet<FileNode> top50LeastRecentlyModifiedSet = new LimitedTreeSet<FileNode>(50, TopList.LEAST_RECENTLY_MODIFIED_COMPARATOR);
        LimitedTreeSet<FileNode> top50MostRecentlyModifiedSet = new LimitedTreeSet<FileNode>(50, TopList.MOST_RECENTLY_MODIFIED_COMPARATOR);
        LimitedTreeSet<FileNode> top50LeastRecentlyAccessedSet = new LimitedTreeSet<FileNode>(50, TopList.LEAST_RECENTLY_ACCESSED_COMPARATOR);
        LimitedTreeSet<FileNode> top50MostRecentlyAccessedSet = new LimitedTreeSet<FileNode>(50, TopList.MOST_RECENTLY_ACCESSED_COMPARATOR);
        LimitedTreeSet<FileNode> top50LeastRecentlyUsedSet = new LimitedTreeSet<FileNode>(50, TopList.LEAST_RECENTLY_USED_COMPARATOR);
        LimitedTreeSet<FileNode> top50MostRecentlyUsedSet = new LimitedTreeSet<FileNode>(50, TopList.MOST_RECENTLY_USED_COMPARATOR);
        SizeDistribution sizeDistribution = new SizeDistribution();
        LastModifiedDistribution modifiedDistribution = new LastModifiedDistribution();
        LastAccessDistribution accessedDistribution = new LastAccessDistribution();
        TypeDistribution typeDistribution = new TypeDistribution();
        for (Statistics statistics : allStatistics) {
            for (FileNode fileNode : statistics.getLargestFiles().getFiles()) {
                if (!top50LargestSet.addItem(fileNode)) break;
            }
            for (FileNode fileNode : statistics.getLeastRecentlyModifiedFiles().getFiles()) {
                if (!top50LeastRecentlyModifiedSet.addItem(fileNode)) break;
            }
            for (FileNode fileNode : statistics.getMostRecentlyModifiedFiles().getFiles()) {
                if (!top50MostRecentlyModifiedSet.addItem(fileNode)) break;
            }
            for (FileNode fileNode : statistics.getLeastRecentlyAccessedFiles().getFiles()) {
                if (!top50LeastRecentlyAccessedSet.addItem(fileNode)) break;
            }
            for (FileNode fileNode : statistics.getMostRecentlyAccessedFiles().getFiles()) {
                if (!top50MostRecentlyAccessedSet.addItem(fileNode)) break;
            }
            for (FileNode fileNode : statistics.getLeastRecentlyUsedFiles().getFiles()) {
                if (!top50LeastRecentlyUsedSet.addItem(fileNode)) break;
            }
            for (FileNode fileNode : statistics.getMostRecentlyUsedFiles().getFiles()) {
                if (!top50MostRecentlyUsedSet.addItem(fileNode)) break;
            }
            sizeDistribution.add(statistics.getSizeDistribution());
            modifiedDistribution.add(statistics.getModifiedDistribution());
            accessedDistribution.add(statistics.getAccessedDistribution());
            typeDistribution.add(statistics.getTypeDistribution());
        }
        return new Statistics(new TopList(top50LargestSet), new TopList(top50LeastRecentlyModifiedSet), new TopList(top50MostRecentlyModifiedSet), new TopList(top50LeastRecentlyAccessedSet), new TopList(top50MostRecentlyAccessedSet), new TopList(top50LeastRecentlyUsedSet), new TopList(top50MostRecentlyUsedSet), sizeDistribution, modifiedDistribution, accessedDistribution, typeDistribution);
    }

    public TopList getLargestFiles() {
        return this.largestFiles;
    }

    public TopList getLeastRecentlyModifiedFiles() {
        return this.leastRecentlyModifiedFiles;
    }

    public TopList getMostRecentlyModifiedFiles() {
        return this.mostRecentlyModifiedFiles;
    }

    public TopList getLeastRecentlyAccessedFiles() {
        return this.leastRecentlyAccessedFiles;
    }

    public TopList getMostRecentlyAccessedFiles() {
        return this.mostRecentlyAccessedFiles;
    }

    public TopList getLeastRecentlyUsedFiles() {
        return this.leastRecentlyUsedFiles;
    }

    public TopList getMostRecentlyUsedFiles() {
        return this.mostRecentlyUsedFiles;
    }

    public AbstractDistribution getSizeDistribution() {
        return this.sizeDistribution;
    }

    public AbstractDistribution getModifiedDistribution() {
        return this.modifiedDistribution;
    }

    public AbstractDistribution getAccessedDistribution() {
        return this.accessedDistribution;
    }

    public TypeDistribution getTypeDistribution() {
        return this.typeDistribution;
    }
}

