/*
 * Decompiled with CFR 0.152.
 */
package org.onemind.jxp;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.onemind.commons.invoke.InvocableFunction;
import org.onemind.commons.java.datastructure.NametableStack;
import org.onemind.commons.java.datastructure.ThreadLocalStack;
import org.onemind.commons.java.lang.reflect.ReflectUtils;
import org.onemind.commons.java.util.Counter;
import org.onemind.commons.java.util.FileUtils;
import org.onemind.commons.java.util.StringUtils;
import org.onemind.jxp.ArrayAssignable;
import org.onemind.jxp.Assignable;
import org.onemind.jxp.Control;
import org.onemind.jxp.Evaluator;
import org.onemind.jxp.FilePageSource;
import org.onemind.jxp.JxpInvocable;
import org.onemind.jxp.JxpPage;
import org.onemind.jxp.JxpPageSource;
import org.onemind.jxp.JxpProcessingContext;
import org.onemind.jxp.ProcessingException;
import org.onemind.jxp.VariableAssignable;
import org.onemind.jxp.parser.AstArguments;
import org.onemind.jxp.parser.AstArrayAllocationExpression;
import org.onemind.jxp.parser.AstArrayDims;
import org.onemind.jxp.parser.AstArrayInitializer;
import org.onemind.jxp.parser.AstArrayReference;
import org.onemind.jxp.parser.AstAssertStatement;
import org.onemind.jxp.parser.AstAssignExpression;
import org.onemind.jxp.parser.AstBitwiseAndAssignExpression;
import org.onemind.jxp.parser.AstBitwiseAndExpression;
import org.onemind.jxp.parser.AstBitwiseComplementExpression;
import org.onemind.jxp.parser.AstBitwiseOrAssignExpression;
import org.onemind.jxp.parser.AstBitwiseOrExpression;
import org.onemind.jxp.parser.AstBitwiseXOrAssignExpression;
import org.onemind.jxp.parser.AstBitwiseXOrExpression;
import org.onemind.jxp.parser.AstBlock;
import org.onemind.jxp.parser.AstBreakStatement;
import org.onemind.jxp.parser.AstCase;
import org.onemind.jxp.parser.AstCastExpression;
import org.onemind.jxp.parser.AstCatchBlock;
import org.onemind.jxp.parser.AstConditionalAndExpression;
import org.onemind.jxp.parser.AstConditionalOrExpression;
import org.onemind.jxp.parser.AstContent;
import org.onemind.jxp.parser.AstContinueStatement;
import org.onemind.jxp.parser.AstDivideAssignExpression;
import org.onemind.jxp.parser.AstDivideExpression;
import org.onemind.jxp.parser.AstDoStatement;
import org.onemind.jxp.parser.AstEQExpression;
import org.onemind.jxp.parser.AstEmptyStatement;
import org.onemind.jxp.parser.AstEnhancedForStatement;
import org.onemind.jxp.parser.AstExitStatement;
import org.onemind.jxp.parser.AstField;
import org.onemind.jxp.parser.AstFieldDeclaration;
import org.onemind.jxp.parser.AstFieldReference;
import org.onemind.jxp.parser.AstFinallyBlock;
import org.onemind.jxp.parser.AstForInit;
import org.onemind.jxp.parser.AstForStatement;
import org.onemind.jxp.parser.AstForUpdate;
import org.onemind.jxp.parser.AstFormalParameter;
import org.onemind.jxp.parser.AstFormalParameters;
import org.onemind.jxp.parser.AstFunctionDeclaration;
import org.onemind.jxp.parser.AstFunctionDeclarator;
import org.onemind.jxp.parser.AstGEExpression;
import org.onemind.jxp.parser.AstGTExpression;
import org.onemind.jxp.parser.AstHookExpression;
import org.onemind.jxp.parser.AstIfStatement;
import org.onemind.jxp.parser.AstImportDeclaration;
import org.onemind.jxp.parser.AstInstanceOfExpression;
import org.onemind.jxp.parser.AstJxpDocument;
import org.onemind.jxp.parser.AstLEExpression;
import org.onemind.jxp.parser.AstLShiftAssignExpression;
import org.onemind.jxp.parser.AstLShiftExpression;
import org.onemind.jxp.parser.AstLTExpression;
import org.onemind.jxp.parser.AstLabeledStatement;
import org.onemind.jxp.parser.AstLiteral;
import org.onemind.jxp.parser.AstLogicalComplementExpression;
import org.onemind.jxp.parser.AstMethodCall;
import org.onemind.jxp.parser.AstMethodInvocation;
import org.onemind.jxp.parser.AstMinusAssignExpression;
import org.onemind.jxp.parser.AstMinusExpression;
import org.onemind.jxp.parser.AstMultiplyAssignExpression;
import org.onemind.jxp.parser.AstMultiplyExpression;
import org.onemind.jxp.parser.AstNEExpression;
import org.onemind.jxp.parser.AstName;
import org.onemind.jxp.parser.AstNameList;
import org.onemind.jxp.parser.AstObjectAllocationExpression;
import org.onemind.jxp.parser.AstPlusAssignExpression;
import org.onemind.jxp.parser.AstPlusExpression;
import org.onemind.jxp.parser.AstPostDecrementExpression;
import org.onemind.jxp.parser.AstPostIncrementExpression;
import org.onemind.jxp.parser.AstPreDecrementExpression;
import org.onemind.jxp.parser.AstPreIncrementExpression;
import org.onemind.jxp.parser.AstPrimaryExpression;
import org.onemind.jxp.parser.AstPrimarySuffix;
import org.onemind.jxp.parser.AstPrimitiveType;
import org.onemind.jxp.parser.AstPrintStatement;
import org.onemind.jxp.parser.AstRSignedShiftAssignExpression;
import org.onemind.jxp.parser.AstRSignedShiftExpression;
import org.onemind.jxp.parser.AstRUnsignedShiftAssignExpression;
import org.onemind.jxp.parser.AstRUnsignedShiftExpression;
import org.onemind.jxp.parser.AstRemAssignExpression;
import org.onemind.jxp.parser.AstRemainderExpression;
import org.onemind.jxp.parser.AstReturnStatement;
import org.onemind.jxp.parser.AstStatementExpressionList;
import org.onemind.jxp.parser.AstStaticImportDeclaration;
import org.onemind.jxp.parser.AstSwitchStatement;
import org.onemind.jxp.parser.AstSynchronizedStatement;
import org.onemind.jxp.parser.AstThrowStatement;
import org.onemind.jxp.parser.AstTryStatement;
import org.onemind.jxp.parser.AstType;
import org.onemind.jxp.parser.AstUnaryMinusExpression;
import org.onemind.jxp.parser.AstUnaryPlusExpression;
import org.onemind.jxp.parser.AstVariableDeclarator;
import org.onemind.jxp.parser.AstVariableDeclaratorId;
import org.onemind.jxp.parser.AstVariableParameters;
import org.onemind.jxp.parser.AstWhileStatement;
import org.onemind.jxp.parser.JxpParserVisitor;
import org.onemind.jxp.parser.Node;
import org.onemind.jxp.parser.SimpleNode;
import org.onemind.jxp.util.StaticImport;
import org.onemind.jxp.util.StaticImportUtils;

public class JxpProcessor
implements JxpParserVisitor {
    private static final Logger _logger = Logger.getLogger((class$org$onemind$jxp$JxpProcessor == null ? (class$org$onemind$jxp$JxpProcessor = JxpProcessor.class$("org.onemind.jxp.JxpProcessor")) : class$org$onemind$jxp$JxpProcessor).getName());
    private static final Integer ONE = new Integer(1);
    private static final Map PRIMITIVE_DEFAULTS = new HashMap();
    private ThreadLocalStack _contextLocal = new ThreadLocalStack();
    private JxpPageSource _source;
    private boolean doMethodStats;
    private final Counter _methodStats = new Counter();
    static /* synthetic */ Class class$org$onemind$jxp$JxpProcessor;
    static /* synthetic */ Class class$java$lang$Object;

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.out.println("Usage: java org.onemind.jxp.JxpProcessor <source dir> <page>");
        } else {
            FilePageSource source = new FilePageSource(args[0]);
            JxpProcessor processor = new JxpProcessor(source);
            JxpProcessingContext context = new JxpProcessingContext(new OutputStreamWriter(System.out), new HashMap());
            try {
                processor.process(args[1], context);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            context.getWriter().flush();
        }
    }

    public JxpProcessor() {
    }

    public JxpProcessor(JxpPageSource source) {
        this._source = source;
    }

    public final void setSource(JxpPageSource source) {
        this._source = source;
    }

    public final JxpPageSource getSource() {
        return this._source;
    }

    protected Object assign(SimpleNode node, Object value) throws ProcessingException {
        Object target = this.resolveAssignmentTarget(node, true);
        if (target instanceof Assignable) {
            return ((Assignable)target).assign(value);
        }
        return this.generateProcessingException(new IllegalArgumentException(node + " is not assignable"), node);
    }

    protected Object assignVariable(String name, Object value) {
        NametableStack ntStack = this.getCurrentContext().getNametableStack();
        ntStack.put(name, value);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object callFunction(String methodName, Object[] args) throws Exception {
        if (methodName.equals("print")) {
            this.print(args[0]);
            return null;
        }
        if (methodName.equals("println")) {
            this.println(args[0]);
            return null;
        }
        JxpProcessingContext context = this.getCurrentContext();
        String functionName = methodName;
        if (context.getUserDefinedFunctions().containsKey(functionName)) {
            JxpUserDefinedFunction function = (JxpUserDefinedFunction)context.getUserDefinedFunctions().get(functionName);
            NametableStack functionEnv = this.createFunctionEnv(function.getParameterSpec(), args);
            context.pushNametableStack(functionEnv);
            try {
                Object obj = function.getBlock().jjtAccept(this, null);
                if (obj == Control.EXIT) {
                    Object object = obj;
                    return object;
                }
                if (obj instanceof Control) {
                    Object object = ((Control)obj).getObject();
                    return object;
                }
                Object object = obj;
                return object;
            }
            finally {
                context.popNametableStack();
            }
        }
        if (context.canInvoke(methodName, args)) {
            return context.invoke(methodName, args);
        }
        List staticImports = context.getStaticImports();
        Iterator it = staticImports.iterator();
        while (it.hasNext()) {
            StaticImport sImport = (StaticImport)it.next();
            InvocableFunction func = sImport.getFunction(functionName, args);
            if (func == null) continue;
            return func.invoke(null, args);
        }
        throw new NoSuchMethodException("Method " + methodName + " not found for the Processor");
    }

    public NametableStack createFunctionEnv(SimpleNode params, Object[] args) throws ProcessingException {
        NametableStack stack = new NametableStack();
        int n = params.jjtGetNumChildren();
        if (params instanceof AstFormalParameters) {
            if (n != args.length) {
                throw this.generateProcessingException(new IllegalArgumentException("The number of arguments not matched."), params);
            }
            for (int i = 0; i < n; ++i) {
                AstFormalParameter param = (AstFormalParameter)params.jjtGetChild(i);
                AstVariableDeclaratorId id = (AstVariableDeclaratorId)param.jjtGetChild(1);
                stack.put(id.getData(), args[i]);
            }
        } else {
            stack.put(params.getData(), args);
        }
        return stack;
    }

    private ProcessingException generateProcessingException(Throwable e, SimpleNode node) {
        ProcessingException ex = new ProcessingException(this.getCurrentContext().getCurrentPage(), e, node);
        try {
            this.println(e.getMessage());
        }
        catch (Exception exp) {
            // empty catch block
        }
        return ex;
    }

    protected Object declareVariable(String name, Object value) throws Exception {
        NametableStack ntStack = this.getCurrentContext().getNametableStack();
        if (ntStack.containsKey(name)) {
            throw new Exception("Variable " + name + " has been declared.");
        }
        return ntStack.put(name, value);
    }

    protected Object includeCall(String id) throws Exception {
        return this.process(id);
    }

    protected Object instantiate(Class type, Object[] args) throws Exception {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("Instantiaing " + type + " with " + StringUtils.concat(args, ","));
        }
        return ReflectUtils.newInstance(type, args);
    }

    protected Object invokeMethod(Object obj, String methodName, Object[] args) throws Exception {
        JxpInvocable invocable;
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("Invoking " + obj.getClass() + "." + methodName + "(" + StringUtils.concat(args, ",") + ")");
        }
        if (obj == this) {
            return this.callFunction(methodName, args);
        }
        if (this.doMethodStats) {
            this._methodStats.count(methodName);
        }
        if (obj instanceof JxpInvocable && (invocable = (JxpInvocable)obj).canInvoke(methodName, args)) {
            return invocable.invoke(methodName, args);
        }
        return ReflectUtils.invoke(obj, methodName, args);
    }

    protected Object lookupVariable(String variableName) throws NoSuchFieldException {
        NametableStack ntStack = this.getCurrentContext().getNametableStack();
        if (!ntStack.containsKey(variableName)) {
            throw new NoSuchFieldException("Variable/Function " + variableName + " is not declared before");
        }
        Object v = ntStack.get(variableName);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("Looking up variable " + variableName + " found " + v);
        }
        return v;
    }

    protected void print(Object o) throws IOException {
        if (o == null) {
            this.print("null");
        } else {
            this.print(o.toString());
        }
    }

    protected void print(String s) throws IOException {
        Writer writer = this.getCurrentContext().getWriter();
        try {
            writer.write(s);
        }
        catch (Exception e) {
            _logger.throwing(this.getClass().getName(), "print", e);
        }
    }

    protected void println(Object o) throws IOException {
        this.print(o + "\n");
    }

    protected void println(String s) throws IOException {
        this.print(s + "\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object process(String id, JxpProcessingContext context) throws Exception {
        int scope = this._contextLocal.pushLocal(context);
        try {
            Object object = this.process(id);
            return object;
        }
        finally {
            this._contextLocal.popLocalUtil(scope);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object process(String id) throws Exception {
        String prefix;
        JxpProcessingContext context = this.getCurrentContext();
        String scriptId = id;
        JxpPage currentPage = context.getCurrentPage();
        if (currentPage != null && !id.startsWith("/") && (prefix = StringUtils.substringBeforeLast(currentPage.getName(), "/")) != null) {
            scriptId = FileUtils.concatFilePath(prefix, id);
        }
        JxpPage page = this._source.getJxpPage(scriptId);
        try {
            context.pushPage(page);
            Object object = this.visit(page.getJxpDocument(), null);
            return object;
        }
        finally {
            context.popPage(page);
        }
    }

    public JxpProcessingContext getCurrentContext() {
        return (JxpProcessingContext)this._contextLocal.getLocal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object processCall(String id) throws Exception {
        JxpProcessingContext context = this.getCurrentContext();
        int scope = context.getNametableStack().newScope();
        try {
            Object object = this.process(id);
            return object;
        }
        finally {
            context.getNametableStack().closeScope(scope);
        }
    }

    protected Object[] resolveArguments(AstArguments node, JxpProcessingContext context) throws Exception {
        int n = node.jjtGetNumChildren();
        Object[] args = new Object[n];
        for (int i = 0; i < n; ++i) {
            args[i] = node.jjtGetChild(i).jjtAccept(this, context);
        }
        return args;
    }

    protected int[] resolveArrayDims(AstArrayDims node, JxpProcessingContext context) throws Exception {
        int[] dims = new int[node.jjtGetNumChildren()];
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            Object o = node.jjtGetChild(i).jjtAccept(this, context);
            if (!(o instanceof Number)) {
                throw this.generateProcessingException(new IllegalArgumentException("Array dimension " + o + " is not a number"), node);
            }
            dims[i] = ((Number)o).intValue();
        }
        return dims;
    }

    protected Object resolveAssignmentTarget(SimpleNode node, boolean throwException) throws ProcessingException {
        if (node instanceof AstName) {
            AstName name = (AstName)node;
            List l = (List)name.getData();
            JxpProcessingContext context = this.getCurrentContext();
            if (l.size() == 1) {
                String variableName = (String)l.get(0);
                if (context.getNametableStack().containsKey(variableName)) {
                    return new VariableAssignable((String)l.get(0), this.getCurrentContext());
                }
                throw this.generateProcessingException(new IllegalArgumentException("Variable " + variableName + " has not been declared."), node);
            }
            if (throwException) {
                throw this.generateProcessingException(new IllegalArgumentException(node + " is not assignable"), node);
            }
            return null;
        }
        if (node instanceof AstArrayReference) {
            try {
                Object obj = node.jjtGetChild(0).jjtAccept(this, null);
                if (obj == null) {
                    throw this.generateProcessingException(new NullPointerException(), (SimpleNode)node.jjtGetChild(0));
                }
                if (!obj.getClass().isArray()) {
                    throw this.generateProcessingException(new IllegalArgumentException("Argument is not an array"), (SimpleNode)node.jjtGetChild(0));
                }
                Object dimObj = node.jjtGetChild(1).jjtAccept(this, null);
                int dim = 0;
                if (!(dimObj instanceof Number)) {
                    throw this.generateProcessingException(new IllegalArgumentException("Invalid index type " + dimObj.getClass() + " for array"), node);
                }
                dim = ((Number)dimObj).intValue();
                return new ArrayAssignable(obj, dim);
            }
            catch (ProcessingException e) {
                throw e;
            }
            catch (Exception e) {
                throw this.generateProcessingException(e, node);
            }
        }
        if (throwException) {
            throw this.generateProcessingException(new IllegalArgumentException(node + " is not assignable"), node);
        }
        return null;
    }

    protected final Class resolveClass(String className) {
        return this.getCurrentContext().resolveClass(className);
    }

    protected Object resolveField(Object obj, String fieldName) throws Exception {
        JxpInvocable invocable;
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("Resolving field " + fieldName + " of " + obj);
        }
        if (obj == null) {
            throw new NoSuchFieldException("Cannot find field " + fieldName + " for null");
        }
        if (fieldName.equals("class")) {
            if (obj instanceof Class) {
                return (Class)obj;
            }
            throw new IllegalStateException(".class cannot be apply to " + obj);
        }
        if (fieldName.equals("length") && obj.getClass().isArray()) {
            return new Integer(Array.getLength(obj));
        }
        if (obj instanceof JxpInvocable && (invocable = (JxpInvocable)obj).canInvoke(fieldName, null)) {
            return invocable.invoke(fieldName, null);
        }
        if (obj instanceof Map) {
            return ((Map)obj).get(fieldName);
        }
        Field f = null;
        f = obj instanceof Class ? ((Class)obj).getField(fieldName) : obj.getClass().getField(fieldName);
        return f.get(obj);
    }

    protected Object resolveName(List l) throws Exception {
        Object current = null;
        NametableStack ntStack = this.getCurrentContext().getNametableStack();
        for (int i = 0; i < l.size(); ++i) {
            String s = (String)l.get(i);
            if (i == 0) {
                if (ntStack.containsKey(s)) {
                    current = this.lookupVariable(s);
                    continue;
                }
                current = this.resolveClass(s);
                if (current != null) continue;
                throw new NoSuchFieldException("Variable " + s + " has not been declared");
            }
            current = this.resolveField(current, s);
        }
        return current;
    }

    private String toDottedName(AstName name) {
        return StringUtils.concat((List)name.getData(), ".");
    }

    public Object visit(AstArguments node, Object data) throws Exception {
        throw new IllegalStateException("visit(AstArguments, Object) should not be called");
    }

    public Object visit(AstArrayAllocationExpression node, Object data) throws Exception {
        String className = this.toDottedName((AstName)node.jjtGetChild(0));
        Class type = this.resolveClass(className);
        if (type == null) {
            throw this.generateProcessingException(new ClassNotFoundException("No definition found for " + className), node);
        }
        SimpleNode n = (SimpleNode)node.jjtGetChild(1);
        if (n instanceof AstArrayDims) {
            int[] dims = this.resolveArrayDims((AstArrayDims)n, this.getCurrentContext());
            return Array.newInstance(type, dims);
        }
        return n.jjtAccept(this, type);
    }

    public Object visit(AstArrayDims node, Object data) throws Exception {
        throw this.generateProcessingException(new IllegalStateException("AstArrayDims are not supposed to be called"), node);
    }

    public Object visit(AstArrayInitializer node, Object data) throws Exception {
        Class type = data instanceof Class ? (Class)data : (class$java$lang$Object == null ? (class$java$lang$Object = JxpProcessor.class$("java.lang.Object")) : class$java$lang$Object);
        int dim = node.jjtGetNumChildren();
        ArrayList<Object> l = new ArrayList<Object>();
        Class<?> elementType = null;
        for (int i = 0; i < dim; ++i) {
            Object element = node.jjtGetChild(i).jjtAccept(this, type);
            if (element != null ? !(elementType = element.getClass()).isArray() && !type.isAssignableFrom(element.getClass()) : type.isPrimitive()) {
                throw this.generateProcessingException(new IllegalArgumentException("Illegal element " + element + " in " + type.getName() + " array"), (SimpleNode)node.jjtGetChild(i));
            }
            l.add(element);
        }
        if (elementType != null) {
            Object[] array = (Object[])Array.newInstance(elementType, l.size());
            return l.toArray(array);
        }
        return l.toArray();
    }

    public Object visit(AstArrayReference node, Object data) throws Exception {
        Object obj = node.jjtGetChild(0).jjtAccept(this, data);
        if (obj != null && obj.getClass().isArray()) {
            Object dimObj = node.jjtGetChild(1).jjtAccept(this, data);
            int dim = 0;
            if (!(dimObj instanceof Number)) {
                throw this.generateProcessingException(new IllegalArgumentException("Invalid index type " + dimObj.getClass() + " for array"), node);
            }
            dim = ((Number)dimObj).intValue();
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Resolving array reference of " + obj + "[" + dim + "]");
            }
            return Array.get(obj, dim);
        }
        throw this.generateProcessingException(new IllegalArgumentException("Cannot get array referernce of non-array " + obj), node);
    }

    public Object visit(AstAssertStatement node, Object data) throws Exception {
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            Boolean assertion = Evaluator.toBoolean(node.jjtGetChild(i).jjtAccept(this, data));
            if (assertion.booleanValue()) continue;
            throw this.generateProcessingException((Throwable)((Object)new AssertionError((Object)"Assertion error ")), (SimpleNode)node.jjtGetChild(i));
        }
        return Boolean.TRUE;
    }

    public Object visit(AstAssignExpression node, Object data) throws Exception {
        Object value = node.jjtGetChild(1).jjtAccept(this, data);
        return this.assign((SimpleNode)node.jjtGetChild(0), value);
    }

    public Object visit(AstBitwiseAndAssignExpression node, Object data) throws Exception {
        Object origValue = node.jjtGetChild(0).jjtAccept(this, data);
        Object value = node.jjtGetChild(1).jjtAccept(this, data);
        return this.assign((SimpleNode)node.jjtGetChild(0), Evaluator.bitwiseAnd(origValue, value));
    }

    public Object visit(AstBitwiseAndExpression node, Object data) throws Exception {
        return Evaluator.bitwiseAnd(node.jjtGetChild(0).jjtAccept(this, data), node.jjtGetChild(1).jjtAccept(this, data));
    }

    public Object visit(AstBitwiseComplementExpression node, Object data) throws Exception {
        return Evaluator.bitwiseComplement(node.jjtGetChild(0).jjtAccept(this, data));
    }

    public Object visit(AstBitwiseOrAssignExpression node, Object data) throws Exception {
        Object origValue = node.jjtGetChild(0).jjtAccept(this, data);
        Object value = node.jjtGetChild(1).jjtAccept(this, data);
        return this.assign((SimpleNode)node.jjtGetChild(0), Evaluator.bitwiseOr(origValue, value));
    }

    public Object visit(AstBitwiseOrExpression node, Object data) throws Exception {
        return Evaluator.bitwiseOr(node.jjtGetChild(0).jjtAccept(this, data), node.jjtGetChild(1).jjtAccept(this, data));
    }

    public Object visit(AstBitwiseXOrAssignExpression node, Object data) throws Exception {
        Object origValue = node.jjtGetChild(0).jjtAccept(this, data);
        Object value = node.jjtGetChild(1).jjtAccept(this, data);
        return this.assign((SimpleNode)node.jjtGetChild(0), Evaluator.bitwiseXOr(origValue, value));
    }

    public Object visit(AstBitwiseXOrExpression node, Object data) throws Exception {
        return Evaluator.bitwiseXOr(node.jjtGetChild(0).jjtAccept(this, data), node.jjtGetChild(1).jjtAccept(this, data));
    }

    public Object visit(AstBlock node, Object data) throws Exception {
        JxpProcessingContext context = this.getCurrentContext();
        int scope = context.getNametableStack().newScope();
        Object obj = null;
        SimpleNode childNode = null;
        int i = 0;
        try {
            for (i = 0; i < node.jjtGetNumChildren(); ++i) {
                childNode = (SimpleNode)node.jjtGetChild(i);
                obj = childNode.jjtAccept(this, data);
                if (!(obj instanceof Control)) continue;
                break;
            }
        }
        catch (ProcessingException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw this.generateProcessingException(e, childNode);
        }
        finally {
            context.getNametableStack().closeScope(scope);
        }
        return obj;
    }

    public Object visit(AstBreakStatement node, Object data) throws Exception {
        return Control.BREAK;
    }

    public Object visit(AstCase node, Object data) throws Exception {
        throw this.generateProcessingException(new IllegalStateException("Switch case: are not suppossed to be called"), node);
    }

    public Object visit(AstCastExpression node, Object data) throws Exception {
        throw this.generateProcessingException(new UnsupportedOperationException("Cast expression: Unsupported Language Feature"), node);
    }

    public Object visit(AstCatchBlock node, Object data) throws Exception {
        throw this.generateProcessingException(new IllegalStateException("This should not be called"), node);
    }

    public Object visit(AstConditionalAndExpression node, Object data) throws Exception {
        Boolean b1 = Evaluator.toBoolean(node.jjtGetChild(0).jjtAccept(this, data));
        if (!b1.booleanValue()) {
            return Boolean.FALSE;
        }
        Boolean b2 = Evaluator.toBoolean(node.jjtGetChild(1).jjtAccept(this, data));
        if (!b2.booleanValue()) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Object visit(AstConditionalOrExpression node, Object data) throws Exception {
        Boolean b1 = Evaluator.toBoolean(node.jjtGetChild(0).jjtAccept(this, data));
        if (b1.booleanValue()) {
            return Boolean.TRUE;
        }
        Boolean b2 = Evaluator.toBoolean(node.jjtGetChild(1).jjtAccept(this, data));
        if (b2.booleanValue()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Object visit(AstContent node, Object data) throws Exception {
        Object content = node.getData();
        this.print(content);
        return content;
    }

    public Object visit(AstContinueStatement node, Object data) throws Exception {
        return Control.CONTINUE;
    }

    public Object visit(AstDivideAssignExpression node, Object data) throws Exception {
        Object origValue = node.jjtGetChild(0).jjtAccept(this, data);
        Object value = node.jjtGetChild(1).jjtAccept(this, data);
        return this.assign((SimpleNode)node.jjtGetChild(0), Evaluator.divide(origValue, value));
    }

    public Object visit(AstDivideExpression node, Object data) throws Exception {
        return Evaluator.divide(node.jjtGetChild(0).jjtAccept(this, data), node.jjtGetChild(1).jjtAccept(this, data));
    }

    public Object visit(AstDoStatement node, Object data) throws Exception {
        Node condition = node.jjtGetChild(1);
        Boolean b = null;
        Object returnValue = null;
        do {
            if (!((returnValue = node.jjtGetChild(0).jjtAccept(this, data)) instanceof Control)) continue;
            if (returnValue == Control.CONTINUE) {
                returnValue = null;
                continue;
            }
            if (returnValue != Control.BREAK) break;
            returnValue = null;
            break;
        } while ((b = Evaluator.toBoolean(condition.jjtAccept(this, data))).booleanValue());
        return returnValue;
    }

    public Object visit(AstEmptyStatement node, Object data) throws Exception {
        return null;
    }

    public Object visit(AstEQExpression node, Object data) throws Exception {
        Object o1 = node.jjtGetChild(0).jjtAccept(this, data);
        Object o2 = node.jjtGetChild(1).jjtAccept(this, data);
        return Evaluator.eq(o1, o2);
    }

    public Object visit(AstField node, Object data) throws Exception {
        throw this.generateProcessingException(new IllegalStateException("visit(AstField, Object) is not supposed to be called"), node);
    }

    public Object visit(AstFieldDeclaration node, Object data) throws Exception {
        for (int i = 1; i < node.jjtGetNumChildren(); ++i) {
            node.jjtGetChild(i).jjtAccept(this, node.jjtGetChild(0));
        }
        return null;
    }

    public Object visit(AstFieldReference node, Object data) throws Exception {
        Object o1 = node.jjtGetChild(0).jjtAccept(this, data);
        String fieldName = (String)((SimpleNode)node.jjtGetChild(1)).getData();
        return this.resolveField(o1, fieldName);
    }

    public Object visit(AstFinallyBlock node, Object data) throws Exception {
        return node.jjtGetChild(0).jjtAccept(this, data);
    }

    public Object visit(AstForInit node, Object data) throws Exception {
        return node.childrenAccept(this, data);
    }

    public Object visit(AstFormalParameter node, Object data) throws Exception {
        throw this.generateProcessingException(new IllegalStateException("visit(AstFormalParameter, Object) are not supposed to be called"), node);
    }

    public Object visit(AstFormalParameters node, Object data) throws Exception {
        throw this.generateProcessingException(new UnsupportedOperationException("Unsupported Language Feature"), node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visit(AstForStatement node, Object data) throws Exception {
        JxpProcessingContext context = this.getCurrentContext();
        SimpleNode forInit = null;
        SimpleNode forCondition = null;
        SimpleNode forUpdate = null;
        SimpleNode statements = null;
        for (int i = 0; i < node.jjtGetNumChildren() - 1; ++i) {
            SimpleNode n = (SimpleNode)node.jjtGetChild(i);
            if (n instanceof AstForInit) {
                forInit = n;
                continue;
            }
            if (n instanceof AstForUpdate) {
                forUpdate = n;
                continue;
            }
            forCondition = n;
        }
        statements = (SimpleNode)node.jjtGetChild(node.jjtGetNumChildren() - 1);
        int newscope = context.getNametableStack().newScope();
        if (forInit != null) {
            forInit.jjtAccept(this, data);
        }
        Boolean condition = Boolean.TRUE;
        if (forCondition != null) {
            condition = Evaluator.toBoolean(forCondition.jjtAccept(this, data));
        }
        Object returnValue = null;
        try {
            while (condition.booleanValue()) {
                returnValue = statements.jjtAccept(this, data);
                if (returnValue == Control.CONTINUE) {
                    returnValue = null;
                } else {
                    if (returnValue == Control.BREAK) {
                        returnValue = null;
                        break;
                    }
                    if (returnValue instanceof Control) {
                        break;
                    }
                }
                if (forUpdate != null) {
                    forUpdate.jjtAccept(this, data);
                }
                if (forCondition == null) continue;
                condition = Evaluator.toBoolean(forCondition.jjtAccept(this, data));
            }
        }
        finally {
            context.getNametableStack().closeScope(newscope);
        }
        return returnValue;
    }

    public Object visit(AstForUpdate node, Object data) throws Exception {
        return node.childrenAccept(this, data);
    }

    public Object visit(AstGEExpression node, Object data) throws Exception {
        Object o1 = node.jjtGetChild(0).jjtAccept(this, data);
        Object o2 = node.jjtGetChild(1).jjtAccept(this, data);
        return Evaluator.ge(o1, o2);
    }

    public Object visit(AstGTExpression node, Object data) throws Exception {
        Object o1 = node.jjtGetChild(0).jjtAccept(this, data);
        Object o2 = node.jjtGetChild(1).jjtAccept(this, data);
        return Evaluator.gt(o1, o2);
    }

    public Object visit(AstHookExpression node, Object data) throws Exception {
        Object returnValue = node.jjtGetChild(0).jjtAccept(this, data);
        if (returnValue instanceof Boolean) {
            if (Boolean.TRUE.equals(returnValue)) {
                return node.jjtGetChild(1).jjtAccept(this, data);
            }
            return node.jjtGetChild(2).jjtAccept(this, data);
        }
        throw this.generateProcessingException(new IllegalArgumentException("condition of hook expression is not a boolean expression"), node);
    }

    public Object visit(AstIfStatement node, Object data) throws Exception {
        Boolean condition = Evaluator.toBoolean(node.jjtGetChild(0).jjtAccept(this, data));
        if (condition.booleanValue()) {
            return node.jjtGetChild(1).jjtAccept(this, data);
        }
        if (node.jjtGetNumChildren() > 2) {
            return node.jjtGetChild(2).jjtAccept(this, data);
        }
        return null;
    }

    public Object visit(AstImportDeclaration node, Object data) throws Exception {
        JxpProcessingContext context = this.getCurrentContext();
        String packageName = this.toDottedName((AstName)node.jjtGetChild(0));
        String className = (String)node.getData();
        context.getImports().addPackage(packageName);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("Add import " + packageName);
            _logger.finest(context.getImports().getPackages().toString());
        }
        if (className != null && !className.equals("*")) {
            context.getImports().getClass(className);
        }
        return null;
    }

    public Object visit(AstInstanceOfExpression node, Object data) throws Exception {
        Object obj = node.jjtGetChild(0).jjtAccept(this, data);
        if (obj == null) {
            return Boolean.FALSE;
        }
        Class c = (Class)node.jjtGetChild(1).jjtAccept(this, data);
        return c.isInstance(obj);
    }

    public Object visit(AstJxpDocument node, Object data) throws Exception {
        int n = node.jjtGetNumChildren();
        Object returnValue = null;
        SimpleNode statement = null;
        try {
            for (int i = 0; i < n; ++i) {
                statement = (SimpleNode)node.jjtGetChild(i);
                returnValue = statement.jjtAccept(this, data);
                if (!(returnValue instanceof Control)) continue;
                return returnValue;
            }
        }
        catch (ProcessingException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw this.generateProcessingException(e, statement);
        }
        return null;
    }

    public Object visit(AstLabeledStatement node, Object data) throws Exception {
        throw this.generateProcessingException(new UnsupportedOperationException("Labeled statement: Unsupported Language Feature"), node);
    }

    public Object visit(AstLEExpression node, Object data) throws Exception {
        Object o1 = node.jjtGetChild(0).jjtAccept(this, data);
        Object o2 = node.jjtGetChild(1).jjtAccept(this, data);
        return Evaluator.le(o1, o2);
    }

    public Object visit(AstLiteral node, Object data) throws Exception {
        return node.getData();
    }

    public Object visit(AstLogicalComplementExpression node, Object data) throws Exception {
        Boolean b = Evaluator.toBoolean(node.jjtGetChild(0).jjtAccept(this, data));
        return b == false;
    }

    public Object visit(AstLShiftAssignExpression node, Object data) throws Exception {
        Object origValue = node.jjtGetChild(0).jjtAccept(this, data);
        Object value = node.jjtGetChild(1).jjtAccept(this, data);
        return this.assign((SimpleNode)node.jjtGetChild(0), Evaluator.leftShift(origValue, value));
    }

    public Object visit(AstLShiftExpression node, Object data) throws Exception {
        return Evaluator.leftShift(node.jjtGetChild(0).jjtAccept(this, data), node.jjtGetChild(1).jjtAccept(this, data));
    }

    public Object visit(AstLTExpression node, Object data) throws Exception {
        Object o1 = node.jjtGetChild(0).jjtAccept(this, data);
        Object o2 = node.jjtGetChild(1).jjtAccept(this, data);
        return Evaluator.lt(o1, o2);
    }

    public Object visit(AstMethodCall node, Object data) throws Exception {
        String methodName = (String)node.getData();
        Object[] args = this.resolveArguments((AstArguments)node.jjtGetChild(0), this.getCurrentContext());
        if (args.length == 0) {
            if (methodName.equals("flush")) {
                this.flush();
                return null;
            }
        } else if (args[0] instanceof String && args.length == 1 && methodName.equals("include")) {
            return this.includeCall((String)args[0]);
        }
        try {
            return this.invokeMethod(this, methodName, args);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            throw this.generateProcessingException(t, node);
        }
        catch (Exception e) {
            throw this.generateProcessingException(e, node);
        }
    }

    public Object visit(AstFunctionDeclaration node, Object data) throws Exception {
        int i = 0;
        SimpleNode declarator = null;
        while (!((declarator = (SimpleNode)node.jjtGetChild(i++)) instanceof AstFunctionDeclarator)) {
        }
        SimpleNode block = null;
        int n = node.jjtGetNumChildren();
        if (i < n) {
            while (!((block = (SimpleNode)node.jjtGetChild(i++)) instanceof AstBlock) && i < n) {
            }
        }
        return this.getCurrentContext().getUserDefinedFunctions().put((String)declarator.getData(), new JxpUserDefinedFunction((SimpleNode)declarator.jjtGetChild(0), (AstBlock)block));
    }

    public Object visit(AstFunctionDeclarator node, Object data) throws Exception {
        throw this.generateProcessingException(new IllegalStateException("visit(AstFunctionDeclarator,Object) is not meant to be called."), node);
    }

    public Object visit(AstMethodInvocation node, Object data) throws Exception {
        Object obj = node.jjtGetChild(0).jjtAccept(this, data);
        SimpleNode methodCall = (SimpleNode)node.jjtGetChild(1);
        String methodName = (String)methodCall.getData();
        if (obj == null) {
            throw this.generateProcessingException(new NullPointerException("Cannot invoke method " + methodName + "(...) of null at "), node);
        }
        Object[] args = this.resolveArguments((AstArguments)methodCall.jjtGetChild(0), this.getCurrentContext());
        try {
            return this.invokeMethod(obj, methodName, args);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            throw this.generateProcessingException(t, node);
        }
        catch (Exception e) {
            throw this.generateProcessingException(e, node);
        }
    }

    public Object visit(AstMinusAssignExpression node, Object data) throws Exception {
        Object origValue = node.jjtGetChild(0).jjtAccept(this, data);
        Object value = node.jjtGetChild(1).jjtAccept(this, data);
        return this.assign((SimpleNode)node.jjtGetChild(0), Evaluator.minus(origValue, value));
    }

    public Object visit(AstMinusExpression node, Object data) throws Exception {
        return Evaluator.minus(node.jjtGetChild(0).jjtAccept(this, data), node.jjtGetChild(1).jjtAccept(this, data));
    }

    public Object visit(AstMultiplyAssignExpression node, Object data) throws Exception {
        Object origValue = node.jjtGetChild(0).jjtAccept(this, data);
        Object value = node.jjtGetChild(1).jjtAccept(this, data);
        return this.assign((SimpleNode)node.jjtGetChild(0), Evaluator.multiply(origValue, value));
    }

    public Object visit(AstMultiplyExpression node, Object data) throws Exception {
        return Evaluator.multiply(node.jjtGetChild(0).jjtAccept(this, data), node.jjtGetChild(1).jjtAccept(this, data));
    }

    public Object visit(AstName node, Object data) throws Exception {
        List l = (List)node.getData();
        return this.resolveName(l);
    }

    public Object visit(AstNameList node, Object data) throws Exception {
        throw this.generateProcessingException(new IllegalStateException("visit(ASTNameList, Object) not supposed to be called"), node);
    }

    public Object visit(AstNEExpression node, Object data) throws Exception {
        Object o1 = node.jjtGetChild(0).jjtAccept(this, data);
        Object o2 = node.jjtGetChild(1).jjtAccept(this, data);
        return Evaluator.ne(o1, o2);
    }

    public Object visit(AstObjectAllocationExpression node, Object data) throws Exception {
        String className = this.toDottedName((AstName)node.jjtGetChild(0));
        Class type = this.getCurrentContext().resolveClass(className);
        if (type == null) {
            throw this.generateProcessingException(new ClassNotFoundException("No definition found for " + className), node);
        }
        Object[] args = this.resolveArguments((AstArguments)node.jjtGetChild(1), this.getCurrentContext());
        try {
            return this.instantiate(type, args);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            throw this.generateProcessingException(t, node);
        }
        catch (Exception e) {
            throw this.generateProcessingException(e, node);
        }
    }

    public Object visit(AstPlusAssignExpression node, Object data) throws Exception {
        Object origValue = node.jjtGetChild(0).jjtAccept(this, data);
        Object value = node.jjtGetChild(1).jjtAccept(this, data);
        return this.assign((SimpleNode)node.jjtGetChild(0), Evaluator.plus(origValue, value));
    }

    public Object visit(AstPlusExpression node, Object data) throws Exception {
        Object o1 = node.jjtGetChild(0).jjtAccept(this, data);
        Object o2 = node.jjtGetChild(1).jjtAccept(this, data);
        if (o1 instanceof String) {
            return o1.toString() + o2;
        }
        if (o2 instanceof String) {
            return o1 + o2.toString();
        }
        return Evaluator.plus(node.jjtGetChild(0).jjtAccept(this, data), node.jjtGetChild(1).jjtAccept(this, data));
    }

    public Object visit(AstPostDecrementExpression node, Object data) throws Exception {
        Object returnValue = node.jjtGetChild(0).jjtAccept(this, data);
        Object newValue = Evaluator.minus(returnValue, ONE);
        if (this.resolveAssignmentTarget((SimpleNode)node.jjtGetChild(0), false) != null) {
            this.assign((SimpleNode)node.jjtGetChild(0), newValue);
        }
        return returnValue;
    }

    public Object visit(AstPostIncrementExpression node, Object data) throws Exception {
        Object returnValue = node.jjtGetChild(0).jjtAccept(this, data);
        Object newValue = Evaluator.plus(returnValue, ONE);
        if (this.resolveAssignmentTarget((SimpleNode)node.jjtGetChild(0), false) != null) {
            this.assign((SimpleNode)node.jjtGetChild(0), newValue);
        }
        return returnValue;
    }

    public Object visit(AstPreDecrementExpression node, Object data) throws Exception {
        Object returnValue = node.jjtGetChild(0).jjtAccept(this, data);
        Object newValue = Evaluator.minus(returnValue, ONE);
        if (this.resolveAssignmentTarget((SimpleNode)node.jjtGetChild(0), false) != null) {
            this.assign((SimpleNode)node.jjtGetChild(0), newValue);
        }
        return newValue;
    }

    public Object visit(AstPreIncrementExpression node, Object data) throws Exception {
        Object returnValue = node.jjtGetChild(0).jjtAccept(this, data);
        Object newValue = Evaluator.plus(returnValue, ONE);
        if (this.resolveAssignmentTarget((SimpleNode)node.jjtGetChild(0), false) != null) {
            this.assign((SimpleNode)node.jjtGetChild(0), newValue);
        }
        return newValue;
    }

    public Object visit(AstPrimaryExpression node, Object data) throws Exception {
        throw this.generateProcessingException(new IllegalStateException("visit(AstPrimaryExpression, Object) not supposed to be called."), node);
    }

    public Object visit(AstPrimarySuffix node, Object data) throws Exception {
        throw this.generateProcessingException(new IllegalStateException("visit(AstPrimarySuffix, Object) not supposed to be called."), node);
    }

    public Object visit(AstPrimitiveType node, Object data) throws Exception {
        throw this.generateProcessingException(new IllegalStateException("visit(AstPrimitiveType, Object) not supposed to be called."), node);
    }

    public Object visit(AstPrintStatement node, Object data) throws Exception {
        this.print(node.jjtGetChild(0).jjtAccept(this, data));
        return null;
    }

    public Object visit(AstRemainderExpression node, Object data) throws Exception {
        return Evaluator.remainder(node.jjtGetChild(0).jjtAccept(this, data), node.jjtGetChild(1).jjtAccept(this, data));
    }

    public Object visit(AstRemAssignExpression node, Object data) throws Exception {
        Object origValue = node.jjtGetChild(0).jjtAccept(this, data);
        Object value = node.jjtGetChild(1).jjtAccept(this, data);
        return this.assign((SimpleNode)node.jjtGetChild(0), Evaluator.remainder(origValue, value));
    }

    public Object visit(AstReturnStatement node, Object data) throws Exception {
        if (node.jjtGetNumChildren() > 0) {
            return new Control(node.jjtGetChild(0).jjtAccept(this, data));
        }
        return Control.RETURN;
    }

    public Object visit(AstRSignedShiftAssignExpression node, Object data) throws Exception {
        Object origValue = node.jjtGetChild(0).jjtAccept(this, data);
        Object value = node.jjtGetChild(1).jjtAccept(this, data);
        return this.assign((SimpleNode)node.jjtGetChild(0), Evaluator.rightSignedShift(origValue, value));
    }

    public Object visit(AstRSignedShiftExpression node, Object data) throws Exception {
        return Evaluator.rightUnsignedShift(node.jjtGetChild(0).jjtAccept(this, data), node.jjtGetChild(1).jjtAccept(this, data));
    }

    public Object visit(AstRUnsignedShiftAssignExpression node, Object data) throws Exception {
        Object origValue = node.jjtGetChild(0).jjtAccept(this, data);
        Object value = node.jjtGetChild(1).jjtAccept(this, data);
        return this.assign((SimpleNode)node.jjtGetChild(0), Evaluator.rightUnsignedShift(origValue, value));
    }

    public Object visit(AstRUnsignedShiftExpression node, Object data) throws Exception {
        return Evaluator.rightUnsignedShift(node.jjtGetChild(0).jjtAccept(this, data), node.jjtGetChild(1).jjtAccept(this, data));
    }

    public Object visit(AstStatementExpressionList node, Object data) throws Exception {
        throw this.generateProcessingException(new IllegalStateException("visit(AstStatementExpressionList, Object) not supposed to be called."), node);
    }

    public Object visit(AstSwitchStatement node, Object data) throws Exception {
        Object switchValue = node.jjtGetChild(0).jjtAccept(this, data);
        if (switchValue == null) {
            throw this.generateProcessingException(new IllegalArgumentException("Switch value cannot be null"), node);
        }
        int n = node.jjtGetNumChildren();
        boolean matchCase = false;
        for (int i = 1; i < n; ++i) {
            AstCase case_ = (AstCase)node.jjtGetChild(i);
            int caseChildren = case_.jjtGetNumChildren();
            if (!matchCase) {
                if (caseChildren == 1) {
                    matchCase = true;
                } else {
                    Object caseValue = case_.jjtGetChild(0).jjtAccept(this, null);
                    if (caseValue == null) {
                        throw this.generateProcessingException(new IllegalArgumentException("Switch case value cannot be null"), case_);
                    }
                    if (switchValue.equals(caseValue)) {
                        matchCase = true;
                    }
                }
            }
            if (!matchCase) continue;
            Object obj = case_.jjtGetChild(caseChildren - 1).jjtAccept(this, null);
            if (obj == Control.BREAK) {
                return null;
            }
            if (!(obj instanceof Control)) continue;
            return obj;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visit(AstSynchronizedStatement node, Object data) throws Exception {
        Object obj = node.jjtGetChild(0).jjtAccept(this, data);
        if (obj == null) {
            throw this.generateProcessingException(new IllegalArgumentException("Cannot synchronize on null"), node);
        }
        Object object = obj;
        synchronized (object) {
            return node.jjtGetChild(1).jjtAccept(this, data);
        }
    }

    public Object visit(AstThrowStatement node, Object data) throws Exception {
        Object o = node.jjtGetChild(0).jjtAccept(this, data);
        if (o instanceof Exception) {
            throw (Exception)o;
        }
        throw this.generateProcessingException(new IllegalArgumentException("Cannot throw non-exception " + o), node);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object visit(AstTryStatement node, Object data) throws Exception {
        Object object;
        int n = node.jjtGetNumChildren();
        int i = 0;
        try {
            try {
                SimpleNode block = (SimpleNode)node.jjtGetChild(0);
                object = block.jjtAccept(this, data);
                Object var17_9 = null;
                if (i >= n) return object;
            }
            catch (Throwable e) {
                JxpProcessingContext context = this.getCurrentContext();
                Throwable realCause = e;
                if (realCause instanceof ProcessingException && realCause.getCause() != null) {
                    realCause = realCause.getCause();
                }
                i = 1;
                while (true) {
                    SimpleNode formalParameter;
                    AstType type;
                    Class c;
                    if (i >= n) {
                        if (!(e instanceof ProcessingException)) throw new IllegalStateException("Should be ProcessingException after try block");
                        throw (ProcessingException)e;
                    }
                    SimpleNode handlerBlock = (SimpleNode)node.jjtGetChild(i);
                    if (handlerBlock instanceof AstCatchBlock && (c = (Class)(type = (AstType)(formalParameter = (SimpleNode)handlerBlock.jjtGetChild(0)).jjtGetChild(0)).jjtAccept(this, data)).isAssignableFrom(realCause.getClass())) {
                        Object object2;
                        int scope = context.getNametableStack().newScope();
                        try {
                            AstVariableDeclaratorId id = (AstVariableDeclaratorId)formalParameter.jjtGetChild(1);
                            this.declareVariable((String)id.getData(), realCause);
                            object2 = handlerBlock.jjtGetChild(1).jjtAccept(this, data);
                            Object var17_10 = null;
                            if (i >= n) return object2;
                        }
                        catch (Exception eAgain) {
                            throw this.generateProcessingException(eAgain, (SimpleNode)handlerBlock.jjtGetChild(1));
                        }
                        SimpleNode block = (SimpleNode)node.jjtGetChild(n - 1);
                        if (!(block instanceof AstFinallyBlock)) return object2;
                        block.jjtAccept(this, data);
                        return object2;
                        finally {
                            context.getNametableStack().closeScope(scope);
                        }
                    }
                    ++i;
                }
            }
        }
        catch (Throwable throwable) {
            Object var17_11 = null;
            if (i >= n) throw throwable;
            SimpleNode block = (SimpleNode)node.jjtGetChild(n - 1);
            if (!(block instanceof AstFinallyBlock)) throw throwable;
            block.jjtAccept(this, data);
            throw throwable;
        }
        SimpleNode block = (SimpleNode)node.jjtGetChild(n - 1);
        if (!(block instanceof AstFinallyBlock)) return object;
        block.jjtAccept(this, data);
        return object;
    }

    public Object visit(AstUnaryMinusExpression node, Object data) throws Exception {
        return Evaluator.negate(node.jjtGetChild(0).jjtAccept(this, data));
    }

    public Object visit(AstUnaryPlusExpression node, Object data) throws Exception {
        return node.jjtGetChild(0).jjtAccept(this, data);
    }

    public Object visit(AstVariableDeclarator node, Object data) throws Exception {
        Object value = null;
        if (node.jjtGetNumChildren() > 1) {
            value = node.jjtGetChild(1).jjtAccept(this, null);
        } else {
            AstType type = (AstType)data;
            if (type.jjtGetChild(0) instanceof AstPrimitiveType) {
                AstPrimitiveType primitive = (AstPrimitiveType)type.jjtGetChild(0);
                value = PRIMITIVE_DEFAULTS.get(primitive.getData());
            }
        }
        String variableName = (String)((AstVariableDeclaratorId)node.jjtGetChild(0)).getData();
        return this.declareVariable(variableName, value);
    }

    public Object visit(AstWhileStatement node, Object data) throws Exception {
        Node condition = node.jjtGetChild(0);
        Boolean b = Evaluator.toBoolean(condition.jjtAccept(this, data));
        Object returnValue = null;
        while (b.booleanValue()) {
            returnValue = node.jjtGetChild(1).jjtAccept(this, data);
            if (returnValue instanceof Control) {
                if (returnValue == Control.CONTINUE) {
                    returnValue = null;
                } else {
                    if (returnValue != Control.BREAK) break;
                    returnValue = null;
                    break;
                }
            }
            b = Evaluator.toBoolean(condition.jjtAccept(this, data));
        }
        return returnValue;
    }

    public Object visit(SimpleNode node, Object data) throws Exception {
        throw new IllegalStateException("Illegal state");
    }

    public void flush() throws IOException {
        this.getCurrentContext().getWriter().flush();
    }

    public Object visit(AstType node, Object data) throws Exception {
        Node child = node.jjtGetChild(0);
        Class c = null;
        if (child instanceof AstName) {
            AstName name = (AstName)child;
            String className = this.toDottedName(name);
            c = this.getCurrentContext().resolveClass(className);
            if (c == null) {
                throw this.generateProcessingException(new ClassNotFoundException("Class " + className + " not found"), node);
            }
        } else {
            c = (Class)node.jjtAccept(this, data);
        }
        return c;
    }

    public Counter getMethodStats() {
        return this._methodStats;
    }

    public Object visit(AstVariableDeclaratorId node, Object data) throws Exception {
        throw this.generateProcessingException(new IllegalStateException("visit(AstVariableDeclaratorId,Object) should not be called directly"), node);
    }

    public Object visit(AstExitStatement node, Object data) throws Exception {
        return Control.EXIT;
    }

    public Object visit(AstStaticImportDeclaration node, Object data) throws Exception {
        AstName name = (AstName)node.jjtGetChild(0);
        String className = this.toDottedName(name);
        Class c = this.getCurrentContext().resolveClass(className);
        if (c == null) {
            throw this.generateProcessingException(new IllegalArgumentException("Cannot resolve class " + className), node);
        }
        StaticImport si = StaticImportUtils.getStaticImport(c);
        this.getCurrentContext().addStaticImport(si);
        this.getCurrentContext().getNametableStack().putAll(si.getStaticFields());
        return null;
    }

    public Object visit(AstVariableParameters node, Object data) throws Exception {
        throw this.generateProcessingException(new IllegalStateException("visit(AstVariableParameters) should not be called directly"), node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visit(AstEnhancedForStatement node, Object data) throws Exception {
        JxpProcessingContext context = this.getCurrentContext();
        String variable = (String)node.getData();
        Node statements = node.jjtGetChild(2);
        Object colObj = node.jjtGetChild(1).jjtAccept(this, data);
        if (colObj instanceof Collection) {
            Object returnValue = null;
            Iterator it = ((Collection)colObj).iterator();
            int newscope = context.getNametableStack().newScope();
            try {
                this.declareVariable(variable, null);
                while (it.hasNext()) {
                    this.assignVariable(variable, it.next());
                    returnValue = statements.jjtAccept(this, data);
                    if (returnValue == Control.CONTINUE) {
                        returnValue = null;
                        continue;
                    }
                    if (returnValue == Control.BREAK) {
                        returnValue = null;
                        break;
                    }
                    if (!(returnValue instanceof Control)) continue;
                }
                Object object = returnValue;
                return object;
            }
            finally {
                context.getNametableStack().closeScope(newscope);
            }
        }
        throw this.generateProcessingException(new IllegalArgumentException("Expression for enhanced for loop must be collection, get " + colObj + " instead"), node);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        PRIMITIVE_DEFAULTS.put(Integer.TYPE, new Integer(0));
        PRIMITIVE_DEFAULTS.put(Long.TYPE, new Long(0L));
        PRIMITIVE_DEFAULTS.put(Float.TYPE, new Float(0.0f));
        PRIMITIVE_DEFAULTS.put(Double.TYPE, new Double(0.0));
        PRIMITIVE_DEFAULTS.put(Character.TYPE, new Character('\u0000'));
        PRIMITIVE_DEFAULTS.put(Byte.TYPE, new Byte(0));
        PRIMITIVE_DEFAULTS.put(Boolean.TYPE, Boolean.FALSE);
    }

    private class JxpUserDefinedFunction {
        private SimpleNode _paramSpec;
        private AstBlock _block;

        public JxpUserDefinedFunction(SimpleNode paramSpec, AstBlock block) {
            this._paramSpec = paramSpec;
            this._block = block;
        }

        public SimpleNode getParameterSpec() {
            return this._paramSpec;
        }

        public AstBlock getBlock() {
            return this._block;
        }
    }
}

