/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.registry.xml;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.java.plugin.registry.xml.ManifestHandler;
import org.java.plugin.registry.xml.ManifestInfoHandler;
import org.java.plugin.registry.xml.ModelManifestInfo;
import org.java.plugin.registry.xml.ModelPluginManifest;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

final class ManifestParser {
    private static Log log = LogFactory.getLog(class$org$java$plugin$registry$xml$ManifestParser == null ? (class$org$java$plugin$registry$xml$ManifestParser = ManifestParser.class$("org.java.plugin.registry.xml.ManifestParser")) : class$org$java$plugin$registry$xml$ManifestParser);
    static final String PLUGIN_DTD_0_2 = ManifestParser.loadPluginDtd("0_2");
    static final String PLUGIN_DTD_0_3 = ManifestParser.loadPluginDtd("0_3");
    static final String PLUGIN_DTD_0_4 = ManifestParser.loadPluginDtd("0_4");
    static final String PLUGIN_DTD_0_5 = ManifestParser.loadPluginDtd("0_5");
    private final SAXParserFactory parserFactory = SAXParserFactory.newInstance();
    private final EntityResolver entityResolver;
    static /* synthetic */ Class class$org$java$plugin$registry$xml$ManifestParser;
    static /* synthetic */ Class class$org$java$plugin$registry$xml$PluginRegistryImpl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String loadPluginDtd(String string) {
        String string2;
        InputStreamReader inputStreamReader = new InputStreamReader((class$org$java$plugin$registry$xml$PluginRegistryImpl == null ? (class$org$java$plugin$registry$xml$PluginRegistryImpl = ManifestParser.class$("org.java.plugin.registry.xml.PluginRegistryImpl")) : class$org$java$plugin$registry$xml$PluginRegistryImpl).getResourceAsStream("plugin_" + string + ".dtd"), "UTF-8");
        try {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            char[] cArray = new char[64];
            while ((n = inputStreamReader.read(cArray)) != -1) {
                stringBuffer.append(cArray, 0, n);
            }
            string2 = stringBuffer.toString();
        }
        catch (Throwable throwable) {
            try {
                ((Reader)inputStreamReader).close();
                throw throwable;
            }
            catch (IOException iOException) {
                log.error("can't read plug-in DTD file of version " + string, iOException);
                return null;
            }
        }
        ((Reader)inputStreamReader).close();
        return string2;
    }

    private static EntityResolver getDtdEntityResolver() {
        return new EntityResolver(){

            public InputSource resolveEntity(String string, String string2) {
                if (string == null) {
                    return null;
                }
                if (string.equals("-//JPF//Java Plug-in Manifest 0.5") && PLUGIN_DTD_0_5 != null) {
                    return new InputSource(new StringReader(PLUGIN_DTD_0_5));
                }
                if (string.equals("-//JPF//Java Plug-in Manifest 0.4") && PLUGIN_DTD_0_4 != null) {
                    return new InputSource(new StringReader(PLUGIN_DTD_0_4));
                }
                if (string.equals("-//JPF//Java Plug-in Manifest 0.3") && PLUGIN_DTD_0_3 != null) {
                    return new InputSource(new StringReader(PLUGIN_DTD_0_3));
                }
                if (string.equals("-//JPF//Java Plug-in Manifest 0.2") && PLUGIN_DTD_0_2 != null) {
                    return new InputSource(new StringReader(PLUGIN_DTD_0_2));
                }
                return null;
            }
        };
    }

    ManifestParser(boolean bl) {
        this.parserFactory.setValidating(bl);
        this.entityResolver = bl ? ManifestParser.getDtdEntityResolver() : null;
        log.info("got SAX parser factory - " + this.parserFactory);
    }

    ModelPluginManifest parseManifest(URL uRL) throws ParserConfigurationException, SAXException, IOException {
        ManifestHandler manifestHandler = new ManifestHandler(this.entityResolver);
        this.parserFactory.newSAXParser().parse(new InputSource(uRL.toExternalForm()), (DefaultHandler)manifestHandler);
        return manifestHandler.getResult();
    }

    ModelManifestInfo parseManifestInfo(URL uRL) throws ParserConfigurationException, SAXException, IOException {
        ManifestInfoHandler manifestInfoHandler = new ManifestInfoHandler(this.entityResolver);
        this.parserFactory.newSAXParser().parse(new InputSource(uRL.toExternalForm()), (DefaultHandler)manifestInfoHandler);
        return manifestInfoHandler.getResult();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

