/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Boolean2ScorerSupplier;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BooleanScorer;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.DisjunctionSumScorer;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FakeScorer;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.ReqExclBulkScorer;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.Bits;

final class BooleanWeight
extends Weight {
    final Similarity similarity;
    final BooleanQuery query;
    final ArrayList<Weight> weights;
    final boolean needsScores;

    BooleanWeight(BooleanQuery query, IndexSearcher searcher, boolean needsScores, float boost) throws IOException {
        super(query);
        this.query = query;
        this.needsScores = needsScores;
        this.similarity = searcher.getSimilarity(needsScores);
        this.weights = new ArrayList();
        for (BooleanClause c : query) {
            Weight w = searcher.createWeight(c.getQuery(), needsScores && c.isScoring(), boost);
            this.weights.add(w);
        }
    }

    @Override
    public void extractTerms(Set<Term> terms) {
        int i = 0;
        for (BooleanClause clause : this.query) {
            if (clause.isScoring() || !this.needsScores && !clause.isProhibited()) {
                this.weights.get(i).extractTerms(terms);
            }
            ++i;
        }
    }

    @Override
    public Explanation explain(LeafReaderContext context, int doc) throws IOException {
        int minShouldMatch = this.query.getMinimumNumberShouldMatch();
        ArrayList<Explanation> subs = new ArrayList<Explanation>();
        float sum = 0.0f;
        boolean fail = false;
        int matchCount = 0;
        int shouldMatchCount = 0;
        Iterator<BooleanClause> cIter = this.query.iterator();
        for (Weight w : this.weights) {
            BooleanClause c = cIter.next();
            Explanation e = w.explain(context, doc);
            if (e.isMatch()) {
                if (c.isScoring()) {
                    subs.add(e);
                    sum += e.getValue();
                } else if (c.isRequired()) {
                    subs.add(Explanation.match(0.0f, "match on required clause, product of:", Explanation.match(0.0f, (Object)((Object)BooleanClause.Occur.FILTER) + " clause", new Explanation[0]), e));
                } else if (c.isProhibited()) {
                    subs.add(Explanation.noMatch("match on prohibited clause (" + c.getQuery().toString() + ")", e));
                    fail = true;
                }
                if (!c.isProhibited()) {
                    ++matchCount;
                }
                if (c.getOccur() != BooleanClause.Occur.SHOULD) continue;
                ++shouldMatchCount;
                continue;
            }
            if (!c.isRequired()) continue;
            subs.add(Explanation.noMatch("no match on required clause (" + c.getQuery().toString() + ")", e));
            fail = true;
        }
        if (fail) {
            return Explanation.noMatch("Failure to meet condition(s) of required/prohibited clause(s)", subs);
        }
        if (matchCount == 0) {
            return Explanation.noMatch("No matching clauses", subs);
        }
        if (shouldMatchCount < minShouldMatch) {
            return Explanation.noMatch("Failure to match minimum number of optional clauses: " + minShouldMatch, subs);
        }
        return Explanation.match(sum, "sum of:", subs);
    }

    static BulkScorer disableScoring(final BulkScorer scorer) {
        return new BulkScorer(){

            @Override
            public int score(final LeafCollector collector, Bits acceptDocs, int min, int max) throws IOException {
                LeafCollector noScoreCollector = new LeafCollector(){
                    FakeScorer fake = new FakeScorer();

                    @Override
                    public void setScorer(Scorer scorer) throws IOException {
                        collector.setScorer(this.fake);
                    }

                    @Override
                    public void collect(int doc) throws IOException {
                        this.fake.doc = doc;
                        collector.collect(doc);
                    }
                };
                return scorer.score(noScoreCollector, acceptDocs, min, max);
            }

            @Override
            public long cost() {
                return scorer.cost();
            }
        };
    }

    BulkScorer optionalBulkScorer(LeafReaderContext context) throws IOException {
        ArrayList<BulkScorer> optional = new ArrayList<BulkScorer>();
        Iterator<BooleanClause> cIter = this.query.iterator();
        for (Weight w : this.weights) {
            BulkScorer subScorer;
            BooleanClause c = cIter.next();
            if (c.getOccur() != BooleanClause.Occur.SHOULD || (subScorer = w.bulkScorer(context)) == null) continue;
            optional.add(subScorer);
        }
        if (optional.size() == 0) {
            return null;
        }
        if (this.query.getMinimumNumberShouldMatch() > optional.size()) {
            return null;
        }
        if (optional.size() == 1) {
            return (BulkScorer)optional.get(0);
        }
        return new BooleanScorer(this, optional, Math.max(1, this.query.getMinimumNumberShouldMatch()), this.needsScores);
    }

    private BulkScorer requiredBulkScorer(LeafReaderContext context) throws IOException {
        BulkScorer scorer = null;
        Iterator<BooleanClause> cIter = this.query.iterator();
        for (Weight w : this.weights) {
            BooleanClause c = cIter.next();
            if (!c.isRequired()) continue;
            if (scorer != null) {
                return null;
            }
            scorer = w.bulkScorer(context);
            if (scorer == null) {
                return null;
            }
            if (c.isScoring() || !this.needsScores) continue;
            scorer = BooleanWeight.disableScoring(scorer);
        }
        return scorer;
    }

    BulkScorer booleanScorer(LeafReaderContext context) throws IOException {
        Scorer prohibitedScorer;
        BulkScorer positiveScorer;
        int numOptionalClauses = this.query.getClauses(BooleanClause.Occur.SHOULD).size();
        int numRequiredClauses = this.query.getClauses(BooleanClause.Occur.MUST).size() + this.query.getClauses(BooleanClause.Occur.FILTER).size();
        if (numRequiredClauses == 0) {
            positiveScorer = this.optionalBulkScorer(context);
            if (positiveScorer == null) {
                return null;
            }
            long costThreshold = this.query.getMinimumNumberShouldMatch() <= 1 ? -1L : (long)(context.reader().maxDoc() / 3);
            if (positiveScorer.cost() < costThreshold) {
                return null;
            }
        } else if (numRequiredClauses == 1 && numOptionalClauses == 0 && this.query.getMinimumNumberShouldMatch() == 0) {
            positiveScorer = this.requiredBulkScorer(context);
        } else {
            return null;
        }
        if (positiveScorer == null) {
            return null;
        }
        ArrayList<Scorer> prohibited = new ArrayList<Scorer>();
        Iterator<BooleanClause> cIter = this.query.iterator();
        for (Weight w : this.weights) {
            Scorer scorer;
            BooleanClause c = cIter.next();
            if (!c.isProhibited() || (scorer = w.scorer(context)) == null) continue;
            prohibited.add(scorer);
        }
        if (prohibited.isEmpty()) {
            return positiveScorer;
        }
        Scorer scorer = prohibitedScorer = prohibited.size() == 1 ? (Scorer)prohibited.get(0) : new DisjunctionSumScorer(this, prohibited, false);
        if (prohibitedScorer.twoPhaseIterator() != null) {
            return null;
        }
        return new ReqExclBulkScorer(positiveScorer, prohibitedScorer.iterator());
    }

    @Override
    public BulkScorer bulkScorer(LeafReaderContext context) throws IOException {
        BulkScorer bulkScorer = this.booleanScorer(context);
        if (bulkScorer != null) {
            return bulkScorer;
        }
        return super.bulkScorer(context);
    }

    @Override
    public Scorer scorer(LeafReaderContext context) throws IOException {
        ScorerSupplier scorerSupplier = this.scorerSupplier(context);
        if (scorerSupplier == null) {
            return null;
        }
        return scorerSupplier.get(Long.MAX_VALUE);
    }

    @Override
    public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
        int minShouldMatch = this.query.getMinimumNumberShouldMatch();
        EnumMap<BooleanClause.Occur, Collection<ScorerSupplier>> scorers = new EnumMap<BooleanClause.Occur, Collection<ScorerSupplier>>(BooleanClause.Occur.class);
        for (BooleanClause.Occur occur : BooleanClause.Occur.values()) {
            scorers.put(occur, new ArrayList());
        }
        Iterator<BooleanClause> cIter = this.query.iterator();
        for (Weight w : this.weights) {
            BooleanClause c = cIter.next();
            ScorerSupplier subScorer = w.scorerSupplier(context);
            if (subScorer == null) {
                if (!c.isRequired()) continue;
                return null;
            }
            ((Collection)scorers.get((Object)c.getOccur())).add(subScorer);
        }
        if (((Collection)scorers.get((Object)BooleanClause.Occur.SHOULD)).size() == minShouldMatch) {
            ((Collection)scorers.get((Object)BooleanClause.Occur.MUST)).addAll((Collection)scorers.get((Object)BooleanClause.Occur.SHOULD));
            ((Collection)scorers.get((Object)BooleanClause.Occur.SHOULD)).clear();
            minShouldMatch = 0;
        }
        if (((Collection)scorers.get((Object)BooleanClause.Occur.FILTER)).isEmpty() && ((Collection)scorers.get((Object)BooleanClause.Occur.MUST)).isEmpty() && ((Collection)scorers.get((Object)BooleanClause.Occur.SHOULD)).isEmpty()) {
            return null;
        }
        if (((Collection)scorers.get((Object)BooleanClause.Occur.SHOULD)).size() < minShouldMatch) {
            return null;
        }
        if (!this.needsScores && minShouldMatch == 0 && ((Collection)scorers.get((Object)BooleanClause.Occur.MUST)).size() + ((Collection)scorers.get((Object)BooleanClause.Occur.FILTER)).size() > 0) {
            ((Collection)scorers.get((Object)BooleanClause.Occur.SHOULD)).clear();
        }
        return new Boolean2ScorerSupplier(this, scorers, this.needsScores, minShouldMatch);
    }
}

