#include "XmlParser.h"

Player *p;
Team* t;
State *s;
Formation *f[4];

static void print_player(FILE*fd, Player* player){
	fprintf(fd,"  <player name=\"%s\" number=\"%i\" position=\"%s\" race=\"%s\" display=\"%s\">\n",
		player->get_name(),player->get_number(),player->get_position(),player->get_race(),player->get_picture_name()
		);
	fprintf(fd,"   <ma>%i</ma>\n",player->get_ma());
	fprintf(fd,"   <st>%i</st>\n",player->get_st());
	fprintf(fd,"   <ag>%i</ag>\n",player->get_ag());
	fprintf(fd,"   <av>%i</av>\n",player->get_av());
	fprintf(fd,"   <positionid>%i</positionid>\n",player->get_position_id());
	fprintf(fd,"   <cost>%i</cost>\n",player->get_cost());
	
	std::list<char*>* skills = player->get_skills(); 
	std::list<char*>::iterator it;
	for(it=skills->begin();it!=skills->end();it++){
		/*string s = (*it); 
		char *tmp = new char(32);
		unsigned int i;
		for(i=0;i<s.size();i++){
			tmp[i] = s[i];
		}
		tmp[i]='\0';*/
		fprintf(fd,"   <skill>%s</skill>\n",(*it));
	}
	
	fprintf(fd,"  </player>\n");
}

static void print_full_player(FILE*fd, Player* player){
	fprintf(fd,"  <player name=\"%s\" number=\"%i\" position=\"%s\" race=\"%s\" display=\"%s\">\n",
		player->get_name(),player->get_number(),player->get_position(),player->get_race(),player->get_picture_name()
		);
	fprintf(fd,"   <ma>%i</ma>\n",player->get_ma());
	fprintf(fd,"   <st>%i</st>\n",player->get_st());
	fprintf(fd,"   <ag>%i</ag>\n",player->get_ag());
	fprintf(fd,"   <av>%i</av>\n",player->get_av());
	fprintf(fd,"   <positionid>%i</positionid>\n",player->get_position_id());
	fprintf(fd,"   <cost>%i</cost>\n",player->get_cost());
	
	std::list<char*>* skills = player->get_skills(); 
	std::list<char*>::iterator it;
	for(it=skills->begin();it!=skills->end();it++){
		/*
		string s = (*it); 
		char *tmp = new char(32);
		unsigned int i;
		for(i=0;i<s.size();i++){
			tmp[i] = s[i];
		}
		tmp[i]='\0';
		*/
		fprintf(fd,"   <skill>%s</skill>\n",(*it));
	}
	if(player->get_square()) fprintf(fd,"   <square>%i,%i</square>\n",player->get_square()->get_x(),player->get_square()->get_y());
	if(player->get_reserve_square()) fprintf(fd,"   <reserve_square>%i,%i</reserve_square>\n",player->get_reserve_square()->get_x(),player->get_reserve_square()->get_y());

	fprintf(fd,"  </player>\n");
}

static void print_team(FILE*fd, Team*t){
	fprintf(fd,"<team name=\"%s\" race=\"%s\" coach=\"%s\" BBversion=\"4\" emblem=\"%s\"\n",
				t->get_name(),t->get_race(),t->get_coach(),t->get_emblem());
	fprintf(fd," <rating>%i</rating>\n",t->get_rating());
	fprintf(fd," <treasury>%i</treasury>\n",t->get_treasury());
	fprintf(fd," <reroll>%i</reroll>\n",t->get_reroll());
	fprintf(fd," <rerollcost>%i</rerollcost>\n",t->get_reroll_cost());
	fprintf(fd," <fanfactor>%i</fanfactor>\n",t->get_fan_factor());
	fprintf(fd," <assistant>%i</assistant>\n",t->get_assistant());
	fprintf(fd," <cheerleader>%i</cheerleader>\n",t->get_cheer_leaders());
	fprintf(fd," <apothecary>%i</apothecary>\n",t->get_apothecary());
	fprintf(fd," <wizard>%i</wizard>\n",t->get_wizard());
	fprintf(fd," <players>\n");

	std::map<int,Player*> ::iterator it;
	std::map<int,Player*> *players = t->get_players();
	for(it=players->begin();it!=players->end();it++)
		print_player(fd, (*it).second);

	fprintf(fd," </players>\n");
	fprintf(fd,"</team>\n");
}

static void print_full_team(FILE*fd, Team*t){
	fprintf(fd,"<team name=\"%s\" race=\"%s\" coach=\"%s\" BBversion=\"4\" emblem=\"%s\"\n",
				t->get_name(),t->get_race(),t->get_coach(),t->get_emblem());
	fprintf(fd," <rating>%i</rating>\n",t->get_rating());
	fprintf(fd," <treasury>%i</treasury>\n",t->get_treasury());
	fprintf(fd," <reroll>%i</reroll>\n",t->get_reroll());
	fprintf(fd," <rerollcost>%i</rerollcost>\n",t->get_reroll_cost());
	fprintf(fd," <fanfactor>%i</fanfactor>\n",t->get_fan_factor());
	fprintf(fd," <assistant>%i</assistant>\n",t->get_assistant());
	fprintf(fd," <cheerleader>%i</cheerleader>\n",t->get_cheer_leaders());
	fprintf(fd," <apothecary>%i</apothecary>\n",t->get_apothecary());
	fprintf(fd," <wizard>%i</wizard>\n",t->get_wizard());
	fprintf(fd," <players>\n");

	std::map<int,Player*> ::iterator it;
	std::map<int,Player*> *players = t->get_players();
	for(it=players->begin();it!=players->end();it++)
		print_full_player(fd, (*it).second);

	fprintf(fd," </players>\n");
	fprintf(fd,"</team>\n");
}

static void makePlayer(xmlDocPtr doc, xmlNsPtr ns, xmlNodePtr cur) {
	cur = cur->xmlChildrenNode;
    while (cur != NULL) {
        if ((!xmlStrcmp(cur->name, (const xmlChar *)"ma")) && (cur->ns == ns)){
			p->set_ma(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )) ;
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"st")) && (cur->ns == ns)){
			p->set_st(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )) ;
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"ag")) && (cur->ns == ns)){
			p->set_ag(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )) ;
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"av")) && (cur->ns == ns)){
			p->set_av(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )) ;
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"positionid")) && (cur->ns == ns)){
			p->set_position_id(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )) ;
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"cost")) && (cur->ns == ns)){
			p->set_cost(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )) ;
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"skill")) && (cur->ns == ns)){
			/*
			char *tmp = (char*) malloc( CHAR_32 );
			sprintf(tmp,"%s",(char*)xmlNodeListGetString(doc, cur->xmlChildrenNode, 1));
			p->add_skill(tmp);
			free(tmp);
			*/
			p->add_skill((char*)xmlNodeListGetString(doc, cur->xmlChildrenNode, 1));
		}
	cur = cur->next;
	}
}

static void makePlayers(xmlDocPtr doc, xmlNsPtr ns, xmlNodePtr cur) {
	int i=0;
	
//	sprintf(race,"%s",r);	

	char *name = (char*)malloc( CHAR_64 );
	char *position = (char*)malloc( CHAR_64 );
	char *race = (char*)malloc( CHAR_64 );
	char *picture_name = (char*)malloc( CHAR_128 );
	int number;

    cur = cur->xmlChildrenNode;
	while (cur != NULL) {
		if ((!xmlStrcmp(cur->name, (const xmlChar *) "player")) && (cur->ns == ns)) {

			sprintf(name,"%s",(char*)xmlGetProp(cur, (const xmlChar *) "name"));
			number = atoi( (char*) xmlGetProp(cur, (const xmlChar *) "number") );
			sprintf(position,"%s",(char*)xmlGetProp(cur, (const xmlChar *) "position"));
			sprintf(race,"%s",(char*)xmlGetProp(cur, (const xmlChar *) "race"));
			sprintf(picture_name,"%s",(char*)xmlGetProp(cur, (const xmlChar *) "display"));

			p = new Player(name,number,position,0,0,0,0,0,0,race,picture_name,0);
			makePlayer(doc, ns, cur);
			
			if (i++ >= 16) break;

			t->add_player(p);
		}
	cur = cur->next;
    }

	free(name);
	free(race);
	free(position);
	free(picture_name);

}

static void makeTeam(xmlDocPtr doc, xmlNsPtr ns, xmlNodePtr cur) {    
    while (cur != NULL) {
        if ((!xmlStrcmp(cur->name, (const xmlChar *)"rating")) && (cur->ns == ns))
			t->set_rating(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )) ;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"treasury")) && (cur->ns == ns))
			t->set_treasury(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )) ;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"reroll")) && (cur->ns == ns))
			t->set_reroll(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )) ;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"rerollcost")) && (cur->ns == ns))
		    t->set_reroll_cost(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )) ;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"fanfactor")) && (cur->ns == ns))
			t->set_fan_factor(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )) ;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"assistant")) && (cur->ns == ns))
			t->set_assistant(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )) ;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"cheerleader")) && (cur->ns == ns))
			t->set_cheer_leaders(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )) ;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"apothecary")) && (cur->ns == ns))
			t->set_apothecary(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )) ;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"wizard")) && (cur->ns == ns))
			t->set_wizard(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )) ;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"formation")) && (cur->ns == ns)){
			t->set_formations_file((char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1)) ;
		}
		
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"players")) && (cur->ns == ns) )
			makePlayers(doc, ns, cur);
		
	cur = cur->next;
    }
}
////////////////////////////////////////////////////////

static void makeSquare(xmlDocPtr doc, xmlNsPtr ns, xmlNodePtr cur) {
	cur = cur->xmlChildrenNode;
	int sx=-2,sy=-2;
	while (cur != NULL) {
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"x")) && (cur->ns == ns))
			sx = ( atoi( (char*) xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) ));
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"y")) && (cur->ns == ns))
			sy = ( atoi( (char*) xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) ));
		cur = cur->next;
	}
	if(sx!=-2 && sy!=-2) {
		p->place(sx,sy);
	}
}

/////////////////////////////////////////////////////////

static void makeReserveSquare(xmlDocPtr doc, xmlNsPtr ns, xmlNodePtr cur) {
	cur = cur->xmlChildrenNode;
	int sx=-2,sy=-2;
	while (cur != NULL) {
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"x")) && (cur->ns == ns))
			sx = ( atoi( (char*) xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) ));
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"y")) && (cur->ns == ns))
			sy = ( atoi( (char*) xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) ));
		cur = cur->next;
	}
	if(sx!=-2 && sy!=-2) p->place_in_reserve(sx,sy);
}

////////////////////////////////////////////////////////
static void makePlayer(xmlDocPtr doc, xmlNsPtr ns, xmlNodePtr cur, int id) {
	cur = cur->xmlChildrenNode;
    while (cur != NULL) {
		
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"team")) && (cur->ns == ns)){
			p->set_team(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )) ;
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"move_count")) && (cur->ns == ns)){
			p->set_move_count(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )) ;
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"overmore_count")) && (cur->ns == ns)){
			p->set_overmove_count(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )) ;
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"number")) && (cur->ns == ns)){
			p->set_number(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )) ;
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"status")) && (cur->ns == ns)){
			p->set_status_only(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )) ;
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"xps")) && (cur->ns == ns)){
			p->set_xps(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )) ;
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"ma")) && (cur->ns == ns)){
			p->set_ma(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )) ;
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"st")) && (cur->ns == ns)){
			p->set_st(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )) ;
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"ag")) && (cur->ns == ns)){
			p->set_ag(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )) ;
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"av")) && (cur->ns == ns)){
			p->set_av(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )) ;
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"position_id")) && (cur->ns == ns)){
			p->set_position_id(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )) ;
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"cost")) && (cur->ns == ns)){
			p->set_cost(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )) ;
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"team_reroll_used")) && (cur->ns == ns)){
			p->set_team_reroll_used(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0?false:true) ;
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"move_reroll_used")) && (cur->ns == ns)){
			p->set_move_reroll_used(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0?false:true) ;
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"block_done")) && (cur->ns == ns)){
			p->set_block_done(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0?false:true) ;
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"aggress_done")) && (cur->ns == ns)){
			p->set_aggress_done(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0?false:true) ;
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"gather_done")) && (cur->ns == ns)){
			p->set_gather_done(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0?false:true) ;
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"throw_done")) && (cur->ns == ns)){
			p->set_throw_done(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0?false:true) ;
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"throw_team_mate_done")) && (cur->ns == ns)){
			p->set_throw_team_mate_done(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0?false:true) ;
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"blitz_done")) && (cur->ns == ns)){
			p->set_blitz_done(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0?false:true) ;
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"team_blitz_done")) && (cur->ns == ns)){
			p->set_team_blitz_done(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0?false:true) ;
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"team_aggress_done")) && (cur->ns == ns)){
			p->set_team_aggress_done(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0?false:true) ;
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"team_throw_done")) && (cur->ns == ns)){
			p->set_team_throw_done(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0?false:true) ;
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"receive_done")) && (cur->ns == ns)){
			p->set_receive_done(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0?false:true) ;
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"on_playground")) && (cur->ns == ns)){
			p->set_on_playground(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0?false:true) ;
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"has_ball")) && (cur->ns == ns)){
			p->set_has_ball(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0?false:true) ;
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"selected")) && (cur->ns == ns)){
			p->set_selected(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0?false:true) ;
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"played")) && (cur->ns == ns)){
			p->set_has_played(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0?false:true) ;
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"get_up_done")) && (cur->ns == ns)){
			p->set_get_up_done(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0?false:true) ;
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"mighty_blow_used")) && (cur->ns == ns)){
			p->set_mighty_blow_used(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0?false:true) ;
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"dirty_player_used")) && (cur->ns == ns)){
			p->set_dirty_player_used(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0?false:true) ;
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"pilling_on_used")) && (cur->ns == ns)){
			p->set_pilling_on_used(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0?false:true) ;
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"frenzy_block_done")) && (cur->ns == ns)){
			p->set_frenzy_block_done(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0?false:true) ;
		}
		
		//////////////////////////////////////
		// Ragnar Modif6 : nouvelles mthodes dans Team
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"bone_head_tested")) && (cur->ns == ns)){
			p->set_bone_head_tested(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0?false:true) ;
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"really_stupid_tested")) && (cur->ns == ns)){
			p->set_really_stupid_tested(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0?false:true) ;
		}
		//////////////////////////////////////

		if ((!xmlStrcmp(cur->name, (const xmlChar *)"skill")) && (cur->ns == ns)){
			/*
			char *tmp = (char*) malloc( CHAR_32 );
			sprintf(tmp,"%s",(char*)xmlNodeListGetString(doc, cur->xmlChildrenNode, 1));
			p->add_skill(tmp);
			free(tmp);
			*/
			p->add_skill((char*)xmlNodeListGetString(doc, cur->xmlChildrenNode, 1));
		}
		
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"name")) && (cur->ns == ns)){
			p->set_name( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) ) ;
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"position")) && (cur->ns == ns)){
			p->set_position( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) ) ;
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"picture_name")) && (cur->ns == ns)){
			p->set_picture_name( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) ) ;
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"race")) && (cur->ns == ns)){
			p->set_race( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) ) ;
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"square")) && (cur->ns == ns) ) {
			makeSquare(doc, ns, cur);
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"reserve_square")) && (cur->ns == ns) ) {
			makeReserveSquare(doc, ns, cur);
		}

	cur = cur->next;
	}
}

/////////////////////////////////////////////////////////

static void makePlayers(xmlDocPtr doc, xmlNsPtr ns, xmlNodePtr cur, int id) {
	cur = cur->xmlChildrenNode;
	
	while (cur != NULL) {
		if ((!xmlStrcmp(cur->name, (const xmlChar *) "player")) && (cur->ns == ns)) {
			p = new Player(NULL,0,NULL,0,0,0,0,0,0,NULL,NULL,0);
			makePlayer(doc, ns, cur, id);
			s->team[id]->add_player(p,p->get_number());
		}
	cur = cur->next;
    }

}


/////////////////////////////////////////////////////////
static void makeTeam(xmlDocPtr doc, xmlNsPtr ns, xmlNodePtr cur, int id) {
cur = cur->xmlChildrenNode;
	
    while (cur != NULL) {
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"rating")) && (cur->ns == ns))
			s->team[id]->set_rating(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )) ;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"treasury")) && (cur->ns == ns))
			s->team[id]->set_treasury(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )) ;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"reroll")) && (cur->ns == ns))
			s->team[id]->set_reroll(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )) ;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"reroll_cost")) && (cur->ns == ns))
			s->team[id]->set_reroll_cost(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )) ;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"fanfactor")) && (cur->ns == ns))
			s->team[id]->set_fan_factor(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )) ;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"assistant")) && (cur->ns == ns))
			s->team[id]->set_assistant(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )) ;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"cheerleader")) && (cur->ns == ns))
			s->team[id]->set_cheer_leaders(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )) ;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"apothecary")) && (cur->ns == ns))
			s->team[id]->set_apothecary(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )) ;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"wizard")) && (cur->ns == ns))
			s->team[id]->set_wizard(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )) ;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"score")) && (cur->ns == ns))
			s->team[id]->set_score(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )) ;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"turn")) && (cur->ns == ns))
			s->team[id]->set_turn(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )) ;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"id")) && (cur->ns == ns))
			s->team[id]->set_id(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )) ;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"ejected")) && (cur->ns == ns))
			s->team[id]->set_ejected(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )) ;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"out")) && (cur->ns == ns))
			s->team[id]->set_out(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )) ;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"reserve")) && (cur->ns == ns))
			s->team[id]->set_reserve(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )) ;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"ko")) && (cur->ns == ns))
			s->team[id]->set_ko(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )) ;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"reroll_init")) && (cur->ns == ns))
			s->team[id]->set_reroll_init(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )) ;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"reroll_used")) && (cur->ns == ns))
			s->team[id]->set_reroll_used((atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0)?false:true) ;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"blitz_done")) && (cur->ns == ns))
			s->team[id]->set_blitz_done((atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0)?false:true) ;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"placed")) && (cur->ns == ns))
			s->team[id]->set_placed((atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0)?false:true) ;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"aggress_done")) && (cur->ns == ns))
			s->team[id]->set_aggress_done((atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0)?false:true) ;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"throw_done")) && (cur->ns == ns))
			s->team[id]->set_throw_done((atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0)?false:true) ;		
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"throw_team_mate_done")) && (cur->ns == ns))
			s->team[id]->set_throw_team_mate_done((atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0)?false:true) ;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"transmit_done")) && (cur->ns == ns))
			s->team[id]->set_transmit_done((atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0)?false:true) ;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"complain_ok")) && (cur->ns == ns))
			s->team[id]->set_can_complain((atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0)?false:true) ;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"referee_intimidated")) && (cur->ns == ns))
			s->team[id]->set_referee_intimidated((atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0)?false:true) ;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"free_turn")) && (cur->ns == ns))
			s->team[id]->set_has_free_turn((atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0)?false:true) ;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"name")) && (cur->ns == ns))
			s->team[id]->set_name( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) ) ;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"coach")) && (cur->ns == ns))
			s->team[id]->set_coach( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) ) ;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"race")) && (cur->ns == ns))
			s->team[id]->set_race( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) ) ;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"emblem")) && (cur->ns == ns))
			s->team[id]->set_emblem( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) ) ;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"formation")) && (cur->ns == ns)){
			s->team[id]->set_formations_file((char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1)) ;
		}

		if ((!xmlStrcmp(cur->name, (const xmlChar *)"players")) && (cur->ns == ns) ) {
			makePlayers(doc, ns, cur, id);
		}

	cur = cur->next;
    }
}

////////////////////////////////////////////////////////
static void makeAudience(xmlDocPtr doc, xmlNsPtr ns, xmlNodePtr cur) {    
	cur = cur->xmlChildrenNode;
	
	while (cur != NULL) {
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"number")) && (cur->ns == ns))
			s->audience->set_number( atoi( (char*) xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) ));	
		cur = cur->next;
	}
}

////////////////////////////////////////////////////////

static void makeSelection(xmlDocPtr doc, xmlNsPtr ns, xmlNodePtr cur) {    
	cur = cur->xmlChildrenNode;
	
	while (cur != NULL) {
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"x")) && (cur->ns == ns))
			s->selection->set_x( atoi( (char*) xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) ));
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"y")) && (cur->ns == ns))
			s->selection->set_y( atoi( (char*) xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) ));
		cur = cur->next;
	}
}
////////////////////////////////////////////////////////

static void makeOldSelectedPlayer(xmlDocPtr doc, xmlNsPtr ns, xmlNodePtr cur) {    
	cur = cur->xmlChildrenNode;
	
	while (cur != NULL) {
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"x")) && (cur->ns == ns))
			s->old_selected_player->set_x( atoi( (char*) xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) ));
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"y")) && (cur->ns == ns))
			s->old_selected_player->set_y( atoi( (char*) xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) ));
		cur = cur->next;
	}
}
////////////////////////////////////////////////////////

static void makeBall(xmlDocPtr doc, xmlNsPtr ns, xmlNodePtr cur) {    
	cur = cur->xmlChildrenNode;
	int bx = -2,by = -2;
	while (cur != NULL) {
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"special")) && (cur->ns == ns))
			s->ball->set_special( (atoi( (char*) xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0)?(false):(true));
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"visible")) && (cur->ns == ns))
			s->ball->set_visible( (atoi( (char*) xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0)?(false):(true));
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"bounced")) && (cur->ns == ns))
			s->ball->set_has_bounced( (atoi( (char*) xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0)?(false):(true));
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"x")) && (cur->ns == ns))
			bx = atoi( (char*) xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) );
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"y")) && (cur->ns == ns))
			by = atoi( (char*) xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) );
		cur = cur->next;
	}
	s->ball->place(bx,by);
}
/////////////////////////////////////////////////////////

static void makeState(xmlDocPtr doc, xmlNsPtr ns, xmlNodePtr cur) {    
    while (cur != NULL) {
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"debug")) && (cur->ns == ns))
			s->debug = (atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0)?false:true;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"dices_roll")) && (cur->ns == ns)) 
			s->dices_roll = (atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0)?false:true;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"player_to_place_x")) && (cur->ns == ns)) 
			s->player_to_place_x = atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) );
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"player_to_place_y")) && (cur->ns == ns)) 
			s->player_to_place_y = atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) );
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"tackle_zone_drawing_mode")) && (cur->ns == ns)) 
			s->tackle_zone_drawing_mode = atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) );
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"number_drawing_mode")) && (cur->ns == ns)) 
			s->number_drawing_mode = (atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0)?false:true;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"ticks_drawing_mode")) && (cur->ns == ns)) 
			s->ticks_drawing_mode = (atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0)?false:true;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"grab_mouse_mode")) && (cur->ns == ns)) 
			s->grab_mouse_mode = (atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0)?false:true;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"current_action")) && (cur->ns == ns)) 
			s->current_action = atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) );
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"current_mode")) && (cur->ns == ns)) 
			s->current_mode = atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) );
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"player_is_moving")) && (cur->ns == ns)) 
			s->player_is_moving = (atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0)?false:true;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"x_menu_clic")) && (cur->ns == ns)) 
			s->x_menu_clic = atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) );
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"y_menu_clic")) && (cur->ns == ns)) 
			s->y_menu_clic = atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) );
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"x_player_clic")) && (cur->ns == ns))
			s->x_player_clic = atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) );
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"y_player_clic")) && (cur->ns == ns)) 
			s->y_player_clic = atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) );
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"zoom_mode")) && (cur->ns == ns)) 
			s->zoom_mode = (atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0)?false:true;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"autocenter_mode")) && (cur->ns == ns)) 
			s->autocenter_mode = (atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0)?false:true;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"freeze_interaction")) && (cur->ns == ns)) 
			s->freeze_interaction = (atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0)?false:true;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"select_throw_target")) && (cur->ns == ns)) 
			s->select_throw_target = (atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0)?false:true;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"throw_team_mate_anim")) && (cur->ns == ns)) 
			s->throw_team_mate_anim =(atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0)?false:true;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"x_push")) && (cur->ns == ns)) 
			s->x_push = atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) );
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"y_push")) && (cur->ns == ns)) 
			s->y_push = atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) );
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"push_square_count")) && (cur->ns == ns)) 
			s->push_square_count = atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) );
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"direct_push")) && (cur->ns == ns)) 
			s->direct_push = (atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0)?false:true;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"x_indirect_push")) && (cur->ns == ns)) 
			s->x_indirect_push = atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) );
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"y_indirect_push")) && (cur->ns == ns)) 
			s->y_indirect_push = atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) );
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"indirect_push_square_count")) && (cur->ns == ns))
			s->indirect_push_square_count = atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) );
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"direct_indirect_push")) && (cur->ns == ns))
			s->direct_indirect_push = (atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0)?false:true;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"x_double_indirect_push")) && (cur->ns == ns)) 
			s->x_double_indirect_push = atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) );
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"y_double_indirect_push")) && (cur->ns == ns)) 
			s->y_double_indirect_push = atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) );
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"double_indirect_push_square_count")) && (cur->ns == ns))
			s->double_indirect_push_square_count = atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) );
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"direct_double_indirect_push")) && (cur->ns == ns))
			s->direct_double_indirect_push = (atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0)?false:true;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"old_x_square")) && (cur->ns == ns))
			s->old_x_square = atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) );
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"old_y_square")) && (cur->ns == ns))
			s->old_y_square = atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) );
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"throw_in_anim")) && (cur->ns == ns))
			s->throw_in_anim = (atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0)?false:true;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"active_team")) && (cur->ns == ns)) 
			s->active_team = atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) );
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"old_active_team")) && (cur->ns == ns)) 
			s->old_active_team = atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) );
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"turn_begining_time")) && (cur->ns == ns)) 
			s->turn_begining_time = atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) );
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"pause_begining_time")) && (cur->ns == ns))
			s->pause_begining_time = atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) );
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"autocenter_anim")) && (cur->ns == ns)) 
			s->autocenter_anim = (atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0)?false:true;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"pass_anim")) && (cur->ns == ns)) 
			s->pass_anim = (atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0)?false:true;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"target_anim")) && (cur->ns == ns))
			s->target_anim = (atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0)?false:true;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"perfect_pass")) && (cur->ns == ns)) 
			s->perfect_pass = (atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0)?false:true;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"interception_square_count")) && (cur->ns == ns))
			s->interception_square_count = atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) );
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"interception_attempt")) && (cur->ns == ns)) 
			s->interception_attempt = (atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0)?false:true;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"x_dock")) && (cur->ns == ns))
			s->x_dock = atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) );
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"y_dock")) && (cur->ns == ns))
			s->y_dock = atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) );
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"drag_dock")) && (cur->ns == ns))
			s->drag_dock = (atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0)?false:true;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"drag_playground")) && (cur->ns == ns)) 
			s->drag_playground = (atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0)?false:true;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"pause")) && (cur->ns == ns)) 
			s->pause = (atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0)?false:true;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"update_time")) && (cur->ns == ns)) 
			s->update_time = (atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0)?false:true;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"remaining_time")) && (cur->ns == ns)) 
			s->remaining_time = atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) );
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"max_victims")) && (cur->ns == ns)) 
			s->max_victims = atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) );
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"old_ball_owner_team")) && (cur->ns == ns))
			s->old_ball_owner_team = atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) );
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"transmit_square_count")) && (cur->ns == ns))
			s->transmit_square_count = atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) );
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"reserve_page_0_")) && (cur->ns == ns)) 
			s->reserve_page[0] = atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) );
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"reserve_page_1_")) && (cur->ns == ns)) 
			s->reserve_page[1] = atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) );
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"reserve_page_count_0_")) && (cur->ns == ns))
			s->reserve_page_count[0] = atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) );
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"reserve_page_count_1_")) && (cur->ns == ns))
			s->reserve_page_count[1] = atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) );
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"corridor_count_0__0_")) && (cur->ns == ns)) 
			s->corridor_count[0][0] = atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) );
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"corridor_count_0__1_")) && (cur->ns == ns))
			s->corridor_count[0][1] = atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) );
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"corridor_count_1__0_")) && (cur->ns == ns))
			s->corridor_count[1][0] = atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) );
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"corridor_count_1__1_")) && (cur->ns == ns))
			s->corridor_count[1][1] = atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) );
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"kick_off_result")) && (cur->ns == ns))
			s->kick_off_result = atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) );
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"kick_off_team")) && (cur->ns == ns)) 
			s->kick_off_team = atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) );
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"first_half_kick_off_team")) && (cur->ns == ns)) 
			s->first_half_kick_off_team = atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) );
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"team_in_placement")) && (cur->ns == ns))
			s->team_in_placement = atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) );
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"half")) && (cur->ns == ns)) 
			s->half = atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) );
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"t0")) && (cur->ns == ns))
			s->t0 = atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) );
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"weather")) && (cur->ns == ns))
			s->weather = atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) );
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"is_a_skull_and_star")) && (cur->ns == ns))
			s->is_a_skull_and_star = (atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0)?false:true;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"throw_team_mate_fumble")) && (cur->ns == ns))
			s->throw_team_mate_fumble = (atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0)?false:true;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"freeze_time")) && (cur->ns == ns))
			s->freeze_time = (atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0)?false:true;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"is_a_dump_off")) && (cur->ns == ns))
			s->is_a_dump_off = (atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0)?false:true;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"is_a_blitz_dump_off")) && (cur->ns == ns))
			s->is_a_blitz_dump_off = (atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0)?false:true;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"need_a_winner")) && (cur->ns == ns))
			s->need_a_winner = (atoi( (char*)  xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) )==0)?false:true;
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"player_save")) && (cur->ns == ns) ){
			s->player_save = s->team[atoi((char*)xmlGetProp(cur, (const xmlChar *) "id"))]->get_player(atoi((char*)xmlGetProp(cur, (const xmlChar *) "number")));
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"selection_save")) && (cur->ns == ns) ){
			s->selection_save = new Square(atoi((char*)xmlGetProp(cur, (const xmlChar *) "x")), atoi((char*)xmlGetProp(cur, (const xmlChar *) "y")));
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"path")) && (cur->ns == ns) ){
			s->path = NULL;
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"ball")) && (cur->ns == ns) ){
			s->ball = new Ball();
			makeBall(doc, ns, cur);	
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"selection")) && (cur->ns == ns) ){
			s->selection = new Square();
			makeSelection(doc, ns, cur);
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"old_selected_player")) && (cur->ns == ns) ){
			s->old_selected_player = new Square();
			makeOldSelectedPlayer(doc, ns, cur);
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"audience")) && (cur->ns == ns) ){
			s->audience = new Public();
			makeAudience(doc, ns, cur);
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"player_to_place")) && (cur->ns == ns) ){
			s->player_to_place = s->team[atoi((char*)xmlGetProp(cur, (const xmlChar *) "id"))]->get_player(atoi((char*)xmlGetProp(cur, (const xmlChar *) "number")));
		}

		if ((!xmlStrcmp(cur->name, (const xmlChar *)"transmit_square")) && (cur->ns == ns) ){
			s->transmit_square = new Square(atoi((char*)xmlGetProp(cur, (const xmlChar *) "x")), atoi((char*)xmlGetProp(cur, (const xmlChar *) "y")));
		}

		if ((!xmlStrcmp(cur->name, (const xmlChar *)"transmit_squares")) && (cur->ns == ns) ){
			s->transmit_squares[atoi((char*)xmlGetProp(cur, (const xmlChar *) "id"))] = new Square(atoi((char*)xmlGetProp(cur, (const xmlChar *) "x")), atoi((char*)xmlGetProp(cur, (const xmlChar *) "y")));
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"push_square")) && (cur->ns == ns) ){
			s->push_square = new Square(atoi((char*)xmlGetProp(cur, (const xmlChar *) "x")), atoi((char*)xmlGetProp(cur, (const xmlChar *) "y")));
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"push_squares")) && (cur->ns == ns) ){
			s->push_squares[atoi((char*)xmlGetProp(cur, (const xmlChar *) "id"))] = new Square(atoi((char*)xmlGetProp(cur, (const xmlChar *) "x")), atoi((char*)xmlGetProp(cur, (const xmlChar *) "y")));
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"indirect_push_square")) && (cur->ns == ns) ){
			s->indirect_push_square = new Square(atoi((char*)xmlGetProp(cur, (const xmlChar *) "x")), atoi((char*)xmlGetProp(cur, (const xmlChar *) "y")));
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"indirect_push_squares")) && (cur->ns == ns) ){
			s->indirect_push_squares[atoi((char*)xmlGetProp(cur, (const xmlChar *) "id"))] = new Square(atoi((char*)xmlGetProp(cur, (const xmlChar *) "x")), atoi((char*)xmlGetProp(cur, (const xmlChar *) "y")));
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"double_indirect_push_square")) && (cur->ns == ns) ){
			s->double_indirect_push_square = new Square(atoi((char*)xmlGetProp(cur, (const xmlChar *) "x")), atoi((char*)xmlGetProp(cur, (const xmlChar *) "y")));
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"double_indirect_push_squares")) && (cur->ns == ns) ){
			s->double_indirect_push_squares[atoi((char*)xmlGetProp(cur, (const xmlChar *) "id"))] = new Square(atoi((char*)xmlGetProp(cur, (const xmlChar *) "x")), atoi((char*)xmlGetProp(cur, (const xmlChar *) "y")));
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"interception_square")) && (cur->ns == ns) ){
			s->interception_square = new Square(atoi((char*)xmlGetProp(cur, (const xmlChar *) "x")), atoi((char*)xmlGetProp(cur, (const xmlChar *) "y")));
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"interception_squares")) && (cur->ns == ns) ){
			s->interception_squares[atoi((char*)xmlGetProp(cur, (const xmlChar *) "id"))] = new Square(atoi((char*)xmlGetProp(cur, (const xmlChar *) "x")), atoi((char*)xmlGetProp(cur, (const xmlChar *) "y")));
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"selected_player")) && (cur->ns == ns) ){
			s->selected_player = s->team[atoi((char*)xmlGetProp(cur, (const xmlChar *) "id"))]->get_player(atoi((char*)xmlGetProp(cur, (const xmlChar *) "number")));
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"location_square")) && (cur->ns == ns) ){
			s->location_square = new Square(atoi((char*)xmlGetProp(cur, (const xmlChar *) "x")), atoi((char*)xmlGetProp(cur, (const xmlChar *) "y")));
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"team_mate")) && (cur->ns == ns) ){
			s->team_mate = s->team[atoi((char*)xmlGetProp(cur, (const xmlChar *) "id"))]->get_player(atoi((char*)xmlGetProp(cur, (const xmlChar *) "number")));
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"target")) && (cur->ns == ns) ){
			s->target = new Square(atoi((char*)xmlGetProp(cur, (const xmlChar *) "x")), atoi((char*)xmlGetProp(cur, (const xmlChar *) "y")));
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"home_team")) && (cur->ns == ns) ){
			s->team[HOME] = new Team(NULL,NULL,NULL, 0,0,0,0,0,0,NULL,0);
			makeTeam(doc, ns, cur, HOME);
		}
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"visitor_team")) && (cur->ns == ns) ){
			s->team[VISITOR] = new Team(NULL,NULL,NULL, 0,0,0,0,0,0,NULL,0);
			makeTeam(doc, ns, cur, VISITOR);
		}

	cur = cur->next;
    }
}


static void makeFormation(xmlDocPtr doc, xmlNsPtr ns, xmlNodePtr cur){
	int id=0,n=0,x=0,y=0;
	while (cur != NULL) {
		id = atoi((char*)xmlGetProp(cur, (const xmlChar *) "id"));
		n = atoi((char*)xmlGetProp(cur, (const xmlChar *) "n"));
		x = atoi((char*)xmlGetProp(cur, (const xmlChar *) "x"));
		y = atoi((char*)xmlGetProp(cur, (const xmlChar *) "y"));
		f[id-1]->add_element(n,x,y);		
		cur = cur->next;
	}	
}


// --------------- xml load formation -------------// 

void xml_load_formation(const char* filename){
	xmlDocPtr doc;
    xmlNsPtr ns;
    xmlNodePtr cur;

	xmlKeepBlanksDefault(0);

    doc = xmlParseFile(filename);
    if (doc == NULL) return;

    cur = xmlDocGetRootElement(doc);
    if (cur == NULL) {
      fprintf(stderr,"empty document\n");
      xmlFreeDoc(doc);
	return;
    }
    ns = NULL;

    if (xmlStrcmp(cur->name, (const xmlChar *) "formations")) {
      fprintf(stderr,"document of the wrong type, root node != formations\n");
      xmlFreeDoc(doc);
      return;
    }
    
    cur = cur->xmlChildrenNode;
    while ( cur && xmlIsBlankNode ( cur ) ){
		cur = cur -> next;
    }
    
	if ( cur == 0 )
      return;
    
	f[0] = new Formation(0);
	f[1] = new Formation(1);
	f[2] = new Formation(2);
	f[3] = new Formation(3);

    makeFormation(doc, ns, cur);

	t->add_formation(f[0]);
	t->add_formation(f[1]);
	t->add_formation(f[2]);
	t->add_formation(f[3]);

	xmlFreeDoc(doc);  
	xmlCleanupParser();
	
}

void xml_load_formation(const char* filename, int id){
	xmlDocPtr doc;
    xmlNsPtr ns;
    xmlNodePtr cur;

	xmlKeepBlanksDefault(0);

    doc = xmlParseFile(filename);
    if (doc == NULL) return;

    cur = xmlDocGetRootElement(doc);
    if (cur == NULL) {
      fprintf(stderr,"empty document\n");
      xmlFreeDoc(doc);
	return;
    }
    ns = NULL;

    if (xmlStrcmp(cur->name, (const xmlChar *) "formations")) {
      fprintf(stderr,"document of the wrong type, root node != formations\n");
      xmlFreeDoc(doc);
      return;
    }
    
    cur = cur->xmlChildrenNode;
    while ( cur && xmlIsBlankNode ( cur ) ){
		cur = cur -> next;
    }
    
	if ( cur == 0 )
      return;
    
	f[0] = new Formation(0);
	f[1] = new Formation(1);
	f[2] = new Formation(2);
	f[3] = new Formation(3);

    makeFormation(doc, ns, cur);

	s->team[id]->add_formation(f[0]);
	s->team[id]->add_formation(f[1]);
	s->team[id]->add_formation(f[2]);
	s->team[id]->add_formation(f[3]);

	xmlFreeDoc(doc);  
	xmlCleanupParser();
	
}


//--------------- xml load team -------------------//

Team* xml_load_team(const char *filename, int id) {
    xmlDocPtr doc;
    xmlNsPtr ns;
    xmlNodePtr cur;

	xmlKeepBlanksDefault(0);

    doc = xmlParseFile(filename);
    if (doc == NULL) return(NULL);

    cur = xmlDocGetRootElement(doc);
    if (cur == NULL) {
      fprintf(stderr,"empty document\n");
      xmlFreeDoc(doc);
	return(NULL);
    }
    ns = NULL;

	t = new Team(NULL,NULL,NULL, 0,0,0,0,0,0,NULL,0);
	t->set_id(id);

    if (xmlStrcmp(cur->name, (const xmlChar *) "team")) {
      fprintf(stderr,"document of the wrong type, root node != team\n");
      xmlFreeDoc(doc);
      return(NULL);
    }
    else {
      t->set_name((char*)xmlGetProp(cur, (const xmlChar *) "name"));
      t->set_race((char*)xmlGetProp(cur, (const xmlChar *) "race"));
      t->set_coach((char*)xmlGetProp(cur, (const xmlChar *) "coach"));
      t->set_emblem((char*)xmlGetProp(cur, (const xmlChar *) "emblem"));
    }

    cur = cur->xmlChildrenNode;
    while ( cur && xmlIsBlankNode ( cur ) )
      {
	cur = cur -> next;
      }
    if ( cur == 0 )
      return ( NULL );
    
    makeTeam(doc, ns, cur);

	char* ff = t->get_formations_file();
	if(ff){
		char tmp[32];
		sprintf(tmp,"%s/%s",FORMATIONS_PATH,ff);
		xml_load_formation(tmp);
	}
	else {
		xml_load_formation(ADD_FORMATIONS_PATH("default.xml"));
	}
	xmlFreeDoc(doc);
	xmlCleanupParser();
	
	return t;
}  

//--------------- xml save team -------------------//

int xml_save_team(Team* t, const char* filename) {
	FILE* fd = fopen(filename,"wtS");
	if(!fd) { 
		fprintf(stderr,"fopen(\"filename\") failed !");
		return -1;
	}

	fprintf(fd,"<?xml version=\"1.0\"?>\n\n");
	print_team(fd,t);
	fclose(fd);
	return 0;
}

//--------------- xml load game -------------------//

State* xml_load_game(const char* filename){
	xmlDocPtr doc;
    xmlNsPtr ns;
    xmlNodePtr cur;

	xmlKeepBlanksDefault(0);

    doc = xmlParseFile(filename);
    if (doc == NULL) return(NULL);

    cur = xmlDocGetRootElement(doc);
    if (cur == NULL) {
      fprintf(stderr,"xml_load_team_summary -> empty document\n");
      xmlFreeDoc(doc);
	return(NULL);
    }
    ns = NULL;

	s = new State();

    if (xmlStrcmp(cur->name, (const xmlChar *) "state")) {
      fprintf(stderr,"xml_load_team_summary -> document of the wrong type, root node != team\n");
      xmlFreeDoc(doc);
      return(NULL);
    }
    
	cur = cur->xmlChildrenNode;
    while ( cur && xmlIsBlankNode ( cur ) )
      {
	cur = cur -> next;
      }
    if ( cur == 0 )
      return ( NULL );
    
    makeState(doc, ns, cur);
    
	char* ff = s->team[HOME]->get_formations_file();
	if(ff){
		char tmp[32];
		sprintf(tmp,"%s/%s",FORMATIONS_PATH,ff);
		xml_load_formation(tmp,HOME);
		free(ff);
	}
	else {
		xml_load_formation(ADD_FORMATIONS_PATH("default.xml"),HOME);
	}
	
	ff = s->team[VISITOR]->get_formations_file();
	if(ff){
		char tmp[32];
		sprintf(tmp,"%s/%s",FORMATIONS_PATH,ff);
		xml_load_formation(tmp,VISITOR);
		free(ff);
	}
	else {
		xml_load_formation(ADD_FORMATIONS_PATH("default.xml"),VISITOR);
	}
	
	xmlFreeDoc(doc);
	xmlCleanupParser();
	
	return s;
}


//--------------- xml save game -------------------//

int xml_save_game(State* state, const char* filename){
	char* xml_file;
	xml_file = (char*) malloc( CHAR_128 );
	sprintf(xml_file, "%s/%s.xml",SAVES_PATH,filename);
	FILE* fd = fopen(xml_file,"wtS");
	if(!fd) { 
		fprintf(stderr,"fopen(\"filename\") failed !");
		return -1;
	}

	fprintf(fd,"<?xml version=\"1.0\"?>\n\n");
	state->save_state(fd,1);
	fclose(fd);
	free(xml_file);
	return 0;
}

team_summary_t* xml_load_team_summary(char* filename){
	
	xmlDocPtr doc;
    xmlNsPtr ns;
    xmlNodePtr cur;

	xmlKeepBlanksDefault(0);

    doc = xmlParseFile(filename);
    if (doc == NULL) return(NULL);

    cur = xmlDocGetRootElement(doc);
    if (cur == NULL) {
      fprintf(stderr,"xml_load_team_summary -> empty document\n");
      xmlFreeDoc(doc);
	return(NULL);
    }
    ns = NULL;

	team_summary_t* team_summary = (team_summary_t*)malloc(sizeof(team_summary_t));
	memset(team_summary,0,sizeof(team_summary_t));

    if (xmlStrcmp(cur->name, (const xmlChar *) "team")) {
      fprintf(stderr,"xml_load_team_summary -> document of the wrong type, root node != team\n");
      xmlFreeDoc(doc);
	  free(team_summary);
      return(NULL);
    }
    else {
	  team_summary->name = (char*)xmlGetProp(cur, (const xmlChar *) "name");
	  team_summary->emblem = (char*)xmlGetProp(cur, (const xmlChar *) "emblem");
	}
	
	team_summary->filename = strdup(filename);

	xmlFreeDoc(doc);
	xmlCleanupParser();
	
    if(team_summary && team_summary->name && team_summary->emblem && team_summary->filename) 
		return team_summary;
	else {
		free(team_summary);
		return NULL;
	}
}

/////////////////////////////////////////////////////////////////////
//////////////////      Load config         //////////////////////////
//////////////////////////////////////////////////////////////////////

//--------------- xml load config -------------------//

config_data_t* xml_load_config(const char* filename){

	xmlDocPtr doc;
    xmlNsPtr ns;
    xmlNodePtr cur;

	xmlKeepBlanksDefault(0);

    doc = xmlParseFile(filename);
    if (doc == NULL) return(NULL);

    cur = xmlDocGetRootElement(doc);
    if (cur == NULL) {
      fprintf(stderr,"xml_load_config -> empty document\n");
      xmlFreeDoc(doc);
	return(NULL);
    }
    ns = NULL;

    if (xmlStrcmp(cur->name, (const xmlChar *) "config")) {
      fprintf(stderr,"xml_load_config -> document of the wrong type, root node != config\n");
      xmlFreeDoc(doc);
      return(NULL);
    }
    
	cur = cur->xmlChildrenNode;
    while ( cur && xmlIsBlankNode ( cur ) )
      {
	cur = cur -> next;
      }
    if ( cur == 0 )
      return ( NULL );
    
	config_data_t* c = (config_data_t*) malloc( sizeof(config_data_t) );
	
	while (cur != NULL) {			
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"screen_w")) && (cur->ns == ns))
			c->screen_w = atoi( (char*) xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) );
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"screen_h")) && (cur->ns == ns))
			c->screen_h = atoi( (char*) xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) );
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"sound_enabled")) && (cur->ns == ns))
			c->sound_enabled = atoi( (char*) xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) );
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"video_enabled")) && (cur->ns == ns))
			c->video_enabled = atoi( (char*) xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) );
		if ((!xmlStrcmp(cur->name, (const xmlChar *)"language")) && (cur->ns == ns))
			c->language = atoi( (char*) xmlNodeListGetString(doc, cur->xmlChildrenNode, 1) );
		cur = cur->next;
	}	
	
	if(c->screen_w<800) c->screen_w = 800;
	else if(c->screen_w>1024) c->screen_w = 1024;
	if(c->screen_h<600) c->screen_h = 600;
	else if(c->screen_h>1054) c->screen_h = 1054;

	c->ok = true;
	xmlFreeDoc(doc);
	xmlCleanupParser();
	return c;
}


int xml_save_config(config_data_t* cd, const char* filename){
	FILE* fd = fopen(filename,"wtS");
	if(!fd) { 
		fprintf(stderr,"fopen(\"filename\") failed !");
		return -1;
	}

	fprintf(fd,"<?xml version=\"1.0\"?>\n\n");
	fprintf(fd,"<config>\n");
	fprintf(fd,"<screen_w>%i</screen_w>\n",cd->screen_w);
	fprintf(fd,"<screen_h>%i</screen_h>\n",cd->screen_h);
	fprintf(fd,"<sound_enabled>%i</sound_enabled>\n",cd->sound_enabled);
	fprintf(fd,"<video_enabled>%i</video_enabled>\n",cd->video_enabled);
	fprintf(fd,"<language>%i</language>\n",cd->language);
	fprintf(fd,"</config>\n");
	fclose(fd);
	return 0;
}

