/* dnaProbe.c was originally generated by the autoSql program, which also 
 * generated dnaProbe.h and dnaProbe.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "dnaProbe.h"


void dnaProbeStaticLoad(char **row, struct dnaProbe *ret)
/* Load a row from dnaProbe table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->name = row[0];
ret->dna = row[1];
ret->size = sqlSigned(row[2]);
ret->chrom = row[3];
ret->start = sqlSigned(row[4]);
ret->end = sqlSigned(row[5]);
strcpy(ret->strand, row[6]);
ret->tpDist = sqlSigned(row[7]);
ret->tm = atof(row[8]);
ret->pGC = atof(row[9]);
ret->affyHeur = sqlSigned(row[10]);
ret->secStruct = atof(row[11]);
ret->blatScore = sqlSigned(row[12]);
ret->comparison = atof(row[13]);
}

struct dnaProbe *dnaProbeLoad(char **row)
/* Load a dnaProbe from row fetched with select * from dnaProbe
 * from database.  Dispose of this with dnaProbeFree(). */
{
struct dnaProbe *ret;

AllocVar(ret);
ret->name = cloneString(row[0]);
ret->dna = cloneString(row[1]);
ret->size = sqlSigned(row[2]);
ret->chrom = cloneString(row[3]);
ret->start = sqlSigned(row[4]);
ret->end = sqlSigned(row[5]);
strcpy(ret->strand, row[6]);
ret->tpDist = sqlSigned(row[7]);
ret->tm = atof(row[8]);
ret->pGC = atof(row[9]);
ret->affyHeur = sqlSigned(row[10]);
ret->secStruct = atof(row[11]);
ret->blatScore = sqlSigned(row[12]);
ret->comparison = atof(row[13]);
return ret;
}

struct dnaProbe *dnaProbeLoadAll(char *fileName) 
/* Load all dnaProbe from a tab-separated file.
 * Dispose of this with dnaProbeFreeList(). */
{
struct dnaProbe *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[14];

while (lineFileRow(lf, row))
    {
    el = dnaProbeLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct dnaProbe *dnaProbeLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all dnaProbe from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with dnaProbeFreeList(). */
{
struct dnaProbe *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = dnaProbeLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void dnaProbeSaveToDb(struct sqlConnection *conn, struct dnaProbe *el, char *tableName, int updateSize)
/* Save dnaProbe as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Note that strings must be escaped to allow insertion into the database.
 * For example "autosql's features include" --> "autosql\'s features include" 
 * If worried about this use dnaProbeSaveToDbEscaped() */
{
struct dyString *update = newDyString(updateSize);
dyStringPrintf(update, "insert into %s values ( '%s','%s',%d,'%s',%d,%d,'%s',%d,%f,%f,%d,%f,%d,%f)", 
	tableName,  el->name,  el->dna,  el->size,  el->chrom,  el->start,  el->end,  el->strand,  el->tpDist,  el->tm,  el->pGC,  el->affyHeur,  el->secStruct,  el->blatScore,  el->comparison);
sqlUpdate(conn, update->string);
freeDyString(&update);
}

void dnaProbeSaveToDbEscaped(struct sqlConnection *conn, struct dnaProbe *el, char *tableName, int updateSize)
/* Save dnaProbe as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size.
 * of a string that would contain the entire query. Automatically 
 * escapes all simple strings (not arrays of string) but may be slower than dnaProbeSaveToDb().
 * For example automatically copies and converts: 
 * "autosql's features include" --> "autosql\'s features include" 
 * before inserting into database. */ 
{
struct dyString *update = newDyString(updateSize);
char  *name, *dna, *chrom, *strand;
name = sqlEscapeString(el->name);
dna = sqlEscapeString(el->dna);
chrom = sqlEscapeString(el->chrom);
strand = sqlEscapeString(el->strand);

dyStringPrintf(update, "insert into %s values ( '%s','%s',%d,'%s',%d,%d,'%s',%d,%f,%f,%d,%f,%d,%f)", 
	tableName,  name,  dna, el->size ,  chrom, el->start , el->end ,  strand, el->tpDist , el->tm , el->pGC , el->affyHeur , el->secStruct , el->blatScore , el->comparison );
sqlUpdate(conn, update->string);
freeDyString(&update);
freez(&name);
freez(&dna);
freez(&chrom);
freez(&strand);
}

struct dnaProbe *dnaProbeCommaIn(char **pS, struct dnaProbe *ret)
/* Create a dnaProbe out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new dnaProbe */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->name = sqlStringComma(&s);
ret->dna = sqlStringComma(&s);
ret->size = sqlSignedComma(&s);
ret->chrom = sqlStringComma(&s);
ret->start = sqlSignedComma(&s);
ret->end = sqlSignedComma(&s);
sqlFixedStringComma(&s, ret->strand, sizeof(ret->strand));
ret->tpDist = sqlSignedComma(&s);
ret->tm = sqlFloatComma(&s);
ret->pGC = sqlFloatComma(&s);
ret->affyHeur = sqlSignedComma(&s);
ret->secStruct = sqlFloatComma(&s);
ret->blatScore = sqlSignedComma(&s);
ret->comparison = sqlFloatComma(&s);
*pS = s;
return ret;
}

void dnaProbeFree(struct dnaProbe **pEl)
/* Free a single dynamically allocated dnaProbe such as created
 * with dnaProbeLoad(). */
{
struct dnaProbe *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freeMem(el->dna);
freeMem(el->chrom);
freez(pEl);
}

void dnaProbeFreeList(struct dnaProbe **pList)
/* Free a list of dynamically allocated dnaProbe's */
{
struct dnaProbe *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    dnaProbeFree(&el);
    }
*pList = NULL;
}

void dnaProbeOutput(struct dnaProbe *el, FILE *f, char sep, char lastSep) 
/* Print out dnaProbe.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->dna);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->size);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->start);
fputc(sep,f);
fprintf(f, "%d", el->end);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->strand);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->tpDist);
fputc(sep,f);
fprintf(f, "%f", el->tm);
fputc(sep,f);
fprintf(f, "%f", el->pGC);
fputc(sep,f);
fprintf(f, "%d", el->affyHeur);
fputc(sep,f);
fprintf(f, "%f", el->secStruct);
fputc(sep,f);
fprintf(f, "%d", el->blatScore);
fputc(sep,f);
fprintf(f, "%f", el->comparison);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

