/* cytoBand.h was originally generated by the autoSql program, which also 
 * generated cytoBand.c and cytoBand.sql.  This header links the database and the RAM 
 * representation of objects. */

#ifndef CYTOBAND_H
#define CYTOBAND_H

struct cytoBand
/* Describes the positions of cytogenetic bands with a chromosome */
    {
    struct cytoBand *next;  /* Next in singly linked list. */
    char *chrom;	/* Human chromosome number */
    unsigned chromStart;	/* Start position in genoSeq */
    unsigned chromEnd;	/* End position in genoSeq */
    char *name;	/* Name of cytogenetic band */
    char *gieStain;	/* Giesma stain results */
    unsigned firmStart;	/* Start position of part we're confident is in band */
    unsigned firmEnd;	/* End position of part we're confident is in band */
    };

void cytoBandStaticLoad(char **row, struct cytoBand *ret);
/* Load a row from cytoBand table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct cytoBand *cytoBandLoad(char **row);
/* Load a cytoBand from row fetched with select * from cytoBand
 * from database.  Dispose of this with cytoBandFree(). */

struct cytoBand *cytoBandCommaIn(char **pS, struct cytoBand *ret);
/* Create a cytoBand out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cytoBand */

void cytoBandFree(struct cytoBand **pEl);
/* Free a single dynamically allocated cytoBand such as created
 * with cytoBandLoad(). */

void cytoBandFreeList(struct cytoBand **pList);
/* Free a list of dynamically allocated cytoBand's */

void cytoBandOutput(struct cytoBand *el, FILE *f, char sep, char lastSep);
/* Print out cytoBand.  Separate fields with sep. Follow last field with lastSep. */

#define cytoBandTabOut(el,f) cytoBandOutput(el,f,'\t','\n');
/* Print out cytoBand as a line in a tab-separated file. */

#define cytoBandCommaOut(el,f) cytoBandOutput(el,f,',',',');
/* Print out cytoBand as a comma separated list including final comma. */

#endif /* CYTOBAND_H */

