/* coloredExon.h was originally generated by the autoSql program, which also 
 * generated coloredExon.c and coloredExon.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef COLOREDEXON_H
#define COLOREDEXON_H

#define COLOREDEXON_NUM_COLS 13

struct coloredExon
/* Colored Exon bed using #FF00DD style RGB strings */
    {
    struct coloredExon *next;  /* Next in singly linked list. */
    char *chrom;	/* Reference sequence chromosome or scaffold */
    unsigned chromStart;	/* Start position in chromosome */
    unsigned chromEnd;	/* End position in chromosome */
    char *name;	/* Name of item */
    unsigned score;	/* Score from 0-1000 */
    char strand[2];	/* + or - */
    unsigned thickStart;	/* Start of where display should be thick (start codon) */
    unsigned thickEnd;	/* End of where display should be thick (stop codon) */
    unsigned reserved;	/* Used as itemRgb as of 2004-11-22 */
    int blockCount;	/* Number of blocks */
    int *blockSizes;	/* Comma separated list of block sizes */
    int *chromStarts;	/* Start positions relative to chromStart */
    char **colors;	/* Color of exon e.g. #F67D23 or #F43 (short for #FF4433) */
    };

struct coloredExon *coloredExonLoad(char **row);
/* Load a coloredExon from row fetched with select * from coloredExon
 * from database.  Dispose of this with coloredExonFree(). */

struct coloredExon *coloredExonLoadAll(char *fileName);
/* Load all coloredExon from whitespace-separated file.
 * Dispose of this with coloredExonFreeList(). */

struct coloredExon *coloredExonLoadAllByChar(char *fileName, char chopper);
/* Load all coloredExon from chopper separated file.
 * Dispose of this with coloredExonFreeList(). */

#define coloredExonLoadAllByTab(a) coloredExonLoadAllByChar(a, '\t');
/* Load all coloredExon from tab separated file.
 * Dispose of this with coloredExonFreeList(). */

struct coloredExon *coloredExonCommaIn(char **pS, struct coloredExon *ret);
/* Create a coloredExon out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new coloredExon */

void coloredExonFree(struct coloredExon **pEl);
/* Free a single dynamically allocated coloredExon such as created
 * with coloredExonLoad(). */

void coloredExonFreeList(struct coloredExon **pList);
/* Free a list of dynamically allocated coloredExon's */

void coloredExonOutput(struct coloredExon *el, FILE *f, char sep, char lastSep);
/* Print out coloredExon.  Separate fields with sep. Follow last field with lastSep. */

#define coloredExonTabOut(el,f) coloredExonOutput(el,f,'\t','\n');
/* Print out coloredExon as a line in a tab-separated file. */

#define coloredExonCommaOut(el,f) coloredExonOutput(el,f,',',',');
/* Print out coloredExon as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* COLOREDEXON_H */

