//
//  AlertPaneler.h
//  BwanaDik
//
//  Created by John Schilling on 11/28/04.
//  Copyright 2004 John Schilling. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "BwanaHeaders.h"

@interface AlertPanelUp : NSWindowController {

        BOOL                        _alertOpen;

        IBOutlet NSImageView        *_alertPanelImageView;
        IBOutlet NSTextField        *_alertPanelExternalIPField;
        IBOutlet NSTextField        *_alertPanelLocalIPField;
        
        NSTimer                     *_closeTimer;
        NSTimer                     *_animeTimer;
        
        BOOL                        _animeSwitch;
        
        NSMutableString             *_lastAppPath;
}

- (void)runAlertPanelWithWANAddress:(NSString *)WANAddress 
                         LANAddress:(NSString *)LANAddress 
                             status:(BDConnectionState)status 
                          autoClose:(BOOL)autoClose;
- (void)killAlert;

- (void)startCloseTimer;
- (void)stopCloseTimer;
- (void)closeTimerFired:(NSTimer *)timer;

- (void)startAnimeTimer;
- (void)stopAnimeTimer;
- (void)animeTimerFired:(NSTimer *)timer;

- (void)setLastApplicationPath;
- (void)returnFocusToLastApplication;

@end
