//
//  LANController.h
//  BwanaDik
//
//  Created by John Schilling on 9/8/06.
//  Copyright 2006 John Schilling. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "BwanaHeaders.h"

@interface LANController : NSObject
{
    IBOutlet id      _delegate;
    
    NSMutableString  *_currentAddress;
    NSMutableString  *_previousAddress;
    
    NSMutableArray   *_interfaceAddresses;
    int              _wiredCount;
}

- (void)setDelegate:(id)delegate;

- (int)numWiredInterfaces;
- (NSString *)currentLANAddress;
- (NSString *)previousLANAddress;
- (NSString *)interfaceAddressForIndex:(int)index;

- (NSArray *)ExecuteShellScript: (NSString *)script;
- (int)getWiredInterfaceCount;
- (void)getCurrentLANAddresses;
- (NSString *)currentLANAddressForInterface:(int)interface;
- (void)checkLANaddressChanged;

@end

@interface NSObject (LANControllerDelegate)
- (void)LANCheckFinished;
- (void)LANAddressChangedFrom:(NSString *)previousAddress to:(NSString *)currentAddress;
@end
