/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.archive;

import java.io.IOException;
import org.basex.io.in.BufferInput;
import org.basex.io.out.ArrayOutput;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.archive.ArchiveFn;
import org.basex.query.func.archive.ArchiveIn;
import org.basex.query.func.archive.ArchiveOut;
import org.basex.query.func.archive.GZIPIn;
import org.basex.query.iter.Iter;
import org.basex.query.value.item.B64;
import org.basex.query.value.item.Bin;
import org.basex.query.value.item.Item;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.hash.TokenSet;

public final class ArchiveDelete
extends ArchiveFn {
    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        Item item;
        Bin archive = this.toArchive(this.arg(0), qc);
        Iter entries = this.arg(1).iter(qc);
        TokenSet names = new TokenSet();
        while ((item = qc.next(entries)) != null) {
            names.add(this.toString(item, qc));
        }
        try (BufferInput bi = archive.input(this.info);){
            ArchiveIn in = ArchiveIn.get(bi, this.info);
            try {
                String format = in.format();
                if (in instanceof GZIPIn) {
                    throw QueryError.ARCHIVE_MODIFY_X.get(this.info, format);
                }
                ArrayOutput ao = new ArrayOutput();
                try (ArchiveOut out = ArchiveOut.get(format, this.info, ao);){
                    while (in.more()) {
                        if (names.contains(Token.token(in.entry().getName()))) continue;
                        out.write(in);
                    }
                }
                B64 b64 = B64.get(ao.finish());
                if (in != null) {
                    in.close();
                }
                return b64;
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            throw QueryError.ARCHIVE_ERROR_X.get(this.info, ex);
        }
    }
}

