/*
 * Decompiled with CFR 0.152.
 */
package net.xqj.basex;

import com.xqj2.XQInsertOptions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.CharBuffer;
import java.util.HashMap;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQItem;
import net.xqj.basex.BaseXClient;
import net.xqj.basex.BaseXXQInsertOptions;
import net.xqj.basex.BasicQueryString;
import net.xqj.basex.Constants;
import net.xqj.basic.BasicConnection;
import net.xqj.basic.BasicItem;
import net.xqj.basic.BasicQuery;
import net.xqj.basic.BasicResultSequence;
import net.xqj.core.Factory;
import net.xqj.core.TextContainer;
import net.xqj.core.XQToolkit;
import net.xqj.core.exception.XQExceptionImpl;
import net.xqj.core.util.ByteBufferOutputStream;
import net.xqj.core.util.Logger;
import net.xqj.core.util.StringWriter;

public class BasicConnectionImpl
implements BasicConnection,
BasicResultSequence,
BasicItem {
    private BaseXClient conn = null;
    private HashMap<String, String> hints = new HashMap();
    private BaseXClient.Query currentQuery = null;
    private TextContainer textContainer = new TextContainer();
    private Logger log = null;
    private boolean readOnly = false;
    private boolean defaultDb = Constants.DEFAULT_DEFAULTDB;
    private StringWriter queryStringWriter = new StringWriter();
    private ByteBufferOutputStream commandResponse = new ByteBufferOutputStream(false, 512);

    @Override
    public void connect() throws XQException {
        block11: {
            String serverName = this.hints.get("serverName");
            String port = this.hints.get("port");
            String user = this.hints.get("user");
            String password = this.hints.get("password");
            if (serverName == null || serverName.trim().isEmpty()) {
                throw new XQExceptionImpl("Must provide a 'serverName' property.", "XQJBX010");
            }
            if (port == null || port.trim().isEmpty()) {
                throw new XQExceptionImpl("Must provide a 'port' property.", "XQJBX011");
            }
            if (user == null || user.trim().isEmpty()) {
                throw new XQExceptionImpl("Must provide a 'user' property.", "XQJBX012");
            }
            if (password == null || password.trim().isEmpty()) {
                throw new XQExceptionImpl("Must provide a 'password' property.", "XQJBX013");
            }
            try {
                this.conn = new BaseXClient(serverName, Integer.parseInt(port), user, password);
                String databaseName = this.hints.get("databaseName");
                if (databaseName == null || databaseName.trim().isEmpty()) break block11;
                try {
                    this.conn.execute("OPEN " + databaseName);
                    this.conn.execute("SET DEFAULTDB " + this.defaultDb);
                }
                catch (IOException e) {
                    try {
                        this.conn.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw new XQExceptionImpl(e.getMessage(), "XQJBX016");
                }
            }
            catch (NumberFormatException e) {
                throw new XQExceptionImpl("port property must be an integer between 1-65535, perhaps 1984?", "XQJBX014", e);
            }
            catch (IOException e) {
                throw new XQExceptionImpl(e.getMessage(), "XQJNC001", e);
            }
        }
    }

    @Override
    public BasicResultSequence executeQuery(BasicQuery query) throws XQException {
        String XQuery = query.toString();
        try {
            if (this.currentQuery != null) {
                this.currentQuery.close();
                this.currentQuery = null;
            }
            this.currentQuery = this.conn.query(XQuery, this.isReadOnly());
            return this;
        }
        catch (IOException e) {
            throw new XQExceptionImpl(e.getMessage(), "XQJBX005", e);
        }
    }

    @Override
    public BasicQuery createQuery() throws XQException {
        return new BasicQueryString(this.queryStringWriter);
    }

    @Override
    public void executeCommand(BasicQuery query) throws XQException {
        if (this.isReadOnly()) {
            throw new XQExceptionImpl("Can not execute a command whilst in read-only mode.", "XQJBX015");
        }
        this.commandResponse.reset();
        try {
            String actualCommand = query.toString();
            this.conn.execute(actualCommand, this.commandResponse);
            if (this.commandResponse.size() == 0) {
                return;
            }
            if (this.log.isInfoLoggable()) {
                this.log.log(3, actualCommand + ":\n" + BaseXClient.UTF8.decode(this.commandResponse.toByteBuffer()).toString());
            }
        }
        catch (IOException e) {
            throw new XQExceptionImpl(e.getMessage(), "XQJBX018", e);
        }
    }

    @Override
    public void close() throws XQException {
        try {
            this.conn.close();
        }
        catch (IOException e) {
            throw new XQExceptionImpl(e.getMessage(), "XQJBX001", e);
        }
    }

    @Override
    public void hint(String name, String value) throws XQException {
        if ("readOnly".equals(name)) {
            this.setReadOnly(XQToolkit.getBooleanFromString(value, this.isReadOnly()));
        } else if ("defaultDb".equals(name)) {
            this.defaultDb = XQToolkit.getBooleanFromString(value, Constants.DEFAULT_DEFAULTDB);
        } else {
            this.hints.put(name, value);
        }
    }

    @Override
    public void insert(String uri, XQItem item, XQInsertOptions options) throws XQException {
        block11: {
            int insertStrategy;
            this.isClosedCheck();
            if (this.readOnly) {
                throw new XQExceptionImpl("Can not insert data whist in read-only mode.", "XQJBX019", null);
            }
            if (this.hints.get("databaseName") == null) {
                throw new XQExceptionImpl("No 'databaseName' property specified.\nProvide this at the XQDataSource level prior to creating an XQConnection.", "XQJBX017");
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            item.writeItem((OutputStream)buffer, null);
            if (options == null) {
                insertStrategy = this.isXQItemTypeABinary(item) ? 3 : 1;
            } else if (options instanceof BaseXXQInsertOptions) {
                insertStrategy = ((BaseXXQInsertOptions)options).getInsertStrategy();
            } else {
                throw new IllegalArgumentException("XQInsertOptions argument should be a subclass of BaseXXQInsertOptions.");
            }
            try {
                if (insertStrategy == 2) {
                    this.conn.add(uri, new ByteArrayInputStream(buffer.toByteArray()));
                    break block11;
                }
                if (insertStrategy == 1) {
                    this.conn.replace(uri, new ByteArrayInputStream(buffer.toByteArray()));
                    break block11;
                }
                if (insertStrategy == 3) {
                    this.conn.store(uri, new ByteArrayInputStream(buffer.toByteArray()));
                    break block11;
                }
                throw new XQExceptionImpl("invalid insert strategy", "XQJBX010");
            }
            catch (IOException e) {
                throw new XQExceptionImpl(e.getMessage(), "XQJBX002", e);
            }
        }
    }

    @Override
    public void commit() throws XQException {
    }

    @Override
    public void rollback() throws XQException {
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws XQException {
    }

    @Override
    public void setReadOnly(boolean readOnly) throws XQException {
        if (readOnly != this.readOnly) {
            this.readOnly = readOnly;
            this.hints.put("readOnly", String.valueOf(readOnly));
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    private void isClosedCheck() throws XQException {
        if (this.conn == null) {
            throw new XQExceptionImpl("BaseX Connection not yet initialized.", "XQJBX004");
        }
        if (this.conn.isClosed()) {
            throw new XQExceptionImpl("BaseX Connection is closed.", "XQJBX003");
        }
    }

    @Override
    public boolean nextItem() throws XQException {
        if (this.hasNext()) {
            this.next();
            return true;
        }
        return false;
    }

    @Override
    public BasicItem getItem() {
        return this;
    }

    public boolean hasNext() {
        try {
            return this.currentQuery.more();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public BasicItem next() throws XQException {
        if (!this.hasNext()) {
            throw new XQExceptionImpl("There are no more items in the sequence.", "XQJBX009");
        }
        try {
            this.textContainer.setLength(0);
            this.textContainer.append(this.currentQuery.next().toCharArray());
            return this;
        }
        catch (IOException e) {
            throw new XQExceptionImpl(e.getMessage(), "XQJBX006", e);
        }
    }

    @Override
    public int getItemKind() throws XQException {
        return BasicConnectionImpl.getItemKind(this.currentQuery.xdmType());
    }

    @Override
    public int getItemType() throws XQException {
        return BasicConnectionImpl.getItemType(this.currentQuery.xdmType());
    }

    @Override
    public boolean hasURL() throws XQException {
        return this.currentQuery.uri() != "";
    }

    @Override
    public String getURL() throws XQException {
        return this.currentQuery.uri();
    }

    public TextContainer getTextContainer() throws XQException {
        return this.textContainer;
    }

    @Override
    public CharBuffer getCharBuffer() throws XQException {
        return CharBuffer.wrap(this.textContainer.getRawCharArray(), this.textContainer.offset(), this.textContainer.length());
    }

    @Override
    public Reader getReader() throws XQException {
        return new CharArrayReader(this.textContainer.toCharArray());
    }

    @Override
    public char[] toCharArray() throws XQException {
        return this.textContainer.toCharArray();
    }

    @Override
    public InputStream getInputStream() throws XQException {
        ByteArrayOutputStream binOut = new ByteArrayOutputStream();
        Writer writer = Factory.newUTF8Writer(binOut);
        try {
            writer.write(this.textContainer.getRawCharArray(), this.textContainer.offset(), this.textContainer.length());
            writer.flush();
            return new ByteArrayInputStream(binOut.toByteArray());
        }
        catch (IOException e) {
            throw new XQExceptionImpl(e.getMessage(), "XQJBX008", e);
        }
    }

    @Override
    public boolean isStreaming() {
        return false;
    }

    @Override
    public void writeItem(Writer out) throws XQException {
        try {
            out.write(this.textContainer.getRawCharArray(), this.textContainer.offset(), this.textContainer.length());
        }
        catch (IOException e) {
            throw new XQExceptionImpl(e.getMessage(), "XQJBX007", e);
        }
    }

    public void setLogger(Logger log) {
        this.log = log;
    }

    public static final int getItemKind(int BaseXtype) {
        return BaseXtype < 32 ? Constants.BASEX_2_XQJITEMKIND[BaseXtype] : 1;
    }

    public static final int getItemType(int BaseXtype) {
        return BaseXtype >= 32 || BaseXtype <= 15 && BaseXtype >= 10 ? Constants.BASEX_2_XQJITEMTYPE[BaseXtype] : 1;
    }

    private boolean isXQItemTypeABinary(XQItem item) throws XQException {
        int atomicType = item.getItemType().getBaseType();
        return atomicType == 26 || atomicType == 9;
    }
}

