/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.node;

import java.io.IOException;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import org.basex.api.dom.BXNode;
import org.basex.core.MainOptions;
import org.basex.data.Data;
import org.basex.data.DataText;
import org.basex.data.MemData;
import org.basex.io.out.ArrayOutput;
import org.basex.io.out.DataOutput;
import org.basex.io.serial.Serializer;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.iter.BasicNodeIter;
import org.basex.query.iter.NodeIter;
import org.basex.query.util.DataBuilder;
import org.basex.query.util.DeepEqual;
import org.basex.query.util.DeepEqualOptions;
import org.basex.query.util.collation.Collation;
import org.basex.query.util.list.ANodeList;
import org.basex.query.value.item.Atm;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.item.Uri;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.node.FNode;
import org.basex.query.value.node.FTxt;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Type;
import org.basex.util.Atts;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public abstract class ANode
extends Item {
    static final QNm XML_BASE = new QNm(QueryText.BASE, QueryText.XML_URI);
    private static final NodeType[] TYPES = new NodeType[]{NodeType.DOCUMENT_NODE, NodeType.ELEMENT, NodeType.TEXT, NodeType.ATTRIBUTE, NodeType.COMMENT, NodeType.PROCESSING_INSTRUCTION};
    private static final AtomicInteger ID = new AtomicInteger();
    public final int id = ID.incrementAndGet();

    ANode(NodeType type) {
        super(type);
    }

    @Override
    public final void write(DataOutput out) throws IOException {
        ArrayOutput ao = new ArrayOutput();
        Serializer.get(ao).serialize(this);
        out.writeToken(ao.finish());
    }

    @Override
    public boolean test(QueryContext qc, InputInfo ii, long pos) {
        return true;
    }

    @Override
    public final boolean bool(InputInfo ii) {
        return true;
    }

    @Override
    public final byte[] string(InputInfo ii) {
        return this.string();
    }

    public abstract byte[] string();

    @Override
    public final Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        Item expr = this;
        if (mode == CompileContext.Simplify.STRING) {
            expr = Str.get(this.string());
        } else if (mode.oneOf(CompileContext.Simplify.DATA, CompileContext.Simplify.NUMBER)) {
            expr = Atm.get(this.string());
        }
        return cc.simplify(this, expr, mode);
    }

    @Override
    public final boolean comparable(Item item) {
        return item.type.isStringOrUntyped();
    }

    @Override
    public final int compare(Item item, Collation coll, boolean transitive, InputInfo ii) throws QueryException {
        return item.type.isStringOrUntyped() ? Token.compare(this.string(), item.string(ii), Collation.get(coll, ii)) : -item.compare(this, coll, transitive, ii);
    }

    @Override
    public final boolean deepEqual(Item item, DeepEqual deep) throws QueryException {
        Type type1 = this.type;
        Type type2 = item.type;
        if (type1 != type2) {
            return false;
        }
        ANode node1 = this;
        ANode node2 = (ANode)item;
        if (node1.is(node2)) {
            return true;
        }
        QNm name1 = node1.qname();
        QNm name2 = node2.qname();
        if (type1 == NodeType.NAMESPACE_NODE) {
            return name1.eq(name2) && Token.eq(node1.string(), node2.string());
        }
        DeepEqualOptions options = deep.options;
        if (name1 != null && (!name1.eq(name2) || options.get(DeepEqualOptions.NAMESPACE_PREFIXES).booleanValue() && !Token.eq(name1.prefix(), name2.prefix()))) {
            return false;
        }
        if (type1.oneOf(NodeType.TEXT, NodeType.COMMENT, NodeType.PROCESSING_INSTRUCTION, NodeType.ATTRIBUTE) && !Token.eq(node1.string(), node2.string(), deep)) {
            return false;
        }
        if (options.get(DeepEqualOptions.BASE_URI).booleanValue()) {
            Uri uri2;
            if (deep.nested) {
                return Token.eq(node1.baseURI(), node2.baseURI());
            }
            Uri uri1 = node1.baseURI(Uri.EMPTY, true, deep.info);
            if (!uri1.eq(uri2 = node2.baseURI(Uri.EMPTY, true, deep.info))) {
                return false;
            }
        }
        if (type1 == NodeType.ELEMENT) {
            ANode attr1;
            BasicNodeIter iter1 = node1.attributeIter();
            BasicNodeIter iter2 = node2.attributeIter();
            if (iter1.size() != iter2.size()) {
                return false;
            }
            while ((attr1 = iter1.next()) != null) {
                ANode attr2;
                name1 = attr1.qname();
                do {
                    if ((attr2 = iter2.next()) != null) continue;
                    return false;
                } while (!name1.eq(name2 = attr2.qname()));
                Bln eq = deep.itemsEqual(attr1, attr2);
                if (eq != Bln.TRUE && (eq != null || options.get(DeepEqualOptions.NAMESPACE_PREFIXES).booleanValue() && !Token.eq(name1.prefix(), name2.prefix()) || !Token.eq(attr1.string(), attr2.string(), deep))) {
                    return false;
                }
                iter2 = node2.attributeIter();
            }
            if (options.get(DeepEqualOptions.IN_SCOPE_NAMESPACES).booleanValue()) {
                Atts atts2;
                Atts atts1 = deep.nested ? node1.namespaces() : node1.nsScope(null);
                Atts atts = atts2 = deep.nested ? node2.namespaces() : node2.nsScope(null);
                if (!atts1.equals(atts2)) {
                    return false;
                }
            }
        } else if (type1 != NodeType.DOCUMENT_NODE) {
            return true;
        }
        Function<ANode, ANodeList> children = node -> {
            ANodeList nl = new ANodeList();
            for (ANode child : node.childIter()) {
                Type tp;
                if (deep.qc != null) {
                    deep.qc.checkStop();
                }
                if ((tp = child.type) == NodeType.PROCESSING_INSTRUCTION && !options.get(DeepEqualOptions.PROCESSING_INSTRUCTIONS).booleanValue() || tp == NodeType.COMMENT && !options.get(DeepEqualOptions.COMMENTS).booleanValue()) continue;
                nl.add(tp != NodeType.TEXT || nl.isEmpty() || ((ANode)nl.peek()).type != NodeType.TEXT ? child.finish() : new FTxt(Token.concat(((ANode)nl.pop()).string(), child.string())));
            }
            if (options.get(DeepEqualOptions.WHITESPACE) != DeepEqualOptions.Whitespace.PRESERVE && !this.preserve()) {
                for (int n = nl.size() - 1; n >= 0; --n) {
                    ANode child;
                    child = (ANode)nl.get(n);
                    if (child.type != NodeType.TEXT || !Token.ws(child.string())) continue;
                    nl.remove(n);
                }
            }
            return nl;
        };
        ANodeList list1 = children.apply(node1);
        ANodeList list2 = children.apply(node2);
        int size1 = list1.size();
        if (size1 != list2.size()) {
            return false;
        }
        deep.nested = true;
        if (name1 == null || !options.unordered(name1)) {
            ANode child1;
            BasicNodeIter iter1 = list1.iter();
            BasicNodeIter iter2 = list2.iter();
            do {
                if (deep.qc != null) {
                    deep.qc.checkStop();
                }
                if ((child1 = ((NodeIter)iter1).next()) != null) continue;
                return true;
            } while (deep.equal(child1, ((NodeIter)iter2).next()));
            return false;
        }
        for (int l1 = size1 - 1; l1 >= 0; --l1) {
            boolean found = false;
            for (int l2 = list2.size() - 1; !found && l2 >= 0; --l2) {
                if (deep.qc != null) {
                    deep.qc.checkStop();
                }
                if (!deep.equal((Item)list1.get(l1), (Item)list2.get(l2))) continue;
                list2.remove(l2);
                found = true;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private boolean preserve() {
        QNm xs = new QNm(DataText.XML_SPACE, QueryText.XML_URI);
        for (ANode node = this; node != null; node = node.parent()) {
            byte[] v;
            if (node.type != NodeType.ELEMENT || (v = node.attribute(xs)) == null) continue;
            return Token.eq(v, DataText.PRESERVE);
        }
        return false;
    }

    @Override
    public final Item atomValue(QueryContext qc, InputInfo ii) {
        return this.atomItem(qc, ii);
    }

    @Override
    public final Item atomItem(QueryContext qc, InputInfo ii) {
        return this.type.oneOf(NodeType.PROCESSING_INSTRUCTION, NodeType.COMMENT) ? Str.get(this.string()) : Atm.get(this.string());
    }

    @Override
    public abstract ANode materialize(Predicate<Data> var1, InputInfo var2, QueryContext var3) throws QueryException;

    @Override
    public final boolean materialized(Predicate<Data> test, InputInfo ii) {
        return test.test(this.data());
    }

    public final DBNode copy(QueryContext qc) throws QueryException {
        return this.copy(qc.context.options, qc);
    }

    public final DBNode copy(MainOptions options, QueryContext qc) throws QueryException {
        MemData data = new MemData(options);
        new DataBuilder(data, qc).build(this);
        return new DBNode(data);
    }

    public abstract ANode finish();

    public byte[] name() {
        return null;
    }

    public QNm qname() {
        return null;
    }

    public Atts namespaces() {
        return null;
    }

    public final Atts nsScope(StaticContext sc) {
        Atts ns = new Atts();
        for (ANode node = this; node != null; node = node.parent()) {
            Atts nsp = node.namespaces();
            if (nsp == null) continue;
            for (int a = nsp.size() - 1; a >= 0; --a) {
                byte[] name = nsp.name(a);
                if (ns.contains(name)) continue;
                ns.add(name, nsp.value(a));
            }
        }
        if (sc != null) {
            sc.ns.inScope(ns);
        }
        return ns;
    }

    public final byte[] uri(byte[] prefix) {
        Atts ns = this.namespaces();
        if (ns != null) {
            byte[] s = ns.value(prefix);
            if (s != null) {
                return s;
            }
            ANode n = this.parent();
            if (n != null) {
                return n.uri(prefix);
            }
        }
        return (byte[])(prefix.length == 0 ? Token.EMPTY : null);
    }

    public byte[] baseURI() {
        return Token.EMPTY;
    }

    public final Uri baseURI(Uri base, boolean empty, InputInfo info) throws QueryException {
        if (!this.type.oneOf(NodeType.ELEMENT, NodeType.DOCUMENT_NODE) && this.parent() == null) {
            return empty ? Uri.EMPTY : null;
        }
        Uri uri = Uri.EMPTY;
        ANode nd = this;
        do {
            Uri bu;
            if (!(bu = Uri.get(nd.baseURI(), false)).isValid()) {
                throw QueryError.INVURI_X.get(info, new Object[]{nd.baseURI()});
            }
            uri = bu.resolve(uri, info);
            if (nd.type == NodeType.DOCUMENT_NODE && nd instanceof DBNode) break;
            nd = nd.parent();
        } while (!uri.isAbsolute() && nd != null);
        return nd == null || uri == Uri.EMPTY ? base.resolve(uri, info) : uri;
    }

    public abstract boolean is(ANode var1);

    public abstract int compare(ANode var1);

    static int compare(ANode node1, ANode node2) {
        ANodeList nl = new ANodeList();
        for (ANode node = node1; node != null; node = node.parent()) {
            if (node == node2) {
                return 1;
            }
            nl.add(node);
        }
        ANode c2 = node2;
        ANode node = node2;
        block1: while ((node = node.parent()) != null) {
            int is = nl.size();
            for (int i = 1; i < is; ++i) {
                if (node == node1) {
                    return -1;
                }
                if (!((ANode)nl.get(i)).is(node)) continue;
                ANode c1 = (ANode)nl.get(i - 1);
                for (ANode c : node.childIter()) {
                    if (c.is(c1)) {
                        return -1;
                    }
                    if (!c.is(c2)) continue;
                    return 1;
                }
                break block1;
            }
            c2 = node;
        }
        return Integer.signum(node1.id - node2.id);
    }

    public final ANode root() {
        ANode p = this.parent();
        return p == null ? this : p.root();
    }

    public abstract ANode parent();

    public abstract void parent(FNode var1);

    public abstract boolean hasChildren();

    public abstract boolean hasAttributes();

    public final byte[] attribute(QNm name) {
        ANode node;
        BasicNodeIter iter = this.attributeIter();
        do {
            if ((node = iter.next()) != null) continue;
            return null;
        } while (!node.qname().eq(name));
        return node.string();
    }

    public BasicNodeIter ancestorIter(final boolean self) {
        return new BasicNodeIter(){
            private ANode node;
            private boolean slf;
            {
                this.node = ANode.this;
                this.slf = self;
            }

            @Override
            public ANode next() {
                if (this.slf) {
                    this.slf = false;
                } else {
                    this.node = this.node.parent();
                }
                return this.node;
            }
        };
    }

    public abstract BasicNodeIter attributeIter();

    public abstract BasicNodeIter childIter();

    public BasicNodeIter descendantIter(final boolean self) {
        return new BasicNodeIter(){
            private final Stack<BasicNodeIter> iters = new Stack();
            private ANode last;

            @Override
            public ANode next() {
                BasicNodeIter ir = this.last != null ? this.last.childIter() : (self ? ANode.this.selfIter() : ANode.this.childIter());
                this.last = ir.next();
                if (this.last == null) {
                    while (!this.iters.isEmpty()) {
                        this.last = this.iters.peek().next();
                        if (this.last == null) {
                            this.iters.pop();
                            continue;
                        }
                        break;
                    }
                } else {
                    this.iters.add(ir);
                }
                return this.last;
            }
        };
    }

    public BasicNodeIter followingIter(final boolean self) {
        return new BasicNodeIter(){
            private BasicNodeIter iter;

            @Override
            public ANode next() {
                if (this.iter == null) {
                    ANodeList list = new ANodeList();
                    if (self) {
                        list.add(ANode.this.finish());
                    }
                    ANode node = ANode.this;
                    for (ANode root = node.parent(); root != null; root = root.parent()) {
                        BasicNodeIter ir = root.childIter();
                        if (node.type != NodeType.ATTRIBUTE) {
                            for (ANode nd : ir) {
                                if (nd.is(node)) break;
                            }
                        }
                        for (ANode nd : ir) {
                            list.add(nd.finish());
                            ANode.addDescendants(nd.childIter(), list);
                        }
                        node = root;
                    }
                    this.iter = list.iter();
                }
                return this.iter.next();
            }
        };
    }

    public BasicNodeIter followingSiblingIter(final boolean self) {
        final ANode root = this.parent();
        if (root == null || this.type == NodeType.ATTRIBUTE) {
            return self ? this.selfIter() : BasicNodeIter.EMPTY;
        }
        return new BasicNodeIter(){
            private final BasicNodeIter iter;
            private boolean found;
            {
                this.iter = root.childIter();
            }

            @Override
            public ANode next() {
                ANode n;
                while (!this.found && (n = this.iter.next()) != null) {
                    if (!n.is(ANode.this)) continue;
                    this.found = true;
                    if (!self) continue;
                    return n;
                }
                return this.iter.next();
            }
        };
    }

    public final BasicNodeIter parentIter() {
        return new BasicNodeIter(){
            private boolean called;

            @Override
            public ANode next() {
                if (this.called) {
                    return null;
                }
                this.called = true;
                return ANode.this.parent();
            }
        };
    }

    public BasicNodeIter precedingIter(final boolean self) {
        return new BasicNodeIter(){
            private BasicNodeIter iter;

            @Override
            public ANode next() {
                if (this.iter == null) {
                    ANodeList list = new ANodeList();
                    if (self) {
                        list.add(ANode.this.finish());
                    }
                    ANode node = ANode.this;
                    for (ANode root = node.parent(); root != null; root = root.parent()) {
                        if (node.type != NodeType.ATTRIBUTE) {
                            ANodeList tmp = new ANodeList();
                            for (ANode c : root.childIter()) {
                                if (c.is(node)) break;
                                tmp.add(c.finish());
                                ANode.addDescendants(c.childIter(), tmp);
                            }
                            for (int t = tmp.size() - 1; t >= 0; --t) {
                                list.add((ANode)tmp.get(t));
                            }
                        }
                        node = root;
                    }
                    this.iter = list.iter();
                }
                return this.iter.next();
            }
        };
    }

    public final BasicNodeIter precedingSiblingIter(final boolean self) {
        final ANode root = this.parent();
        if (root == null || this.type == NodeType.ATTRIBUTE) {
            return self ? this.selfIter() : BasicNodeIter.EMPTY;
        }
        return new BasicNodeIter(){
            private ANodeList list;
            private int l;

            @Override
            public ANode next() {
                if (this.list == null) {
                    this.list = new ANodeList();
                    for (ANode node : root.childIter()) {
                        boolean last = node.is(ANode.this);
                        if (!last || self) {
                            this.list.add(node.finish());
                        }
                        if (!last) continue;
                        break;
                    }
                    this.l = this.list.size();
                }
                return this.l > 0 ? (ANode)this.list.get(--this.l) : null;
            }
        };
    }

    public final BasicNodeIter selfIter() {
        return new BasicNodeIter(){
            private boolean called;

            @Override
            public ANode next() {
                if (this.called) {
                    return null;
                }
                this.called = true;
                return ANode.this;
            }
        };
    }

    private static void addDescendants(BasicNodeIter children, ANodeList nodes) {
        for (ANode node : children) {
            nodes.add(node.finish());
            ANode.addDescendants(node.childIter(), nodes);
        }
    }

    public int kind() {
        return ANode.kind((NodeType)this.type);
    }

    public static int kind(NodeType type) {
        return switch (type) {
            case NodeType.DOCUMENT_NODE -> 0;
            case NodeType.ELEMENT -> 1;
            case NodeType.TEXT -> 2;
            case NodeType.ATTRIBUTE -> 3;
            case NodeType.COMMENT -> 4;
            case NodeType.PROCESSING_INSTRUCTION -> 5;
            default -> -1;
        };
    }

    public static NodeType type(int k) {
        return TYPES[k];
    }

    @Override
    public abstract BXNode toJava() throws QueryException;
}

