/*
 * Decompiled with CFR 0.152.
 */
package org.basex.build.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.transform.sax.SAXSource;
import org.basex.build.SingleParser;
import org.basex.build.xml.SAXHandler;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.core.jobs.JobException;
import org.basex.io.IO;
import org.basex.io.in.BufferInput;
import org.basex.io.parse.xml.XmlParser;
import org.basex.util.Util;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public final class SAXWrapper
extends SingleParser {
    private long bytes;
    private int lines;
    private SAXHandler saxh;
    private long length;

    public SAXWrapper(IO source, MainOptions options) {
        super(source, options);
    }

    @Override
    public void parse() throws IOException {
        InputSource is = this.inputSource();
        SAXSource saxs = new SAXSource(is);
        try {
            EntityResolver er;
            XMLReader reader = saxs.getXMLReader();
            if (reader == null) {
                reader = XmlParser.reader(this.options);
            }
            if (reader.getEntityResolver() == null && (er = this.options.resolver().entityResolver()) != null) {
                reader.setEntityResolver(er);
            }
            this.saxh = new SAXHandler(this.builder, this.options.get(MainOptions.STRIPWS), this.options.get(MainOptions.STRIPNS));
            reader.setDTDHandler(this.saxh);
            reader.setContentHandler(this.saxh);
            reader.setProperty("http://xml.org/sax/properties/lexical-handler", this.saxh);
            reader.setErrorHandler(this.saxh);
            reader.parse(is);
        }
        catch (SAXHandler.ValidationException | SAXParseException ex) {
            SAXParseException spex = (SAXParseException)(ex instanceof SAXHandler.ValidationException ? ex.getCause() : ex);
            String msg = Util.info(Text.SCANPOS_X_X, this.source.path(), spex.getLineNumber(), spex.getColumnNumber()) + ": " + Util.message(spex);
            throw new IOException(msg, ex);
        }
        catch (JobException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String msg = ex.getCause() != null ? ex.getCause().getMessage() : Util.message(ex);
            throw new IOException(this.source.path() + ": " + msg, ex);
        }
        finally {
            InputStream ist;
            Reader r = is.getCharacterStream();
            if (r != null) {
                r.close();
            }
            if ((ist = is.getByteStream()) != null) {
                ist.close();
            }
        }
    }

    private InputSource inputSource() throws IOException {
        final InputStream input = this.source.inputStream();
        this.length = this.source.length();
        try {
            if (this.length <= 0L) {
                this.length = input.available();
            }
        }
        catch (IOException ex) {
            input.close();
            throw ex;
        }
        InputStream wrapped = new InputStream(){
            final InputStream buffer;
            {
                this.buffer = input instanceof ByteArrayInputStream ? input : BufferInput.get(input);
            }

            @Override
            public int read() throws IOException {
                int i = this.buffer.read();
                if (i == 10) {
                    ++SAXWrapper.this.lines;
                }
                ++SAXWrapper.this.bytes;
                return i;
            }

            @Override
            public void close() throws IOException {
                this.buffer.close();
            }
        };
        InputSource is = new InputSource(wrapped);
        is.setEncoding(this.source.encoding());
        is.setSystemId(this.source.url());
        return is;
    }

    @Override
    public String detailedInfo() {
        return this.length == 0L ? super.detailedInfo() : Util.info(Text.SCANPOS_X_X, this.source.name(), this.lines + 1);
    }

    @Override
    public double progressInfo() {
        return this.length == 0L ? (this.saxh == null ? 0.0 : (double)this.saxh.nodes / 3000000.0 % 1.0) : (double)this.bytes / (double)this.length;
    }
}

