/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.io.IOException;
import java.math.BigDecimal;
import org.basex.io.out.DataOutput;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.util.collation.Collation;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class Bln
extends Item {
    public static final Bln TRUE = new Bln(true);
    public static final Bln FALSE = new Bln(false);
    private final boolean value;
    private double score;

    private Bln(boolean value) {
        super(AtomType.BOOLEAN);
        this.value = value;
    }

    private Bln(double score) {
        this(true);
        this.score = score;
    }

    public static Bln get(double score) {
        return score != 0.0 ? new Bln(score) : FALSE;
    }

    public static Bln get(boolean value) {
        return value ? TRUE : FALSE;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeBool(this.value);
    }

    @Override
    public byte[] string(InputInfo ii) {
        return Token.token(this.value);
    }

    public int hashCode() {
        return Boolean.hashCode(this.value);
    }

    @Override
    public boolean bool(InputInfo ii) {
        return this.value;
    }

    @Override
    public long itr(InputInfo ii) {
        return this.value ? 1L : 0L;
    }

    @Override
    public float flt(InputInfo ii) {
        return this.value ? 1.0f : 0.0f;
    }

    @Override
    public double dbl(InputInfo ii) {
        return this.value ? 1.0 : 0.0;
    }

    @Override
    public BigDecimal dec(InputInfo ii) {
        return this.value ? BigDecimal.ONE : BigDecimal.ZERO;
    }

    @Override
    public int compare(Item item, Collation coll, boolean transitive, InputInfo ii) throws QueryException {
        boolean b;
        boolean bl = b = item.type == AtomType.BOOLEAN ? item.bool(ii) : Bln.parse(item, ii);
        return this.value == b ? 0 : (b ? -1 : 1);
    }

    @Override
    public double score() {
        return this.score;
    }

    @Override
    public Boolean toJava() {
        return this.value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof Bln)) return false;
        Bln bln = (Bln)obj;
        if (this.value != bln.value) return false;
        return true;
    }

    @Override
    public void toString(QueryString qs) {
        qs.token(this.value ? Token.TRUE : Token.FALSE).paren("");
    }

    public static boolean parse(Item item, InputInfo info) throws QueryException {
        Boolean b = Bln.parse(item.string(info));
        if (b != null) {
            return b;
        }
        throw AtomType.BOOLEAN.castError(item, info);
    }

    public static Boolean parse(byte[] value) {
        byte[] v = Token.trim(value);
        if (Token.eq(v, Token.TRUE) || Token.eq(v, Token.cpToken(49))) {
            return Boolean.TRUE;
        }
        if (Token.eq(v, Token.FALSE) || Token.eq(v, Token.cpToken(48))) {
            return Boolean.FALSE;
        }
        return null;
    }
}

