/*
 * Decompiled with CFR 0.152.
 */
package use.newer.java;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class Util {
    public static final String TARGET_CLASS_ATTRIBUTE_NAME = "Main-Class-After-UseNewerJava-Check";

    public static void checkJavaVersionAndExecuteMainProgram(int n, String[] stringArray) {
        Util.checkJavaVersionIsNewEnough(n);
        Util.executeMainProgram(stringArray);
    }

    private static void executeMainProgram(String[] stringArray) {
        String string = Util.readTargetClassNameFromManifest();
        if (string == null) {
            System.err.println("\n\nCouldn't find the target main class to run after checking the Java version.\n\nThe attribute should be in the Jar manifest and called Main-Class-After-UseNewerJava-Check");
            System.exit(-1);
        } else {
            Util.invokeMainMethod(stringArray, string);
        }
    }

    private static void checkJavaVersionIsNewEnough(int n) {
        String string = Util.specVersion();
        if (string == null) {
            Util.dieAndAskFor(n, "Looks like your version of Java is too old to run this program.");
        } else {
            int n2 = Util.majorJavaVersionFrom(string);
            if (n2 < n) {
                Util.dieAndAskFor(n, "Looks like your version of Java (" + string + ") is too old to run this program.");
            }
        }
    }

    private static void dieAndAskFor(int n, String string) {
        System.err.println("\n\n" + string + "\n\nYou'll need to get Java " + n + " or later.");
        System.exit(-1);
    }

    private static String readTargetClassNameFromManifest() {
        try {
            Enumeration<URL> enumeration = Util.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (enumeration.hasMoreElements()) {
                Attributes attributes = new Manifest(enumeration.nextElement().openStream()).getMainAttributes();
                String string = attributes.getValue(TARGET_CLASS_ATTRIBUTE_NAME);
                if (string == null) continue;
                return string;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    static int majorJavaVersionFrom(String string) {
        String[] stringArray = string.split("\\.");
        if (stringArray.length > 1 && stringArray[0].equals("1")) {
            return Integer.parseInt(stringArray[1]);
        }
        try {
            return Integer.parseInt(stringArray[0]);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    static String specVersion() {
        return System.getProperty("java.specification.version");
    }

    static void invokeMainMethod(String[] stringArray, String string) {
        try {
            Method method = Class.forName(string).getMethod("main", String[].class);
            method.invoke(null, new Object[]{stringArray});
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }
}

