/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the reusable ccl java library
 * (http://www.kclee.com/clemens/java/ccl/).
 *
 * The Initial Developer of the Original Code is
 * Chr. Clemens Lee.
 * Portions created by Chr. Clemens Lee are Copyright (C) 2002
 * Chr. Clemens Lee. All Rights Reserved.
 *
 * Contributor(s): Chr. Clemens Lee <clemens@kclee.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package ccl;

import ccl.test.MainTest;
import ccl.util.Exitable;
import ccl.util.Init;
import ccl.util.Test;
import java.util.Hashtable;

/**
 * This class does nothing else except offering a static main
 * routine and therefore one fix starting point for the whole
 * ccl library. Not that a library needs an executable, but
 * this one right now just triggers some self tests. In the
 * future this command can be also used to request the version 
 * number of the library and similar stuff.
 *
 * @version  $Id: Main.java,v 32.69 2003/11/23 09:13:43 clemens Exp clemens $
 * @author <a href="http://www.kclee.com/clemens/">
 *         Chr. Clemens Lee</a>
 *         &lt;<a href="mailto:clemens@kclee.com">
 *         clemens@kclee.com
 *         </a>>
 */
public class Main implements Exitable 
{
    private static final String S_INI_FILE_CONTENT = 
        "[Init]\n"
        + "Author=Chr. Clemens Lee\n"
        + "\n"
        + "[Help]\n"
        + "HelpUsage=\n"
        + "Options=check\n"
        + "check=b,o,Trigger self tests for the ccl java library.\n";

    private boolean _bExit = false;

    /**
     * The static main routine creates this object which
     * then triggers on demand the self tests.
     */
    public Main( String[] asArg_, String sRcsHeader_ )
    {
        super();

        Init pInit = new Init( this, 
                               asArg_,
                               sRcsHeader_,
                               S_INI_FILE_CONTENT );
        if ( _bExit ) 
        {
            return;
        }
        
        Hashtable htOptions = pInit.getOptions();
        if ( htOptions.get( "check" ) != null ) 
        {
            MainTest pTest = new MainTest();
            pTest.setInit( pInit );
            pTest.setVerbose( true );
            pTest.setTiming( true );
            pTest.run();
            Test.printResult( pTest );
        }
        else 
        {
            // if nothing was selected then print at least help message
            pInit.printHelpMessage();
        }
    }

    /**
     * Ccl is a library. You execute this application only to
     * trigger some self tests or to get the library version
     * number.
     */
    public static void main( String[] asArg_ ) 
    {
        new Main( asArg_
                  , "$Header: /home/clemens/src/java/ccl/src/ccl/RCS/Main.java,v 32.69 2003/11/23 09:13:43 clemens Exp clemens $" );
        
        System.exit(0);
    }

    /**
     * Implements ccl.util.Exitable interface.
     */
    public void setExit() 
    {
        _bExit = true;
    }
}
