/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the reusable ccl java library
 * (http://www.kclee.com/clemens/java/ccl/).
 *
 * The Initial Developer of the Original Code is
 * Chr. Clemens Lee.
 * Portions created by Chr. Clemens Lee are Copyright (C) 2002
 * Chr. Clemens Lee. All Rights Reserved.
 *
 * Contributor(s): Chr. Clemens Lee <clemens@kclee.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package ccl.servlet;

import ccl.util.DBUtil;
import ccl.util.Util;
import java.io.BufferedReader;
import java.io.FileReader;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

/**
 * Sax2 parser for xml database input.
 *
 * @author    Chr. Clemens Lee (clemens@kclee.com)
 * @version   $Id: XMLImportHandler.java,v 1.10 2003/11/23 09:13:49 clemens Exp clemens $
 */
public class XMLImportHandler extends DefaultHandler 
{
    /**
     * XML Parser used.
     */
    static private final String S_PARSER = "org.apache.crimson.parser.XMLReaderImpl";

    /**
     * Tag name of column.
     */
    static final String S_TAG_COLUMN = "column";

    /**
     * Tag name of columns.
     */
    static final String S_TAG_COLUMNS = "columns";

    /**
     * Tag name of database.
     */
    static final String S_TAG_DATABASE = "database";

    /**
     * Tag name of row.
     */
    static final String S_TAG_ROW = "row";

    /**
     * Tag name of rows.
     */
    static final String S_TAG_ROWS = "rows";

    /**
     * Tag name of table.
     */
    static final String S_TAG_TABLE = "table";

    /**
     * Tag name of value.
     */
    static final String S_TAG_VALUE = "value";

    /**
     * StringBuffer used to store the element's CDATA/content in it.
     */
    private StringBuffer _sbCDATA = new StringBuffer();

    private Connection _connection = null;

    /**
     * Creates an instance of this sax handler.
     */
    public XMLImportHandler( Connection connection ) 
    {
        super();

        _connection = connection;
    }

    /**
     * Gets the CDATA from the elements.
     *
     * @param   ac_       an array of chars, representing the CDATA.
     * @param   start_    the start index from ac.
     * @param   length_   the length to copy from ac from start index.
     */
    public void characters( char ac_[], int start_, int length_ ) 
    {
        _sbCDATA.append( ac_, start_, length_ );
    }

    private String _sTableName = null;

    /**
     * Gets invoked from the sax xml parser whenever a new element starts.
     */
    public void startElement( String       namespaceURI_
                              , String     localName_
                              , String     qName_
                              , Attributes atts_         )
    {
        if ( qName_.equals( S_TAG_TABLE ) ) 
        {
            _sTableName = atts_.getValue( "name" );
            
            try 
            {
                DBUtil.deleteTable( _connection, _sTableName );
            }
            catch( SQLException sqlException ) 
            {
                Util.printlnErr( sqlException );
            }
        }
        if ( qName_.equals( S_TAG_COLUMNS ) ) 
        {
            _vColumns = new Vector();
        }
        if ( qName_.equals( S_TAG_ROW ) ) 
        {
            _vValues = new Vector();
        }
        _sbCDATA.setLength( 0 );
    }

    private Vector _vColumns = null;
    private Vector _vValues = null;
    private PreparedStatement _statement = null;
    private String _sStatement = null;
    private Vector _vTypes = null;

    /**
     * Gets invoked from the sax xml parser whenever an element 
     * closes.
     */
    public void endElement( String       namespaceURI_
                            , String     localName_
                            , String     qName_        )
    {
        if ( localName_.equals( S_TAG_COLUMN ) )
        {
            _vColumns.addElement( _sbCDATA.toString() );
        }
        else if ( localName_.equals( S_TAG_COLUMNS ) ) 
        {
            String sInsert = "insert into " 
                   + _sTableName
                   + " (";
            String sQuestionMarks = "";
            Enumeration eColumns = _vColumns.elements();
            while( eColumns.hasMoreElements() ) 
            {
                sInsert += (String)eColumns.nextElement();
                sQuestionMarks += "?";
                if ( eColumns.hasMoreElements() ) 
                {
                    sInsert += ",";
                    sQuestionMarks += ",";
                }
            }
            sInsert +=") values ("
                   + sQuestionMarks
                   + ")";
            Util.debug( this, "endElement(..).Empty insert call: " + sInsert );
            _sStatement = sInsert;
            try
            {
                _statement = _connection.prepareStatement( sInsert );
                Util.debug( this, "endElement(..)._statement: " + _statement );

                // find out types
                DatabaseMetaData meta = _connection.getMetaData();
                Util.debug( this, "endElement(..).table: " + _sTableName );
                ResultSet result = meta.getColumns( null, null, _sTableName.toLowerCase(), null );
                _vTypes = new Vector();
                int column = 0;
                Util.debug( this, "endElement(..).GET_TYPES" );
                while( result.next() )
                {
                    String sXMLColumn = (String)_vColumns.elementAt( column );
                    String sName = result.getString( 4 ); // COLUMN_NAME
                    Util.debug( this, "endElement(..).sName: " + sName );
                    if ( !sXMLColumn.equals( sName ) )
                    {
                        throw new RuntimeException( "Xml column '"
                                                    + sXMLColumn
                                                    + "' in table '"
                                                    + _sTableName
                                                    + "' does not match real column '"
                                                    + sName
                                                    + "' in the database!" );
                    }
                    _vTypes.addElement( result.getString( 6 ) ); // TYPE_NAME
                    column++;
                }
                result.close();
            }
            catch( SQLException sqlException ) 
            {
                Util.printlnErr( sqlException );
            }

        }
        else if ( localName_.equals( S_TAG_DATABASE ) ) 
        {
        } 
        else if ( localName_.equals( S_TAG_ROW ) ) 
        {
            String sStatement = _sStatement + " ";
            try 
            {
                if ( _statement == null )
                {
                    Util.debug( this, "endElement(..)._statement is indeed null!" );
                }
                Enumeration eValues = _vValues.elements();
                Enumeration eTypes  = _vTypes .elements();
                int index = 1;
                while( eValues.hasMoreElements() ) 
                {
                    String sValue = (String)eValues.nextElement();
                    /*if ( sValue.indexOf( "ne Tasche" ) != -1 )
                    {
                        Util.println( sValue );
                        System.exit( 5 );
                        }*/
                    if ( eTypes.hasMoreElements() == false )
                    {
                        throw new RuntimeException( "No more type for value '" + sValue + "' (" + sStatement  + ")" );
                    }
                    String sType  = (String)eTypes .nextElement();
                    Util.debug( this, "endElement(..).type: --->" + sType + "<---" );
                    if ( sType.equals( "int" ) )
                    {
                        _statement.setInt( index, Util.atoi( sValue ) );
                        sStatement += index + ":" + sValue + ", ";
                    } 
                    else if ( sType.equals( "double precis" ) )
                    {
                        _statement.setDouble( index, Util.atod( sValue ) );
                        sStatement += index + ":" + sValue + ", ";
                    }
                    else if ( sType.equals( "numeric" ) )
                    {
                        _statement.setBigDecimal( index, BigDecimal.valueOf( Util.atol( sValue ) ) );
                        sStatement += index + ":" + sValue + ", ";
                    }
                    else 
                    {
                        _statement.setString( index, sValue );
                        sStatement += index + ":'" + sValue + "', ";
                    }
                    index++;
                }
                _statement.executeUpdate();
            }
            catch( SQLException sqlException ) 
            {
                Util.printlnErr( sStatement );
                Util.printlnErr( sqlException );
            }
            catch( Exception exception ) 
            {
                Util.printlnErr( exception );
            }

        }
        else if ( localName_.equals( S_TAG_ROWS ) ) 
        {
            /*
            try 
            {
                _statement.close();
            }
            catch( SQLException sqlException ) 
            {
                Util.printlnErr( sqlException );
            }
            */
        }
        else if ( localName_.equals( S_TAG_TABLE ) ) 
        {
        }
        else if ( localName_.equals( S_TAG_VALUE ) ) 
        {
            _vValues.addElement( _sbCDATA.toString() );
        }
    }

    /**
     * This method creates an instance of this parser and pipes the specified
     * file through it.
     *
     * @exception   Exception    if anything goes wrong while parsing.
     */
    static public void parse( Connection connection_, String sFileName_ )
        throws Exception
    {
        if ( Util.isEmpty( System.getProperty( "org.xml.sax.driver" ) ) )
        {
            System.getProperties().put( "org.xml.sax.driver", S_PARSER );
        }
        Util.debug( XMLImportHandler.class, "parse(..).org.xml.sax.driver: " + System.getProperty( "org.xml.sax.driver" ) );
        XMLImportHandler xmlimporthandler = new XMLImportHandler( connection_ );
        XMLReader reader = XMLReaderFactory.createXMLReader();
        reader.setContentHandler( xmlimporthandler );
        reader.setErrorHandler  ( xmlimporthandler );

        InputSource pInputSource = new InputSource( new BufferedReader( new FileReader( sFileName_ ) ) );

        reader.parse( pInputSource );
    }
}
