/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the reusable ccl java library
 * (http://www.kclee.com/clemens/java/ccl/).
 *
 * The Initial Developer of the Original Code is
 * Chr. Clemens Lee.
 * Portions created by Chr. Clemens Lee are Copyright (C) 2002
 * Chr. Clemens Lee. All Rights Reserved.
 *
 * Contributor(s): Chr. Clemens Lee <clemens@kclee.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package ccl.swing;

import java.awt.Color;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.util.*;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;

import ccl.swing.AutoGridBagLayout;
import ccl.swing.SwingUtil;
import ccl.util.*;

public class DoubleListCancelSelector extends ExitJDialog 
{
    public static final String S_TITLE = "Select";
    private static final int MAX_ELEMENTS = 10;
    private DoubleList _pDoubleList = null;
    private OKCancelPanel _pOKCancelPanel = null;

    public DoubleListCancelSelector(Frame frmParent_,
                                    String sMessage_,
                                    Vector vsFirstList_,
                                    Vector vsSecondList_,
                                    boolean bMultiSelect_)
    {
        super(frmParent_, S_TITLE, true);
        
        Util.panicIf(vsFirstList_ == null || vsFirstList_.size() == 0 ||
                     vsSecondList_ == null || vsSecondList_.size() == 0 ||
                     sMessage_ == null);

        ((JPanel)getContentPane()).setBorder
            ( BorderFactory.createEmptyBorder( 5, 5, 5, 5 ) );

        AutoGridBagLayout pAutoGridBagLayout = new AutoGridBagLayout();
        getContentPane().setLayout( pAutoGridBagLayout );

        getContentPane().setBackground( frmParent_.getBackground() );

        // Headline
        JLabel lblMessage = new JLabel(sMessage_);
        lblMessage.setForeground( Color.black );
        pAutoGridBagLayout.setAnchor( GridBagConstraints.WEST );
        getContentPane().add(lblMessage);
        pAutoGridBagLayout.endLine();

        // some extra space
        pAutoGridBagLayout.setExpandNone();
        getContentPane().add(Box.createVerticalStrut(2));
        pAutoGridBagLayout.endLine();

        // Double list
        _pDoubleList = new DoubleList( vsFirstList_,
                                       vsSecondList_,
                                       bMultiSelect_ );
        _pDoubleList.setBackground( frmParent_.getBackground() );
        pAutoGridBagLayout.setExpandBoth();
        pAutoGridBagLayout.setFillBoth();
        getContentPane().add(_pDoubleList );
        pAutoGridBagLayout.endLine();

        // some extra space
        pAutoGridBagLayout.setExpandNone();
        getContentPane().add(Box.createVerticalStrut(5));
        pAutoGridBagLayout.endLine();

        // OK and Cancel at bottom
        _pOKCancelPanel = new OKCancelPanel( this );

        pAutoGridBagLayout.setExpandHorizontal();
        getContentPane().add( _pOKCancelPanel );

        setSize( 600, 400 );
        SwingUtil.centerComponent(this);

        Util.debug( "DoubleListCancelSelector.<init>(..).END" );
    }

    public void setListBackground(Color pColor_) 
{
        _pDoubleList.setListBackground(pColor_);
    }

    public void setListForeground(Color pColor_) 
{
        _pDoubleList.setListForeground(pColor_);
    }

    public boolean isOK() 
{
        Util.panicIf( _pOKCancelPanel == null );

        return _pOKCancelPanel.isOK();
    }

    public Vector getValues() 
{
        Vector vRetVal = null;

        if ( !isOK() ) 
{
            return( vRetVal );
        }

        vRetVal = _pDoubleList.getSecondSelectedItems();
        if ( vRetVal != null) 
{
            vRetVal.insertElementAt( _pDoubleList.getFirstItem(), 0 );
        }

        return vRetVal;
    }
}
