/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the reusable ccl java library
 * (http://www.kclee.com/clemens/java/ccl/).
 *
 * The Initial Developer of the Original Code is
 * Chr. Clemens Lee.
 * Portions created by Chr. Clemens Lee are Copyright (C) 2002
 * Chr. Clemens Lee. All Rights Reserved.
 *
 * Contributor(s): Chr. Clemens Lee <clemens@kclee.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package ccl.util;

import java.io.FileDescriptor;
import java.net.InetAddress;

/**
 * This security manager allows just the thread which
 * created and installed this security manager to exit the
 * virtual machine. Additionally this security manager stops
 * on request threads that want to exit the jvm.
 *
 * @author  Chr. Clemens Lee
 * @version $Id: ThreadExitSecurityManager.java,v 1.4 2002/10/06 16:42:15 clemens Exp clemens $
 */
public class ThreadExitSecurityManager extends SecurityManager 
{
    private Thread _thrLegal = null;

    public ThreadExitSecurityManager()
    {
        _thrLegal = Thread.currentThread();
    }

    public void checkCreateClassLoader() 
    { } 
    public void checkAccess(Thread g) 
    { }
    public void checkAccess(ThreadGroup g) 
    { }

    private Thread _thrObservable = null;

    /*
     Has been never used except for jikes debugger plugin
     which is also not being used any more [2002-06-02].
    public synchronized void observeThread( Thread thrObservable_ ) 
    {
        _thrObservable = thrObservable_;
    }
    */

    public synchronized void checkExit(int status) 
    {
        if ( Thread.currentThread() != _thrLegal ) 
        {
            /*
            if ( Thread.currentThread() == _thrObservable ) 
            {
                _thrObservable.stop();
            }
            */
            throw new SecurityException();
        }
    }

    public void checkExec(String cmd) 
    { }
    public void checkLink(String lib) 
    { }
    public void checkRead(FileDescriptor fd) 
    { }
    public void checkRead(String file) 
    { }
    public void checkRead(String file, Object context) 
    { }
    public void checkWrite(FileDescriptor fd) 
    { }
    public void checkWrite(String file) 
    { }
    public void checkDelete(String file) 
    { }
    public void checkConnect(String host, int port) 
    { }
    public void checkConnect(String host, int port, Object context) 
    { }
    public void checkListen(int port) 
    { }
    public void checkAccept(String host, int port) 
    { }
    public void checkMulticast(InetAddress maddr) 
    { }
    public void checkMulticast(InetAddress maddr, byte ttl) 
    { }
    public void checkPropertiesAccess() 
    { }
    public void checkPropertyAccess(String key) 
    { }
    public void checkPropertyAccess(String key, String def) 
    { }
    public boolean checkTopLevelWindow(Object window) 
    { return true; }
    public void checkPrintJobAccess() 
    { }
    public void checkSystemClipboardAccess() 
    { }
    public void checkAwtEventQueueAccess() 
    { }
    public void checkPackageAccess(String pkg) 
    { }
    public void checkPackageDefinition(String pkg) 
    { }
    public void checkSetFactory() 
    { }
    public void checkMemberAccess(Class clazz, int which) 
    { }
    public void checkSecurityAccess(String provider) 
    { }
}       
