//
//  JCF Java Class File Manipulation Package (package lti.java.jcf)
//  Copyright (c) 1997 Matt T. Yourst. All rights reserved.
//
//  Version:  1.00.171
//  Date:     January through May 1997
//  Author:   Matt Yourst [yourst@laserstars.com]
//  Language: Java 1.1+
//

package lti.java.jcf;

import java.io.*;
import java.util.*;
import lti.java.jcf.RuntimeConstants;       

/**
 * JcfAttributeCollection is a vector of JcfAttributes. It can read and write collections
 * of attributes, and can be used to add and delete attributes.
 */ 
public class JcfAttributeCollection extends Vector implements RuntimeConstants
{
  protected JcfConstantPool constPool;
    public final JcfConstantPool getConstPool() { return constPool; }
      
  public JcfAttributeCollection (JcfClassInput ist, JcfConstantPool p)
    throws ClassFormatError, IOException
  {
    super(ist.readShort(), 4);
    constPool = p;
    for (int i = 0; i < capacity(); i++)
      { addElement(readAttribute(ist, ist.readCPRef())); }
  }

  /** 
   * Called to read each attribute; use as factory method for substituting
   * subclasses of JcfAttribute.
   * @param nameIndex the CP index of a CptUTF that defines the name of the attribute
   * to be read.
   */
  public JcfAttribute readAttribute (JcfClassInput ist, short nameIndex)
    throws IOException
  {
    if (constPool.utfAt(nameIndex).equals("Code"))
      return new JcfCodeAttribute(ist, nameIndex, constPool);
    else return new JcfAttribute(ist, nameIndex, constPool);
  }

  public final JcfAttribute attributeAt(int index)
    { return (JcfAttribute)(elementAt(index)); }

  public void write (JcfClassOutput ost) throws IOException
  {
    ost.writeShort(size());
    for (int i = 0; i < size(); i++) { writeAttribute(ost, attributeAt(i)); }
  }

  /** Called to write each attribute. */
  public void writeAttribute (JcfClassOutput ost, JcfAttribute attribute) throws IOException
  {
    attribute.write(ost);
  }
}
