/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.extract;

import cc.mallet.extract.Span;
import cc.mallet.types.Token;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class StringSpan
extends Token
implements Span {
    private CharSequence document;
    private int start;
    private int end;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 1;

    public StringSpan(CharSequence doc, int start, int end) {
        super(StringSpan.constructTokenText(doc, start, end));
        this.document = doc;
        this.start = start;
        this.end = end;
    }

    public Span intersection(Span r) {
        StringSpan other = (StringSpan)r;
        int newStart = Math.max(this.start, other.start);
        int newEnd = Math.min(this.end, other.end);
        return new StringSpan(this.document, newStart, newEnd);
    }

    private static String constructTokenText(CharSequence doc, int start, int end) {
        CharSequence subseq = doc.subSequence(start, end);
        return ((Object)subseq).toString().intern();
    }

    public Object getDocument() {
        return this.document;
    }

    public boolean intersects(Span r) {
        if (!(r instanceof StringSpan)) {
            return false;
        }
        StringSpan sr = (StringSpan)r;
        return sr.document == this.document && sr.end >= this.start && sr.start <= this.end;
    }

    public boolean isSubspan(Span r) {
        return r.getDocument() == this.document && this.start <= r.getStartIdx() && r.getEndIdx() <= this.end;
    }

    public int getStartIdx() {
        return this.start;
    }

    public int getEndIdx() {
        return this.end;
    }

    public String toString() {
        return super.toString() + "  span[" + this.start + ".." + this.end + "]";
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(1);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int version = in.readInt();
    }
}

