/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst;

import cc.mallet.fst.TransducerEvaluator;
import cc.mallet.fst.TransducerTrainer;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.types.Sequence;
import cc.mallet.util.MalletLogger;
import java.util.HashMap;
import java.util.logging.Logger;

public class InstanceAccuracyEvaluator
extends TransducerEvaluator {
    private static final Logger logger = MalletLogger.getLogger(InstanceAccuracyEvaluator.class.getName());
    private HashMap<String, Double> accuracy = new HashMap();

    public void evaluateInstanceList(TransducerTrainer tt, InstanceList data, String description) {
        int correct = 0;
        for (int i = 0; i < data.size(); ++i) {
            Instance instance = (Instance)data.get(i);
            Sequence input = (Sequence)instance.getData();
            Sequence trueOutput = (Sequence)instance.getTarget();
            assert (input.size() == trueOutput.size());
            Sequence predOutput = tt.getTransducer().transduce(input);
            assert (predOutput.size() == trueOutput.size());
            if (!this.sequencesMatch(trueOutput, predOutput)) continue;
            ++correct;
        }
        double acc = (double)correct / (double)data.size();
        this.accuracy.put(description, acc);
        logger.info(description + " Num instances = " + data.size() + "  Num correct = " + correct + " Per-instance accuracy = " + acc);
    }

    public double getAccuracy(String description) {
        return this.accuracy.get(description);
    }

    private boolean sequencesMatch(Sequence trueOutput, Sequence predOutput) {
        for (int j = 0; j < trueOutput.size(); ++j) {
            Object tru = trueOutput.get(j);
            Object pred = predOutput.get(j);
            if (tru.toString().equals(pred.toString())) continue;
            return false;
        }
        return true;
    }
}

