/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst.confidence;

import cc.mallet.classify.Classification;
import cc.mallet.classify.MaxEnt;
import cc.mallet.classify.MaxEntTrainer;
import cc.mallet.fst.Transducer;
import cc.mallet.fst.confidence.PipedInstanceWithConfidence;
import cc.mallet.fst.confidence.SequenceConfidenceInstance;
import cc.mallet.fst.confidence.TransducerSequenceConfidenceEstimator;
import cc.mallet.pipe.Pipe;
import cc.mallet.types.Alphabet;
import cc.mallet.types.InfoGain;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.types.Labeling;
import java.util.ArrayList;
import java.util.Collections;

public class MaxEntSequenceConfidenceEstimator
extends TransducerSequenceConfidenceEstimator {
    MaxEntTrainer meTrainer;
    MaxEnt meClassifier;
    Pipe pipe;
    String correct;
    String incorrect;

    public MaxEntSequenceConfidenceEstimator(Transducer model, double gaussianVariance) {
        super(model);
        this.meTrainer = new MaxEntTrainer(gaussianVariance);
    }

    public MaxEntSequenceConfidenceEstimator(Transducer model) {
        this(model, 10.0);
    }

    public MaxEnt getClassifier() {
        return this.meClassifier;
    }

    public MaxEnt trainClassifier(InstanceList ilist, String correct, String incorrect) {
        this.meClassifier = this.meTrainer.train(ilist);
        this.pipe = ilist.getPipe();
        this.correct = correct;
        this.incorrect = incorrect;
        InfoGain ig = new InfoGain(ilist);
        int igl = Math.min(30, ig.numLocations());
        for (int i = 0; i < igl; ++i) {
            System.out.println("InfoGain[" + ig.getObjectAtRank(i) + "]=" + ig.getValueAtRank(i));
        }
        return this.meClassifier;
    }

    public double estimateConfidenceFor(Instance instance, Object[] startTags, Object[] inTags) {
        Classification c = null;
        c = Alphabet.alphabetsMatch(instance, this.pipe) ? this.meClassifier.classify(new SequenceConfidenceInstance(instance)) : this.meClassifier.classify(instance);
        return c.getLabelVector().value(this.correct);
    }

    public PipedInstanceWithConfidence[] rankPipedInstancesByConfidence(InstanceList ilist, Object[] startTags, Object[] continueTags) {
        ArrayList<PipedInstanceWithConfidence> confidenceList = new ArrayList<PipedInstanceWithConfidence>();
        for (int i = 0; i < ilist.size(); ++i) {
            Instance instance = (Instance)ilist.get(i);
            boolean correctInstance = ((Labeling)instance.getTarget()).getBestLabel().toString().equals(this.correct);
            System.err.println("Instance is " + (correctInstance ? "correct" : "incorrect"));
            confidenceList.add(new PipedInstanceWithConfidence(instance, this.estimateConfidenceFor(instance, startTags, continueTags), correctInstance));
        }
        Collections.sort(confidenceList);
        PipedInstanceWithConfidence[] ret = new PipedInstanceWithConfidence[1];
        ret = confidenceList.toArray(ret);
        return ret;
    }
}

