/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.learning;

import bsh.EvalError;
import cc.mallet.grmm.inference.Inferencer;
import cc.mallet.grmm.learning.ACRF;
import cc.mallet.grmm.learning.ACRFEvaluator;
import cc.mallet.grmm.learning.AcrfSerialEvaluator;
import cc.mallet.grmm.learning.DefaultAcrfTrainer;
import cc.mallet.grmm.learning.GenericAcrfData2TokenSequence;
import cc.mallet.grmm.learning.MultiSegmentationEvaluatorACRF;
import cc.mallet.pipe.Pipe;
import cc.mallet.pipe.SerialPipes;
import cc.mallet.pipe.TokenSequence2FeatureVectorSequence;
import cc.mallet.pipe.iterator.LineGroupIterator;
import cc.mallet.types.InstanceList;
import cc.mallet.util.BshInterpreter;
import cc.mallet.util.CommandOption;
import cc.mallet.util.FileUtils;
import cc.mallet.util.Timing;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class GenericAcrfTui {
    private static CommandOption.File modelFile = new CommandOption.File(GenericAcrfTui.class, "model-file", "FILENAME", true, null, "Text file describing model structure.", null);
    private static CommandOption.File trainFile = new CommandOption.File(GenericAcrfTui.class, "training", "FILENAME", true, null, "File containing training data.", null);
    private static CommandOption.File testFile = new CommandOption.File(GenericAcrfTui.class, "testing", "FILENAME", true, null, "File containing testing data.", null);
    private static CommandOption.Integer numLabelsOption = new CommandOption.Integer(GenericAcrfTui.class, "num-labels", "INT", true, -1, "If supplied, number of labels on each line of input file.  Otherwise, the token ---- must separate labels from features.", null);
    private static CommandOption.String inferencerOption = new CommandOption.String(GenericAcrfTui.class, "inferencer", "STRING", true, "TRP", "Specification of inferencer.", null);
    private static CommandOption.String maxInferencerOption = new CommandOption.String(GenericAcrfTui.class, "max-inferencer", "STRING", true, "TRP.createForMaxProduct()", "Specification of inferencer.", null);
    private static CommandOption.String evalOption = new CommandOption.String(GenericAcrfTui.class, "eval", "STRING", true, "LOG", "Evaluator to use.  Java code grokking performed.", null);
    static CommandOption.Boolean cacheUnrolledGraph = new CommandOption.Boolean(GenericAcrfTui.class, "cache-graphs", "true|false", true, false, "Whether to use memory-intensive caching.", null);
    static CommandOption.Boolean useTokenText = new CommandOption.Boolean(GenericAcrfTui.class, "use-token-text", "true|false", true, false, "Set this to true if first feature in every list is should be considered the text of the current token.  This is used for NLP-specific debugging and error analysis.", null);
    static CommandOption.Integer randomSeedOption = new CommandOption.Integer(GenericAcrfTui.class, "random-seed", "INTEGER", true, 0, "The random seed for randomly selecting a proportion of the instance list for training", null);
    private static BshInterpreter interpreter = GenericAcrfTui.setupInterpreter();

    public static void main(String[] args) throws IOException, EvalError {
        GenericAcrfTui.doProcessOptions(GenericAcrfTui.class, args);
        Timing timing = new Timing();
        GenericAcrfData2TokenSequence basePipe = !numLabelsOption.wasInvoked() ? new GenericAcrfData2TokenSequence() : new GenericAcrfData2TokenSequence(GenericAcrfTui.numLabelsOption.value);
        basePipe.setFeaturesIncludeToken(GenericAcrfTui.useTokenText.value);
        basePipe.setIncludeTokenText(GenericAcrfTui.useTokenText.value);
        SerialPipes pipe = new SerialPipes(new Pipe[]{basePipe, new TokenSequence2FeatureVectorSequence(true, true)});
        LineGroupIterator trainSource = new LineGroupIterator(new FileReader(GenericAcrfTui.trainFile.value), Pattern.compile("^\\s*$"), true);
        LineGroupIterator testSource = testFile.wasInvoked() ? new LineGroupIterator(new FileReader(GenericAcrfTui.testFile.value), Pattern.compile("^\\s*$"), true) : null;
        InstanceList training = new InstanceList(pipe);
        training.addThruPipe(trainSource);
        InstanceList testing = new InstanceList(pipe);
        testing.addThruPipe(testSource);
        ACRF.Template[] tmpls = GenericAcrfTui.parseModelFile(GenericAcrfTui.modelFile.value);
        ACRFEvaluator eval = GenericAcrfTui.createEvaluator(GenericAcrfTui.evalOption.value);
        Inferencer inf = GenericAcrfTui.createInferencer(GenericAcrfTui.inferencerOption.value);
        Inferencer maxInf = GenericAcrfTui.createInferencer(GenericAcrfTui.maxInferencerOption.value);
        ACRF acrf = new ACRF(pipe, tmpls);
        acrf.setInferencer(inf);
        acrf.setViterbiInferencer(maxInf);
        DefaultAcrfTrainer trainer = new DefaultAcrfTrainer();
        trainer.train(acrf, training, null, testing, eval, 9999);
        timing.tick("Training");
        FileUtils.writeGzippedObject(new File("acrf.ser.gz"), acrf);
        timing.tick("Serializing");
        System.out.println("Total time (ms) = " + timing.elapsedTime());
    }

    private static BshInterpreter setupInterpreter() {
        BshInterpreter interpreter = CommandOption.getInterpreter();
        try {
            interpreter.eval("import edu.umass.cs.mallet.base.extract.*");
            interpreter.eval("import edu.umass.cs.mallet.grmm.inference.*");
            interpreter.eval("import edu.umass.cs.mallet.grmm.learning.*");
            interpreter.eval("import edu.umass.cs.mallet.grmm.learning.templates.*");
        }
        catch (EvalError e) {
            throw new RuntimeException(e);
        }
        return interpreter;
    }

    public static ACRFEvaluator createEvaluator(String spec) throws EvalError {
        if (spec.indexOf(40) >= 0) {
            return (ACRFEvaluator)interpreter.eval(spec);
        }
        LinkedList<String> toks = new LinkedList<String>(Arrays.asList(spec.split("\\s+")));
        return GenericAcrfTui.createEvaluator(toks);
    }

    private static ACRFEvaluator createEvaluator(LinkedList toks) {
        String type = (String)toks.removeFirst();
        if (type.equalsIgnoreCase("SEGMENT")) {
            int slice = Integer.parseInt((String)toks.removeFirst());
            if (toks.size() % 2 != 0) {
                throw new RuntimeException("Error in --eval " + GenericAcrfTui.evalOption.value + ": Every start tag must have a continue.");
            }
            int numTags = toks.size() / 2;
            Object[] startTags = new String[numTags];
            Object[] continueTags = new String[numTags];
            for (int i = 0; i < numTags; ++i) {
                startTags[i] = (String)toks.removeFirst();
                continueTags[i] = (String)toks.removeFirst();
            }
            return new MultiSegmentationEvaluatorACRF(startTags, continueTags, slice);
        }
        if (type.equalsIgnoreCase("LOG")) {
            return new DefaultAcrfTrainer.LogEvaluator();
        }
        if (type.equalsIgnoreCase("SERIAL")) {
            ArrayList<ACRFEvaluator> evals = new ArrayList<ACRFEvaluator>();
            while (!toks.isEmpty()) {
                evals.add(GenericAcrfTui.createEvaluator(toks));
            }
            return new AcrfSerialEvaluator(evals);
        }
        throw new RuntimeException("Error in --eval " + GenericAcrfTui.evalOption.value + ": illegal evaluator " + type);
    }

    private static Inferencer createInferencer(String spec) throws EvalError {
        String cmd = spec.indexOf(40) >= 0 ? spec : "new " + spec + "()";
        Object inf = interpreter.eval(cmd);
        if (inf instanceof Inferencer) {
            return (Inferencer)inf;
        }
        throw new RuntimeException("Don't know what to do with inferencer " + inf);
    }

    public static void doProcessOptions(Class childClass, String[] args) {
        CommandOption.List options = new CommandOption.List("", new CommandOption[0]);
        options.add(childClass);
        options.process(args);
        options.logOptions(Logger.getLogger(""));
    }

    private static ACRF.Template[] parseModelFile(File mdlFile) throws IOException, EvalError {
        BufferedReader in = new BufferedReader(new FileReader(mdlFile));
        ArrayList<Object> tmpls = new ArrayList<Object>();
        String line = in.readLine();
        while (line != null) {
            Object tmpl = interpreter.eval(line);
            if (!(tmpl instanceof ACRF.Template)) {
                throw new RuntimeException("Error in " + mdlFile + " line " + in.toString() + ":\n  Object " + tmpl + " not a template");
            }
            tmpls.add(tmpl);
            line = in.readLine();
        }
        return tmpls.toArray(new ACRF.Template[0]);
    }
}

