/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.als;

import com.sun.electric.tool.simulation.DigitalSample;
import com.sun.electric.tool.simulation.MutableSignal;
import com.sun.electric.tool.simulation.Signal;
import com.sun.electric.tool.simulation.SimulationTool;
import com.sun.electric.tool.simulation.als.ALS;
import com.sun.electric.tool.user.waveform.Panel;
import com.sun.electric.util.TextUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class Sim {
    private ALS als;
    private List<ALS.Load> chekList = new ArrayList<ALS.Load>();
    private HashMap<ALS.Node, List<ALS.Trak>> tracking;
    private static String[] stateDesc = new String[]{"High", "Undefined", "Low"};
    private static String[] strengthDesc = new String[]{"Off-", "Weak-", "Weak-", "", "", "Strong-", "Strong-"};
    boolean tracing = false;

    Sim(ALS als) {
        this.als = als;
    }

    double initializeSimulator(boolean force2) {
        this.als.timeAbs = 0.0;
        this.tracking = new HashMap();
        while (this.als.linkFront != null) {
            if (this.als.linkFront.down != null) {
                this.als.linkFront.down.right = this.als.linkFront.right;
                this.als.linkFront = this.als.linkFront.down;
                continue;
            }
            this.als.linkFront = this.als.linkFront.right;
        }
        this.als.linkBack = null;
        ALS.Link linkHead = this.als.setRoot;
        while (linkHead != null) {
            ALS.Link linkPtr2 = new ALS.Link();
            if (linkPtr2 == null) {
                return this.als.timeAbs;
            }
            linkPtr2.type = linkHead.type;
            linkPtr2.ptr = linkHead.ptr;
            linkPtr2.state = linkHead.state;
            linkPtr2.strength = linkHead.strength;
            linkPtr2.priority = linkHead.priority;
            linkPtr2.time = linkHead.time;
            linkPtr2.primHead = null;
            this.insertLinkList(linkPtr2);
            linkHead = linkHead.right;
        }
        for (ALS.Node nodeHead : this.als.nodeList) {
            nodeHead.sumState = 0;
            nodeHead.sumStrength = 0;
            nodeHead.newState = new Integer(0);
            nodeHead.newStrength = 0;
            nodeHead.arrive = 0;
            nodeHead.depart = 0;
            nodeHead.tLast = 0.0;
            for (ALS.Stat statHead : nodeHead.statList) {
                statHead.newState = 0;
                statHead.newStrength = 0;
                statHead.schedOp = '\u0000';
            }
        }
        boolean update2 = SimulationTool.isBuiltInResimulateEach();
        if (force2) {
            update2 = true;
        }
        if (update2) {
            System.out.print("Simulating...");
            double tMax = 0.0;
            for (Signal<?> sig : this.als.sc.getSignals()) {
                tMax = Math.max(tMax, sig.getMaxTime());
            }
            Iterator<Panel> it = this.als.ww.getPanels();
            while (it.hasNext()) {
                Panel wp = it.next();
                double panelMax = wp.getMaxXAxis();
                if (!(panelMax > tMax)) continue;
                tMax = panelMax;
            }
            while (!(this.als.linkFront == null || !(this.als.linkFront.time <= tMax) || this.fireEvent() || this.chekList.size() != 0 && this.scheduleNewEvents())) {
            }
            this.fillDisplayArrays();
            System.out.println("Done.  Ran to time " + TextUtils.convertToEngineeringNotation(this.als.timeAbs, "s"));
        }
        return this.als.timeAbs;
    }

    private void fillDisplayArrays() {
        for (ALS.Node node : this.tracking.keySet()) {
            Signal<DigitalSample> sig = node.sig;
            List<ALS.Trak> trakHeads = this.tracking.get(node);
            for (ALS.Trak trakHead : trakHeads) {
                MutableSignal mSig = (MutableSignal)sig;
                DigitalSample ds = DigitalSample.fromOldStyle(trakHead.state & 3);
                if (mSig.getSample(trakHead.time) == null) {
                    mSig.addSample(trakHead.time, ds);
                    continue;
                }
                mSig.replaceSample(trakHead.time, ds);
            }
        }
        this.als.ww.repaint();
    }

    private boolean fireEvent() {
        this.als.timeAbs = this.als.linkFront.time;
        ALS.Link linkHead = this.als.linkFront;
        if (this.als.linkFront.down != null) {
            this.als.linkFront = this.als.linkFront.down;
            this.als.linkFront.left = null;
            this.als.linkFront.right = linkHead.right;
            this.als.linkFront.up = linkHead.up;
            if (this.als.linkFront.right != null) {
                this.als.linkFront.right.left = this.als.linkFront;
            } else {
                this.als.linkBack = this.als.linkFront;
            }
        } else {
            this.als.linkFront = this.als.linkFront.right;
            if (this.als.linkFront != null) {
                this.als.linkFront.left = null;
            } else {
                this.als.linkBack = null;
            }
        }
        this.tracing = false;
        switch (linkHead.type) {
            case 'G': {
                ALS.Stat statHead = (ALS.Stat)linkHead.ptr;
                if (statHead.nodePtr.traceNode) {
                    String s2 = this.als.computeNodeName(statHead.nodePtr);
                    System.out.println(TextUtils.convertToEngineeringNotation(this.als.timeAbs) + ": Firing gate " + statHead.primPtr.name + statHead.primPtr.level + ", net " + s2);
                    this.tracing = true;
                }
                if (statHead.schedState != linkHead.state || statHead.schedOp != linkHead.operatr || statHead.schedStrength != linkHead.strength) break;
                statHead.schedOp = '\u0000';
                char operatr = linkHead.operatr;
                int operand = 0;
                if (operatr < '\u0080') {
                    operand = (Integer)linkHead.state;
                } else {
                    operatr = (char)(operatr - 128);
                }
                int state = 0;
                switch (operatr) {
                    case '=': {
                        state = operand;
                        break;
                    }
                    case '+': {
                        state = statHead.nodePtr.sumState + operand;
                        break;
                    }
                    case '-': {
                        state = statHead.nodePtr.sumState - operand;
                        break;
                    }
                    case '*': {
                        state = statHead.nodePtr.sumState * operand;
                        break;
                    }
                    case '/': {
                        state = statHead.nodePtr.sumState / operand;
                        break;
                    }
                    case '%': {
                        state = statHead.nodePtr.sumState % operand;
                        break;
                    }
                    default: {
                        System.out.println("Invalid arithmetic operator: " + operatr);
                        return true;
                    }
                }
                if (state == statHead.newState && linkHead.strength == statHead.newStrength) break;
                statHead.newState = state;
                statHead.newStrength = linkHead.strength;
                this.createCheckList(statHead.nodePtr, linkHead);
                break;
            }
            case 'N': {
                ALS.Node nodeHead = (ALS.Node)linkHead.ptr;
                if (nodeHead.traceNode) {
                    String s2 = this.als.computeNodeName(nodeHead);
                    System.out.println(TextUtils.convertToEngineeringNotation(this.als.timeAbs) + ": Changed state of net " + s2);
                    this.tracing = true;
                }
                if (linkHead.state == nodeHead.newState && linkHead.strength == nodeHead.newStrength) break;
                nodeHead.newState = linkHead.state;
                nodeHead.newStrength = linkHead.strength;
                this.createCheckList(nodeHead, linkHead);
                break;
            }
            case 'C': {
                double time = this.als.timeAbs;
                ALS.Row rowHead = (ALS.Row)linkHead.ptr;
                for (Object obj : rowHead.inList) {
                    ALS.Link vectHead = (ALS.Link)obj;
                    ALS.Link linkPtr2 = new ALS.Link();
                    linkPtr2.type = (char)78;
                    linkPtr2.ptr = vectHead.ptr;
                    linkPtr2.state = vectHead.state;
                    linkPtr2.strength = vectHead.strength;
                    linkPtr2.priority = vectHead.priority;
                    linkPtr2.time = time;
                    linkPtr2.primHead = null;
                    this.insertLinkList(linkPtr2);
                    time += vectHead.time;
                }
                if ((Integer)linkHead.state == 0) {
                    this.calculateClockTime(linkHead, rowHead);
                    return false;
                }
                linkHead.state = new Integer((Integer)linkHead.state - 1);
                if ((Integer)linkHead.state == 0) break;
                this.calculateClockTime(linkHead, rowHead);
                return false;
            }
        }
        return false;
    }

    private void createCheckList(ALS.Node nodeHead, ALS.Link linkHead) {
        int state = (Integer)nodeHead.newState;
        int strength = nodeHead.newStrength;
        if (this.tracing) {
            System.out.println("  Formerly " + strengthDesc[nodeHead.sumStrength] + stateDesc[nodeHead.sumState + 3] + ", starts at " + strengthDesc[strength] + stateDesc[state + 3]);
        }
        for (ALS.Stat statHead : nodeHead.statList) {
            int thisState = statHead.newState;
            int thisStrength = statHead.newStrength;
            if (this.tracing) {
                System.out.println("    " + strengthDesc[thisStrength] + stateDesc[thisState + 3] + " from " + statHead.primPtr.name + statHead.primPtr.level);
            }
            if (thisStrength > strength) {
                state = thisState;
                strength = thisStrength;
                continue;
            }
            if (thisStrength != strength || thisState == state) continue;
            state = 1;
        }
        if (strength == 0) {
            state = nodeHead.sumState;
            strength = 4;
        }
        if (nodeHead.sumState == state && nodeHead.sumStrength == strength) {
            if (this.tracing) {
                System.out.println("    NO CHANGE");
            }
            return;
        }
        if (nodeHead.sig != null) {
            List<ALS.Trak> nodeData = this.tracking.get(nodeHead);
            if (nodeData == null) {
                nodeData = new ArrayList<ALS.Trak>();
                this.tracking.put(nodeHead, nodeData);
            }
            ALS.Trak trakHead = new ALS.Trak();
            trakHead.state = state | strength;
            trakHead.time = this.als.timeAbs;
            nodeData.add(trakHead);
        }
        if (this.tracing) {
            System.out.println("    BECOMES " + strengthDesc[strength] + stateDesc[state + 3]);
        }
        nodeHead.sumState = state;
        nodeHead.sumStrength = strength;
        nodeHead.tLast = this.als.timeAbs;
        this.als.driveNode = nodeHead;
        for (ALS.Load l : nodeHead.pinList) {
            this.chekList.add(l);
        }
    }

    private boolean scheduleNewEvents() {
        ArrayList<ALS.Load> chekListCopy = new ArrayList<ALS.Load>();
        for (ALS.Load l : this.chekList) {
            chekListCopy.add(l);
        }
        this.chekList.clear();
        block7: for (ALS.Load chekHead : chekListCopy) {
            ALS.Model primHead = (ALS.Model)chekHead.ptr;
            if (primHead.type == 'F') {
                ALS.Func funcHead = (ALS.Func)primHead.ptr;
                funcHead.procPtr.simulate(primHead);
                continue;
            }
            ALS.Row rowHead = (ALS.Row)primHead.ptr;
            while (rowHead != null) {
                boolean flag = true;
                for (Object obj : rowHead.inList) {
                    int operand;
                    ALS.IO ioHead = (ALS.IO)obj;
                    int operatr = ioHead.operatr;
                    if (operatr < 128) {
                        operand = (Integer)ioHead.operand;
                    } else {
                        operatr -= 128;
                        ALS.Node nodeHead = (ALS.Node)ioHead.operand;
                        operand = nodeHead.sumState;
                    }
                    switch (operatr) {
                        case 61: {
                            if (((ALS.Node)ioHead.nodePtr).sumState == operand) break;
                            flag = false;
                            break;
                        }
                        case 33: {
                            if (((ALS.Node)ioHead.nodePtr).sumState != operand) break;
                            flag = false;
                            break;
                        }
                        case 60: {
                            if (((ALS.Node)ioHead.nodePtr).sumState < operand) break;
                            flag = false;
                            break;
                        }
                        case 62: {
                            if (((ALS.Node)ioHead.nodePtr).sumState > operand) break;
                            flag = false;
                            break;
                        }
                        default: {
                            System.out.println("Invalid logical operator: " + operatr);
                            return true;
                        }
                    }
                    if (flag) continue;
                    break;
                }
                if (flag) {
                    this.calculateEventTime(primHead, rowHead);
                    continue block7;
                }
                rowHead = rowHead.next;
            }
        }
        return false;
    }

    private void calculateClockTime(ALS.Link linkHead, ALS.Row rowHead) {
        double time = this.als.timeAbs;
        if (rowHead.delta != 0.0) {
            time += rowHead.delta;
        }
        if (rowHead.linear != 0.0) {
            double prob = Math.random();
            time += 2.0 * prob * rowHead.linear;
        }
        linkHead.time = time;
        this.insertLinkList(linkHead);
    }

    private void calculateEventTime(ALS.Model primHead, ALS.Row rowHead) {
        double prob;
        double time = 0.0;
        int priority = primHead.priority;
        if (rowHead.delta != 0.0) {
            time += rowHead.delta;
        }
        if (rowHead.abs != 0.0) {
            time += rowHead.abs;
        }
        if (rowHead.linear != 0.0) {
            prob = Math.random();
            time += 2.0 * prob * rowHead.linear;
        }
        if (rowHead.random != 0.0 && (prob = Math.random()) <= rowHead.random) {
            priority = -1;
        }
        if (primHead.fanOut != '\u0000') {
            Iterator<Object> it = rowHead.outList.iterator();
            ALS.IO ioPtr = (ALS.IO)it.next();
            ALS.Stat statHead = (ALS.Stat)ioPtr.nodePtr;
            time *= statHead.nodePtr.load;
        }
        time += this.als.timeAbs;
        for (Object obj : rowHead.outList) {
            ALS.IO ioHead = (ALS.IO)obj;
            ALS.Stat statHead = (ALS.Stat)ioHead.nodePtr;
            if (statHead.schedOp == ioHead.operatr && statHead.schedState.equals(ioHead.operand) && statHead.schedStrength == ioHead.strength) continue;
            ALS.Link linkPtr2 = new ALS.Link();
            linkPtr2.type = (char)71;
            linkPtr2.ptr = statHead;
            linkPtr2.operatr = statHead.schedOp = ioHead.operatr;
            linkPtr2.state = statHead.schedState = ioHead.operand;
            linkPtr2.strength = statHead.schedStrength = ioHead.strength;
            linkPtr2.time = time;
            linkPtr2.priority = priority;
            linkPtr2.primHead = primHead;
            if (this.tracing) {
                System.out.println("      Schedule(G): " + statHead.primPtr.name + statHead.primPtr.level + " at " + TextUtils.convertToEngineeringNotation(time));
            }
            this.insertLinkList(linkPtr2);
        }
    }

    void insertLinkList(ALS.Link linkHead) {
        ALS.Link linkPtr2;
        int linkPtr1Is = 0;
        ALS.Link linkPtr2Val = linkPtr2 = this.als.linkBack;
        ALS.Link linkPtr3 = null;
        while (true) {
            if (linkPtr2 == null) {
                this.als.linkFront = linkHead;
                switch (linkPtr1Is) {
                    case 0: {
                        this.als.linkBack = linkHead;
                        break;
                    }
                    case 1: {
                        linkPtr2Val.up = linkHead;
                        break;
                    }
                    case 2: {
                        linkPtr2Val.left = linkHead;
                    }
                }
                linkHead.left = null;
                linkHead.right = linkPtr3;
                linkHead.up = linkHead;
                linkHead.down = null;
                return;
            }
            if (linkPtr2.time < linkHead.time) {
                linkPtr2.right = linkHead;
                switch (linkPtr1Is) {
                    case 0: {
                        this.als.linkBack = linkHead;
                        break;
                    }
                    case 1: {
                        linkPtr2Val.up = linkHead;
                        break;
                    }
                    case 2: {
                        linkPtr2Val.left = linkHead;
                    }
                }
                linkHead.left = linkPtr2;
                linkHead.right = linkPtr3;
                linkHead.up = linkHead;
                linkHead.down = null;
                return;
            }
            if (linkPtr2.time == linkHead.time) {
                if (linkPtr2.priority > linkHead.priority) {
                    linkHead.left = linkPtr2.left;
                    linkHead.right = linkPtr2.right;
                    linkHead.down = linkPtr2;
                    linkHead.up = linkPtr2.up;
                    linkPtr2.up = linkHead;
                    switch (linkPtr1Is) {
                        case 0: {
                            this.als.linkBack = linkHead;
                            break;
                        }
                        case 1: {
                            linkPtr2Val.up = linkHead;
                            break;
                        }
                        case 2: {
                            linkPtr2Val.left = linkHead;
                        }
                    }
                    if (linkHead.left != null) {
                        linkHead.left.right = linkHead;
                    } else {
                        this.als.linkFront = linkHead;
                    }
                    return;
                }
                linkPtr1Is = 1;
                linkPtr2Val = linkPtr2;
                linkPtr2 = linkPtr2.up;
                linkPtr3 = null;
                while (true) {
                    if (linkPtr2.priority <= linkHead.priority) {
                        linkPtr2.down = linkHead;
                        switch (linkPtr1Is) {
                            case 0: {
                                this.als.linkBack = linkHead;
                                break;
                            }
                            case 1: {
                                linkPtr2Val.up = linkHead;
                                break;
                            }
                            case 2: {
                                linkPtr2Val.left = linkHead;
                            }
                        }
                        linkHead.up = linkPtr2;
                        linkHead.down = linkPtr3;
                        return;
                    }
                    linkPtr3 = linkPtr2;
                    linkPtr1Is = 1;
                    linkPtr2Val = linkPtr2;
                    linkPtr2 = linkPtr2.up;
                }
            }
            linkPtr3 = linkPtr2;
            linkPtr1Is = 2;
            linkPtr2Val = linkPtr2;
            linkPtr2 = linkPtr2.left;
        }
    }
}

