/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ctc;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.ctc.epubpackage.EpubPackage;
import com.adobe.epubcheck.ctc.epubpackage.ManifestItem;
import com.adobe.epubcheck.ctc.xml.Epub3StructureHandler;
import com.adobe.epubcheck.ctc.xml.XMLContentDocParser;
import com.adobe.epubcheck.opf.DocumentValidator;
import com.adobe.epubcheck.util.SearchDictionary;
import java.util.zip.ZipEntry;

public class Epub3StructureCheck
implements DocumentValidator {
    private final Report report;
    private final EpubPackage epack;

    public Epub3StructureCheck(EpubPackage epack, Report report) {
        this.report = report;
        this.epack = epack;
    }

    @Override
    public boolean validate() {
        boolean result = false;
        SearchDictionary vtsd = new SearchDictionary(SearchDictionary.DictionaryType.VALID_TEXT_MEDIA_TYPES);
        for (int i = 0; i < this.epack.getManifest().itemsLength(); ++i) {
            ManifestItem mi = this.epack.getManifest().getItem(i);
            if (!vtsd.isValidMediaType(mi.getMediaType())) continue;
            XMLContentDocParser parser = new XMLContentDocParser(this.epack.getZip(), this.report);
            Epub3StructureHandler epub3StructureHandler = new Epub3StructureHandler();
            String fileToParse = this.epack.getManifestItemFileName(mi);
            ZipEntry entry = this.epack.getZip().getEntry(fileToParse);
            if (entry == null) continue;
            epub3StructureHandler.setFileName(this.epack.getFileName());
            epub3StructureHandler.setReport(this.report);
            parser.parseDoc(fileToParse, epub3StructureHandler);
            if (epub3StructureHandler.getSpecificTagsCount() <= 0) continue;
            result = true;
        }
        return result;
    }
}

