/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.PooledLinkedList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PooledLinkedListTest {
    private PooledLinkedList<Integer> list;

    @Before
    public void setUp() {
        this.list = new PooledLinkedList(10);
        this.list.add(1);
        this.list.add(2);
        this.list.add(3);
    }

    @Test
    public void size() {
        Assert.assertEquals((long)3L, (long)this.list.size());
        this.list.iter();
        this.list.next();
        this.list.remove();
        Assert.assertEquals((long)2L, (long)this.list.size());
    }

    @Test
    public void iteration() {
        this.list.iter();
        Assert.assertEquals((Object)1, (Object)this.list.next());
        Assert.assertEquals((Object)2, (Object)this.list.next());
        Assert.assertEquals((Object)3, (Object)this.list.next());
        Assert.assertNull((Object)this.list.next());
    }

    @Test
    public void reverseIteration() {
        this.list.iterReverse();
        Assert.assertEquals((Object)3, (Object)this.list.previous());
        Assert.assertEquals((Object)2, (Object)this.list.previous());
        Assert.assertEquals((Object)1, (Object)this.list.previous());
        Assert.assertNull((Object)this.list.previous());
    }

    @Test
    public void remove() {
        this.list.iter();
        this.list.next();
        this.list.remove();
        this.list.next();
        this.list.next();
        this.list.remove();
        this.list.iter();
        Assert.assertEquals((Object)2, (Object)this.list.next());
        Assert.assertNull((Object)this.list.next());
    }

    @Test
    public void removeLast() {
        this.list.iter();
        Assert.assertEquals((Object)1, (Object)this.list.next());
        this.list.removeLast();
        Assert.assertEquals((Object)2, (Object)this.list.next());
        Assert.assertNull((Object)this.list.next());
    }

    @Test
    public void clear() {
        this.list.clear();
        Assert.assertEquals((long)0L, (long)this.list.size());
        this.list.iter();
        Assert.assertNull((Object)this.list.next());
    }
}

