/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.gloomhavenhelper.util;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.esotericsoftware.gloomhavenhelper.App;
import com.esotericsoftware.gloomhavenhelper.model.ElementState;
import com.esotericsoftware.spine.AnimationState;
import com.esotericsoftware.spine.AnimationStateData;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.utils.SkeletonDrawable;

public class ElementButton
extends ImageButton {
    private final String name;
    private final Skeleton skeleton;
    private final AnimationState state;
    private final TextureAtlas.AtlasRegion ringRegion;
    private final TextureAtlas.AtlasRegion glowRegion;
    private final TextureAtlas.AtlasRegion glowHalfRegion;
    private final TextureAtlas.AtlasRegion elementRegion;
    public ElementState elementState = ElementState.inert;
    boolean allowOver = true;
    long lastClickTime;
    float glowAlpha;
    float glowHalfAlpha;

    public ElementButton(String name) {
        super(new ImageButton.ImageButtonStyle());
        this.name = name;
        this.skeleton = new Skeleton(App.elementsSkeletonData);
        this.state = new AnimationState(new AnimationStateData(App.elementsSkeletonData));
        this.state.setAnimation(0, String.valueOf(name) + "-strong-inert", false).setTrackTime(999.0f);
        ImageButton.ImageButtonStyle style = this.getStyle();
        style.imageUp = new SkeletonDrawable(App.skeletonRenderer, this.skeleton, this.state);
        style.imageUp.setMinWidth(100.0f);
        style.imageUp.setMinHeight(100.0f);
        this.setStyle(style);
        this.ringRegion = App.atlas.findRegion("element-ring");
        this.glowRegion = App.atlas.findRegion("element-glow");
        this.glowHalfRegion = App.atlas.findRegion("element-glow-half");
        this.elementRegion = App.atlas.findRegion("psd/element-" + name);
        this.addListener(new ClickListener(-1){

            @Override
            public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {
                super.enter(event, x, y, pointer, fromActor);
                ElementButton.this.allowOver = true;
            }

            @Override
            public void clicked(InputEvent event, float x, float y) {
                long time = System.currentTimeMillis();
                if (time - ElementButton.this.lastClickTime < 400L) {
                    ElementButton.this.setState(ElementState.waning, "strong-waning");
                } else if (ElementButton.this.elementState == ElementState.inert) {
                    ElementButton.this.infuse();
                } else {
                    ElementButton.this.consume();
                }
                ElementButton.this.lastClickTime = time;
                ElementButton.this.allowOver = false;
                ElementButton.this.clicked(ElementButton.this.elementState);
            }
        });
    }

    @Override
    public void act(float delta) {
        super.act(delta);
        this.state.update(delta);
        this.skeleton.update(delta);
        AnimationState.TrackEntry current = this.state.getCurrent(0);
        if (current != null && (current.getTrackTime() < current.getAnimation().getDuration() || current.getNext() != null)) {
            Gdx.graphics.requestRendering();
        }
        boolean animDone = this.state.getCurrent(0).isComplete() && this.state.getCurrent(0).getNext() == null;
        float target = this.elementState == ElementState.strong && animDone ? 0.7f : 0.0f;
        float modifier = this.glowAlpha < target ? 0.5f : 1.0f;
        this.glowAlpha = App.animate(this.glowAlpha, target, 0.6f * modifier, 1.5f * modifier, 3.0f * modifier, delta);
        target = this.elementState == ElementState.waning && animDone ? 0.7f : 0.0f;
        modifier = this.glowHalfAlpha < target ? 0.5f : 1.0f;
        this.glowHalfAlpha = App.animate(this.glowHalfAlpha, target, 0.6f * modifier, 1.5f * modifier, 3.0f * modifier, delta);
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        this.state.apply(this.skeleton);
        if (this.glowAlpha > 0.0f) {
            batch.setColor(1.0f, 1.0f, 1.0f, this.glowAlpha);
            batch.draw(this.glowRegion, this.getX() - 6.0f, this.getY() - 6.0f);
        }
        if (this.glowHalfAlpha > 0.0f) {
            batch.setColor(1.0f, 1.0f, 1.0f, this.glowHalfAlpha);
            batch.draw(this.glowHalfRegion, this.getX() - 6.0f, this.getY() - 6.0f);
        }
        super.draw(batch, parentAlpha);
        batch.setBlendFunction(770, 771);
        if (this.allowOver && this.isOver()) {
            batch.setColor(Color.WHITE);
            if (this.elementState == ElementState.inert) {
                batch.draw(this.elementRegion, this.getX() + this.elementRegion.offsetX, this.getY() + this.elementRegion.offsetY);
            }
            batch.draw(this.ringRegion, this.getX() - 2.0f, this.getY() - 2.0f);
        }
    }

    public void setState(ElementState elementState, boolean animate) {
        if (elementState == null) {
            throw new IllegalArgumentException("elementState cannot be null.");
        }
        if (this.elementState == elementState) {
            return;
        }
        String anim = null;
        if (animate) {
            if (elementState == ElementState.inert) {
                if (this.elementState == ElementState.inert) {
                    this.setState(ElementState.inert, false);
                    return;
                }
                anim = this.elementState == ElementState.strong ? "strong-inert" : "waning-inert";
            } else {
                anim = elementState == ElementState.waning ? "strong-waning" : "inert-strong";
            }
            this.setState(elementState, anim);
            return;
        }
        anim = elementState == ElementState.inert ? "waning-inert" : (elementState == ElementState.waning ? "strong-waning" : "inert-strong");
        this.state.setAnimation(0, String.valueOf(this.name) + "-" + anim, false).setTrackTime(999.0f);
        this.elementState = elementState;
    }

    public AnimationState.TrackEntry setState(ElementState elementState, String anim) {
        if (elementState == null) {
            throw new IllegalArgumentException("elementState cannot be null.");
        }
        AnimationState.TrackEntry current = this.state.getCurrent(0);
        AnimationState.TrackEntry entry = current.getNext() == null && current.isComplete() ? this.state.addAnimation(0, String.valueOf(this.name) + "-" + anim, false, current.getTrackTime() + 0.4f) : this.state.setAnimation(0, String.valueOf(this.name) + "-" + anim, false);
        this.toFront();
        this.elementState = elementState;
        return entry;
    }

    public void endOfRound() {
        if (this.elementState == ElementState.strong) {
            this.setState(ElementState.waning, "strong-waning");
        } else if (this.elementState == ElementState.waning) {
            this.setState(ElementState.inert, "waning-inert");
        }
    }

    public void consume() {
        this.setState(ElementState.inert, "strong-inert");
    }

    public void infuse() {
        this.setState(ElementState.strong, "inert-strong");
    }

    protected void clicked(ElementState elementState) {
    }
}

