/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.Null;
import com.badlogic.gdx.utils.ObjectSet;
import com.esotericsoftware.spine.Bone;
import com.esotericsoftware.spine.Event;
import com.esotericsoftware.spine.IkConstraint;
import com.esotericsoftware.spine.PathConstraint;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.Slot;
import com.esotericsoftware.spine.TransformConstraint;
import com.esotericsoftware.spine.TransformConstraintData;
import com.esotericsoftware.spine.attachments.Attachment;
import com.esotericsoftware.spine.attachments.VertexAttachment;
import com.esotericsoftware.spine.utils.SpineUtils;

public class Animation {
    final String name;
    Array<Timeline> timelines;
    final ObjectSet<String> timelineIds = new ObjectSet();
    float duration;

    public Animation(String name, Array<Timeline> timelines, float duration) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null.");
        }
        this.name = name;
        this.duration = duration;
        this.setTimelines(timelines);
    }

    public Array<Timeline> getTimelines() {
        return this.timelines;
    }

    public void setTimelines(Array<Timeline> timelines) {
        if (timelines == null) {
            throw new IllegalArgumentException("timelines cannot be null.");
        }
        this.timelines = timelines;
        this.timelineIds.clear();
        T[] items = timelines.items;
        int i = 0;
        int n = timelines.size;
        while (i < n) {
            this.timelineIds.addAll((String[])((Timeline)items[i]).getPropertyIds());
            ++i;
        }
    }

    public boolean hasTimeline(String[] propertyIds) {
        String[] stringArray = propertyIds;
        int n = propertyIds.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (this.timelineIds.contains(id)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public float getDuration() {
        return this.duration;
    }

    public void setDuration(float duration) {
        this.duration = duration;
    }

    public void apply(Skeleton skeleton, float lastTime, float time, boolean loop, @Null Array<Event> events, float alpha, MixBlend blend, MixDirection direction) {
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        if (loop && this.duration != 0.0f) {
            time %= this.duration;
            if (lastTime > 0.0f) {
                lastTime %= this.duration;
            }
        }
        T[] timelines = this.timelines.items;
        int i = 0;
        int n = this.timelines.size;
        while (i < n) {
            ((Timeline)timelines[i]).apply(skeleton, lastTime, time, events, alpha, blend, direction);
            ++i;
        }
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    static int search(float[] frames, float time) {
        int n = frames.length;
        int i = 1;
        while (i < n) {
            if (frames[i] > time) {
                return i - 1;
            }
            ++i;
        }
        return n - 1;
    }

    static int search(float[] frames, float time, int step) {
        int n = frames.length;
        int i = step;
        while (i < n) {
            if (frames[i] > time) {
                return i - step;
            }
            i += step;
        }
        return n - step;
    }

    public static class AttachmentTimeline
    extends Timeline
    implements SlotTimeline {
        final int slotIndex;
        final String[] attachmentNames;

        public AttachmentTimeline(int frameCount, int slotIndex) {
            super(frameCount, String.valueOf(Property.attachment.ordinal()) + "|" + slotIndex);
            this.slotIndex = slotIndex;
            this.attachmentNames = new String[frameCount];
        }

        @Override
        public int getSlotIndex() {
            return this.slotIndex;
        }

        public String[] getAttachmentNames() {
            return this.attachmentNames;
        }

        public void setFrame(int frame, float time, String attachmentName) {
            this.frames[frame] = time;
            this.attachmentNames[frame] = attachmentName;
        }

        @Override
        public void apply(Skeleton skeleton, float lastTime, float time, @Null Array<Event> events, float alpha, MixBlend blend, MixDirection direction) {
            Slot slot = skeleton.slots.get(this.slotIndex);
            if (!slot.bone.active) {
                return;
            }
            if (direction == MixDirection.out) {
                if (blend == MixBlend.setup) {
                    this.setAttachment(skeleton, slot, slot.data.attachmentName);
                }
                return;
            }
            float[] frames = this.frames;
            if (time < frames[0]) {
                if (blend == MixBlend.setup || blend == MixBlend.first) {
                    this.setAttachment(skeleton, slot, slot.data.attachmentName);
                }
                return;
            }
            this.setAttachment(skeleton, slot, this.attachmentNames[Animation.search(frames, time)]);
        }

        private void setAttachment(Skeleton skeleton, Slot slot, String attachmentName) {
            slot.setAttachment(attachmentName == null ? null : skeleton.getAttachment(this.slotIndex, attachmentName));
        }
    }

    public static interface BoneTimeline {
        public int getBoneIndex();
    }

    public static class ColorTimeline
    extends CurveTimeline
    implements SlotTimeline {
        public static final int ENTRIES = 5;
        private static final int R = 1;
        private static final int G = 2;
        private static final int B = 3;
        private static final int A = 4;
        final int slotIndex;

        public ColorTimeline(int frameCount, int bezierCount, int slotIndex) {
            super(frameCount, bezierCount, String.valueOf(Property.rgba.ordinal()) + "|" + slotIndex);
            this.slotIndex = slotIndex;
        }

        @Override
        public int getFrameEntries() {
            return 5;
        }

        @Override
        public int getSlotIndex() {
            return this.slotIndex;
        }

        public void setFrame(int frame, float time, float r, float g, float b, float a) {
            this.frames[frame *= 5] = time;
            this.frames[frame + 1] = r;
            this.frames[frame + 2] = g;
            this.frames[frame + 3] = b;
            this.frames[frame + 4] = a;
        }

        @Override
        public void apply(Skeleton skeleton, float lastTime, float time, @Null Array<Event> events, float alpha, MixBlend blend, MixDirection direction) {
            float a;
            float b;
            float g;
            float r;
            Slot slot = skeleton.slots.get(this.slotIndex);
            if (!slot.bone.active) {
                return;
            }
            float[] frames = this.frames;
            if (time < frames[0]) {
                switch (blend) {
                    case setup: {
                        slot.color.set(slot.data.color);
                        return;
                    }
                    case first: {
                        Color color = slot.color;
                        Color setup = slot.data.color;
                        color.add((setup.r - color.r) * alpha, (setup.g - color.g) * alpha, (setup.b - color.b) * alpha, (setup.a - color.a) * alpha);
                    }
                }
                return;
            }
            int i = Animation.search(frames, time, 5);
            int curveType = (int)this.curves[i / 5];
            switch (curveType) {
                case 0: {
                    float before = frames[i];
                    r = frames[i + 1];
                    g = frames[i + 2];
                    b = frames[i + 3];
                    a = frames[i + 4];
                    float t = (time - before) / (frames[i + 5] - before);
                    r += (frames[i + 5 + 1] - r) * t;
                    g += (frames[i + 5 + 2] - g) * t;
                    b += (frames[i + 5 + 3] - b) * t;
                    a += (frames[i + 5 + 4] - a) * t;
                    break;
                }
                case 1: {
                    r = frames[i + 1];
                    g = frames[i + 2];
                    b = frames[i + 3];
                    a = frames[i + 4];
                    break;
                }
                default: {
                    r = this.getBezierValue(time, i, 1, curveType - 2);
                    g = this.getBezierValue(time, i, 2, curveType + 18 - 2);
                    b = this.getBezierValue(time, i, 3, curveType + 36 - 2);
                    a = this.getBezierValue(time, i, 4, curveType + 54 - 2);
                }
            }
            if (alpha == 1.0f) {
                slot.color.set(r, g, b, a);
            } else {
                Color color = slot.color;
                if (blend == MixBlend.setup) {
                    color.set(slot.data.color);
                }
                color.add((r - color.r) * alpha, (g - color.g) * alpha, (b - color.b) * alpha, (a - color.a) * alpha);
            }
        }
    }

    public static abstract class CurveTimeline
    extends Timeline {
        public static final int LINEAR = 0;
        public static final int STEPPED = 1;
        public static final int BEZIER = 2;
        public static final int BEZIER_SIZE = 18;
        float[] curves;

        public CurveTimeline(int frameCount, int bezierCount, String ... propertyIds) {
            super(frameCount, propertyIds);
            this.curves = new float[frameCount + bezierCount * 18];
            this.curves[frameCount - 1] = 1.0f;
        }

        public void setLinear(int frame) {
            this.curves[frame] = 0.0f;
        }

        public void setStepped(int frame) {
            this.curves[frame] = 1.0f;
        }

        public int getCurveType(int frame) {
            return (int)this.curves[frame];
        }

        public void shrink(int bezierCount) {
            int size = this.getFrameCount() + bezierCount * 18;
            if (this.curves.length > size) {
                float[] newCurves = new float[size];
                SpineUtils.arraycopy(this.curves, 0, newCurves, 0, size);
                this.curves = newCurves;
            }
        }

        public void setBezier(int bezier, int frame, int value, float time1, float value1, float cx1, float cy1, float cx2, float cy2, float time2, float value2) {
            float[] curves = this.curves;
            int i = this.getFrameCount() + bezier * 18;
            if (value == 0) {
                curves[frame] = 2 + i;
            }
            float tmpx = (time1 - cx1 * 2.0f + cx2) * 0.03f;
            float tmpy = (value1 - cy1 * 2.0f + cy2) * 0.03f;
            float dddx = ((cx1 - cx2) * 3.0f - time1 + time2) * 0.006f;
            float dddy = ((cy1 - cy2) * 3.0f - value1 + value2) * 0.006f;
            float ddx = tmpx * 2.0f + dddx;
            float ddy = tmpy * 2.0f + dddy;
            float dx = (cx1 - time1) * 0.3f + tmpx + dddx * 0.16666667f;
            float dy = (cy1 - value1) * 0.3f + tmpy + dddy * 0.16666667f;
            float x = time1 + dx;
            float y = value1 + dy;
            int n = i + 18;
            while (i < n) {
                curves[i] = x;
                curves[i + 1] = y;
                x += (dx += (ddx += dddx));
                y += (dy += (ddy += dddy));
                i += 2;
            }
        }

        public float getBezierValue(float time, int frameIndex, int valueOffset, int i) {
            float[] curves = this.curves;
            if (curves[i] > time) {
                float x = this.frames[frameIndex];
                float y = this.frames[frameIndex + valueOffset];
                return y + (time - x) / (curves[i] - x) * (curves[i + 1] - y);
            }
            int n = i + 18;
            i += 2;
            while (i < n) {
                if (curves[i] >= time) {
                    float x = curves[i - 2];
                    float y = curves[i - 1];
                    return y + (time - x) / (curves[i] - x) * (curves[i + 1] - y);
                }
                i += 2;
            }
            float x = curves[n - 2];
            float y = curves[n - 1];
            return y + (time - x) / (this.frames[frameIndex += this.getFrameEntries()] - x) * (this.frames[frameIndex + valueOffset] - y);
        }
    }

    public static abstract class CurveTimeline1
    extends CurveTimeline {
        public static final int ENTRIES = 2;
        static final int VALUE = 1;

        public CurveTimeline1(int frameCount, int bezierCount, String ... propertyIds) {
            super(frameCount, bezierCount, propertyIds);
        }

        @Override
        public int getFrameEntries() {
            return 2;
        }

        public void setFrame(int frame, float time, float value) {
            this.frames[frame <<= 1] = time;
            this.frames[frame + 1] = value;
        }

        public float getCurveValue(float time) {
            float[] frames = this.frames;
            int i = frames.length - 2;
            int ii = 2;
            while (ii <= i) {
                if (frames[ii] > time) {
                    i = ii - 2;
                    break;
                }
                ii += 2;
            }
            int curveType = (int)this.curves[i >> 1];
            switch (curveType) {
                case 0: {
                    float before = frames[i];
                    float value = frames[i + 1];
                    return value + (time - before) / (frames[i + 2] - before) * (frames[i + 2 + 1] - value);
                }
                case 1: {
                    return frames[i + 1];
                }
            }
            return this.getBezierValue(time, i, 1, curveType - 2);
        }
    }

    public static abstract class CurveTimeline2
    extends CurveTimeline {
        public static final int ENTRIES = 3;
        static final int VALUE1 = 1;
        static final int VALUE2 = 2;

        public CurveTimeline2(int frameCount, int bezierCount, String ... propertyIds) {
            super(frameCount, bezierCount, propertyIds);
        }

        @Override
        public int getFrameEntries() {
            return 3;
        }

        public void setFrame(int frame, float time, float value1, float value2) {
            this.frames[frame *= 3] = time;
            this.frames[frame + 1] = value1;
            this.frames[frame + 2] = value2;
        }
    }

    public static class DeformTimeline
    extends CurveTimeline
    implements SlotTimeline {
        final int slotIndex;
        final VertexAttachment attachment;
        private final float[][] vertices;

        public DeformTimeline(int frameCount, int bezierCount, int slotIndex, VertexAttachment attachment) {
            super(frameCount, bezierCount, String.valueOf(Property.deform.ordinal()) + "|" + slotIndex + "|" + attachment.getId());
            this.slotIndex = slotIndex;
            this.attachment = attachment;
            this.vertices = new float[frameCount][];
        }

        @Override
        public int getSlotIndex() {
            return this.slotIndex;
        }

        public VertexAttachment getAttachment() {
            return this.attachment;
        }

        public float[][] getVertices() {
            return this.vertices;
        }

        public void setFrame(int frame, float time, float[] vertices) {
            this.frames[frame] = time;
            this.vertices[frame] = vertices;
        }

        @Override
        public void setBezier(int bezier, int frame, int value, float time1, float value1, float cx1, float cy1, float cx2, float cy2, float time2, float value2) {
            float[] curves = this.curves;
            int i = this.getFrameCount() + bezier * 18;
            if (value == 0) {
                curves[frame] = 2 + i;
            }
            float tmpx = (time1 - cx1 * 2.0f + cx2) * 0.03f;
            float tmpy = cy2 * 0.03f - cy1 * 0.06f;
            float dddx = ((cx1 - cx2) * 3.0f - time1 + time2) * 0.006f;
            float dddy = (cy1 - cy2 + 0.33333334f) * 0.018f;
            float ddx = tmpx * 2.0f + dddx;
            float ddy = tmpy * 2.0f + dddy;
            float dx = (cx1 - time1) * 0.3f + tmpx + dddx * 0.16666667f;
            float dy = cy1 * 0.3f + tmpy + dddy * 0.16666667f;
            float x = time1 + dx;
            float y = dy;
            int n = i + 18;
            while (i < n) {
                curves[i] = x;
                curves[i + 1] = y;
                x += (dx += (ddx += dddx));
                y += (dy += (ddy += dddy));
                i += 2;
            }
        }

        private float getCurvePercent(float time, int frame) {
            float[] curves = this.curves;
            int i = (int)curves[frame];
            switch (i) {
                case 0: {
                    float x = this.frames[frame];
                    return (time - x) / (this.frames[frame + this.getFrameEntries()] - x);
                }
                case 1: {
                    return 0.0f;
                }
            }
            i -= 2;
            if (curves[i] > time) {
                float x = this.frames[frame];
                return curves[i + 1] * (time - x) / (curves[i] - x);
            }
            int n = i + 18;
            i += 2;
            while (i < n) {
                if (curves[i] >= time) {
                    float x = curves[i - 2];
                    float y = curves[i - 1];
                    return y + (time - x) / (curves[i] - x) * (curves[i + 1] - y);
                }
                i += 2;
            }
            float x = curves[n - 2];
            float y = curves[n - 1];
            return y + (1.0f - y) * (time - x) / (this.frames[frame + this.getFrameEntries()] - x);
        }

        @Override
        public void apply(Skeleton skeleton, float lastTime, float time, @Null Array<Event> events, float alpha, MixBlend blend, MixDirection direction) {
            Slot slot = skeleton.slots.get(this.slotIndex);
            if (!slot.bone.active) {
                return;
            }
            Attachment slotAttachment = slot.attachment;
            if (!(slotAttachment instanceof VertexAttachment) || ((VertexAttachment)slotAttachment).getDeformAttachment() != this.attachment) {
                return;
            }
            FloatArray deformArray = slot.getDeform();
            if (deformArray.size == 0) {
                blend = MixBlend.setup;
            }
            float[][] vertices = this.vertices;
            int vertexCount = vertices[0].length;
            float[] frames = this.frames;
            if (time < frames[0]) {
                VertexAttachment vertexAttachment = (VertexAttachment)slotAttachment;
                switch (blend) {
                    case setup: {
                        deformArray.clear();
                        return;
                    }
                    case first: {
                        if (alpha == 1.0f) {
                            deformArray.clear();
                            return;
                        }
                        float[] deform = deformArray.setSize(vertexCount);
                        if (vertexAttachment.getBones() == null) {
                            float[] setupVertices = vertexAttachment.getVertices();
                            int i = 0;
                            while (i < vertexCount) {
                                int n = i;
                                deform[n] = deform[n] + (setupVertices[i] - deform[i]) * alpha;
                                ++i;
                            }
                        } else {
                            alpha = 1.0f - alpha;
                            int i = 0;
                            while (i < vertexCount) {
                                int n = i++;
                                deform[n] = deform[n] * alpha;
                            }
                        }
                        break;
                    }
                }
                return;
            }
            float[] deform = deformArray.setSize(vertexCount);
            if (time >= frames[frames.length - 1]) {
                float[] lastVertices = vertices[frames.length - 1];
                if (alpha == 1.0f) {
                    if (blend == MixBlend.add) {
                        VertexAttachment vertexAttachment = (VertexAttachment)slotAttachment;
                        if (vertexAttachment.getBones() == null) {
                            float[] setupVertices = vertexAttachment.getVertices();
                            int i = 0;
                            while (i < vertexCount) {
                                int n = i;
                                deform[n] = deform[n] + (lastVertices[i] - setupVertices[i]);
                                ++i;
                            }
                        } else {
                            int i = 0;
                            while (i < vertexCount) {
                                int n = i;
                                deform[n] = deform[n] + lastVertices[i];
                                ++i;
                            }
                        }
                    } else {
                        SpineUtils.arraycopy(lastVertices, 0, deform, 0, vertexCount);
                    }
                } else {
                    switch (blend) {
                        case setup: {
                            VertexAttachment vertexAttachment = (VertexAttachment)slotAttachment;
                            if (vertexAttachment.getBones() == null) {
                                float[] setupVertices = vertexAttachment.getVertices();
                                int i = 0;
                                while (i < vertexCount) {
                                    float setup = setupVertices[i];
                                    deform[i] = setup + (lastVertices[i] - setup) * alpha;
                                    ++i;
                                }
                            } else {
                                int i = 0;
                                while (i < vertexCount) {
                                    deform[i] = lastVertices[i] * alpha;
                                    ++i;
                                }
                            }
                            break;
                        }
                        case first: 
                        case replace: {
                            int i = 0;
                            while (i < vertexCount) {
                                int n = i;
                                deform[n] = deform[n] + (lastVertices[i] - deform[i]) * alpha;
                                ++i;
                            }
                            break;
                        }
                        case add: {
                            VertexAttachment vertexAttachment = (VertexAttachment)slotAttachment;
                            if (vertexAttachment.getBones() == null) {
                                float[] setupVertices = vertexAttachment.getVertices();
                                int i = 0;
                                while (i < vertexCount) {
                                    int n = i;
                                    deform[n] = deform[n] + (lastVertices[i] - setupVertices[i]) * alpha;
                                    ++i;
                                }
                            } else {
                                int i = 0;
                                while (i < vertexCount) {
                                    int n = i;
                                    deform[n] = deform[n] + lastVertices[i] * alpha;
                                    ++i;
                                }
                            }
                            break;
                        }
                    }
                }
                return;
            }
            int frame = Animation.search(frames, time);
            float percent = this.getCurvePercent(time, frame);
            float[] prevVertices = vertices[frame];
            float[] nextVertices = vertices[frame + 1];
            if (alpha == 1.0f) {
                if (blend == MixBlend.add) {
                    VertexAttachment vertexAttachment = (VertexAttachment)slotAttachment;
                    if (vertexAttachment.getBones() == null) {
                        float[] setupVertices = vertexAttachment.getVertices();
                        int i = 0;
                        while (i < vertexCount) {
                            float prev = prevVertices[i];
                            int n = i;
                            deform[n] = deform[n] + (prev + (nextVertices[i] - prev) * percent - setupVertices[i]);
                            ++i;
                        }
                    } else {
                        int i = 0;
                        while (i < vertexCount) {
                            float prev = prevVertices[i];
                            int n = i;
                            deform[n] = deform[n] + (prev + (nextVertices[i] - prev) * percent);
                            ++i;
                        }
                    }
                } else {
                    int i = 0;
                    while (i < vertexCount) {
                        float prev = prevVertices[i];
                        deform[i] = prev + (nextVertices[i] - prev) * percent;
                        ++i;
                    }
                }
            } else {
                switch (blend) {
                    case setup: {
                        VertexAttachment vertexAttachment = (VertexAttachment)slotAttachment;
                        if (vertexAttachment.getBones() == null) {
                            float[] setupVertices = vertexAttachment.getVertices();
                            int i = 0;
                            while (i < vertexCount) {
                                float prev = prevVertices[i];
                                float setup = setupVertices[i];
                                deform[i] = setup + (prev + (nextVertices[i] - prev) * percent - setup) * alpha;
                                ++i;
                            }
                        } else {
                            int i = 0;
                            while (i < vertexCount) {
                                float prev = prevVertices[i];
                                deform[i] = (prev + (nextVertices[i] - prev) * percent) * alpha;
                                ++i;
                            }
                        }
                        break;
                    }
                    case first: 
                    case replace: {
                        int i = 0;
                        while (i < vertexCount) {
                            float prev = prevVertices[i];
                            int n = i;
                            deform[n] = deform[n] + (prev + (nextVertices[i] - prev) * percent - deform[i]) * alpha;
                            ++i;
                        }
                        break;
                    }
                    case add: {
                        VertexAttachment vertexAttachment = (VertexAttachment)slotAttachment;
                        if (vertexAttachment.getBones() == null) {
                            float[] setupVertices = vertexAttachment.getVertices();
                            int i = 0;
                            while (i < vertexCount) {
                                float prev = prevVertices[i];
                                int n = i;
                                deform[n] = deform[n] + (prev + (nextVertices[i] - prev) * percent - setupVertices[i]) * alpha;
                                ++i;
                            }
                        } else {
                            int i = 0;
                            while (i < vertexCount) {
                                float prev = prevVertices[i];
                                int n = i;
                                deform[n] = deform[n] + (prev + (nextVertices[i] - prev) * percent) * alpha;
                                ++i;
                            }
                        }
                        break;
                    }
                }
            }
        }
    }

    public static class DrawOrderTimeline
    extends Timeline {
        private static final String[] propertyIds = new String[]{Integer.toString(Property.drawOrder.ordinal())};
        private final int[][] drawOrders;

        public DrawOrderTimeline(int frameCount) {
            super(frameCount, propertyIds);
            this.drawOrders = new int[frameCount][];
        }

        public int[][] getDrawOrders() {
            return this.drawOrders;
        }

        public void setFrame(int frame, float time, @Null int[] drawOrder) {
            this.frames[frame] = time;
            this.drawOrders[frame] = drawOrder;
        }

        @Override
        public void apply(Skeleton skeleton, float lastTime, float time, @Null Array<Event> events, float alpha, MixBlend blend, MixDirection direction) {
            T[] drawOrder = skeleton.drawOrder.items;
            if (direction == MixDirection.out) {
                if (blend == MixBlend.setup) {
                    SpineUtils.arraycopy(skeleton.slots.items, 0, drawOrder, 0, skeleton.slots.size);
                }
                return;
            }
            float[] frames = this.frames;
            if (time < frames[0]) {
                if (blend == MixBlend.setup || blend == MixBlend.first) {
                    SpineUtils.arraycopy(skeleton.slots.items, 0, drawOrder, 0, skeleton.slots.size);
                }
                return;
            }
            int[] drawOrderToSetupIndex = this.drawOrders[Animation.search(frames, time)];
            if (drawOrderToSetupIndex == null) {
                SpineUtils.arraycopy(skeleton.slots.items, 0, drawOrder, 0, skeleton.slots.size);
            } else {
                T[] slots = skeleton.slots.items;
                int i = 0;
                int n = drawOrderToSetupIndex.length;
                while (i < n) {
                    drawOrder[i] = slots[drawOrderToSetupIndex[i]];
                    ++i;
                }
            }
        }
    }

    public static class EventTimeline
    extends Timeline {
        private static final String[] propertyIds = new String[]{Integer.toString(Property.event.ordinal())};
        private final Event[] events;

        public EventTimeline(int frameCount) {
            super(frameCount, propertyIds);
            this.events = new Event[frameCount];
        }

        public Event[] getEvents() {
            return this.events;
        }

        public void setFrame(int frame, Event event) {
            this.frames[frame] = event.time;
            this.events[frame] = event;
        }

        @Override
        public void apply(Skeleton skeleton, float lastTime, float time, @Null Array<Event> firedEvents, float alpha, MixBlend blend, MixDirection direction) {
            int i;
            if (firedEvents == null) {
                return;
            }
            float[] frames = this.frames;
            int frameCount = frames.length;
            if (lastTime > time) {
                this.apply(skeleton, lastTime, 2.1474836E9f, firedEvents, alpha, blend, direction);
                lastTime = -1.0f;
            } else if (lastTime >= frames[frameCount - 1]) {
                return;
            }
            if (time < frames[0]) {
                return;
            }
            if (lastTime < frames[0]) {
                i = 0;
            } else {
                i = Animation.search(frames, lastTime) + 1;
                float frameTime = frames[i];
                while (i > 0) {
                    if (frames[i - 1] != frameTime) break;
                    --i;
                }
            }
            while (i < frameCount && time >= frames[i]) {
                firedEvents.add(this.events[i]);
                ++i;
            }
        }
    }

    public static class IkConstraintTimeline
    extends CurveTimeline {
        public static final int ENTRIES = 6;
        private static final int MIX = 1;
        private static final int SOFTNESS = 2;
        private static final int BEND_DIRECTION = 3;
        private static final int COMPRESS = 4;
        private static final int STRETCH = 5;
        final int ikConstraintIndex;

        public IkConstraintTimeline(int frameCount, int bezierCount, int ikConstraintIndex) {
            super(frameCount, bezierCount, String.valueOf(Property.ikConstraint.ordinal()) + "|" + ikConstraintIndex);
            this.ikConstraintIndex = ikConstraintIndex;
        }

        @Override
        public int getFrameEntries() {
            return 6;
        }

        public int getIkConstraintIndex() {
            return this.ikConstraintIndex;
        }

        public void setFrame(int frame, float time, float mix, float softness, int bendDirection, boolean compress, boolean stretch) {
            this.frames[frame *= 6] = time;
            this.frames[frame + 1] = mix;
            this.frames[frame + 2] = softness;
            this.frames[frame + 3] = bendDirection;
            this.frames[frame + 4] = compress ? 1 : 0;
            this.frames[frame + 5] = stretch ? 1 : 0;
        }

        @Override
        public void apply(Skeleton skeleton, float lastTime, float time, @Null Array<Event> events, float alpha, MixBlend blend, MixDirection direction) {
            float softness;
            float mix;
            IkConstraint constraint = skeleton.ikConstraints.get(this.ikConstraintIndex);
            if (!constraint.active) {
                return;
            }
            float[] frames = this.frames;
            if (time < frames[0]) {
                switch (blend) {
                    case setup: {
                        constraint.mix = constraint.data.mix;
                        constraint.softness = constraint.data.softness;
                        constraint.bendDirection = constraint.data.bendDirection;
                        constraint.compress = constraint.data.compress;
                        constraint.stretch = constraint.data.stretch;
                        return;
                    }
                    case first: {
                        constraint.mix += (constraint.data.mix - constraint.mix) * alpha;
                        constraint.softness += (constraint.data.softness - constraint.softness) * alpha;
                        constraint.bendDirection = constraint.data.bendDirection;
                        constraint.compress = constraint.data.compress;
                        constraint.stretch = constraint.data.stretch;
                    }
                }
                return;
            }
            int i = Animation.search(frames, time, 6);
            int curveType = (int)this.curves[i / 6];
            switch (curveType) {
                case 0: {
                    float before = frames[i];
                    mix = frames[i + 1];
                    softness = frames[i + 2];
                    float t = (time - before) / (frames[i + 6] - before);
                    mix += (frames[i + 6 + 1] - mix) * t;
                    softness += (frames[i + 6 + 2] - softness) * t;
                    break;
                }
                case 1: {
                    mix = frames[i + 1];
                    softness = frames[i + 2];
                    break;
                }
                default: {
                    mix = this.getBezierValue(time, i, 1, curveType - 2);
                    softness = this.getBezierValue(time, i, 2, curveType + 18 - 2);
                }
            }
            if (blend == MixBlend.setup) {
                constraint.mix = constraint.data.mix + (mix - constraint.data.mix) * alpha;
                constraint.softness = constraint.data.softness + (softness - constraint.data.softness) * alpha;
                if (direction == MixDirection.out) {
                    constraint.bendDirection = constraint.data.bendDirection;
                    constraint.compress = constraint.data.compress;
                    constraint.stretch = constraint.data.stretch;
                } else {
                    constraint.bendDirection = (int)frames[i + 3];
                    constraint.compress = frames[i + 4] != 0.0f;
                    constraint.stretch = frames[i + 5] != 0.0f;
                }
            } else {
                constraint.mix += (mix - constraint.mix) * alpha;
                constraint.softness += (softness - constraint.softness) * alpha;
                if (direction == MixDirection.in) {
                    constraint.bendDirection = (int)frames[i + 3];
                    constraint.compress = frames[i + 4] != 0.0f;
                    constraint.stretch = frames[i + 5] != 0.0f;
                }
            }
        }
    }

    public static enum MixBlend {
        setup,
        first,
        replace,
        add;

    }

    public static enum MixDirection {
        in,
        out;

    }

    public static class PathConstraintMixTimeline
    extends CurveTimeline2 {
        final int pathConstraintIndex;

        public PathConstraintMixTimeline(int frameCount, int bezierCount, int pathConstraintIndex) {
            super(frameCount, bezierCount, String.valueOf(Property.pathConstraintMix.ordinal()) + "|" + pathConstraintIndex);
            this.pathConstraintIndex = pathConstraintIndex;
        }

        public int getPathConstraintIndex() {
            return this.pathConstraintIndex;
        }

        @Override
        public void apply(Skeleton skeleton, float lastTime, float time, @Null Array<Event> events, float alpha, MixBlend blend, MixDirection direction) {
            float translate;
            float rotate;
            PathConstraint constraint = skeleton.pathConstraints.get(this.pathConstraintIndex);
            if (!constraint.active) {
                return;
            }
            float[] frames = this.frames;
            if (time < frames[0]) {
                switch (blend) {
                    case setup: {
                        constraint.rotateMix = constraint.data.rotateMix;
                        constraint.translateMix = constraint.data.translateMix;
                        return;
                    }
                    case first: {
                        constraint.rotateMix += (constraint.data.rotateMix - constraint.rotateMix) * alpha;
                        constraint.translateMix += (constraint.data.translateMix - constraint.translateMix) * alpha;
                    }
                }
                return;
            }
            int i = Animation.search(frames, time, 3);
            int curveType = (int)this.curves[i / 3];
            switch (curveType) {
                case 0: {
                    float before = frames[i];
                    rotate = frames[i + 1];
                    translate = frames[i + 2];
                    float t = (time - before) / (frames[i + 3] - before);
                    rotate += (frames[i + 3 + 1] - rotate) * t;
                    translate += (frames[i + 3 + 2] - translate) * t;
                    break;
                }
                case 1: {
                    rotate = frames[i + 1];
                    translate = frames[i + 2];
                    break;
                }
                default: {
                    rotate = this.getBezierValue(time, i, 1, curveType - 2);
                    translate = this.getBezierValue(time, i, 2, curveType + 18 - 2);
                }
            }
            if (blend == MixBlend.setup) {
                constraint.rotateMix = constraint.data.rotateMix + (rotate - constraint.data.rotateMix) * alpha;
                constraint.translateMix = constraint.data.translateMix + (translate - constraint.data.translateMix) * alpha;
            } else {
                constraint.rotateMix += (rotate - constraint.rotateMix) * alpha;
                constraint.translateMix += (translate - constraint.translateMix) * alpha;
            }
        }
    }

    public static class PathConstraintPositionTimeline
    extends CurveTimeline1 {
        final int pathConstraintIndex;

        public PathConstraintPositionTimeline(int frameCount, int bezierCount, int pathConstraintIndex) {
            super(frameCount, bezierCount, String.valueOf(Property.pathConstraintPosition.ordinal()) + "|" + pathConstraintIndex);
            this.pathConstraintIndex = pathConstraintIndex;
        }

        public int getPathConstraintIndex() {
            return this.pathConstraintIndex;
        }

        @Override
        public void apply(Skeleton skeleton, float lastTime, float time, @Null Array<Event> events, float alpha, MixBlend blend, MixDirection direction) {
            PathConstraint constraint = skeleton.pathConstraints.get(this.pathConstraintIndex);
            if (!constraint.active) {
                return;
            }
            if (time < this.frames[0]) {
                switch (blend) {
                    case setup: {
                        constraint.position = constraint.data.position;
                        return;
                    }
                    case first: {
                        constraint.position += (constraint.data.position - constraint.position) * alpha;
                    }
                }
                return;
            }
            float position = this.getCurveValue(time);
            constraint.position = blend == MixBlend.setup ? constraint.data.position + (position - constraint.data.position) * alpha : (constraint.position += (position - constraint.position) * alpha);
        }
    }

    public static class PathConstraintSpacingTimeline
    extends CurveTimeline1 {
        final int pathConstraintIndex;

        public PathConstraintSpacingTimeline(int frameCount, int bezierCount, int pathConstraintIndex) {
            super(frameCount, bezierCount, String.valueOf(Property.pathConstraintSpacing.ordinal()) + "|" + pathConstraintIndex);
            this.pathConstraintIndex = pathConstraintIndex;
        }

        public int getPathConstraintIndex() {
            return this.pathConstraintIndex;
        }

        @Override
        public void apply(Skeleton skeleton, float lastTime, float time, @Null Array<Event> events, float alpha, MixBlend blend, MixDirection direction) {
            PathConstraint constraint = skeleton.pathConstraints.get(this.pathConstraintIndex);
            if (!constraint.active) {
                return;
            }
            if (time < this.frames[0]) {
                switch (blend) {
                    case setup: {
                        constraint.spacing = constraint.data.spacing;
                        return;
                    }
                    case first: {
                        constraint.spacing += (constraint.data.spacing - constraint.spacing) * alpha;
                    }
                }
                return;
            }
            float spacing = this.getCurveValue(time);
            constraint.spacing = blend == MixBlend.setup ? constraint.data.spacing + (spacing - constraint.data.spacing) * alpha : (constraint.spacing += (spacing - constraint.spacing) * alpha);
        }
    }

    static enum Property {
        rotate,
        translateX,
        translateY,
        scaleX,
        scaleY,
        shearX,
        shearY,
        rgba,
        rgb2,
        attachment,
        deform,
        event,
        drawOrder,
        ikConstraint,
        transformConstraint,
        pathConstraintPosition,
        pathConstraintSpacing,
        pathConstraintMix;

    }

    public static class RotateTimeline
    extends CurveTimeline1
    implements BoneTimeline {
        final int boneIndex;

        public RotateTimeline(int frameCount, int bezierCount, int boneIndex) {
            super(frameCount, bezierCount, String.valueOf(Property.rotate.ordinal()) + "|" + boneIndex);
            this.boneIndex = boneIndex;
        }

        @Override
        public int getBoneIndex() {
            return this.boneIndex;
        }

        @Override
        public void apply(Skeleton skeleton, float lastTime, float time, @Null Array<Event> events, float alpha, MixBlend blend, MixDirection direction) {
            Bone bone = skeleton.bones.get(this.boneIndex);
            if (!bone.active) {
                return;
            }
            if (time < this.frames[0]) {
                switch (blend) {
                    case setup: {
                        bone.rotation = bone.data.rotation;
                        return;
                    }
                    case first: {
                        bone.rotation += (bone.data.rotation - bone.rotation) * alpha;
                    }
                }
                return;
            }
            float r = this.getCurveValue(time);
            switch (blend) {
                case setup: {
                    bone.rotation = bone.data.rotation + r * alpha;
                    break;
                }
                case first: 
                case replace: {
                    r += bone.data.rotation - bone.rotation;
                }
                case add: {
                    bone.rotation += r * alpha;
                }
            }
        }
    }

    public static class ScaleTimeline
    extends CurveTimeline2
    implements BoneTimeline {
        final int boneIndex;

        public ScaleTimeline(int frameCount, int bezierCount, int boneIndex) {
            super(frameCount, bezierCount, String.valueOf(Property.scaleX.ordinal()) + "|" + boneIndex, String.valueOf(Property.scaleY.ordinal()) + "|" + boneIndex);
            this.boneIndex = boneIndex;
        }

        @Override
        public int getBoneIndex() {
            return this.boneIndex;
        }

        @Override
        public void apply(Skeleton skeleton, float lastTime, float time, @Null Array<Event> events, float alpha, MixBlend blend, MixDirection direction) {
            float by;
            float bx;
            float y;
            float x;
            Bone bone = skeleton.bones.get(this.boneIndex);
            if (!bone.active) {
                return;
            }
            float[] frames = this.frames;
            if (time < frames[0]) {
                switch (blend) {
                    case setup: {
                        bone.scaleX = bone.data.scaleX;
                        bone.scaleY = bone.data.scaleY;
                        return;
                    }
                    case first: {
                        bone.scaleX += (bone.data.scaleX - bone.scaleX) * alpha;
                        bone.scaleY += (bone.data.scaleY - bone.scaleY) * alpha;
                    }
                }
                return;
            }
            int i = Animation.search(frames, time, 3);
            int curveType = (int)this.curves[i / 3];
            switch (curveType) {
                case 0: {
                    float before = frames[i];
                    x = frames[i + 1];
                    y = frames[i + 2];
                    float t = (time - before) / (frames[i + 3] - before);
                    x += (frames[i + 3 + 1] - x) * t;
                    y += (frames[i + 3 + 2] - y) * t;
                    break;
                }
                case 1: {
                    x = frames[i + 1];
                    y = frames[i + 2];
                    break;
                }
                default: {
                    x = this.getBezierValue(time, i, 1, curveType - 2);
                    y = this.getBezierValue(time, i, 2, curveType + 18 - 2);
                }
            }
            x *= bone.data.scaleX;
            y *= bone.data.scaleY;
            if (alpha == 1.0f) {
                if (blend == MixBlend.add) {
                    bone.scaleX += x - bone.data.scaleX;
                    bone.scaleY += y - bone.data.scaleY;
                } else {
                    bone.scaleX = x;
                    bone.scaleY = y;
                }
            } else if (direction == MixDirection.out) {
                switch (blend) {
                    case setup: {
                        bx = bone.data.scaleX;
                        by = bone.data.scaleY;
                        bone.scaleX = bx + (Math.abs(x) * Math.signum(bx) - bx) * alpha;
                        bone.scaleY = by + (Math.abs(y) * Math.signum(by) - by) * alpha;
                        break;
                    }
                    case first: 
                    case replace: {
                        bx = bone.scaleX;
                        by = bone.scaleY;
                        bone.scaleX = bx + (Math.abs(x) * Math.signum(bx) - bx) * alpha;
                        bone.scaleY = by + (Math.abs(y) * Math.signum(by) - by) * alpha;
                        break;
                    }
                    case add: {
                        bx = bone.scaleX;
                        by = bone.scaleY;
                        bone.scaleX = bx + (Math.abs(x) * Math.signum(bx) - bone.data.scaleX) * alpha;
                        bone.scaleY = by + (Math.abs(y) * Math.signum(by) - bone.data.scaleY) * alpha;
                    }
                }
            } else {
                switch (blend) {
                    case setup: {
                        bx = Math.abs(bone.data.scaleX) * Math.signum(x);
                        by = Math.abs(bone.data.scaleY) * Math.signum(y);
                        bone.scaleX = bx + (x - bx) * alpha;
                        bone.scaleY = by + (y - by) * alpha;
                        break;
                    }
                    case first: 
                    case replace: {
                        bx = Math.abs(bone.scaleX) * Math.signum(x);
                        by = Math.abs(bone.scaleY) * Math.signum(y);
                        bone.scaleX = bx + (x - bx) * alpha;
                        bone.scaleY = by + (y - by) * alpha;
                        break;
                    }
                    case add: {
                        bx = Math.signum(x);
                        by = Math.signum(y);
                        bone.scaleX = Math.abs(bone.scaleX) * bx + (x - Math.abs(bone.data.scaleX) * bx) * alpha;
                        bone.scaleY = Math.abs(bone.scaleY) * by + (y - Math.abs(bone.data.scaleY) * by) * alpha;
                    }
                }
            }
        }
    }

    public static class ShearTimeline
    extends CurveTimeline2
    implements BoneTimeline {
        final int boneIndex;

        public ShearTimeline(int frameCount, int bezierCount, int boneIndex) {
            super(frameCount, bezierCount, String.valueOf(Property.shearX.ordinal()) + "|" + boneIndex, String.valueOf(Property.shearY.ordinal()) + "|" + boneIndex);
            this.boneIndex = boneIndex;
        }

        @Override
        public int getBoneIndex() {
            return this.boneIndex;
        }

        @Override
        public void apply(Skeleton skeleton, float lastTime, float time, @Null Array<Event> events, float alpha, MixBlend blend, MixDirection direction) {
            float y;
            float x;
            Bone bone = skeleton.bones.get(this.boneIndex);
            if (!bone.active) {
                return;
            }
            float[] frames = this.frames;
            if (time < frames[0]) {
                switch (blend) {
                    case setup: {
                        bone.shearX = bone.data.shearX;
                        bone.shearY = bone.data.shearY;
                        return;
                    }
                    case first: {
                        bone.shearX += (bone.data.shearX - bone.shearX) * alpha;
                        bone.shearY += (bone.data.shearY - bone.shearY) * alpha;
                    }
                }
                return;
            }
            int i = Animation.search(frames, time, 3);
            int curveType = (int)this.curves[i / 3];
            switch (curveType) {
                case 0: {
                    float before = frames[i];
                    x = frames[i + 1];
                    y = frames[i + 2];
                    float t = (time - before) / (frames[i + 3] - before);
                    x += (frames[i + 3 + 1] - x) * t;
                    y += (frames[i + 3 + 2] - y) * t;
                    break;
                }
                case 1: {
                    x = frames[i + 1];
                    y = frames[i + 2];
                    break;
                }
                default: {
                    x = this.getBezierValue(time, i, 1, curveType - 2);
                    y = this.getBezierValue(time, i, 2, curveType + 18 - 2);
                }
            }
            switch (blend) {
                case setup: {
                    bone.shearX = bone.data.shearX + x * alpha;
                    bone.shearY = bone.data.shearY + y * alpha;
                    break;
                }
                case first: 
                case replace: {
                    bone.shearX += (bone.data.shearX + x - bone.shearX) * alpha;
                    bone.shearY += (bone.data.shearY + y - bone.shearY) * alpha;
                    break;
                }
                case add: {
                    bone.shearX += x * alpha;
                    bone.shearY += y * alpha;
                }
            }
        }
    }

    public static interface SlotTimeline {
        public int getSlotIndex();
    }

    public static abstract class Timeline {
        private final String[] propertyIds;
        final float[] frames;

        public Timeline(int frameCount, String ... propertyIds) {
            if (propertyIds == null) {
                throw new IllegalArgumentException("propertyIds cannot be null.");
            }
            this.propertyIds = propertyIds;
            this.frames = new float[frameCount * this.getFrameEntries()];
        }

        public String[] getPropertyIds() {
            return this.propertyIds;
        }

        public float[] getFrames() {
            return this.frames;
        }

        public int getFrameEntries() {
            return 1;
        }

        public int getFrameCount() {
            return this.frames.length / this.getFrameEntries();
        }

        public float getDuration() {
            return this.frames[this.frames.length - this.getFrameEntries()];
        }

        public abstract void apply(Skeleton var1, float var2, float var3, @Null Array<Event> var4, float var5, MixBlend var6, MixDirection var7);
    }

    public static class TransformConstraintTimeline
    extends CurveTimeline {
        public static final int ENTRIES = 5;
        private static final int ROTATE = 1;
        private static final int TRANSLATE = 2;
        private static final int SCALE = 3;
        private static final int SHEAR = 4;
        final int transformConstraintIndex;

        public TransformConstraintTimeline(int frameCount, int bezierCount, int transformConstraintIndex) {
            super(frameCount, bezierCount, String.valueOf(Property.transformConstraint.ordinal()) + "|" + transformConstraintIndex);
            this.transformConstraintIndex = transformConstraintIndex;
        }

        @Override
        public int getFrameEntries() {
            return 5;
        }

        public int getTransformConstraintIndex() {
            return this.transformConstraintIndex;
        }

        public void setFrame(int frame, float time, float rotateMix, float translateMix, float scaleMix, float shearMix) {
            this.frames[frame *= 5] = time;
            this.frames[frame + 1] = rotateMix;
            this.frames[frame + 2] = translateMix;
            this.frames[frame + 3] = scaleMix;
            this.frames[frame + 4] = shearMix;
        }

        @Override
        public void apply(Skeleton skeleton, float lastTime, float time, @Null Array<Event> events, float alpha, MixBlend blend, MixDirection direction) {
            float shear;
            float scale;
            float translate;
            float rotate;
            TransformConstraint constraint = skeleton.transformConstraints.get(this.transformConstraintIndex);
            if (!constraint.active) {
                return;
            }
            float[] frames = this.frames;
            if (time < frames[0]) {
                TransformConstraintData data = constraint.data;
                switch (blend) {
                    case setup: {
                        constraint.rotateMix = data.rotateMix;
                        constraint.translateMix = data.translateMix;
                        constraint.scaleMix = data.scaleMix;
                        constraint.shearMix = data.shearMix;
                        return;
                    }
                    case first: {
                        constraint.rotateMix += (data.rotateMix - constraint.rotateMix) * alpha;
                        constraint.translateMix += (data.translateMix - constraint.translateMix) * alpha;
                        constraint.scaleMix += (data.scaleMix - constraint.scaleMix) * alpha;
                        constraint.shearMix += (data.shearMix - constraint.shearMix) * alpha;
                    }
                }
                return;
            }
            int i = Animation.search(frames, time, 5);
            int curveType = (int)this.curves[i / 5];
            switch (curveType) {
                case 0: {
                    float before = frames[i];
                    rotate = frames[i + 1];
                    translate = frames[i + 2];
                    scale = frames[i + 3];
                    shear = frames[i + 4];
                    float t = (time - before) / (frames[i + 5] - before);
                    rotate += (frames[i + 5 + 1] - rotate) * t;
                    translate += (frames[i + 5 + 2] - translate) * t;
                    scale += (frames[i + 5 + 3] - scale) * t;
                    shear += (frames[i + 5 + 4] - shear) * t;
                    break;
                }
                case 1: {
                    rotate = frames[i + 1];
                    translate = frames[i + 2];
                    scale = frames[i + 3];
                    shear = frames[i + 4];
                    break;
                }
                default: {
                    rotate = this.getBezierValue(time, i, 1, curveType - 2);
                    translate = this.getBezierValue(time, i, 2, curveType + 18 - 2);
                    scale = this.getBezierValue(time, i, 2, curveType + 36 - 2);
                    shear = this.getBezierValue(time, i, 2, curveType + 54 - 2);
                }
            }
            if (blend == MixBlend.setup) {
                TransformConstraintData data = constraint.data;
                constraint.rotateMix = data.rotateMix + (rotate - data.rotateMix) * alpha;
                constraint.translateMix = data.translateMix + (translate - data.translateMix) * alpha;
                constraint.scaleMix = data.scaleMix + (scale - data.scaleMix) * alpha;
                constraint.shearMix = data.shearMix + (shear - data.shearMix) * alpha;
            } else {
                constraint.rotateMix += (rotate - constraint.rotateMix) * alpha;
                constraint.translateMix += (translate - constraint.translateMix) * alpha;
                constraint.scaleMix += (scale - constraint.scaleMix) * alpha;
                constraint.shearMix += (shear - constraint.shearMix) * alpha;
            }
        }
    }

    public static class TranslateTimeline
    extends CurveTimeline2
    implements BoneTimeline {
        final int boneIndex;

        public TranslateTimeline(int frameCount, int bezierCount, int boneIndex) {
            super(frameCount, bezierCount, String.valueOf(Property.translateX.ordinal()) + "|" + boneIndex, String.valueOf(Property.translateY.ordinal()) + "|" + boneIndex);
            this.boneIndex = boneIndex;
        }

        @Override
        public int getBoneIndex() {
            return this.boneIndex;
        }

        @Override
        public void apply(Skeleton skeleton, float lastTime, float time, @Null Array<Event> events, float alpha, MixBlend blend, MixDirection direction) {
            float y;
            float x;
            Bone bone = skeleton.bones.get(this.boneIndex);
            if (!bone.active) {
                return;
            }
            float[] frames = this.frames;
            if (time < frames[0]) {
                switch (blend) {
                    case setup: {
                        bone.x = bone.data.x;
                        bone.y = bone.data.y;
                        return;
                    }
                    case first: {
                        bone.x += (bone.data.x - bone.x) * alpha;
                        bone.y += (bone.data.y - bone.y) * alpha;
                    }
                }
                return;
            }
            int i = Animation.search(frames, time, 3);
            int curveType = (int)this.curves[i / 3];
            switch (curveType) {
                case 0: {
                    float before = frames[i];
                    x = frames[i + 1];
                    y = frames[i + 2];
                    float t = (time - before) / (frames[i + 3] - before);
                    x += (frames[i + 3 + 1] - x) * t;
                    y += (frames[i + 3 + 2] - y) * t;
                    break;
                }
                case 1: {
                    x = frames[i + 1];
                    y = frames[i + 2];
                    break;
                }
                default: {
                    x = this.getBezierValue(time, i, 1, curveType - 2);
                    y = this.getBezierValue(time, i, 2, curveType + 18 - 2);
                }
            }
            switch (blend) {
                case setup: {
                    bone.x = bone.data.x + x * alpha;
                    bone.y = bone.data.y + y * alpha;
                    break;
                }
                case first: 
                case replace: {
                    bone.x += (bone.data.x + x - bone.x) * alpha;
                    bone.y += (bone.data.y + y - bone.y) * alpha;
                    break;
                }
                case add: {
                    bone.x += x * alpha;
                    bone.y += y * alpha;
                }
            }
        }
    }

    public static class TwoColorTimeline
    extends CurveTimeline
    implements SlotTimeline {
        public static final int ENTRIES = 8;
        private static final int R = 1;
        private static final int G = 2;
        private static final int B = 3;
        private static final int A = 4;
        private static final int R2 = 5;
        private static final int G2 = 6;
        private static final int B2 = 7;
        final int slotIndex;

        public TwoColorTimeline(int frameCount, int bezierCount, int slotIndex) {
            super(frameCount, bezierCount, String.valueOf(Property.rgba.ordinal()) + "|" + slotIndex, String.valueOf(Property.rgb2.ordinal()) + "|" + slotIndex);
            this.slotIndex = slotIndex;
        }

        @Override
        public int getFrameEntries() {
            return 8;
        }

        @Override
        public int getSlotIndex() {
            return this.slotIndex;
        }

        public void setFrame(int frame, float time, float r, float g, float b, float a, float r2, float g2, float b2) {
            this.frames[frame <<= 3] = time;
            this.frames[frame + 1] = r;
            this.frames[frame + 2] = g;
            this.frames[frame + 3] = b;
            this.frames[frame + 4] = a;
            this.frames[frame + 5] = r2;
            this.frames[frame + 6] = g2;
            this.frames[frame + 7] = b2;
        }

        @Override
        public void apply(Skeleton skeleton, float lastTime, float time, @Null Array<Event> events, float alpha, MixBlend blend, MixDirection direction) {
            float b2;
            float g2;
            float r2;
            float a;
            float b;
            float g;
            float r;
            Slot slot = skeleton.slots.get(this.slotIndex);
            if (!slot.bone.active) {
                return;
            }
            float[] frames = this.frames;
            if (time < frames[0]) {
                switch (blend) {
                    case setup: {
                        slot.color.set(slot.data.color);
                        slot.darkColor.set(slot.data.darkColor);
                        return;
                    }
                    case first: {
                        Color light = slot.color;
                        Color dark = slot.darkColor;
                        Color setupLight = slot.data.color;
                        Color setupDark = slot.data.darkColor;
                        light.add((setupLight.r - light.r) * alpha, (setupLight.g - light.g) * alpha, (setupLight.b - light.b) * alpha, (setupLight.a - light.a) * alpha);
                        dark.add((setupDark.r - dark.r) * alpha, (setupDark.g - dark.g) * alpha, (setupDark.b - dark.b) * alpha, 0.0f);
                    }
                }
                return;
            }
            int i = Animation.search(frames, time, 8);
            int curveType = (int)this.curves[i >> 3];
            switch (curveType) {
                case 0: {
                    float before = frames[i];
                    r = frames[i + 1];
                    g = frames[i + 2];
                    b = frames[i + 3];
                    a = frames[i + 4];
                    r2 = frames[i + 5];
                    g2 = frames[i + 6];
                    b2 = frames[i + 7];
                    float t = (time - before) / (frames[i + 8] - before);
                    r += (frames[i + 8 + 1] - r) * t;
                    g += (frames[i + 8 + 2] - g) * t;
                    b += (frames[i + 8 + 3] - b) * t;
                    a += (frames[i + 8 + 4] - a) * t;
                    r2 += (frames[i + 8 + 5] - r2) * t;
                    g2 += (frames[i + 8 + 6] - g2) * t;
                    b2 += (frames[i + 8 + 7] - b2) * t;
                    break;
                }
                case 1: {
                    r = frames[i + 1];
                    g = frames[i + 2];
                    b = frames[i + 3];
                    a = frames[i + 4];
                    r2 = frames[i + 5];
                    g2 = frames[i + 6];
                    b2 = frames[i + 7];
                    break;
                }
                default: {
                    r = this.getBezierValue(time, i, 1, curveType - 2);
                    g = this.getBezierValue(time, i, 2, curveType + 18 - 2);
                    b = this.getBezierValue(time, i, 3, curveType + 36 - 2);
                    a = this.getBezierValue(time, i, 4, curveType + 54 - 2);
                    r2 = this.getBezierValue(time, i, 5, curveType + 72 - 2);
                    g2 = this.getBezierValue(time, i, 6, curveType + 90 - 2);
                    b2 = this.getBezierValue(time, i, 7, curveType + 108 - 2);
                }
            }
            if (alpha == 1.0f) {
                slot.color.set(r, g, b, a);
                slot.darkColor.set(r2, g2, b2, 1.0f);
            } else {
                Color light = slot.color;
                Color dark = slot.darkColor;
                if (blend == MixBlend.setup) {
                    light.set(slot.data.color);
                    dark.set(slot.data.darkColor);
                }
                light.add((r - light.r) * alpha, (g - light.g) * alpha, (b - light.b) * alpha, (a - light.a) * alpha);
                dark.add((r2 - dark.r) * alpha, (g2 - dark.g) * alpha, (b2 - dark.b) * alpha, 0.0f);
            }
        }
    }
}

