/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.keyFMap;

import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.keyFMap.KeyFMap;
import org.jetbrains.kotlin.com.intellij.util.keyFMap.MapBackedFMap;
import org.jetbrains.kotlin.com.intellij.util.keyFMap.OneElementFMap;
import org.jetbrains.kotlin.com.intellij.util.keyFMap.PairElementsFMap;

final class ArrayBackedFMap
implements KeyFMap {
    private final int[] keys;
    @NotNull
    private final @NotNull Object @NotNull [] values;

    ArrayBackedFMap(int @NotNull [] keys, @NotNull @NotNull Object @NotNull [] values2) {
        if (keys == null) {
            ArrayBackedFMap.$$$reportNull$$$0(0);
        }
        if (values2 == null) {
            ArrayBackedFMap.$$$reportNull$$$0(1);
        }
        this.keys = keys;
        this.values = values2;
    }

    @Override
    @NotNull
    public <V> KeyFMap plus(@NotNull Key<V> key, @NotNull V value2) {
        int keyCode;
        int keyPos;
        if (key == null) {
            ArrayBackedFMap.$$$reportNull$$$0(2);
        }
        if (value2 == null) {
            ArrayBackedFMap.$$$reportNull$$$0(3);
        }
        if ((keyPos = this.indexOf(keyCode = key.hashCode())) >= 0) {
            if (this.values[keyPos] == value2) {
                ArrayBackedFMap arrayBackedFMap = this;
                if (arrayBackedFMap == null) {
                    ArrayBackedFMap.$$$reportNull$$$0(4);
                }
                return arrayBackedFMap;
            }
            Object[] newValues = (Object[])this.values.clone();
            newValues[keyPos] = value2;
            return new ArrayBackedFMap(this.keys, newValues);
        }
        if (this.size() < 8) {
            int[] newKeys = ArrayUtil.insert(this.keys, -keyPos - 1, keyCode);
            Object[] newValues = ArrayUtil.insert(this.values, -keyPos - 1, value2);
            return new ArrayBackedFMap(newKeys, newValues);
        }
        return new MapBackedFMap(this.keys, keyCode, this.values, value2);
    }

    @Override
    public int size() {
        return this.keys.length;
    }

    private int indexOf(int keyCode) {
        for (int i2 = 0; i2 < this.keys.length; ++i2) {
            int key = this.keys[i2];
            if (key == keyCode) {
                return i2;
            }
            if (key <= keyCode) continue;
            return -i2 - 1;
        }
        return -this.keys.length - 1;
    }

    @Override
    @NotNull
    public KeyFMap minus(@NotNull Key<?> key) {
        int i2;
        if (key == null) {
            ArrayBackedFMap.$$$reportNull$$$0(5);
        }
        if ((i2 = this.indexOf(key.hashCode())) >= 0) {
            if (this.size() == 3) {
                int otherI1 = (2 - i2) / 2;
                int otherI2 = 3 - (i2 + 2) / 2;
                Key key1 = Key.getKeyByIndex(this.keys[otherI1]);
                Key key2 = Key.getKeyByIndex(this.keys[otherI2]);
                if (key1 == null && key2 == null) {
                    KeyFMap keyFMap = EMPTY_MAP;
                    if (keyFMap == null) {
                        ArrayBackedFMap.$$$reportNull$$$0(6);
                    }
                    return keyFMap;
                }
                if (key1 == null) {
                    return new OneElementFMap<Object>(key2, this.values[otherI2]);
                }
                if (key2 == null) {
                    return new OneElementFMap<Object>(key1, this.values[otherI1]);
                }
                return new PairElementsFMap<Object, Object>(key1, this.values[otherI1], key2, this.values[otherI2]);
            }
            int[] newKeys = ArrayUtil.remove(this.keys, i2);
            Object[] newValues = ArrayUtil.remove(this.values, i2, ArrayUtil.OBJECT_ARRAY_FACTORY);
            return new ArrayBackedFMap(newKeys, newValues);
        }
        ArrayBackedFMap arrayBackedFMap = this;
        if (arrayBackedFMap == null) {
            ArrayBackedFMap.$$$reportNull$$$0(7);
        }
        return arrayBackedFMap;
    }

    @Override
    public <V> V get(@NotNull Key<V> key) {
        int i2;
        if (key == null) {
            ArrayBackedFMap.$$$reportNull$$$0(8);
        }
        return (V)((i2 = this.indexOf(key.hashCode())) < 0 ? null : this.values[i2]);
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder("{");
        for (int i2 = 0; i2 < this.keys.length; ++i2) {
            int key = this.keys[i2];
            Object value2 = this.values[i2];
            s2.append(s2.length() == 1 ? "" : ", ").append(Key.getKeyByIndex(key)).append("=").append(value2);
        }
        return s2.append("}").toString();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    @NotNull
    public @NotNull Key<?> @NotNull [] getKeys() {
        return ArrayBackedFMap.getKeysByIndices(this.keys);
    }

    @NotNull
    static @NotNull Key<?> @NotNull [] getKeysByIndices(int @NotNull [] indexes) {
        if (indexes == null) {
            ArrayBackedFMap.$$$reportNull$$$0(9);
        }
        Key[] result2 = new Key[indexes.length];
        int o2 = 0;
        for (int index : indexes) {
            Key key = Key.getKeyByIndex(index);
            if (key == null) continue;
            result2[o2++] = key;
        }
        Key[] keyArray = o2 == result2.length ? result2 : Arrays.copyOf(result2, o2);
        if (keyArray == null) {
            ArrayBackedFMap.$$$reportNull$$$0(10);
        }
        return keyArray;
    }

    public int hashCode() {
        int hash = 0;
        int length = this.keys.length;
        for (int i2 = 0; i2 < length; ++i2) {
            hash += this.keys[i2] ^ this.values[i2].hashCode();
        }
        return hash;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof ArrayBackedFMap)) {
            return false;
        }
        ArrayBackedFMap map = (ArrayBackedFMap)o2;
        if (map.size() != this.size()) {
            return false;
        }
        int length = this.keys.length;
        for (int i2 = 0; i2 < length; ++i2) {
            if (this.keys[i2] == map.keys[i2] && this.values[i2].equals(map.values[i2])) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 10: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/keyFMap/ArrayBackedFMap";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexes";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/keyFMap/ArrayBackedFMap";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "plus";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "minus";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeysByIndices";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "plus";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "minus";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getKeysByIndices";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "equalsByReference";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

