/* PgSqlClient - ADO.NET Data Provider for PostgreSQL 7.4+
 * Copyright (c) 2003-2004 Carlos Guzman Alvarez
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;
using System.Data;
using System.Text;

namespace PostgreSql.Data.PgSqlClient.DbSchema
{
	internal class PgIndexesSchema : PgAbstractDbSchema
	{
		#region Constructors

		public PgIndexesSchema() : base("Indexes")
		{
		}

		#endregion

		#region Add Methods

		public override void AddTables()
		{
			AddTable("pg_index");
		}

		public override void AddRestrictionColumns()
		{
			AddRestrictionColumn("pg_namespace.nspname"	, "TABLE_SCHEMA", null);
			AddRestrictionColumn("pg_class.relname"		, "TABLE_NAME", null);
			AddRestrictionColumn("pg_classidx.relname"	, "INDEX_NAME", null);
		}

		public override void AddDataColumns()
		{
			AddDataColumn("Pgnamespidx.nspname"		, "INDEX_SCHEMA");
			AddDataColumn("pg_am.amname"			, "TYPE");
			AddDataColumn("pg_index.indkey"			, "INDEX_KEY");
			AddDataColumn("pg_index.indisclustered"	, "CLUSTERED");
			AddDataColumn("pg_index.indisunique"	, "UNIQUE");
			AddDataColumn("pg_index.indisprimary"	, "PRIMARY");
			AddDataColumn("pg_am.amindexnulls"		, "ALLOW_NULLS");
			AddDataColumn("pg_am.amcanmulticol"		, "MULTICOLUMN");
			AddDataColumn("pg_am.amconcurrent"		, "CONCURRENT");
			AddDataColumn("pg_description.description", "DESCRIPTION");
		}

		public override void AddJoins()
		{			
			AddJoin("left join", "pg_class", "pg_index.indrelid = pg_class.oid");			
			AddJoin("left join", "pg_class as pg_classidx", "pg_index.indexrelid = pg_classidx.oid");
			AddJoin("left join", "pg_namespace", "pg_classidx.relnamespace = pg_namespace.oid");
			AddJoin("left join", "pg_namespace as Pgnamespidx", "pg_classidx.relnamespace = Pgnamespidx.oid");
			AddJoin("left join", "pg_am", "pg_classidx.relam = pg_am.oid");
			AddJoin("left join", "pg_description", "pg_index.indexrelid = pg_description.objoid");
		}

		public override void AddOrderByColumns()
		{
			AddOrderBy("pg_namespace.nspname");
			AddOrderBy("pg_class.relname");
			AddOrderBy("pg_classidx.relname");
		}

		public override void AddWhereFilters()
		{
		}

		#endregion

		#region Parse Methods

		public override object[] ParseRestrictions(object[] restrictions)
		{
			object[] parsed = restrictions;

			return parsed;
		}

		#endregion
	}
}