/* PgSqlClient - ADO.NET Data Provider for PostgreSQL 7.4+
 * Copyright (c) 2003-2004 Carlos Guzman Alvarez
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;
using System.Data;
using System.Text;

namespace PostgreSql.Data.PgSqlClient.DbSchema
{
	internal class PgTriggersSchema : PgAbstractDbSchema
	{
		#region Constructors

		public PgTriggersSchema() : base("Triggers")
		{
		}

		#endregion

		#region Add Methods

		public override void AddTables()
		{
			AddTable("pg_trigger");
		}

		public override void AddRestrictionColumns()
		{
			AddRestrictionColumn("pg_namespace.nspname"	, "TRIGGER_SCHEMA", null);
			AddRestrictionColumn("pg_proc.proname"		, "TRIGGER_NAME", null);
			AddRestrictionColumn("pg_class.relnamespace", "TABLE_SCHEMA", null);
			AddRestrictionColumn("pg_class.relname"		, "TABLE_NAME", null);
		}

		public override void AddDataColumns()
		{
			AddDataColumn("pg_language.lanname"	, "PROCEDURE_LANGUAGE");
			AddDataColumn("pg_proc.proisagg"	, "IS_AGGREGATE");
			AddDataColumn("pg_proc.prosecdef"	, "IS_SECURITY_DEFINER");
			AddDataColumn("pg_proc.proisstrict"	, "IS_STRICT");
			AddDataColumn("pg_proc.proretset"	, "RETURNS_SET");			
		}

		public override void AddJoins()
		{
			AddJoin("left join", "pg_class"		, "pg_trigger.tgconstrrelid = pg_class.oid");
			AddJoin("left join", "pg_proc"		, "pg_trigger.tgfoid = pg_proc.oid");
			AddJoin("left join", "pg_namespace"	, "pg_proc.pronamespace = pg_namespace.oid");
			AddJoin("left join", "pg_language"	, "pg_proc.prolang = pg_language.oid");		
		}

		public override void AddOrderByColumns()
		{
			AddOrderBy("pg_namespace.nspname");
			AddOrderBy("pg_proc.proname");
		}

		public override void AddWhereFilters()
		{
		}

		#endregion

		#region Parse Methods

		public override object[] ParseRestrictions(object[] restrictions)
		{
			object[] parsed = restrictions;

			return parsed;
		}

		#endregion
	}
}