/* PgSqlClient - ADO.NET Data Provider for PostgreSQL 7.4+
 * Copyright (c) 2003-2004 Carlos Guzman Alvarez
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;
using System.Data;

namespace PostgreSql.Data.NPgClient
{
	internal class PgType
	{
		#region Fields

		private int			oid;
		private string		name;
		private PgDataType	dataType;
		private Type		systemType;
		private int			elementType;
		private short		formatCode;
		private int			size;		

		#endregion

		#region Properties

		public int Oid
		{
			get { return oid; }
		}

		public PgDataType DataType
		{
			get { return dataType; }
		}

		public string Name
		{
			get { return name; }
		}

		public Type SystemType
		{
			get { return systemType; }
		}
		
		public int ElementType
		{
			get 
			{ 
				int type = elementType;

				while (PgDbClient.Types[type].DataType == PgDataType.Array)
				{
					type = PgDbClient.Types[type].ElementType;
				}

				return type; 
			}
		}

		public short FormatCode
		{
			get { return formatCode; }
		}

		public int Size
		{
			get { return size; }
		}

		#endregion

		#region Constructors

		public PgType(int oid, string name, PgDataType dataType, int elementType, short formatCode, int size)
		{
			this.oid			= oid;
			this.name			= name;
			this.dataType		= dataType;
			this.elementType	= elementType;
			this.formatCode		= formatCode;
			this.size			= size;
			this.systemType		= this.inferSystemType();
		}

		#endregion

		#region Methods

		public bool IsNumeric()
		{
			bool returnValue = false;
						
			if (this.dataType == PgDataType.Currency	||
				this.dataType == PgDataType.Int2		||
				this.dataType == PgDataType.Int4		||
				this.dataType == PgDataType.Int8		||
				this.dataType == PgDataType.Float	||
				this.dataType == PgDataType.Double	||
				this.dataType == PgDataType.Decimal	||
				this.dataType == PgDataType.Byte)
			{
				returnValue = true;
			}

			return returnValue;
		}

		public bool IsLong()
		{
			bool returnValue = false;
			
			if (this.dataType == PgDataType.Binary)				
			{
				returnValue = true;
			}

			return returnValue;
		}

		#endregion

		#region Private Methods

		private Type inferSystemType()
		{
			switch (this.dataType)
			{
				case PgDataType.Array:
				case PgDataType.Binary:
				case PgDataType.Vector:
					return Type.GetType("System.Array");
				
				case PgDataType.Boolean:
					return Type.GetType("System.Boolean");

				case PgDataType.Box:
					return Type.GetType("PostgreSql.Data.PgTypes.PgBox");

				case PgDataType.Circle:
					return Type.GetType("PostgreSql.Data.PgTypes.PgCircle");

				case PgDataType.Line:
					return Type.GetType("PostgreSql.Data.PgTypes.PgLine");

				case PgDataType.LSeg:
					return Type.GetType("PostgreSql.Data.PgTypes.PgLSeg");

				case PgDataType.Path:
					return Type.GetType("PostgreSql.Data.PgTypes.PgPath");

				case PgDataType.Point:
					return Type.GetType("PostgreSql.Data.PgTypes.PgPoint");

				case PgDataType.Polygon:
					return Type.GetType("PostgreSql.Data.PgTypes.PgPolygon");
				
				case PgDataType.Byte:
					return Type.GetType("System.Byte");
				
				case PgDataType.Char:
				case PgDataType.Text:
				case PgDataType.VarChar:
					return Type.GetType("System.String");
				
				case PgDataType.Currency:
				case PgDataType.Decimal:
				case PgDataType.Numeric:
					return Type.GetType("System.Decimal");
				
				case PgDataType.Date:
				case PgDataType.Time:
				case PgDataType.TimeWithTZ:
				case PgDataType.Timestamp:
				case PgDataType.TimestampWithTZ:
					return Type.GetType("System.DateTime");

				case PgDataType.Double:
					return Type.GetType("System.Double");
				
				case PgDataType.Float:
					return Type.GetType("System.Single");
				
				case PgDataType.Int2:
					return Type.GetType("System.Int16");
				
				case PgDataType.Int4:
					return Type.GetType("System.Int32");
				
				case PgDataType.Int8:
					return Type.GetType("System.Int64");

				default:
					return Type.GetType("System.Object");
			}
		}

		#endregion
	}
}
