/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.lib;

import java.util.Hashtable;
import org.apache.xalan.lib.ExsltBase;
import org.apache.xpath.DOMHelper;
import org.apache.xpath.NodeSet;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ExsltSets
extends ExsltBase {
    public static NodeList leading(NodeList nl1, NodeList nl2) {
        if (nl2.getLength() == 0) {
            return nl1;
        }
        NodeSet ns1 = new NodeSet(nl1);
        NodeSet leadNodes = new NodeSet();
        Node endNode = nl2.item(0);
        if (!ns1.contains(endNode)) {
            return leadNodes;
        }
        int i = 0;
        while (i < nl1.getLength()) {
            Node testNode = nl1.item(i);
            if (DOMHelper.isNodeAfter(testNode, endNode) && !DOMHelper.isNodeTheSame(testNode, endNode)) {
                leadNodes.addElement(testNode);
            }
            ++i;
        }
        return leadNodes;
    }

    public static NodeList trailing(NodeList nl1, NodeList nl2) {
        if (nl2.getLength() == 0) {
            return nl1;
        }
        NodeSet ns1 = new NodeSet(nl1);
        NodeSet trailNodes = new NodeSet();
        Node startNode = nl2.item(0);
        if (!ns1.contains(startNode)) {
            return trailNodes;
        }
        int i = 0;
        while (i < nl1.getLength()) {
            Node testNode = nl1.item(i);
            if (DOMHelper.isNodeAfter(startNode, testNode) && !DOMHelper.isNodeTheSame(startNode, testNode)) {
                trailNodes.addElement(testNode);
            }
            ++i;
        }
        return trailNodes;
    }

    public static NodeList intersection(NodeList nl1, NodeList nl2) {
        NodeSet ns1 = new NodeSet(nl1);
        NodeSet ns2 = new NodeSet(nl2);
        NodeSet inter = new NodeSet();
        inter.setShouldCacheNodes(true);
        int i = 0;
        while (i < ns1.getLength()) {
            Node n = ns1.elementAt(i);
            if (ns2.contains(n)) {
                inter.addElement(n);
            }
            ++i;
        }
        return inter;
    }

    public static NodeList difference(NodeList nl1, NodeList nl2) {
        NodeSet ns1 = new NodeSet(nl1);
        NodeSet ns2 = new NodeSet(nl2);
        NodeSet diff = new NodeSet();
        diff.setShouldCacheNodes(true);
        int i = 0;
        while (i < ns1.getLength()) {
            Node n = ns1.elementAt(i);
            if (!ns2.contains(n)) {
                diff.addElement(n);
            }
            ++i;
        }
        return diff;
    }

    public static NodeList distinct(NodeList nl) {
        NodeSet dist = new NodeSet();
        dist.setShouldCacheNodes(true);
        Hashtable<String, Node> stringTable = new Hashtable<String, Node>();
        int i = 0;
        while (i < nl.getLength()) {
            Node currNode = nl.item(i);
            String key = ExsltBase.toString(currNode);
            if (key == null) {
                dist.addElement(currNode);
            } else if (!stringTable.containsKey(key)) {
                stringTable.put(key, currNode);
                dist.addElement(currNode);
            }
            ++i;
        }
        return dist;
    }

    public static boolean hasSameNode(NodeList nl1, NodeList nl2) {
        NodeSet ns1 = new NodeSet(nl1);
        NodeSet ns2 = new NodeSet(nl2);
        int i = 0;
        while (i < ns1.getLength()) {
            if (ns2.contains(ns1.elementAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

