/*
 * Decompiled with CFR 0.152.
 */
package slothLib.web.search;

import java.io.UnsupportedEncodingException;
import java.net.Proxy;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import slothLib.portUtil.PortUtil;
import slothLib.web.search.GooBlogElement;
import slothLib.web.search.GooBlogSearchResult;
import slothLib.web.search.IBlogSearch;
import slothLib.web.search.WebSearchException;

public class GooBlogSearch
implements IBlogSearch {
    private SortType sortType = SortType.Score;
    private Proxy proxy = null;

    @Override
    public GooBlogSearchResult doSearch(String query, int resultNum) {
        return this.DoGooBlogSearchOver(query, resultNum);
    }

    private GooBlogSearchResult doGooBlogSearch(String query, int start, int resultNum, int tureResultNum) {
        Document xmlDoc;
        String requestURL = this.makeRequestURL(query, start, resultNum);
        System.err.println("start! " + requestURL);
        try {
            xmlDoc = PortUtil.getDocumentFromURL(requestURL, this.proxy);
        }
        catch (WebSearchException e) {
            e.printStackTrace();
            return null;
        }
        ArrayList<GooBlogElement> resultElementList = new ArrayList<GooBlogElement>();
        Element xmlRoot = xmlDoc.getDocumentElement();
        NodeList nodeList = xmlRoot.getElementsByTagName("channel");
        if (nodeList == null) {
            return new GooBlogSearchResult(query, 0L, resultElementList.toArray(new GooBlogElement[0]));
        }
        String strTotalNumber = this.getElementString(((Element)nodeList.item(0)).getElementsByTagName("gooblog:searchTotalResults"));
        long totalSearchResults = PortUtil.isNullOrEmpty(strTotalNumber) ? 0L : Long.parseLong(strTotalNumber.replace(",", ""));
        NodeList items = xmlRoot.getElementsByTagName("item");
        int count = 0;
        int i = 0;
        while (i < items.getLength()) {
            Element element = (Element)items.item(i);
            String title = this.getElementString(element.getElementsByTagName("title"));
            String link = this.getElementString(element.getElementsByTagName("link"));
            String description = this.getElementString(element.getElementsByTagName("description"));
            Date date = this.parseGooDate(this.getElementString(element.getElementsByTagName("dc:date")));
            String source = this.getElementString(element.getElementsByTagName("ag:source"));
            String sourceURL = this.getElementString(element.getElementsByTagName("ag:sourceURL"));
            GooBlogElement gooElement = new GooBlogElement(title, link, description, date, source, sourceURL);
            resultElementList.add(gooElement);
            if (++count >= tureResultNum) break;
            ++i;
        }
        System.err.println("finish! " + requestURL);
        return new GooBlogSearchResult(query, totalSearchResults, resultElementList.toArray(new GooBlogElement[0]));
    }

    private GooBlogSearchResult DoGooBlogSearchOver(String query, int resultNum) {
        int unit = resultNum < 50 ? 10 : 50;
        ArrayList<GooBlogElement> ResultElementList = new ArrayList<GooBlogElement>();
        int loop = (resultNum - 1) / unit;
        int i = 0;
        while (i < loop) {
            GooBlogSearchResult r = this.doGooBlogSearch(query, 1 + i * unit, unit, unit);
            ResultElementList.addAll(Arrays.asList(r.getResultElements()));
            ++i;
        }
        GooBlogSearchResult gsr = this.doGooBlogSearch(query, loop * unit + 1, unit, resultNum - loop * unit);
        ResultElementList.addAll(Arrays.asList(gsr.getResultElements()));
        return new GooBlogSearchResult(query, gsr.getSearchTotalResults(), ResultElementList.toArray(new GooBlogElement[0]));
    }

    private String getElementString(NodeList nodeList) {
        if (nodeList.getLength() == 0) {
            return "";
        }
        return nodeList.item(0).getTextContent();
    }

    private String makeRequestURL(String query, int start, int resultNum) {
        String encodedQuery;
        try {
            encodedQuery = URLEncoder.encode(query, "EUC-JP");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            encodedQuery = URLEncoder.encode(query);
        }
        String url = "http://blog.search.goo.ne.jp/search_goo/result/?tg=all&da=all&st=score&dp=all&bu=&ts=all&status=select&MT=" + encodedQuery + "&dc=" + resultNum + "&fr=" + start + "&rss=1";
        switch (this.sortType) {
            case Date: {
                url = String.valueOf(url) + "&st=date";
                break;
            }
            case Score: {
                url = String.valueOf(url) + "&st=score";
            }
        }
        return url;
    }

    private Date parseGooDate(String strDate) {
        if (PortUtil.isNullOrEmpty(strDate)) {
            return new Date();
        }
        try {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:sszzz").parse(strDate);
        }
        catch (ParseException e) {
            return new Date();
        }
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy value) {
        this.proxy = value;
    }

    public SortType getSortBy() {
        return this.sortType;
    }

    public void setSortBy(SortType value) {
        this.sortType = value;
    }

    public static enum SortType {
        Score,
        Date;

    }
}

