#
# Copyright (c) 2010, W T Schueller
# All rights reserved.
# 
# Redistribution and use in source and binary forms, with or without modification,
# are permitted provided that the following conditions are met:
# 
# * Redistributions of source code must retain the above copyright notice,
#   this list of conditions and the following disclaimer.
# * Redistributions in binary form must reproduce the above copyright notice,
#   this list of conditions and the following disclaimer in the documentation
#   and/or other materials provided with the distribution.
# * Neither the name of the author nor the names of the contributors
#   may be used to endorse or promote products derived from this software
#   without specific prior written permission.
# 
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
# (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
# LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
# ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#

##
# \file
#
# \author W T Schueller
#
# \brief build script
#

#
# process command line options
#
set args $argv
set files [ list ]
set binary "tcl2doxy"
##
# \file
#
# \todo No support for packages yet.
#
while { [ llength $args ] > 0 } {
    switch -exact -- [ lindex $args 0 ] {
        "-o" {
            set binary [ lindex $args 1 ]
            set args [ lrange $args 2 end ]
        }
        default {
            lappend files [ lindex $args 0 ]
            set args [ lrange $args 1 end ]
        }
    }
}
set output [ file rootname $binary ]
#
# svn status
#
set revision "0"
set modification ""
set r [ catch { eval exec svn stat -v [ join $files ] } msg ]
if { $r } then {
    set revision "unknown"
} else {
    foreach i [ split $msg "\n" ] {
        if { [ string index $i 0 ] ne " " } then {
            set modification " modified"
        }
        set r [ lindex [ string range $i 7 end ] 0 ]
        if { $r > $revision } then {
            set revision $r
        }
    }
}
#
# file info
#
array set stringinfo [ list ]
set stringinfo(Language)         0409
set stringinfo(CodePage)         04b0
set stringinfo(FileDescription)  "doxygen input filter"
set stringinfo(CompanyName)      ""
set stringinfo(OriginalFilename) [ file tail $output ]
set stringinfo(FileVersion)      $revision$modification
set stringinfo(LegalCopyright)   "(c) 2010 by wtschueller"
set stringinfo(ProductName)      "tcl2doxy"
set stringinfo(ProductVersion)   $stringinfo(FileVersion)
#
# start with the file system now
#
file delete -force -- $output.vfs
file mkdir $output.vfs
#
# main.tcl
#
set fp [ open [ file join $output.vfs main.tcl ] w ]
puts $fp "package require starkit"
puts $fp "starkit::startup"
puts $fp "set ::REVISION \"svn revision $stringinfo(FileVersion)\""
puts $fp "package require app-[ file tail $output ]"
close $fp
#
# stringinfo
#
set fp [ open [ file join $output.vfs tclkit.inf ] w ]
foreach i [ array names stringinfo ] {
    puts $fp "$i \"$stringinfo($i)\""
}
close $fp
#
# application as a package
#
set pkgdir [ file join $output.vfs lib app-[ file tail $output ] ]
file mkdir $pkgdir
set fp [ open [ file join $pkgdir pkgIndex.tcl ] w ]
puts $fp "package ifneeded app-[ file tail $output ] 1.0 \[ list source \[ file join \$dir [ lindex $files 0 ] \] \]"
close $fp
foreach i $files {
    file mkdir [ file join $pkgdir [ file dirname $i ] ]
    file copy -- $i  [ file join $pkgdir [ file dirname $i ] ]
}
#
# ready to wrap
#

##
# \file
#
# \todo The following embedded use does not work for me if the tclsh itself is
# a tclkit 8.4 (not the same as the prefix).
# (taken from http://www.equi4.com/starkit/sdx.html)
# <br>
# <tt>source sdx.kit</tt><br>
# <tt>package require sdx</tt><br>
# <tt>sdx::sdx wrap $target -runtime $i -vfs [ file tail $output ].vfs</tt><br>
# The error is "can't find package vfs". It works, however, with the command line.
# <br>
# The reason seems to be that the vfs package is compiled into the core and
# is not available via pkgIndex.tcl, and not available to child interpreters.
# The child interpreter ist used by the embedded call to sdx.
# This seems fixed in tclkit 8.5. However, the exec call is more general.
#
set pwd [ pwd ]
cd [ file dirname $output ]
set prefixes [ glob "tclkit*" ]
set files_to_cleanup [ list ]
##
# \file
#
# \todo
# The already running tclkit cannot be used as prefix.
# Try to duplicate it automatically.
#
foreach prefix $prefixes {
    set target [ file tail $output ]-$prefix
    puts "wrap $target, prefix $prefix"
    if { [ info nameofexecutable ] eq [ file normalize $prefix ] } then {
        set sys [ file system $prefix ]
        if { [ lindex $sys 0 ] eq "tclvfs" } then {
            vfs::filesystem unmount $prefix
            file copy -force -- $prefix copy_$prefix
            vfs::filesystem mount $prefix [ lindex $sys 1 ] 
            set prefix copy_$prefix
            lappend files_to_cleanup [ file normalize $prefix ]
        }
    }
    set r [ catch {
        exec -- [ info nameofexecutable ] sdx.kit wrap $target -runtime $prefix -vfs [ file tail $output ].vfs
    } msg ]
    if { $r } then {
        puts $msg
    } else {
        puts $msg
        if { [ file extension $prefix ] eq [ file extension $binary ] } then {
            puts "copy $target to [ file tail $binary ]"
            file copy -force -- $target [ file tail $binary ]
        }
    }
}
cd $pwd
#
# clean up
#
file delete -force -- $output.vfs
foreach i $files_to_cleanup {
    file delete -force -- $i
}
#
# end of script
#
exit