<h1 align="center"><img src="https://raw.githubusercontent.com/MichaIng/DietPi-Website/master/images/dietpi-logo_180x180.png" alt="DietPi logo" width="180" height="180" loading="lazy"></h1>
<p align="center">
	<b>Lightweight justice for your single-board computer!</b>
	<br><br>
	optimised • simplified • for everyone
	<br><br>
	<a href="https://dietpi.com/" target="_blank" rel="noopener">Website</a> • <a href="https://dietpi.com/#download" target="_blank" rel="noopener">Downloads</a> • <a href="https://dietpi.com/docs/" target="_blank" rel="noopener">Documentation</a> • <a href="https://dietpi.com/forum/" target="_blank" rel="noopener">Forum</a> • <a href="https://dietpi.com/blog/" target="_blank" rel="noopener">Blog</a>
</p>
<hr>
<p align="center">
	<strong>Ready to run</strong> optimised software choices with <a href="https://dietpi.com/dietpi-software.html" target="_blank" rel="noopener"><strong>dietpi-software</strong></a>
	<br>Feature-rich configuration tool for your device with <strong>dietpi-config</strong>.
</p>
<hr>

## Introduction

DietPi is an extremely lightweight Debian-based OS. It is highly optimised for minimal CPU and RAM resource usage, ensuring your SBC always runs at its maximum potential. 

The **dietpi programs** use lightweight whiptail menus. You'll spend more time enjoying DietPi and applications you need and less time staring at the command line.

Use `dietpi-software` to quick and easy install **Ready to Run** & **Optimised** applications for your system. DietPi will do all the necessary configurations, including starting the services. Few highlights: [Desktop Environments](https://dietpi.com/docs/software/desktop/), [Remote Desktop Access](https://dietpi.com/docs/software/remote_desktop/), [Media Systems & Players](https://dietpi.com/docs/software/media/), [BitTorrent & Downloading](https://dietpi.com/docs/software/bittorrent/), [Cloud & Backup](https://dietpi.com/docs/software/cloud/), [Gaming & Emulation](https://dietpi.com/docs/software/gaming/), [Social & Search](https://dietpi.com/docs/software/social/), [Camera & Surveillance](https://dietpi.com/docs/software/camera/), [Networking](https://dietpi.com/docs/software/advanced_networking/), [System Stats & Management](https://dietpi.com/docs/software/system_stats/), [Home Automation](https://dietpi.com/docs/software/home_automation/), [Hardware & Voice Projects](https://dietpi.com/docs/software/hardware_projects/), [Webserver Stacks](https://dietpi.com/docs/software/webserver_stack/), [DNS Servers / Pi-hole](https://dietpi.com/docs/software/dns_servers/), [File Servers](https://dietpi.com/docs/software/file_servers/), [Printing](https://dietpi.com/docs/software/printing/) and much more.

Use `dietpi-services` to control which installed software has higher or lower priority levels (nice, affinity, policy scheduler).

`dietpi-update` automatically checks for updates and informs you when they are available. Update instantly, without having to write a new image. **DietPi automation** allows you to completely automate a DietPi installation with no user input, simply by configuring `dietpi.txt` before powering on.

## The DietPi Project Team

The full list of code contributors can be viewed [here](https://github.com/MichaIng/DietPi/graphs/contributors).

### Contributors

#### [Micha](https://github.com/MichaIng)

_Joined Q3 2017_

Project lead (20/02/2019 and onwards), source code contributor, bug fixes, software improvements, DietPi forum administrator.

#### [Daniel Knight](https://github.com/Fourdee)

Project founder and previous project lead (19/02/2019 and previous), source code contributor and tester.

#### [JohnVick](https://dietpi.com/forum/u/johnvick/summary)

_Joined 2016-06-08_

DietPi forum co-administrator, management, support, testing and valuable feedback.

#### [sal666](https://github.com/sal666)

_Joined 2017-07-26_

Creator and maintainer of the first Clonezilla based installer images for x86_64 UEFI systems.

#### [Joulinar](https://github.com/Joulinar)

_Joined Q4 2019_

DietPi forum moderator, support, testing, bug reports + investigation and valuable feedback.

#### [StephanStS](https://github.com/StephanStS)

_Joined Q4 2019_

NanoPi image creator, tester and bug reports.

#### [Petru](https://github.com/fpetru)

_Joined 2020-05-31_

DietPi documentation author, product manager, SEO and DietPi visibility recommendations.

#### [ravenclaw900](https://github.com/ravenclaw900)

_Joined 2020-10-11_

Source code contributor, creator of the [DietPi-Dashboard](https://github.com/ravenclaw900/DietPi-Dashboard) and many software implementations.

#### [yumiris](https://github.com/yumiris)

_Joined 2018-04-16_

Creator and maintainer of the first [DietPi Hyper-V images](https://github.com/yumiris/DietPi.Hyper-V).

---

### Collaborations

#### DietPi + [Amiberry](https://github.com/BlitterStudio/amiberry)

_Since 2016-09-02_

Joint venture to bring you the ultimate Amiga experience on your SBC, running lightweight and optimised DietPi at its core:
https://github.com/MichaIng/DietPi/issues/474

---

### Hall of Fame

#### [K-Plan](https://github.com/k-plan)

_Joined 2016-01-01_

Contributions to the DietPi in general, in-depth testing, bug finding and valuable feedback, forum moderator.

#### [ZombieVirus](https://dietpi.com/forum/u/zombievirus/summary)

_Joined 2016-03-20_

DietPi forum moderator and version history maintainer on forums.

#### [Rhkean](https://github.com/rhkean)

_Joined 2018-03-01_

Contributions to the DietPi in general, including source code, testing, new devices, forum moderator.

#### [Pilovali](https://github.com/pilovali)

_Joined 2015-10-10_

Provided dietpi.com web hosting for 1 year until April 17th 2016. Additionally: forum moderator, testing, bug reporting.

#### [Xenfomation](https://github.com/xenfomation)

_Joined 2016-04-01_

Contributions to the DietPi in general, including source code and VirtualBox image creation/conversion.

#### AWL29

_Joined 2016-10-01_

Created the first DietPi image for NanoPi M3/T3.

---

## Contributing

Git coders, please use the active development branch: [dev](https://github.com/MichaIng/DietPi/tree/dev)

- [How to add a new software title to DietPi-Software](https://github.com/MichaIng/DietPi/wiki/How-to-add-a-new-software-title)

Are you able to:

- Provide feedback and/or test areas of DietPi, to improve the user experience?
- Report bugs?
- Improve/add more features to the [DietPi website](https://github.com/MichaIng/DietPi-Website) or [documentation](https://github.com/MichaIng/DietPi-Website)?
- Compile software for our supported SBCs?
- Contribute to DietPi with programming on GitHub?
- Suggest new software that we can add to the `dietpi-software` install system?

If so, let us know!  
We are always looking for talented people who believe in the DietPi project, and, wish to contribute in any way you can.

- Send us an email: <micha@dietpi.com>
- Join our forum: <https://dietpi.com/forum/>
- GitHub: <https://github.com/MichaIng/DietPi>

Also read our [contribute page](https://dietpi.com/contribute.html) for an overview of way to support DietPi.

## License

DietPi Copyright (C) 2022 [Contributors](https://github.com/MichaIng/DietPi/graphs/contributors)
- Email: <micha@dietpi.com>
- Website: <https://dietpi.com/>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>

## Links

### DietPi Source

- Source: https://github.com/MichaIng/DietPi
- Build: Not applicable, as DietPi uses Bash scripts only, no building or compiling is required.

### DietPi Files

- All files located in (recursively):
  - `/var/lib/dietpi/`
  - `/var/tmp/dietpi/`
  - `/boot/dietpi/`
- `/boot/dietpi.txt`
- `/boot/config.txt` (RPi)
- `/boot/boot.ini` (Odroid)
- All files prefixed with: `dietpi-`

> The above GPLv2 documentation also applies to all mentioned files!

### 3rd Party Sources/Credits

Links to hardware and software manufacturers, sources and build instructions used in DietPi:

- [Linux kernel](https://github.com/torvalds/linux)
- [GNU operating system](https://www.gnu.org/)
- [Bash](https://git.savannah.gnu.org/cgit/bash.git)
- [Debian distribution](https://salsa.debian.org/)
- [Raspberry](https://github.com/raspberrypi) [Pi](https://github.com/RPi-Distro)
- [Hardkernel](https://github.com/hardkernel?tab=repositories)
- [Meveric's Odroid repository](https://forum.odroid.com/viewtopic.php?t=5908)
- [Sparky](https://github.com/sparkysbc?tab=repositories) [SBC](https://github.com/sparky-sbc/sparky-test)
- [PINE64](https://www.pine64.org/)
- [FriendlyARM](https://github.com/friendlyarm?tab=repositories)
- [Radxa](https://github.com/radxa/apt)
- [Armbian](https://github.com/armbian)
- [curl](https://github.com/curl/curl)
- [X.Org-X-Server](https://www.x.org/archive//individual/)
- [LXDE desktop](https://github.com/LXDE)
- [LXQt desktop](https://github.com/lxqt)
- [Xfce desktop](https://git.xfce.org/)
- [MATE desktop](https://github.com/mate-desktop)
- [GNUstep](https://github.com/gnustep)
- [Chromium](https://chromium.googlesource.com/chromium/src/)
- [Kodi/XBMC](https://github.com/xbmc/xbmc)
- [Transmission](https://transmissionbt.com/download/)
- [rTorrent](https://github.com/rakshasa/rtorrent)
- [ruTorrent](https://github.com/Novik/ruTorrent)
- [qBittorrent](https://github.com/qbittorrent/qBittorrent)
- [Nextcloud](https://github.com/nextcloud/server)
- [ownCloud](https://github.com/owncloud/core)
- [Syncthing](https://github.com/syncthing/syncthing)
- [ReadyMedia](https://sourceforge.net/p/minidlna/git/ci/master/tree/)
- [MPD](https://github.com/MusicPlayerDaemon/MPD)
- [ympd](https://github.com/notandy/ympd)
- [myMPD](https://github.com/jcorporation/myMPD)
- [Apache](https://github.com/apache)
- [Nginx](https://hg.nginx.org/nginx/)
- [Lighttpd](https://redmine.lighttpd.net/projects/lighttpd/repository)
- [PHP](https://git.php.net/)
- [PHP OPcache GUI](https://github.com/amnuts/opcache-gui)
- [MariaDB](https://github.com/MariaDB)
- [phpMyAdmin](https://github.com/phpmyadmin)
- [Certbot](https://github.com/certbot/certbot)
- [Pi-hole](https://github.com/pi-hole/pi-hole)
- [phpBB](https://github.com/phpbb/phpbb)
- [ProFTPD](https://github.com/proftpd/proftpd)
- [vsftpd](https://security.appspot.com/vsftpd.html)
- [Samba](https://wiki.samba.org/index.php/Using_Git_for_Samba_Development)
- [NFS](http://linux-nfs.org/wiki/index.php/Main_Page)
- [Dropbear](https://github.com/mkj/dropbear)
- [OpenSSH](https://github.com/openssh/openssh-portable)
- [OpenVPN](https://github.com/OpenVPN)
- [PiVPN](https://github.com/pivpn/pivpn)
- [WireGuard](https://www.wireguard.com/)
- [Amiberry](https://github.com/BlitterStudio/amiberry)
- [OpenTyrian](https://bitbucket.org/opentyrian/opentyrian/wiki/Home)
- [RPi Cam Web Interface](https://github.com/silvanmelchior/RPi_Cam_Web_Interface)
- [Deluge](https://dev.deluge-torrent.org/wiki/Development#SourceCode)
- [Airsonic-Advanced](https://github.com/airsonic-advanced/airsonic-advanced)
- [Logitech Media Server](https://github.com/Logitech/slimserver)
- [Squeezelite](https://github.com/ralph-irving/squeezelite)
- [Ampache](https://github.com/ampache/ampache)
- [Plex Media Server](https://www.plex.tv/)
- [Tautulli](https://github.com/Tautulli/Tautulli)
- [FFmpeg](https://github.com/FFmpeg/FFmpeg)
- [Shairport Sync](https://github.com/mikebrady/shairport-sync)
- [FreshRSS](https://github.com/FreshRSS/FreshRSS)
- [Folding@Home](https://github.com/FoldingAtHome)
- [Medusa](https://github.com/pymedusa/Medusa)
- [Grafana](https://github.com/grafana/grafana)
- [Clonezilla](https://gitlab.com/stevenshiau/clonezilla)
- [Gitea](https://github.com/go-gitea/gitea)
- [Gogs](https://github.com/gogs/gogs)
- [Home Assistant](https://github.com/home-assistant/core)
- [TasmoAdmin](https://github.com/reloxx13/TasmoAdmin)
- [Domoticz](https://github.com/domoticz/domoticz)
- [Firefox Sync Server](https://github.com/mozilla-services/syncserver)
- [Jellyfin](https://github.com/jellyfin/jellyfin)
- [Komga](https://github.com/gotson/komga)
- [HTPC Manager](https://github.com/HTPC-Manager/HTPC-Manager)
- [Bazarr](https://github.com/morpheus65535/bazarr)
- [PaperMC](https://github.com/PaperMC/Paper)
- [Unbound](https://github.com/NLnetLabs/unbound)
- [vaultwarden](https://github.com/dani-garcia/vaultwarden)
- [Docker](https://github.com/docker/docker-ce)
- [Portainer](https://github.com/portainer/portainer)
- [Tor](https://gitlab.torproject.org/tpo/core/tor)
- [Docker Compose](https://github.com/docker/compose)
- [Box86](https://github.com/ptitSeb/box86)
- [Box64](https://github.com/ptitSeb/box64)
- [Steam](https://steamcommunity.com/)
- [mjpg-streamer](https://github.com/jacksonliam/mjpg-streamer)
- [IPFS](https://github.com/ipfs/ipfs)
- [CUPS](https://github.com/OpenPrinting/cups)
- [Go](https://github.com/golang/go)
- [VSCodium](https://github.com/VSCodium/vscodium)
- [WebIOPi](https://github.com/Freenove/WebIOPi)
- [WiringPi](https://github.com/WiringPi/WiringPi)
- [Firefox](https://hg.mozilla.org/mozilla-unified)
- [Beets](https://github.com/beetbox/beets)
- [frp](https://github.com/fatedier/frp)
- [AdGuard Home](https://github.com/AdguardTeam/AdGuardHome)
- [Snapcast](https://github.com/badaix/snapcast)
- [K3s](https://github.com/k3s-io/k3s)
- [Synapse](https://github.com/matrix-org/synapse)
- [youtube-dl](https://github.com/ytdl-org/youtube-dl)
- [PostgreSQL](https://git.postgresql.org/gitweb/?p=postgresql.git)
- [OpenJDK](https://github.com/openjdk)
- [Blynk Server](https://github.com/Peterkn2001/blynk-server)
- [File Browser](https://github.com/filebrowser/filebrowser)
- [Spotifyd](https://github.com/Spotifyd/spotifyd)
- [DietPi-Dashboard](https://github.com/ravenclaw900/dietpi-dashboard)
- [MicroK8s](https://github.com/canonical/microk8s)
- [Allo GUI](https://github.com/MichaIng/DietPi-AlloGUI)
- [PHP Composer](https://github.com/composer/composer)
- [motionEye](https://github.com/motioneye-project/motioneye)
- [Sonarr](https://github.com/Sonarr/Sonarr)
- [Radarr](https://github.com/Radarr/Radarr)
- [Lidarr](https://github.com/Lidarr/Lidarr)
- [Prowlarr](https://github.com/Prowlarr/Prowlarr)
- [Readarr](https://github.com/Readarr/Readarr)
- [Jackett](https://github.com/Jackett/Jackett)
- [HAProxy](https://github.com/haproxy/haproxy)
- [Prometheus Node Exporter](https://github.com/prometheus/node_exporter)
- [Prometheus RPi Exporter](https://github.com/fahlke/raspberrypi_exporter)
- [Tailscale](https://github.com/tailscale/tailscale)
- [Rclone](https://github.com/rclone/rclone)
- [ZeroTier](https://github.com/zerotier/ZeroTierOne)
- [Navidrome](https://github.com/navidrome/navidrome)
- [Homer](https://github.com/bastienwirtz/homer)

---

<p align="center">
	<img src="https://www.myvirtualserver.com/images/myvirtualserver_logo.png" alt="myVirtualserver logo" width="200" height="44" loading="lazy">
	<br>DietPi's web hosting is powered by <a href="https://www.myvirtualserver.com" target="_blank" rel="noopener">myVirtualserver</a>.
</p>
